package dangerzone.items;
import org.newdawn.slick.opengl.Texture;

import dangerzone.InventoryContainer;
import dangerzone.TextureMapper;
import dangerzone.entities.Entity;
import dangerzone.gui.InventoryMenus;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class ItemArmor extends Item {
	
	public float protection = 0.0f; //added to players defense when attacked
	public Texture armortexture = null;
	public String armortexturepath = null;
	public Texture armortexture2 = null; //leggings
	public String armortexturepath2 = null; //leggings
	public int armortype = 0;

	public ItemArmor(String n, String txt, String armortxt, String leggingstxt, float protvalue, int durability, int type) {
		super(n, txt);
		armortype = type; // 0 = helmet, 1 = chestplate, 2 = leggings, 3 = boots
		armortexturepath = armortxt;
		armortexturepath2 = leggingstxt;
		protection = protvalue;
		maxuses = durability;
		maxstack = 1;
		burntime = 0;
		menu = InventoryMenus.HARDWARE;
	}
	
	public void armorTick(Entity e, InventoryContainer ic, int armorindex){		
		//called when being worn, 10x a sec...
		//this is DIFFERENT from Item.inUseTick().
	}
	
	public Texture getArmorTexture(int id){
		if(armortexture == null){
			armortexture = TextureMapper.getTexture(armortexturepath);
		}
		return armortexture;
	}
	
	public Texture getArmorTexture2(int id){
		if(armortexture2 == null){
			armortexture2 = TextureMapper.getTexture(armortexturepath2);
		}
		return armortexture2;
	}

}
