package dangerzone.gui;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.lwjgl.input.Keyboard;
import org.newdawn.slick.opengl.Texture;

import dangerzone.DangerZone;
import dangerzone.TextureMapper;




public class PlayerHelpGUI extends GuiInterface {
	List<MyButtonHandler> buttons;
	Texture backtexture;
	public Texture buttontexture = null;
	public int page = 0;
	
	private class MyButtonHandler extends ButtonHandler {
		
		public int buttonid; //which button they hit
		
		MyButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int i){
			super(xpos, ypos, bxsize, bysize, tx, ot);
			buttonid = i;
		}
		
		public void leftclickhandler(){
			if(buttonid == 0){
				ImAllDone();
			}
			if(buttonid == 7){
				page++;
				if(page > 2)page = 2;
			}
			if(buttonid == 8){
				page--;
				if(page < 0)page = 0;
			}

		}
		public void rightclickhandler(){
			leftclickhandler();
		}
	}
	
	public PlayerHelpGUI(){
		super();
	
		backtexture = TextureMapper.getTexture("res/menus/"+"back.png");
		buttontexture = TextureMapper.getTexture("res/menus/"+"button.png");
	}
	
	/*
	 * Nice reasonably simple button event processing....
	 */
	public void process(){

		int clickx, clicky;
		MyButtonHandler mb = null;
		MyButtonHandler fb = null;
		
		int starty = DangerZone.screen_height - 200;

		//Build the button list... 
		buttons = new ArrayList<MyButtonHandler>();
		buttons.add(new MyButtonHandler(DangerZone.screen_width/2 - 150, starty, 100, 100, backtexture, null, 0));

		buttons.add(new MyButtonHandler(DangerZone.screen_width/2 - 150, starty - 100, 75, 25, buttontexture, "Next", 7));
		buttons.add(new MyButtonHandler(DangerZone.screen_width/2 - 150, starty - 125, 75, 25, buttontexture, "Prev", 8)); 
			
		//Draw buttons!
		Iterator<MyButtonHandler> bb = buttons.iterator();
		while(bb.hasNext()){
			bb.next().draw();
		}
		
		if(page == 0){
			textAt( 50, 60, "w, a, s, d - Move forward, left, back, right");
			textAt( 50, 100, "g - toggle game modes");
			textAt( 50, 140, "y, Y, ctrl-y - change dimensions");
			textAt( 50, 180, "x, c, v - rotate block in X, Y, Z");
			textAt( 50, 220, "t - Talk/Chat for multiplayer");
			textAt( 50, 260, "h - Help");
			textAt( 50, 300, "e - Inventory");
			textAt( 50, 340, "q - Drop held item/block");
			textAt( 550, 60, "F3 - Status overlay");
			textAt( 550, 100, "F5 - Narcissism toggle");
			textAt( 550, 140, "F6 - View underground ores");
			textAt( 550, 180, "F2 - Screen Capture");
			textAt( 550, 220, "/ - commands");
			textAt( 550, 260, "right-click on entity - mount/dismount");
			textAt( 550, 300, "jump on cockroach - change dimension");
			textAt( 550, 340, "esc - in-game graphics options");
		}

		if(page == 1){
			textAt( 50, 340, "COMMANDS:");
			textAt( 50, 60, "/time set (day|night|dawn|dusk|0-359)");
			textAt( 50, 100, "/tp (playername| x y z)");
			textAt( 50, 140, "/stop - shuts down the game");
			textAt( 50, 180, "/weather clear");
			textAt( 50, 220, "/kill (all|hostile)");
			textAt( 50, 260, "/op (playername) - give all privs");
			textAt( 50, 300, "/deop (playername) - remove all privs");
			
			textAt( 550, 60, "/givepriv (playername) (gamemode|op|teleport|kill|weather|time|shutdown|nofire)");
			textAt( 550, 100, "/takepriv (playername) (gamemode|op|teleport|kill|weather|time|shutdown|nofire)");
			textAt( 550, 140, "/ban (playername)");
			textAt( 550, 180, "/unban (playername)");
			textAt( 550, 220, "/playnicely (true|false) - critters are passive");
			textAt( 550, 260, "/defaultprivs (number)");
			textAt( 550, 300, "/maxplayers (number)");
			
		}
		
		if(page == 2){
			textAt( 50, 340, "COMMANDS:");
			textAt( 50, 300, "/nofire");
			textAt( 50, 260, "/validateplayers (true|false)");
			
		}

		
		//Check for exit via keypad
		while(K_next()){
			if (K_getEventKey() == Keyboard.KEY_ESCAPE && K_isKeyDown(Keyboard.KEY_ESCAPE)){
				ImAllDone();
				return;
			}
			if (K_getEventKey() == Keyboard.KEY_H && K_isKeyDown(Keyboard.KEY_H)){
				ImAllDone();
				return;
			}
		}
		
		//Check for mouse events!
		while(M_next()){
			clickx = M_getEventX();
			clicky = M_getEventY();
			if(M_getEventButtonState()){
				if(M_getEventButton() >= 0){ //clicked!
					
					//Find which "button" they clicked on
					bb = buttons.iterator();
					fb = null;
					while(bb.hasNext()){
						mb = bb.next();
						if(clickx >= mb.x && clickx <= mb.x+mb.xsize){
							if(clicky >= mb.y && clicky <= mb.y+mb.ysize){
								fb = mb;
								break;
							}
						}
					}
					// 0 = left, 1 = right, 2 = middle
					if(M_getEventButton() == 0){
						if(fb != null)fb.leftclickhandler();
					}
					if(M_getEventButton() == 1){
						if(fb != null)fb.rightclickhandler();
					}
				}
			}
		}

	}
	

	

}
