package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.Properties;


import dangerzone.ChestInventoryPacket;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.World;
import dangerzone.blocks.Blocks;

/*
 * Don't look at me... I have no idea what I was thinking when I did this!
 * Overly complex and unneeded except as an example of custom packets.
 * 
 */
public class EntityChest extends Entity {
	
	public InventoryContainer[] inventory;
	public boolean contents_requested = false;
	public int rerequest = 0;
	public int blocktries = 0;

	public EntityChest(World w) {
		super(w);
		uniquename = "DangerZone:EntityChest";
		inventory = new InventoryContainer[50];					// 10 * 5
		for(int i=0;i<50;i++)inventory[i] = null;
		ignoreCollisions = true;
		width = 0.01f;
		height = 0.01f;
		contents_requested = false;
		has_inventory = true; //we use this to pass from client to server! (not using packets!)
	}
	
	public void init(){
		//copy from entity inventory to local. awful, but so chests can be filled and sent from client
		//besides, chest is an example for how to use packets, which we really don't even need.
		//so, well, we cheat a little... but only when creating chests on client side.
		for(int i=0;i<50;i++){
			if(entity_inventory[i] != null){
				inventory[i] = entity_inventory[i];
				entity_inventory[i] = null;
			}
		}
	}
	
	public void update(float deltaT){
		if(world.isServer && world.getblock(dimension,  (int)posx, (int)posy, (int)posz) != Blocks.chest.blockID){
			//System.out.printf("update chest entity no chest!\n");	
			blocktries++;
			if(blocktries > 20){
				dumpInventory();
				this.deadflag = true;
			}
		}
		//if we haven't already, ask the server what our contents are...
		if(!world.isServer){
			rerequest--;
			if(rerequest <= 0){
				contents_requested = false;
				rerequest = 600 + world.rand.nextInt(600);
			}
			if(!contents_requested){
				contents_requested = true;
				ChestInventoryPacket cip = new ChestInventoryPacket();
				cip.requestContents(this.entityID);
			}
		}
		
		//kick entity out to other players!
		motionx = motiony = motionz = 0;
		super.update(deltaT);
	}
	
	public boolean rightClickedByPlayer(Player p, InventoryContainer ic){
		if(world.getblock(dimension,  (int)posx, (int)posy, (int)posz) != Blocks.chest.blockID){
			//System.out.printf("rightclickentity chest entity no chest!\n");
			if(world.isServer){
				dumpInventory();
			}
			this.deadflag = true;
			return false;
		}
		Blocks.rightClickOnBlock(Blocks.chest.blockID, p, dimension, (int)posx, (int)posy, (int)posz);
		return false;
	}
	
	private void dumpInventory(){
		InventoryContainer ic = null;
		for(int i=0;i<inventory.length;i++){
			ic = inventory[i];
			if(ic != null){				
				EntityBlockItem e = (EntityBlockItem)world.createEntityByName(DangerZone.blockitemname, dimension, posx, posy, posz);
				if(e != null){
					e.fill(ic);
					e.rotation_pitch = world.rand.nextInt(360);
					e.rotation_yaw = world.rand.nextInt(360);
					e.rotation_roll = world.rand.nextInt(360);
					e.motionx = (world.rand.nextFloat()-world.rand.nextFloat()/10f); 
					e.motiony = world.rand.nextFloat()/2;
					e.motionz = (world.rand.nextFloat()-world.rand.nextFloat()/10f); 
					world.spawnEntityInWorld(e);
				}				
			}
		}
	}
	
	public void writeSelf(Properties prop, String tag){
		String s;
		super.writeSelf(prop, tag);
		
		for(int i=0;i<inventory.length;i++){
			s = String.format("%sInventory_%d:", tag, i);
			if(inventory[i] != null){					
				prop.setProperty(String.format("%s%s", s, "data"), "valid");				
				inventory[i].writeSelf(prop, s);
			}else{
				prop.setProperty(String.format("%s%s", s, "data"), "null");
			}
		}
	}
	
	public void readSelf(Properties prop, String tag){
		String s;
		String n;
		super.readSelf(prop, tag);
		
		for(int i=0;i<inventory.length;i++){
			inventory[i] = null;
			s = String.format("%sInventory_%d:", tag, i);
			n = prop.getProperty(String.format("%s%s", s, "data"));
			if(n != null){
				if(!n.equals("null")){
					inventory[i] = new InventoryContainer();
					inventory[i].readSelf(prop, s);
				}
			}			
		}
	}

}
