package dangerzone;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
import org.lwjgl.opengl.GL11;


public class ModelRenderer {
	

    public float textureWidth;
    public float textureHeight;

    public float textureOffsetX;
    public float textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float sizeX;
    public float sizeY;
    public float sizeZ;
    public boolean mirror = true;
    
    public boolean compiled;
    public int displayList;
    
    
    public ModelRenderer(int par2, int par3)
    {
        this.textureOffsetX = par2;
        this.textureOffsetY = par3;
    }
    
    //techne compatibiliy
    public ModelRenderer(ModelBase mb, int par2, int par3)
    {
        this.textureOffsetX = par2;
        this.textureOffsetY = par3;
    }

    public void setRotationPoint(float par1, float par2, float par3)
    {
        this.rotationPointX = par1;
        this.rotationPointY = par2;
        this.rotationPointZ = par3;
    }
    
    public void setRotation(float x, float y, float z)
    {
    	this.rotateAngleX = x;
    	this.rotateAngleY = y;
    	this.rotateAngleZ = z;
    }
    
    public void addCube(float par1, float par2, float par3, int par4, int par5, int par6)
    {
        this.offsetX = par1;
        this.offsetY = par2;
        this.offsetZ = par3;
        this.sizeX = par4;
        this.sizeY = par5;
        this.sizeZ = par6;
    }
    
    //techne compatibiliy
    public void addBox(float par1, float par2, float par3, int par4, int par5, int par6)
    {
        this.offsetX = par1;
        this.offsetY = par2;
        this.offsetZ = par3;
        this.sizeX = par4;
        this.sizeY = par5;
        this.sizeZ = par6;
    }
    
    public void setTextureSize(int par1, int par2)
    {
        this.textureWidth = (float)par1;
        this.textureHeight = (float)par2;
    }
    
    public void render(float deathfactorscale)
    {
    	float my;
    	if (!this.compiled)
    	{
    		this.compileDisplayList();
    	}

    	my = -(this.rotationPointY*deathfactorscale-24);
    	if(deathfactorscale >= 1.1f && my < 0)my = -my; //So small things don't just explode into the ground on dying!
    	GL11.glTranslatef(this.rotationPointX*deathfactorscale, my, -this.rotationPointZ*deathfactorscale);
    	
       	GL11.glPushMatrix();
    	
       	if (this.rotateAngleZ != 0.0f)
    	{
    		GL11.glRotatef(-this.rotateAngleZ * (180f / (float)Math.PI), 0.0f, 0.0f, 1.0f);
    	}
    	if (this.rotateAngleY != 0.0f)
    	{
    		GL11.glRotatef(-this.rotateAngleY * (180f / (float)Math.PI), 0.0f, 1.0f, 0.0f);
    	}
    	if (this.rotateAngleX != 0.0f)
    	{
    		GL11.glRotatef(this.rotateAngleX * (180f / (float)Math.PI), 1.0f, 0.0f, 0.0f);
    	}
    	
       	my = -this.offsetY*deathfactorscale;
    	if(deathfactorscale > 1.25f && my < 0)my = -my;
    	GL11.glTranslatef(this.offsetX*deathfactorscale, my, -this.offsetZ*deathfactorscale);
 
    	GL11.glCallList(this.displayList);

    	GL11.glPopMatrix();
    	
    	my = -(this.rotationPointY*deathfactorscale-24);
    	if(deathfactorscale >= 1.1f && my < 0)my = -my;
    	GL11.glTranslatef(-this.rotationPointX*deathfactorscale, -my, this.rotationPointZ*deathfactorscale);   	

    }
    
    private void compileDisplayList()
    {
    	if(compiled)return;
    	
        this.displayList = DangerZone.wr.getNextRenderID();
        GL11.glNewList(this.displayList, GL11.GL_COMPILE);
        
		GL11.glBegin(GL11.GL_QUADS);
		
		if(mirror){ //normal (flag is backwards)

			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY)/textureHeight);
			GL11.glVertex3f(sizeX, 0, -sizeZ); // Top Right Of The Quad (Top)
			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY)/textureHeight);
			GL11.glVertex3f(0, 0, -sizeZ); // Top Left Of The Quad (Top)
			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(0, 0, 0); // Bottom Left Of The Quad (Top)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(sizeX, 0, 0); // Bottom Right Of The Quad (Top)

			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeX)/textureWidth,(textureOffsetY)/textureHeight);
			GL11.glVertex3f(sizeX, -sizeY,0); // Top Right Of The Quad (Bottom)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY)/textureHeight);
			GL11.glVertex3f(0, -sizeY, 0); // Top Left Of The Quad (Bottom)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(0, -sizeY, -sizeZ); // Bottom Left Of The Quad (Bottom)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(sizeX, -sizeY, -sizeZ); // Bottom Right Of The Quad (Bottom)

			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(sizeX,0 , 0); // Top Right Of The Quad (Front)
			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(0,0 , 0); // Top Left Of The Quad (Front)
			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(0, -sizeY, 0); // Bottom Left Of The Quad (Front)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(sizeX, -sizeY, 0); // Bottom Right Of The Quad (Front)

			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);				
			GL11.glVertex3f(0, 0, -sizeZ); // Top Left Of The Quad (Back)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);				
			GL11.glVertex3f(sizeX, 0, -sizeZ); // Top Right Of The Quad (Back)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);			
			GL11.glVertex3f(sizeX, -sizeY, -sizeZ); // Bottom Right Of The Quad (Back)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);				
			GL11.glVertex3f(0, -sizeY, -sizeZ); // Bottom Left Of The Quad (Back)

			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(0, 0, 0); // Top Right Of The Quad (Left)
			GL11.glTexCoord2f((textureOffsetX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(0, 0, -sizeZ); // Top Left Of The Quad (Left)
			GL11.glTexCoord2f((textureOffsetX)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(0, -sizeY, -sizeZ); // Bottom Left Of The Quad (Left)
			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(0, -sizeY, 0); // Bottom Right Of The Quad (Left)

			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeZ)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(sizeX, 0, -sizeZ); // Top Right Of The Quad (Right)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(sizeX, 0, 0); // Top Left Of The Quad (Right)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(sizeX, -sizeY, 0); // Bottom Left Of The Quad (Right)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeZ)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(sizeX, -sizeY, -sizeZ); // Bottom Right Of The Quad (Right)

		}else{

			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY)/textureHeight);
			GL11.glVertex3f(sizeX, 0, -sizeZ); // Top Right Of The Quad (Top)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY)/textureHeight);
			GL11.glVertex3f(0, 0, -sizeZ); // Top Left Of The Quad (Top)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(0, 0, 0); // Bottom Left Of The Quad (Top)
			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(sizeX, 0, 0); // Bottom Right Of The Quad (Top)

			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY)/textureHeight);
			GL11.glVertex3f(sizeX, -sizeY,0); // Top Right Of The Quad (Bottom)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeX)/textureWidth,(textureOffsetY)/textureHeight);
			GL11.glVertex3f(0, -sizeY, 0); // Top Left Of The Quad (Bottom)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(0, -sizeY, -sizeZ); // Bottom Left Of The Quad (Bottom)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(sizeX, -sizeY, -sizeZ); // Bottom Right Of The Quad (Bottom)

			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(sizeX,0 , 0); // Top Right Of The Quad (Front)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(0,0 , 0); // Top Left Of The Quad (Front)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(0, -sizeY, 0); // Bottom Left Of The Quad (Front)
			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(sizeX, -sizeY, 0); // Bottom Right Of The Quad (Front)

			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);				
			GL11.glVertex3f(0, 0, -sizeZ); // Top Left Of The Quad (Back)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);				
			GL11.glVertex3f(sizeX, 0, -sizeZ); // Top Right Of The Quad (Back)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);			
			GL11.glVertex3f(sizeX, -sizeY, -sizeZ); // Bottom Right Of The Quad (Back)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);				
			GL11.glVertex3f(0, -sizeY, -sizeZ); // Bottom Left Of The Quad (Back)

			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(0, 0, 0); // Top Right Of The Quad (Left)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeZ)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(0, 0, -sizeZ); // Top Left Of The Quad (Left)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX+sizeZ)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(0, -sizeY, -sizeZ); // Bottom Left Of The Quad (Left)
			GL11.glTexCoord2f((textureOffsetX+sizeZ+sizeX)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(0, -sizeY, 0); // Bottom Right Of The Quad (Left)

			GL11.glTexCoord2f((textureOffsetX)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(sizeX, 0, -sizeZ); // Top Right Of The Quad (Right)
			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY+sizeZ)/textureHeight);
			GL11.glVertex3f(sizeX, 0, 0); // Top Left Of The Quad (Right)
			GL11.glTexCoord2f((textureOffsetX+sizeZ)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(sizeX, -sizeY, 0); // Bottom Left Of The Quad (Right)
			GL11.glTexCoord2f((textureOffsetX)/textureWidth,(textureOffsetY+sizeZ+sizeY)/textureHeight);
			GL11.glVertex3f(sizeX, -sizeY, -sizeZ); // Bottom Right Of The Quad (Right)

		}
		
		GL11.glEnd(); // Done Drawing Quads
		
		
        GL11.glEndList();
        this.compiled = true;
    }
    


}
