package dangerzone.blocks;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.List;
import java.util.ListIterator;

import org.lwjgl.opengl.GL11;


import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.threads.FastBlockTicker;
import dangerzone.threads.VBODataBuilderThread;


public class BlockBarrier extends Block {
	private boolean compiled = false; //graphics outputs compiled. Or not.
	private int myrenderid = 0;
	private float blockrenderwidth = 16;
		
	public BlockBarrier(String n, String txt){
		super(n, txt);
		isSolidForRendering = false;
		isSolid = true;
		hasOwnRenderer = true;
		renderAllSides = true;
		renderSmaller = true;
		alwaystick = true;	
		maxdamage = 10;
		burntime = 30;
	}
	
	public void notifyNeighborChanged(World w, int d, int x, int y, int z){
		if(w.isServer){
			int bid = w.getblock(d, x, y-1, z);
			if(!Blocks.isSolid(bid)){
				w.setblock(d, x, y, z, 0);	
			}
		}
	}
	
	public void tickMeFast(World w, int d, int x, int y, int z){
		tickMe(w, d, x, y, z);
	}
	
	public void tickMe(World w, int d, int x, int y, int z){
		if(w.isServer){
			int bid = w.getblock(d, x, y-1, z);
			if(!Blocks.isSolid(bid)){
				w.setblock(d, x, y, z, 0);
				return;
			}
			if(bid == Blocks.autofence.blockID)return; //slave block		

			//master block!
			FastBlockTicker.addFastTick(d,  x,  y, z, 2); //ticks, in TENTHS of a second
			
			List<Entity> nearby_list = null;
			ListIterator<Entity> li;
			Entity e = null;
			int maxh = 0;
									
			nearby_list = DangerZone.server.entityManager.findEntitiesInRange(16.0f, d, (double)x+0.5f, (double)y+0.5f, (double)z+0.5f);
			if(nearby_list != null){
				if(!nearby_list.isEmpty()){
					li = nearby_list.listIterator();
					while(li.hasNext()){
						e = (Entity)li.next();
						if(e instanceof EntityLiving){
							//System.out.printf("Entity is: %s with height %f\n", e.uniquename, e.getHeight());
							if(maxh < 2)maxh = 2;
							if((e.getHeight()*2+0.9f)>maxh){
								maxh = (int)(e.getHeight()*2+0.9f);
							}
							if(e instanceof Player){
								float dist = (float)Math.sqrt((e.posx-((double)x+0.5f))*(e.posx-((double)x+0.5f)) + (e.posz-((double)z+0.5f))*(e.posz-((double)z+0.5f)));
								if(dist < 1.5){
									Player p = (Player)e;
									InventoryContainer ic = p.getHotbar(p.gethotbarindex());
									if(ic != null && ic.iid == Items.autofencekey.itemID){
										maxh = 0; //open!
										break;
									}
								}								
							}
						}
					}
				}
			}
			if(maxh > 1){
				for(int i=1;i<maxh;i++){
					if(w.getblock(d, x, y+i, z) == 0){
						w.setblock(d, x, y+i, z, this.blockID);
					}
				}
				w.setblockandmeta(d, x, y, z, this.blockID, 0x01); //active
				if(w.rand.nextInt(1000) == 1)w.playSound("DangerZone:arc", d, x, y, z, 0.1f, 1);
			}else{
				if(w.getblock(d, x, y+1, z) == this.blockID){
					w.setblock(d, x, y+1, z, 0);
				}
				w.setblockandmeta(d, x, y, z, this.blockID, 0x00); //inactive
			}			
		}
	}
	
	public float getBrightness(World w, int d, int x, int y, int z){
		int bid = w.getblock(d, x, y-1, z);
		if(bid == Blocks.autofence.blockID)return 0.45f; //slave block	
		if((w.getblockmeta(d, x, y, z)&0x01) != 0x01)return 0;
		return 0.65f;
	}
	
	public int getBlockDrop(Player p, World w, int d, int x, int y, int z){
		int bid = w.getblock(d, x, y-1, z);
		if(bid == this.blockID)return 0; //slave block	
		return this.blockID;
	}
		
	
	public void renderMeToVBO(long chunkvbos[], WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo){

		VBOBuffer v = null;
		StitchedTexture st = null;

		st = VBODataBuilderThread.findVBOtextureforblockside(0, bid); //loads us into the stitching if we are not already!
		v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, isTranslucent);
		if(v == null)return;

		float brw = blockrenderwidth/2;
		float brwtb = blockrenderwidth/8;
		float brud;
		float pixdiff = (st.xoffsetmax - st.xoffsetmin) / 16;
		float tudmin = st.xoffsetmin + pixdiff * 6;
		float tudmax = tudmin + pixdiff * 4;
		float tlrmin = st.yoffsetmin;
		float tlrmax = tlrmin + pixdiff * 4;
		brw -= 0.01f;
		brud = brw - 6;
		brwtb -= 0.01f;

		//top and bottom (texture is top of column)

		v.addVertexInfoToVBO(brwtb + xo, brw + yo, -brwtb + zo, tudmax, tlrmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);		
		v.addVertexInfoToVBO(-brwtb + xo, brw + yo, -brwtb + zo, tudmin, tlrmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);		
		v.addVertexInfoToVBO(-brwtb + xo, brw + yo, brwtb + zo, tudmin, tlrmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
		v.addVertexInfoToVBO(brwtb + xo, brw + yo, brwtb + zo, tudmax, tlrmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);

		v.addVertexInfoToVBO(brwtb + xo, -brw + yo, brwtb + zo, tudmax, tlrmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 			
		v.addVertexInfoToVBO(-brwtb + xo, -brw + yo, brwtb + zo, tudmin, tlrmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 			
		v.addVertexInfoToVBO(-brwtb + xo, -brw + yo, -brwtb + zo, tudmin, tlrmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 			
		v.addVertexInfoToVBO(brwtb + xo, -brw + yo, -brwtb + zo, tudmax, tlrmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);


		//sides (texture down the middle)
		
		v.addVertexInfoToVBO(brud + xo, brw + yo, brud + zo, tudmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 	
		v.addVertexInfoToVBO(-brud + xo, brw + yo, brud + zo, tudmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 		
		v.addVertexInfoToVBO(-brud + xo, -brw + yo, brud + zo, tudmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 		
		v.addVertexInfoToVBO(brud + xo, -brw + yo, brud + zo, tudmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);

		v.addVertexInfoToVBO(-brud + xo, brw + yo, -brud + zo, tudmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 
		v.addVertexInfoToVBO(brud + xo, brw + yo, -brud + zo, tudmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 
		v.addVertexInfoToVBO(brud + xo, -brw + yo, -brud + zo, tudmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 
		v.addVertexInfoToVBO(-brud + xo, -brw + yo, -brud + zo, tudmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 

		v.addVertexInfoToVBO(-brud + xo, brw + yo, brud + zo, tudmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
		v.addVertexInfoToVBO(-brud + xo, brw + yo, -brud + zo, tudmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 
		v.addVertexInfoToVBO(-brud + xo, -brw + yo, -brud + zo, tudmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 
		v.addVertexInfoToVBO(-brud + xo, -brw + yo, brud + zo, tudmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);

		v.addVertexInfoToVBO(brud + xo, brw + yo, -brud + zo, tudmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 
		v.addVertexInfoToVBO(brud + xo, brw + yo, brud + zo, tudmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 
		v.addVertexInfoToVBO(brud + xo, -brw + yo, brud + zo, tudmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 
		v.addVertexInfoToVBO(brud + xo, -brw + yo, -brud + zo, tudmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb); 


	}
	
	public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus){

		if(!compiled){
			float brw = blockrenderwidth/2;
			float brwtb = blockrenderwidth/8;
			float txmin = 6f/16f;
			float txmax = 10f/16f;
			float tymax = 4f/16f;

			
			myrenderid = DangerZone.wr.getNextRenderID();
			GL11.glNewList(myrenderid, GL11.GL_COMPILE);
			GL11.glBegin(GL11.GL_QUADS);
			
			
			GL11.glTexCoord2f(txmax,0);
			GL11.glVertex3f(brwtb, brw, -brwtb); // Top Right Of The Quad (Top)
			GL11.glTexCoord2f(txmin,0);
			GL11.glVertex3f(-brwtb, brw, -brwtb); // Top Left Of The Quad (Top)
			GL11.glTexCoord2f(txmin,tymax);
			GL11.glVertex3f(-brwtb, brw, brwtb); // Bottom Left Of The Quad (Top)
			GL11.glTexCoord2f(txmax,tymax);
			GL11.glVertex3f(brwtb, brw, brwtb); // Bottom Right Of The Quad (Top)
			
			GL11.glTexCoord2f(txmax,0);
			GL11.glVertex3f(brwtb, -brw, brwtb); // Top Right Of The Quad (Bottom)
			GL11.glTexCoord2f(txmin,0);
			GL11.glVertex3f(-brwtb, -brw, brwtb); // Top Left Of The Quad (Bottom)
			GL11.glTexCoord2f(txmin,tymax);
			GL11.glVertex3f(-brwtb, -brw, -brwtb); // Bottom Left Of The Quad (Bottom)
			GL11.glTexCoord2f(txmax,tymax);
			GL11.glVertex3f(brwtb, -brw, -brwtb); // Bottom Right Of The Quad (Bottom)
					
			
			GL11.glTexCoord2f(txmax,0);
			GL11.glVertex3f(brwtb, brw, brwtb); // Top Right Of The Quad (Front)
			GL11.glTexCoord2f(txmin,0);
			GL11.glVertex3f(-brwtb, brw, brwtb); // Top Left Of The Quad (Front)
			GL11.glTexCoord2f(txmin,1);
			GL11.glVertex3f(-brwtb, -brw, brwtb); // Bottom Left Of The Quad (Front)
			GL11.glTexCoord2f(txmax,1);
			GL11.glVertex3f(brwtb, -brw, brwtb); // Bottom Right Of The Quad (Front)
			
			GL11.glTexCoord2f(txmax,0);
			GL11.glVertex3f(-brwtb, brw, -brwtb); // Top Left Of The Quad (Back)
			GL11.glTexCoord2f(txmin,0);
			GL11.glVertex3f(brwtb, brw, -brwtb); // Top Right Of The Quad (Back)
			GL11.glTexCoord2f(txmin,1);
			GL11.glVertex3f(brwtb, -brw, -brwtb); // Bottom Right Of The Quad (Back)
			GL11.glTexCoord2f(txmax,1);
			GL11.glVertex3f(-brwtb, -brw, -brwtb); // Bottom Left Of The Quad (Back)
			
			GL11.glTexCoord2f(txmax,0);
			GL11.glVertex3f(-brwtb, brw, brwtb); // Top Right Of The Quad (Left)
			GL11.glTexCoord2f(txmin,0);
			GL11.glVertex3f(-brwtb, brw, -brwtb); // Top Left Of The Quad (Left)
			GL11.glTexCoord2f(txmin,1);
			GL11.glVertex3f(-brwtb, -brw, -brwtb); // Bottom Left Of The Quad (Left)
			GL11.glTexCoord2f(txmax,1);
			GL11.glVertex3f(-brwtb, -brw, brwtb); // Bottom Right Of The Quad (Left)
			
			GL11.glTexCoord2f(txmax,0);
			GL11.glVertex3f(brwtb, brw, -brwtb); // Top Right Of The Quad (Right)
			GL11.glTexCoord2f(txmin,0);
			GL11.glVertex3f(brwtb, brw, brwtb); // Top Left Of The Quad (Right)
			GL11.glTexCoord2f(txmin,1);
			GL11.glVertex3f(brwtb, -brw, brwtb); // Bottom Left Of The Quad (Right)
			GL11.glTexCoord2f(txmax,1);
			GL11.glVertex3f(brwtb, -brw, -brwtb); // Bottom Right Of The Quad (Right)
			
			
			GL11.glEnd(); // Done Drawing The Quad
			GL11.glEndList();			
			compiled = true;
		}

		wr.loadtextureforblockside(0, bid, false); //We only have one side. Tell world renderer to load our texture.
		
		//We are NOT solid
		//GL11.glEnable(GL11.GL_BLEND);
		//GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		
		GL11.glCallList(myrenderid); //draw
		
		//GL11.glDisable(GL11.GL_BLEND);

	}

}
