package dangerzone.biomes;

import dangerzone.Chunk;
import dangerzone.World;

public class RuggedHillsBiome extends RuggedBiome {

	public RuggedHillsBiome(String n) {
		super(n);
		// TODO Auto-generated constructor stub
	}
	
	//generate height maps directly into chunk so the biomemanager can use them
	public void generateheightmaps(World w, int d, Chunk c, int cx, int cz, int dirtheight[][], int stoneheight[][], int baseheight[][]){

		int i, j, k;

		float noise[][] = new float[16][16];
		float noise2[][] = new float[16][16];
		float noise3[][] = new float[16][16];
		
		float noise4[][] = new float[16][16];
		float noise5[][] = new float[16][16];

		int dirtamp = 2;
		int dx = (cx << 4)+(int)(w.worldseed&0xffff);
		int dz = (cz << 4)+(int)((w.worldseed>>16)&0xffff);
		float t;			
		int waterlevel = 60;
		
		for(i=0;i<16;i++){
			for(k=0;k<16;k++){
				noise[i][k] = 0;
				noise2[i][k] = 0;
				noise3[i][k] = 0;
				noise4[i][k] = 0;
				noise5[i][k] = 0;
			}
		}
		
		for(j=4;j<10;j++){
			for(i=0;i<16;i++){
				for(k=0;k<16;k++){
					noise[i][k] += (float) Math.sin(Math.toRadians((double)((dx+i)/((double)j*j*0.01d))))*Math.sin(Math.toRadians((double)((dx+i)/((double)j*j*0.01d))));
					noise[i][k] += (float) Math.sin(Math.toRadians((double)((dz+k)/((double)j*j*0.03d))))*Math.sin(Math.toRadians((double)((dz+k)/((double)j*j*0.03d))));

					noise[i][k] *= (float) Math.sin(Math.toRadians((double)((dx+i)/((double)j*j*0.07d))));
					noise[i][k] *= (float) Math.sin(Math.toRadians((double)((dz+k)/((double)j*j*0.09d))));


					noise3[i][k] += (float) Math.sin(Math.toRadians((double)((dx+100+i)/((double)j*j*0.03d))))*Math.sin(Math.toRadians((double)((dx+100+i)/((double)j*j*0.03d))));
					noise3[i][k] += (float) Math.sin(Math.toRadians((double)((dz+100+k)/((double)j*j*0.01d))))*Math.sin(Math.toRadians((double)((dz+100+k)/((double)j*j*0.01d))));

					noise3[i][k] *= (float) Math.sin(Math.toRadians((double)((dx+50+i)/((double)j*j*0.09d))));
					noise3[i][k] *= (float) Math.sin(Math.toRadians((double)((dz+50+k)/((double)j*j*0.07d))));

				}
			}
		}
		
		for(j=1;j<4;j++){
			for(i=0;i<16;i++){
				for(k=0;k<16;k++){
					noise4[i][k] += (float) Math.sin(Math.toRadians((double)((dx+i)/((double)j*j*0.011d))))*Math.sin(Math.toRadians((double)((dx+i)/((double)j*j*0.011d))));
					noise4[i][k] += (float) Math.sin(Math.toRadians((double)((dz+k)/((double)j*j*0.031d))))*Math.sin(Math.toRadians((double)((dz+k)/((double)j*j*0.031d))));

					noise4[i][k] *= (float) Math.sin(Math.toRadians((double)((dx+i)/((double)j*j*0.071d))));
					noise4[i][k] *= (float) Math.sin(Math.toRadians((double)((dz+k)/((double)j*j*0.092d))));

					noise5[i][k] += (float) Math.sin(Math.toRadians((double)((dx+100+i)/((double)j*j*0.032d))))*Math.sin(Math.toRadians((double)((dx+100+i)/((double)j*j*0.032d))));
					noise5[i][k] += (float) Math.sin(Math.toRadians((double)((dz+100+k)/((double)j*j*0.012d))))*Math.sin(Math.toRadians((double)((dz+100+k)/((double)j*j*0.012d))));

					noise5[i][k] *= (float) Math.sin(Math.toRadians((double)((dx+50+i)/((double)j*j*0.093d))));
					noise5[i][k] *= (float) Math.sin(Math.toRadians((double)((dz+50+k)/((double)j*j*0.074d))));

				}
			}
		}
		
		for(i=0;i<16;i++){
			for(k=0;k<16;k++){
				noise[i][k] = (noise[i][k] - noise3[i][k]) * 30f;  //amplitude
				noise[i][k] += (noise4[i][k] - noise5[i][k]) * 3f; //amplitude
				noise2[i][k] = (noise3[i][k] - noise5[i][k]);

				t = noise[i][k] + 70;
				stoneheight[i][k] = (int) t;
				t = Math.abs(noise2[i][k]*dirtamp);
				dirtheight[i][k] = (int)t+stoneheight[i][k]+1;
				
				if(stoneheight[i][k] < waterlevel+10 && stoneheight[i][k] >= waterlevel){
					t = Math.abs(noise2[i][k]*dirtamp*((float)stoneheight[i][k]-(float)waterlevel)/10f);					
					dirtheight[i][k] = (int)t+stoneheight[i][k]+1;
				}
				
				baseheight[i][k] = 0;
			}
		}
		
	}

}
