package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.Properties;

import org.newdawn.slick.opengl.Texture;


import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;


public class EntityExp extends Entity {
	
	public int deathtimer = 10 * 120; // = two minutes on the server
	public int pickup_delay = 0; //so you can toss things straight down
	public int points = 0;
	int nexttext = 0;
	int nexttextcount = 0;
	int countdir = 1;
	
	public EntityExp(World w){
		super(w);
		maxrenderdist = 32; //in blocks
		this.height = 0.25f;
		this.width = 0.25f;
		uniquename = "DangerZone:Experience";
		pickup_delay = 10; // = 1 second on server
		points = 0;
		if(w != null){
			nexttext = w.rand.nextInt(8);
			nexttextcount = w.rand.nextInt(10);
		}
		canthitme = true; //Ignore me!
	}
	
	public void writeSelf(Properties prop, String tag){
		super.writeSelf(prop, tag);
		prop.setProperty(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", deathtimer));
		prop.setProperty(String.format("%s%s", tag, "POINTS"), String.format("%d", points));
	}
	
	public void readSelf(Properties prop, String tag){
		super.readSelf(prop, tag);
		deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 32768, 600);
		points = Utils.getPropertyInt(prop, String.format("%s%s", tag, "POINTS"), 0, 10000, 1);
	}

	public void update( float deltaT){
		float rate = (float)((float)DangerZone.entityupdaterate/DangerZone.serverentityupdaterate);
				
		if(this.world.isServer){
			int bbid;
			
			if(posy < -10){
				this.deadflag = true;
				return;
			}
			
			bbid = this.world.getblock(dimension, (int)this.posx, (int)(this.posy-(this.getHeight()+0.25f)), (int)this.posz);
			if(Blocks.isSolid(bbid)){				
				motiony += 0.007f * deltaT;

			}else{
				motiony -= 0.005f * deltaT;
			}
			
			motiony *= (1.0f-(0.05f*deltaT*rate));
			motionx *= (1.0f-(0.05f*deltaT*rate));
			motionz *= (1.0f-(0.05f*deltaT*rate));

			deathtimer--;
			if(deathtimer <= 0){
				this.deadflag = true;
				return;
			}
			
			if(pickup_delay > 0)pickup_delay--;
			
			this.rotation_yaw_motion = 0;
			this.rotation_pitch_motion = 0;
			this.rotation_roll_motion = 0;
			this.rotation_pitch = 0;
			this.rotation_yaw = 0;
			this.rotation_roll = 0;
			
			if(!this.deadflag && pickup_delay <= 0){
				Player p = DangerZone.server.findNearestPlayer(this);
				if(p != null){
					if(this.getDistanceFromEntity(p) < 7){
						if(this.getDistanceFromEntityCenter(p) < p.getWidth()){
							//p.setExperience(p.getExperience()+this.getExperience());
							p.server_thread.sendExpAdjust(this.getExperience());
							this.deadflag = true;
							world.playSound("DangerZone:pop", dimension, posx, posy, posz, 1.0f, 1.0f+(world.rand.nextFloat()-world.rand.nextFloat())*0.3f);
						}

					   	float tdir = (float) Math.atan2(p.posx - posx, p.posz - posz);
				    	float dist;
				    	float factor = 1.0f;
				    	dist = this.getDistanceFromEntity(p);
				    	factor = 7.0f/dist;
				    	if(factor > 1)factor = 1; 
				    	motionx += 0.04f*factor*Math.sin(tdir) * deltaT;
				    	motionz += 0.04f*factor*Math.cos(tdir) * deltaT;
				    	if(posy>p.posy+p.getHeight()/2)motiony -= 0.02f * deltaT;
				    	if(posy<p.posy+p.getHeight()/2)motiony += 0.06f * deltaT;
					}
				}
			}
		}else{
			motiony *= (1.0f-(0.05f*deltaT*rate));
			motionx *= (1.0f-(0.05f*deltaT*rate));
			motionz *= (1.0f-(0.05f*deltaT*rate));
		}
		super.update( deltaT );
	}
	
	public int getSubTexture(){
		int howfast = 5;
		if(this.getExperience() >= 10)howfast = 4;
		if(this.getExperience() >= 100)howfast = 3;
		if(this.getExperience() >= 1000)howfast = 2;
		
		nexttextcount++;
		if(nexttextcount >= howfast){
			nexttextcount = 0;
			nexttext += countdir;
			if(nexttext > 7){
				nexttext = 7;
				countdir = -1;
			}
			if(nexttext < 0){
				nexttext = 0;
				countdir = 1;
			}
		}
		return nexttext;
	}
	
	public Texture getTexture(){
		if(texture == null){
			//ENTITIES MUST USE TEXTUREMAPPER.GETTEXTURE()!!!!
			texture = TextureMapper.getTexture("res/misc/"+ "exp.png");
		}
		return texture;
	}
	

	
}

