package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.Properties;


import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;


public class EntityBlockItem extends Entity {
	
	public int deathtimer = 10 * 120; // = two minutes on the server
	public int pickup_delay = 0; //so you can toss things straight down
	private float mx, mz;
	
	public EntityBlockItem(World w){
		super(w);
		maxrenderdist = 40; //in blocks
		this.height = 0.25f;
		this.width = 0.25f;
		uniquename = DangerZone.blockitemname;
		pickup_delay = 10; // = 1 second on server
		canthitme = true; //Ignore me!
		if(w != null){
			rotation_pitch = w.rand.nextInt(360);
			rotation_yaw = w.rand.nextInt(360);
			rotation_roll = w.rand.nextInt(360);
		}
		mx = (DangerZone.rand.nextFloat()-DangerZone.rand.nextFloat()) * 0.006f;
		mz = (DangerZone.rand.nextFloat()-DangerZone.rand.nextFloat()) * 0.006f;
	}
	
	public void writeSelf(Properties prop, String tag){
		super.writeSelf(prop, tag);
		prop.setProperty(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", deathtimer));
	}
	
	public void readSelf(Properties prop, String tag){
		super.readSelf(prop, tag);
		deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 32768, 600);
	}
	
	public void update( float deltaT){
		
		this.rotation_pitch_motion = 3;
		this.rotation_yaw_motion = 9;
		this.rotation_roll_motion = 5;
				
		if(this.world.isServer){

			int bbid;
			float f;
			
			if(posy < -10){
				this.deadflag = true;
				return;
			}
			
		
			if(this.world.rand.nextInt(100) == 1){
				f = this.world.rand.nextFloat() * 0.12f;
				//System.out.printf("Random f = %f\n", f);
				motiony += f;
			}
			if(this.world.rand.nextInt(200) == 1){
				mx = (this.world.rand.nextFloat()-this.world.rand.nextFloat()) * 0.006f;
				//System.out.printf("Random f = %f\n", f);
				//motionx += f;
			}
			if(this.world.rand.nextInt(200) == 1){
				mz = (this.world.rand.nextFloat()-this.world.rand.nextFloat()) * 0.006f;
				//System.out.printf("Random f = %f\n", f);
				//motionz += f;
			}
			
			motionx += mx;
			motionz += mz;
			
			bbid = this.world.getblock(dimension, (int)this.posx, (int)(this.posy-(this.getHeight())), (int)this.posz);
			if(Blocks.isSolid(bbid)){				
				motiony += 0.25f * deltaT;

			}else{
				motiony -= 0.05f * deltaT;
			}
			

			deathtimer--;
			if(deathtimer <= 0){
				this.deadflag = true;
				return;
			}
			
			if(pickup_delay > 0)pickup_delay--;
			
			if(!this.deadflag && pickup_delay <= 0){
				Player p = DangerZone.server.findNearestPlayer(this);
				if(p != null && !p.deadflag){
					if(this.getDistanceFromEntity(p) < (p.getWidth()/2)+5){
						if(this.getDistanceFromEntity(p) < p.getWidth()*3/2){
							boolean doplaysound = false;
							int ntimes = gethotbarindex();
							if(ntimes <= 0)ntimes = 1; //default is 1
							while(ntimes > 0){
								if(!p.putMeInASlot(this.getBID(), this.getIID(), this.getItemDamage())){
									doplaysound = false;
									sethotbarindex(ntimes); //didn't all fit!
									break;
								}else{
									doplaysound = true;
								}
								ntimes--;
							}
							if(doplaysound){
								this.deadflag = true;							
								world.playSound("DangerZone:pop", dimension, posx, posy, posz, 1.0f, 1.0f+(world.rand.nextFloat()-world.rand.nextFloat())*0.3f);
							}
						}
						
						
					   	float tdir = (float) Math.atan2(p.posx - posx, p.posz - posz);
				    	float dist;
				    	float factor = 1.0f;
				    	dist = this.getDistanceFromEntity(p);
				    	factor = ((p.getWidth()/2)+5.0f)/dist;
				    	if(factor > 1)factor = 1; 
				    	motionx += 0.08f*factor*Math.sin(tdir) * deltaT;
				    	motionz += 0.08f*factor*Math.cos(tdir) * deltaT;
				    	if(posy>p.posy)motiony -= 0.05f * deltaT;
				    	if(posy<p.posy)motiony += 0.15f * deltaT;
					}
				}
			}

		}else{
			float rate = DangerZone.entityupdaterate;
			rate /= DangerZone.serverentityupdaterate;
			int bbid = this.world.getblock(dimension, (int)this.posx, (int)(this.posy-(this.getHeight())), (int)this.posz);
			if(Blocks.isSolid(bbid)){				
				motiony += 0.25f * rate * deltaT;
			}else{
				motiony -= 0.05f * rate * deltaT;
			}
		}
		super.update( deltaT );
	}
	

	
}
