package dangerzone.blocks;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

import org.newdawn.slick.opengl.Texture;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldRenderer;

import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.gui.InventoryMenus;



public class Blocks {
	
	public static Block stone = new BlockStone("DangerZone:Stone", "res/blocks/stone.png", 100);
	public static Block stone2 = new BlockStone("DangerZone:Decorative Stone", "res/blocks/stone2.png", 95);
	public static Block stone3 = new BlockStone("DangerZoneI:Decorative Stone", "res/blocks/stone3.png", 90);
	public static Block stone4 = new BlockStone("DangerZoneII:Decorative Stone", "res/blocks/stone4.png", 85);
	public static Block greystone = new BlockStone("DangerZone:Grey Stone", "res/blocks/greystone.png", 120);
	public static Block greystone2 = new BlockStone("DangerZone:Decorative Grey Stone", "res/blocks/greystone2.png", 115);
	public static Block greystone3 = new BlockStone("DangerZoneI:Decorative Grey Stone", "res/blocks/greystone3.png", 110);
	public static Block greystone4 = new BlockStone("DangerZoneII:Decorative Grey Stone", "res/blocks/greystone4.png", 105);
	public static Block whitestone = new BlockStone("DangerZone:White Stone", "res/blocks/whitestone.png", 140);
	public static Block dirt = new BlockDirt("DangerZone:Dirt", "res/blocks/dirt.png");
	public static Block stopblock = new StopBlock("DangerZone:Stop Block", "res/blocks/stopblock.png");
	public static Block hardrock = new StopBlock("DangerZone:Hard Rock", "res/blocks/hardrock.png");
	public static Block firestone = new FireStone("DangerZone:Fire Stone", "res/blocks/firestone.png", 85);
	public static Block redwoodlog = new BlockLog("DangerZone:Redwood Log", "res/blocks/redwood.png", "res/blocks/redwood_top.png");
	public static Block willowlog = new BlockLog("DangerZone:Willow Log", "res/blocks/willowwood.png", "res/blocks/willowwood_top.png");
	public static Block log = new BlockLog("DangerZone:Log", "res/blocks/wood.png", "res/blocks/wood_top.png");
	public static Block lightplywood = new BlockWood("DangerZone:Light Plywood", "res/blocks/lightplywood.png");
	public static Block plywood = new BlockWood("DangerZone:Plywood", "res/blocks/plywood.png");
	public static Block darkplywood = new BlockWood("DangerZone:Dark Plywood", "res/blocks/darkplywood.png");
	public static Block leaves = new BlockLeaves("DangerZone:Leaves", "res/blocks/leaves.png");
	public static Block redwoodleaves = new BlockLeaves("DangerZone:Redwood Leaves", "res/blocks/redwoodleaves.png");
	public static Block willowleaves = new BlockLeaves("DangerZone:Willow Leaves", "res/blocks/willowleaves.png");
	public static Block grassblock = new GrassBlock("DangerZone:Grass Block", "res/blocks/grasstop.png", "res/blocks/grassbottom.png", "res/blocks/grassside.png");
	public static Block grass = new Grass("DangerZone:Grass", "res/blocks/grass.png");
	public static Block orecopper = new BlockOre("DangerZone:Copper Ore", "res/blocks/orecopper.png", 50, 1);
	public static Block oretin = new BlockOre("DangerZone:Tin Ore", "res/blocks/oretin.png", 100, 5);
	public static Block oresilver = new BlockOre("DangerZone:Silver Ore", "res/blocks/oresilver.png", 150, 12);
	public static Block oreplatinum = new BlockOre("DangerZone:Platinum Ore", "res/blocks/oreplatinum.png", 200, 16);
	public static Block orediamond = new BlockOreDiamond("DangerZone:Diamond Ore", "res/blocks/orediamond.png", 225, 16);
	public static Block oreemerald = new BlockOreEmerald("DangerZone:Emerald Ore", "res/blocks/oreemerald.png", 150, 12);
	public static Block orebloodstone = new BlockOreBloodstone("DangerZone:Bloodstone Ore", "res/blocks/orebloodstone.png", 125, 12);
	public static Block oresunstone = new BlockOreSunstone("DangerZone:Sunstone Ore", "res/blocks/oresunstone.png", 125, 12);
	public static Block workbench = new BlockWorkBench("DangerZone:Workbench");
	public static Block furnace = new BlockFurnace("DangerZone:Furnace");
	public static Block furnaceOn = new BlockFurnaceOn("DangerZone:FurnaceOn");
	public static Block chest = new BlockChest("DangerZone:Chest");
	public static Block lightstick = new LightStick("DangerZone:Lightstick", "res/blocks/torch.png");
	public static Block darkstick = new DarkStick("DangerZone:Darkstick", "res/blocks/darkstick.png");
	public static Block oredark = new BlockDark("DangerZone:Dark Ore", "res/blocks/oredark.png", 200);
	public static Block orelight = new BlockLight("DangerZone:Light Ore", "res/blocks/orelight.png", 50);
	public static Block water = new BlockWater("DangerZone:Water", "res/blocks/water.png");
	public static Block watersource = new BlockWaterSource("DangerZone:Water Source", "res/blocks/water.png");
	public static Block corn_plant = new BlockCorn("DangerZone:Baby Corn Plant", "res/blocks/corn_0.png");
	public static Block corn_plant1 = new BlockCorn("DangerZone:Corn Plant", "res/blocks/corn_1.png");
	public static Block corn_plant2 = new BlockCorn("DangerZone:Flowering Corn Plant", "res/blocks/corn_2.png");
	public static Block corn_plant3 = new BlockCorn("DangerZone:Ripe Corn Plant", "res/blocks/corn_3.png");
	public static Block roachnest = new RoachBlock("DangerZone:Cockroach Nest", "res/blocks/roachnest.png", "res/blocks/grassbottom.png", "res/blocks/grassside.png");
	public static Block glass = new BlockGlass("DangerZone:Glass", "res/blocks/glass.png", 10);
	public static Block flower_red = new BlockFlower("DangerZone:Red Flower", "res/blocks/flower_red.png");
	public static Block flower_pink = new BlockFlower("DangerZone:Blue Flower", "res/blocks/flower_pink.png");
	public static Block flower_purple = new BlockFlower("DangerZone:Purple Flower", "res/blocks/flower_purple.png");
	public static Block flower_yellow = new BlockFlower("DangerZone:Yellow Flower", "res/blocks/flower_yellow.png");
	public static Block butterfly_plant = new ButterflyPlant("DangerZone:Butterfly Plant", "res/blocks/butterfly_0.png");
	public static Block butterfly_plant1 = new ButterflyPlant("DangerZone:Butterfly Plant 1", "res/blocks/butterfly_1.png");
	public static Block butterfly_plant2 = new ButterflyPlant("DangerZone:Butterfly Plant 2", "res/blocks/butterfly_2.png");
	public static Block butterfly_plant3 = new ButterflyPlant("DangerZone:Butterfly Plant 3", "res/blocks/butterfly_3.png");
	public static Block sand = new BlockSand("DangerZone:Sand", "res/blocks/sand.png");
	public static Block radish_plant = new RadishPlant("DangerZone:Radish Plant", "res/blocks/radish_0.png");
	public static Block radish_plant1 = new RadishPlant("DangerZone:Radish Plant 1", "res/blocks/radish_1.png");
	public static Block radish_plant2 = new RadishPlant("DangerZone:Radish Plant 2", "res/blocks/radish_2.png");
	public static Block radish_plant3 = new RadishPlant("DangerZone:Radish Plant 3", "res/blocks/radish_3.png");
	public static Block rice_plant = new RicePlant("DangerZone:Rice Plant", "res/blocks/rice_0.png");
	public static Block rice_plant1 = new RicePlant("DangerZone:Rice Plant 1", "res/blocks/rice_1.png");
	public static Block rice_plant2 = new RicePlant("DangerZone:Rice Plant 2", "res/blocks/rice_2.png");
	public static Block rice_plant3 = new RicePlant("DangerZone:Rice Plant 3", "res/blocks/rice_3.png");
	public static Block blockcopper = new BlockMetal("DangerZone:Copper Block", "res/blocks/blockcopper.png", 100);
	public static Block blocktin = new BlockMetal("DangerZone:Tin Block", "res/blocks/blocktin.png", 125);
	public static Block blocksilver = new BlockMetal("DangerZone:Silver Block", "res/blocks/blocksilver.png", 150);
	public static Block blockplatinum = new BlockMetal("DangerZone:Platinum Block", "res/blocks/blockplatinum.png", 250);
	public static Block blockdiamond = new BlockMetal("DangerZone:Diamond Block", "res/blocks/blockdiamond.png", 250);
	public static Block blockemerald = new BlockMetal("DangerZone:Emerald Block", "res/blocks/blockemerald.png", 200);
	public static Block blockbloodstone = new BlockMetal("DangerZone:Bloodstone Block", "res/blocks/blockbloodstone.png", 175);
	public static Block blocksunstone = new BlockMetal("DangerZone:Sunstone Block", "res/blocks/blocksunstone.png", 175);
	public static Block blockdark = new BlockBlockDark("DangerZone:Dark Block", "res/blocks/blockdark.png", 400);
	public static Block blocklight = new BlockBlockLight("DangerZone:Light Block", "res/blocks/blocklight.png", 350);
	public static Block peachleaves = new BlockPeachLeaves("DangerZone: Peach Leaves", "res/blocks/peachleaves.png");
	public static Block cherryleaves = new BlockCherryLeaves("DangerZone:Cherry Leaves", "res/blocks/cherryleaves.png");
	public static Block appleleaves = new BlockAppleLeaves("DangerZone:Apple Leaves", "res/blocks/appleleaves.png");
	public static Block blueglass = new BlockColoredGlass("DangerZone:Blue Glass", "res/blocks/glassblue.png", 10);
	public static Block greenglass = new BlockColoredGlass("DangerZone:Green Glass", "res/blocks/glassgreen.png", 10);
	public static Block redglass = new BlockColoredGlass("DangerZone:Red Glass", "res/blocks/glassred.png", 10);
	public static Block violetglass = new BlockColoredGlass("DangerZone:Violet Glass", "res/blocks/glassviolet.png", 10);
	public static Block yellowglass = new BlockColoredGlass("DangerZone:Yellow Glass", "res/blocks/glassyellow.png", 10);
	public static Block stickyblock = new StickyBlock("DangerZone:Sticky Block", "res/blocks/stickyblock.png");
	public static Block coloringblock = new ColoringBlock("DangerZone:Coloring Block", "res/blocks/coloringblock.png");
	public static Block doortop = new Door("DangerZone:Door Top", "res/blocks/door_top.png");
	public static Block doorbottom = new Door("DangerZone:Door Bottom", "res/blocks/door_bottom.png");
	
	public static Block cloud_light = new BlockCloud("DangerZone:Cloud", "res/blocks/cloud_light.png");
	public static Block cloud_rain = new BlockCloud("DangerZone:Rain Cloud", "res/blocks/cloud_rain.png");
	public static Block cloud_thunder = new BlockCloud("DangerZone:Thunder Cloud", "res/blocks/cloud_thunder.png");
	
	//name of spawner, what to spawn, scale, tenths of seconds, how many to spawn, min light level (-1), max light level (2)
	public static Block butterflyspawner = new BlockSpawner("DangerZone:Butterfly Spawner", "DangerZone:Butterfly", 0.80f, 200, 3, 0.55f, 1.75f);
	public static Block ghostspawner = new BlockSpawner("DangerZone:Ghost Spawner", "DangerZone:Ghost", 0.65f, 300, 2, -0.55f, 0.55f);
	public static Block ghostskellyspawner = new BlockSpawner("DangerZone:Ghost Skelly Spawner", "DangerZone:GhostSkelly", 0.5f, 400, 2, -0.55f, 0.55f);
	public static Block ratspawner = new BlockSpawner("DangerZone:Rat Spawner", "DangerZone:Rat", 0.65f, 300, 3, -0.25f, 1.0f);
	public static Block cockroachspawner = new BlockSpawner("DangerZone:Cockroach Spawner", "DangerZone:Cockroach", 1.25f, 300, 3, -0.55f, 1.55f);
	public static Block moosespawner = new BlockSpawner("DangerZone:Moose Spawner", "DangerZone:Moose", 0.25f, 600, 1, 0.55f, 1.55f);
	public static Block sparklemuffinspawner = new BlockSpawner("DangerZone:Sparklemuffin Spawner", "DangerZone:Sparklemuffin", 0.4f, 1200, 1, -0.55f, 0.55f);
	public static Block skeletorusspawner = new BlockSpawner("DangerZone:Skeletorus Spawner", "DangerZone:Skeletorus", 0.4f, 1200, 1, -0.55f, 0.55f);
	public static Block goosespawner = new BlockSpawner("DangerZone:Goose Spawner", "DangerZone:Goose", 0.40f, 600, 2, 0.55f, 1.55f);
	public static Block goslingspawner = new BlockSpawner("DangerZone:Gosling Spawner", "DangerZone:Gosling", 0.90f, 600, 2, 0.55f, 1.55f);
	public static Block ostrichspawner = new BlockSpawner("DangerZone:Ostrich Spawner", "DangerZone:Ostrich", 0.35f, 700, 1, 0.55f, 1.55f);
	public static Block anteaterspawner = new BlockSpawner("DangerZone:Anteater Spawner", "DangerZone:Anteater", 0.25f, 600, 1, 0.55f, 1.55f);
	public static Block werewolfspawner = new BlockSpawner("DangerZone:Werewolf Spawner", "DangerZone:Werewolf", 0.48f, 800, 2, -0.55f, 0.55f);
	public static Block vampirespawner = new BlockSpawner("DangerZone:Vampire Spawner", "DangerZone:Vampire", 0.48f, 800, 2, -0.55f, 0.55f);
	public static Block thecountspawner = new BlockSpawner("DangerZone:The Count Spawner", "DangerZone:The Count", 0.48f, 1200, 1, -0.55f, 0.55f);
	public static Block vampiremoosespawner = new BlockSpawner("DangerZone:Vampire Moose Spawner", "DangerZone:Vampire Moose", 0.25f, 1500, 1, -0.55f, 0.55f);
	public static Block fishspawner = new BlockSpawner("DangerZone:Fish Spawner", "DangerZone:Fish", 0.45f, 300, 3, 0.55f, 1.55f);
	
	public static Block block_lightgrey = new BlockOre("DangerZone:Light Grey Block", "res/blocks/block_lightgrey.png", 5, 1);
	public static Block block_lightgreen = new BlockOre("DangerZone:Light Green Block", "res/blocks/block_lightgreen.png", 5, 1);
	public static Block block_lightred = new BlockOre("DangerZone:Light Red Block", "res/blocks/block_lightred.png", 5, 1);
	public static Block block_lightblue = new BlockOre("DangerZone:Light Blue Block", "res/blocks/block_lightblue.png", 5, 1);
	public static Block block_lightyellow = new BlockOre("DangerZone:Light Yellow Block", "res/blocks/block_lightyellow.png", 5, 1);
	public static Block block_lightorange = new BlockOre("DangerZone:Light Orange Block", "res/blocks/block_lightorange.png", 5, 1);
	public static Block block_lightpurple = new BlockOre("DangerZone:Light Purple Block", "res/blocks/block_lightpurple.png", 5, 1);
	public static Block block_lightviolet = new BlockOre("DangerZone:Light Violet Block", "res/blocks/block_lightviolet.png", 5, 1);
	public static Block block_lightbrown = new BlockOre("DangerZone:Light Brown Block", "res/blocks/block_lightbrown.png", 5, 1);
	
	public static Block block_grey = new BlockOre("DangerZone:Grey Block", "res/blocks/block_grey.png", 5, 1);
	public static Block block_green = new BlockOre("DangerZone:Green Block", "res/blocks/block_green.png", 5, 1);
	public static Block block_red = new BlockOre("DangerZone:Red Block", "res/blocks/block_red.png", 5, 1);
	public static Block block_blue = new BlockOre("DangerZone:Blue Block", "res/blocks/block_blue.png", 5, 1);
	public static Block block_yellow = new BlockOre("DangerZone:Yellow Block", "res/blocks/block_yellow.png", 5, 1);
	public static Block block_orange = new BlockOre("DangerZone:Orange Block", "res/blocks/block_orange.png", 5, 1);
	public static Block block_purple = new BlockOre("DangerZone:Purple Block", "res/blocks/block_purple.png", 5, 1);
	public static Block block_violet = new BlockOre("DangerZone:Violet Block", "res/blocks/block_violet.png", 5, 1);
	public static Block block_brown = new BlockOre("DangerZone:Brown Block", "res/blocks/block_brown.png", 5, 1);
	
	public static Block block_darkgrey = new BlockOre("DangerZone:Dark Grey Block", "res/blocks/block_darkgrey.png", 5, 1);
	public static Block block_darkgreen = new BlockOre("DangerZone:Dark Green Block", "res/blocks/block_darkgreen.png", 5, 1);
	public static Block block_darkred = new BlockOre("DangerZone:Dark Red Block", "res/blocks/block_darkred.png", 5, 1);
	public static Block block_darkblue = new BlockOre("DangerZone:Dark Blue Block", "res/blocks/block_darkblue.png", 5, 1);
	public static Block block_darkyellow = new BlockOre("DangerZone:Dark Yellow Block", "res/blocks/block_darkyellow.png", 5, 1);
	public static Block block_darkorange = new BlockOre("DangerZone:Dark Orange Block", "res/blocks/block_darkorange.png", 5, 1);
	public static Block block_darkpurple = new BlockOre("DangerZone:Dark Purple Block", "res/blocks/block_darkpurple.png", 5, 1);
	public static Block block_darkviolet = new BlockOre("DangerZone:Dark Violet Block", "res/blocks/block_darkviolet.png", 5, 1);
	public static Block block_darkbrown = new BlockOre("DangerZone:Dark Brown Block", "res/blocks/block_darkbrown.png", 5, 1);
	
	public static Block BlockArray[];
	public static final int blocksMAX = 2048;
	public static Properties prop = null;
		
	public Blocks(){
		int i;
		BlockArray = new Block[blocksMAX];
		for(i=0;i<blocksMAX;i++){
			BlockArray[i] = null;
		}
	}
	
	public static int registerBlock(Block b){
		int i = 0;
		
		for(i=1;i<blocksMAX;i++){
			if(BlockArray[i] != null){
				if(BlockArray[i].uniquename.equals(b.uniquename)){ //duplicate!!!
					return 0; //duplicate!!!
				}
			}
		}
		
		for(i=1;i<blocksMAX;i++){
			if(BlockArray[i] == null)break;
		}
		if(i >= blocksMAX-1)return 0;
		
		if(prop != null)i = Utils.getPropertyInt(prop, b.uniquename, 1, blocksMAX-1, i);

		//existing or new block
		if(BlockArray[i] == null){ //Slot is open, this is good. Give it the same ID it had last time!
			BlockArray[i] = b;
			b.blockID = i;
			if(prop != null)prop.setProperty(b.uniquename, String.format("%d", i)); //next time we will find it!
			return i;
		}else{ 
			//Oops. Slot already taken.
			//Give this slot to the existing one, and bump the intruder to a new slot.
			//Should only happen when adding new mods and they get loaded before old ones.
			Block intruder = BlockArray[i];
			int isave = i;
			BlockArray[i] = b;
			b.blockID = i;
			for(i=1;i<blocksMAX;i++){
				if(BlockArray[i] == null){
					BlockArray[i] = intruder;
					intruder.blockID = i;
					if(prop != null)prop.setProperty(intruder.uniquename, String.format("%d", i)); //next time we will find it!
					return isave;
				}
			}			
		}
		return 0;
	}
	
	public static int lookup(String name){
		int ret = Utils.getPropertyInt(prop, name, 1, blocksMAX-1, 0);
		return ret;
	}
	
	public static void addthis(String name, int i){
		prop.setProperty(name, String.format("%d", i));
		return;
	}
	
	public static void reRegisterBlockAt(String s, int loc){
		int i;
		
		if(loc <= 0 || loc >= blocksMAX)return;
		if(s == null || s.equals(""))return;
		
		if(BlockArray[loc] != null){
			if(s.equals(BlockArray[loc].uniquename)){
				return; //already where its supposed to be! :)
			}
			//maybe it is somewhere else?
			for(i=1;i<blocksMAX;i++){
				if(BlockArray[i] != null){
					if(s.equals(BlockArray[i].uniquename)){
						//Take it, and move the intruder where I was
						Block me = BlockArray[i];
						Block intruder = BlockArray[loc];
						BlockArray[loc] = me;
						BlockArray[loc].blockID = loc;
						BlockArray[i] = intruder;
						BlockArray[i].blockID = i;
						return;
					}
				}
			}
		}else{
			//maybe it is somewhere else?
			for(i=1;i<blocksMAX;i++){
				if(BlockArray[i] != null){
					if(s.equals(BlockArray[i].uniquename)){
						//Move it!
						BlockArray[loc] = BlockArray[i];
						BlockArray[loc].blockID = loc;
						BlockArray[i] = null;
						return;
					}
				}
			}
		}
	}
	
	public static void load(){
		InputStream input = null;
		prop = new Properties();
		String filepath = new String();		
		filepath = String.format("worlds/%s/blockIDs.dat", DangerZone.worldname);	
		 
		try {	 
			input = new FileInputStream(filepath);
	 
			// load a properties file
			prop.load(input);

		} catch (IOException ex) {
			//ex.printStackTrace();
			input = null;
		}
		if (input != null) {
			try {
				input.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}		
	}
	
	public static void save(){

		OutputStream output = null;
		String filepath = new String();		
		filepath = String.format("worlds/%s/blockIDs.dat", DangerZone.worldname);	
		File f = new File(filepath);		
		f.getParentFile().mkdirs();	
		
		try {	 
			output = new FileOutputStream(filepath);
			// save properties
			prop.store(output, null);
	 
		} catch (IOException io) {
			io.printStackTrace();
		}
		if (output != null) {
			try {
				output.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}		
	}
	
	//used for when it matters and block can change solidity, like a door...
	public static boolean isSolid(int blockid, World w, int d, int x, int y, int z){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].getIsSolid(w, d, x, y, z);
	}
	
	//used for when it matters and block can change solidity, like a door...
	public static void bumpedBlock(int blockid, Entity e, World w, int d, int x, int y, int z){
		if(blockid <= 0)return;
		if(blockid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[blockid]==null)return;
		Blocks.BlockArray[blockid].bumpedBlock(e, w, d, x, y, z);
	}
	
	//when you really don't care too much...
	public static boolean isSolid(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].isSolid;
	}
	
	public static boolean isLiquid(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].isLiquid;
	}
	
	public static boolean isSquishy(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].isSquishy;
	}
	
	public static boolean isSolidForRender(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].isSolidForRendering;
	}
	
	public static boolean renderAllSides(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].renderAllSides;
	}
	
	public static boolean renderSmaller(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].renderSmaller;
	}
	
	public static boolean shouldShow(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].showInInventory;
	}
	
	public static boolean isTranslucentForRender(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].isTranslucent;
	}
	
	public static boolean hasOwnRenderer(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].hasOwnRenderer;
	}
	
	public static boolean alwaystick(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].alwaystick;
	}
	
	public static boolean randomtick(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].randomtick;
	}
	
	public static boolean isWood(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].isWood;
	}
	
	public static boolean isStone(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].isStone;
	}
	
	public static boolean isDirt(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].isDirt;
	}
	
	public static boolean isLeaves(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].isLeaves;
	}
	
	public static boolean canLeavesGrow(int blockid){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].canLeavesGrow;
	}
	
	public static void doblocktick(World w, int d, int x, int y, int z, int blockid){
		if(blockid <= 0)return;
		if(blockid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[blockid]==null)return;		
		Blocks.BlockArray[blockid].tickMe(w, d, x, y, z);
	}
	
	public static void dofastblocktick(World w, int d, int x, int y, int z, int blockid){
		if(blockid <= 0)return;
		if(blockid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[blockid]==null)return;		
		Blocks.BlockArray[blockid].tickMeFast(w, d, x, y, z);
	}
	
	public static void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int blockid, int meta, int sides, boolean focused){
		if(blockid <= 0)return;
		if(blockid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[blockid]==null)return;
		Blocks.BlockArray[blockid].renderMe(wr, w, d, x, y, z, blockid, meta, sides, focused);
	}
	
	public static void renderMeToVBO(long chunkvbos[], WorldRenderer wr, World w, int d, int x, int y, int z, int blockid, int meta, int sides, boolean focused, int xo, int yo, int zo){
		if(blockid <= 0)return;
		if(blockid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[blockid]==null)return;
		Blocks.BlockArray[blockid].renderMeToVBO(chunkvbos, wr, w, d, x, y, z, blockid, meta, sides, focused, xo, yo, zo);
	}
	
	public static String getBreakSound(int blockid){
		if(blockid <= 0)return null;
		if(blockid >= Blocks.blocksMAX)return null;
		if(Blocks.BlockArray[blockid]==null)return null;
		return Blocks.BlockArray[blockid].getBreakSound();
	}
	
	public static String getPlaceSound(int blockid){
		if(blockid <= 0)return null;
		if(blockid >= Blocks.blocksMAX)return null;
		if(Blocks.BlockArray[blockid]==null)return null;
		return Blocks.BlockArray[blockid].getPlaceSound();
	}
	
	public static String getHitSound(int blockid){
		if(blockid <= 0)return null;
		if(blockid >= Blocks.blocksMAX)return null;
		if(Blocks.BlockArray[blockid]==null)return null;
		return Blocks.BlockArray[blockid].getHitSound();
	}
	
	public static String getParticleName(int blockid){
		if(blockid <= 0)return null;
		if(blockid >= Blocks.blocksMAX)return null;
		if(Blocks.BlockArray[blockid]==null)return null;
		return Blocks.BlockArray[blockid].getParticleName();
	}
	
	public static int getMaxStack(int blockid){
		if(blockid <= 0)return 0;
		if(blockid >= Blocks.blocksMAX)return 0;
		if(Blocks.BlockArray[blockid]==null)return 0;
		return Blocks.BlockArray[blockid].maxstack;
	}
	
	public static int getMinDamage(int blockid){
		if(blockid <= 0)return 0;
		if(blockid >= Blocks.blocksMAX)return 0;
		if(Blocks.BlockArray[blockid]==null)return 0;
		return Blocks.BlockArray[blockid].mindamage;
	}

	public static Texture getTexture(int blockid){
		if(blockid <= 0)return null;
		if(blockid >= Blocks.blocksMAX)return null;
		if(Blocks.BlockArray[blockid]==null)return null;
		return Blocks.BlockArray[blockid].getTexture(1 /*front*/);
	}
	
	public static void notifyNeighborChanged(int blockid, World w, int d, int x, int y, int z){
		if(blockid <= 0)return;
		if(blockid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[blockid]==null)return;
		Blocks.BlockArray[blockid].notifyNeighborChanged(w, d, x, y, z);
	}
	
	public static String getUniqueName(int blockid){
		if(blockid <= 0)return null;
		if(blockid >= Blocks.blocksMAX)return null;
		if(Blocks.BlockArray[blockid]==null)return null;
		return Blocks.BlockArray[blockid].uniquename;
	}
	
	public static int findByName(String name){
		int i;
		if(name == null)return 0;
		for(i=1;i<blocksMAX;i++){
			if(BlockArray[i] != null){
				if(BlockArray[i].uniquename != null){
					if(name.equals(BlockArray[i].uniquename)){
						return i;
					}
				}
			}
		}
		return 0;
	}
	
	public static boolean rightClickOnBlock(int blockid, Player p, int d, int x, int y, int z){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].rightClickOnBlock(p, d, x, y, z);
	}
	
	public static boolean leftClickOnBlock(int blockid, Player p, int d, int x, int y, int z){
		if(blockid <= 0)return false;
		if(blockid >= Blocks.blocksMAX)return false;
		if(Blocks.BlockArray[blockid]==null)return false;
		return Blocks.BlockArray[blockid].leftClickOnBlock(p, d, x, y, z);
	}
	
	public static void onBlockBroken(int blockid, Player p, int d, int x, int y, int z){
		if(blockid <= 0)return;
		if(blockid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[blockid]==null)return;
		Blocks.BlockArray[blockid].onBlockBroken(p, d, x, y, z);
	}
	
	public static int getMaxDamage(int blockid){
		if(blockid <= 0)return 0;
		if(blockid >= Blocks.blocksMAX)return 0;
		if(Blocks.BlockArray[blockid]==null)return 0;
		return Blocks.BlockArray[blockid].maxdamage;
	}
	
	public static int getBlockDrop(int blockid, Player p, World w, int d, int x, int y, int z){
		if(blockid <= 0)return 0;
		if(blockid >= Blocks.blocksMAX)return 0;
		if(Blocks.BlockArray[blockid]==null)return 0;
		return Blocks.BlockArray[blockid].getBlockDrop(p, w, d, x, y, z);
	}
	
	public static int getItemDrop(int blockid, Player p, World w, int d, int x, int y, int z){
		if(blockid <= 0)return 0;
		if(blockid >= Blocks.blocksMAX)return 0;
		if(Blocks.BlockArray[blockid]==null)return 0;
		return Blocks.BlockArray[blockid].getItemDrop(p, w, d, x, y, z);
	}
	
	public static int getDropCount(int blockid, Player p, World w, int d, int x, int y, int z){
		if(blockid <= 0)return 0;
		if(blockid >= Blocks.blocksMAX)return 0;
		if(Blocks.BlockArray[blockid]==null)return 0;
		return Blocks.BlockArray[blockid].getDropCount(p, w, d, x, y, z);
	}
	
	public static float getFriction(int blockid){
		if(blockid <= 0)return 0;
		if(blockid >= Blocks.blocksMAX)return 0;
		if(Blocks.BlockArray[blockid]==null)return 0;
		return Blocks.BlockArray[blockid].friction;
	}
	
	public static float getLightLevel(int blockid){
		if(blockid <= 0)return 0.0f;
		if(blockid >= Blocks.blocksMAX)return 0.0f;
		if(Blocks.BlockArray[blockid]==null)return 0.0f;
		return Blocks.BlockArray[blockid].brightness;
	}
	
	public static void doSteppedOn(int blockid, Entity e, World w, int d, int x, int y, int z){
		if(blockid <= 0)return;
		if(blockid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[blockid]==null)return;
		Blocks.BlockArray[blockid].doSteppedOn(e, w, d, x, y, z);
	}
	
	public static void doPlaceBlock(int blockid, int focusblockid, Player p, World w, int d, int x, int y, int z, int side){
		if(blockid <= 0)return;
		if(blockid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[blockid]==null)return;
		Blocks.BlockArray[blockid].doPlaceBlock(focusblockid, p, w, d, x, y, z, side);
	}
	
	public static void doBreakBlock(int blockid, World w, int d, int x, int y, int z){
		if(blockid <= 0)return;
		if(blockid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[blockid]==null)return;
		int bid = Blocks.BlockArray[blockid].getBlockDrop(null, w, d, x, y, z);
		int iid = Blocks.BlockArray[blockid].getItemDrop(null, w, d, x, y, z);
		if(bid != 0 || iid != 0){
			EntityBlockItem eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, x+0.5f, y+0.5f, z+0.5f);
			if(eb != null){
				eb.setBID(bid);
				eb.setIID(iid);
				w.spawnEntityInWorld(eb);
			}
		}
	}
	
	
	public static int getBurnTime(int blockid){
		if(blockid <= 0)return 0;
		if(blockid >= Blocks.blocksMAX)return 0;
		if(Blocks.BlockArray[blockid]==null)return 0;
		return Blocks.BlockArray[blockid].burntime;
	}
	
	public static int getMenu(int blockid){
		if(blockid <= 0)return InventoryMenus.GENERIC;
		if(blockid >= Blocks.blocksMAX)return InventoryMenus.GENERIC;
		if(Blocks.BlockArray[blockid]==null)return InventoryMenus.GENERIC;
		return Blocks.BlockArray[blockid].menu;
	}
	
	public static Block getBlock(int blockid){
		if(blockid <= 0)return null;
		if(blockid >= Blocks.blocksMAX)return null;
		return Blocks.BlockArray[blockid];
	}
	
	public static String getStepSound(int blockid){
		if(blockid <= 0)return null;
		if(blockid >= Blocks.blocksMAX)return null;
		if(Blocks.BlockArray[blockid]==null)return null;
		return Blocks.BlockArray[blockid].getStepSound();
	}

}
