package dangerzone.blocks;
import dangerzone.Player;
import dangerzone.World;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class BlockWaterSource extends Block {

	//non-ticking water block. otherwise, large bodies of water would eat CPU and slow everything down.
	//checks to see if something significant changed.
	//if so, sets itself to a ticking water block.
	
	public BlockWaterSource(String n, String txt){
		super(n, txt);
		isSolidForRendering = false;
		isSolid = false;
		isTranslucent = true;
		friction = 0.10f;
		maxdamage = 2;
		maxstack = 16;
		showInInventory = false; //hide me!
		isLiquid = true;
	}
	
	public void notifyNeighborChanged(World w, int d, int x, int y, int z){
		int i, j, k;
		int bid;
		int meta;
		boolean change = false;
		
		if(w.isServer){
			for(i=-1;i<=1;i++){
				for(j=0;j>=-1;j--){
					for(k=-1;k<=1;k++){
						bid = w.getblock(d, x+i, y+j, z+k);
						meta = w.getblockmeta(d, x+i, y+j, z+k);
						if(bid == 0){
							change = true;
						}else if(bid == Blocks.water.blockID){
							if(meta != 0)change = true;
						}else if(bid != Blocks.watersource.blockID){
							if(!Blocks.isSolid(bid))change = true;
						}
					}
				}
			}
			if(change){
				w.setblockandmetanonotify(d, x, y, z, Blocks.water.blockID, 0); //change to an actively ticking block!
			}
		}
	}
	
	public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z){
		//Player can be NULL! Make sure you check!
		return 0;
	}

}