package dangerzone.blocks;
import dangerzone.Player;
import dangerzone.World;
//import dangerzone.threads.FastBlockTicker;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class BlockWater extends BlockLiquid {
	

	public BlockWater(String n, String txt) {
		super(n, txt);
		maxdamage = 1;
		friction = 0.10f;
		isLiquid = true;
		isSolidForRendering = false;
		isSolid = false;
		isTranslucent = true;
		showInInventory = false; //hide me!
	}
	
	public void tickMe(World w, int d, int x, int y, int z){	
		//FastBlockTicker.addFastTick(d,  x,  y, z, 2); //ticks, in TENTHS of a second
		doTick(w, d, x, y, z);
	}
	
	public void doTick(World w, int d, int x, int y, int z){
		//see if we should change back, but be tight about it, 
		//because this could cause a fight with a watersource and go back and forth.
		int i, j, k;
		int bid;
		int meta;
		boolean change = true;
		int mymeta = w.getblockmeta(d, x, y, z);
		
		for(i=-1;i<=1&&change;i++){
			for(j=-1;j<=0&&change;j++){
				for(k=-1;k<=1&&change;k++){
					if(i==0 && j==0 && k==0)continue; //not self!
					bid = w.getblock(d, x+i, y+j, z+k);
					meta = w.getblockmeta(d, x+i, y+j, z+k);
					if(bid == 0){
						change = false;
					}else if(bid == Blocks.water.blockID){
						if(meta != 0)change = false;
					}else if(bid != Blocks.watersource.blockID){
						if(!Blocks.isSolid(bid))change = false;
					}
				}
			}
		}
		
		if(!change){
			bid = w.getblock(d, x, y+1, z);
			meta = w.getblockmeta(d, x, y+1, z);
			if(bid == Blocks.watersource.blockID){
				if(mymeta != 0){
					w.setblockandmeta(d, x, y, z, Blocks.water.blockID, 0); //fill up!
					return;
				}
			}else if(bid == Blocks.water.blockID && meta == 0){
				if(mymeta != 0){
					w.setblockandmeta(d, x, y, z, Blocks.water.blockID, 0); //fill up!
					return;
				}
			}
		}
		

		if(change){
			//System.out.printf("Changed!\n");
			w.setblockandmeta(d, x, y, z, Blocks.watersource.blockID, 0); //change to stable block!
			return;
		}
		
		super.tickMe(w, d, x, y, z);
	}
	
	//public void tickMeFast(World w, int d, int x, int y, int z){
	//	if(!w.isServer)return;
	//	FastBlockTicker.addFastTick(d, x, y, z, 2); //ticks, in TENTHS of a second
	//	doTick(w, d, x, y, z);
	//}
	
	public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z){
		//Player can be NULL! Make sure you check!
		return 0;
	}

}
