package dangerzone;

import dangerzone.biomes.Biome1;
import dangerzone.biomes.Biome2;
import dangerzone.biomes.Biome3;
import dangerzone.biomes.Biome4;
import dangerzone.biomes.Biome5;
import dangerzone.biomes.BiomeManager1;
import dangerzone.biomes.BiomeManager2;
import dangerzone.biomes.BiomeManager3;
import dangerzone.biomes.BiomeManager4;
import dangerzone.biomes.BiomeManager5;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Anteater;
import dangerzone.entities.Butterfly;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entities;
import dangerzone.entities.EntityChest;
import dangerzone.entities.EntityCloud;
import dangerzone.entities.EntityExplosion;
import dangerzone.entities.EntityExtendedRangeDamage;
import dangerzone.entities.EntityFire;
import dangerzone.entities.EntityFurnace;
import dangerzone.entities.EntityLightning;
import dangerzone.entities.EntitySpawner;
import dangerzone.entities.EntityTrophy;
import dangerzone.entities.Fish;
import dangerzone.entities.Ghost;
import dangerzone.entities.GhostSkelly;
import dangerzone.entities.Goose;
import dangerzone.entities.Gosling;
import dangerzone.entities.ModelAnteater;
import dangerzone.entities.ModelButterfly;
import dangerzone.entities.ModelCloud;
import dangerzone.entities.ModelCockroach;
import dangerzone.entities.ModelEntityBlockItem;
import dangerzone.entities.ModelFire;
import dangerzone.entities.ModelFireball;
import dangerzone.entities.ModelFish;
import dangerzone.entities.ModelFuzzButt;
import dangerzone.entities.ModelGhost;
import dangerzone.entities.ModelGhostSkelly;
import dangerzone.entities.ModelGoose;
import dangerzone.entities.ModelHumanoid;
import dangerzone.entities.ModelLightning;
import dangerzone.entities.ModelMoose;
import dangerzone.entities.ModelOstrich;
import dangerzone.entities.ModelRat;
import dangerzone.entities.ModelSpawner;
import dangerzone.entities.ModelTrophy;
import dangerzone.entities.Moose;
import dangerzone.entities.Ostrich;
import dangerzone.entities.Rat;
import dangerzone.entities.Skeletorus;
import dangerzone.entities.Sparklemuffin;
import dangerzone.entities.TheCount;
import dangerzone.entities.ThrownBlockItem;
import dangerzone.entities.ThrownFireball;
import dangerzone.entities.ThrownInstability;
import dangerzone.entities.Vampire;
import dangerzone.entities.VampireMoose;
import dangerzone.entities.Werewolf;
import dangerzone.items.Items;
import dangerzone.particles.ParticleBreak;
import dangerzone.particles.ParticleDeath;
import dangerzone.particles.ParticleDroplet;
import dangerzone.particles.ParticleDust;
import dangerzone.particles.ParticleFire;
import dangerzone.particles.ParticleHappy;
import dangerzone.particles.ParticleHurt;
import dangerzone.particles.ParticleRain;
import dangerzone.particles.ParticleSmoke;
import dangerzone.particles.ParticleSparkle;
import dangerzone.particles.Particles;

public class DangerZoneBase extends BaseMod {

	public static BiomeManager1 my_biomemanager1;
	public static Biome1 my_biome1;

	public static BiomeManager2 my_biomemanager2;
	public static Biome2 my_biome2;
	
	public static BiomeManager3 my_biomemanager3;
	public static Biome3 my_biome3;
	
	public static BiomeManager4 my_biomemanager4;
	public static Biome4 my_biome4;
	
	public static BiomeManager5 my_biomemanager5;
	public static Biome5 my_biome5;
	
	
	public static WorldDecorator fengshui;
	
	public static ChestInventoryPacket chestpacket;
	public static FurnaceInventoryPacket furnacepacket;
	
	//
	//ENTITY MODELS ARE SHARED SO THAT GRAPHICS DOESN'T RUN OUT OF COMPILE LISTS AND CRASH!
	//Many entites, one model.
	//ModelTrophy is just a pass-through, so it's not here...
	//But each of the ModelTrophy entities all point back to these models!
	//
	public static ModelButterfly modelbutterfly = new ModelButterfly();
	public static ModelRat modelrat = new ModelRat();
	public static ModelMoose modelmoose = new ModelMoose();
	public static ModelCockroach modelcockroach = new ModelCockroach();
	public static ModelGhost modelghost = new ModelGhost();
	public static ModelGhostSkelly modelghostskelly = new ModelGhostSkelly();
	public static ModelGoose modelgoose = new ModelGoose();
	public static ModelFuzzButt modelfuzzbutt = new ModelFuzzButt();
	public static ModelAnteater modelanteater = new ModelAnteater();
	public static ModelHumanoid modelhumanoid = new ModelHumanoid();
	public static ModelOstrich modelostrich = new ModelOstrich();
	public static ModelLightning modellightning = new ModelLightning();
	public static ModelCloud modelcloud = new ModelCloud();
	public static ModelFish modelfish = new ModelFish();
	
	public DangerZoneBase(){
		super();		
	}
	
	/*
	 * Replace with the name of your mod.
	 */
	public String getModName()
	{
		return "DangerZone Base Version 0.9";
	}
	
	
	/*
	 * RETURN THE VERSION OF DANGERZONE THIS MOD IS BUILT WITH!!!!
	 * THIS IS SO WE CAN CHECK COMPATIBILITY AND NOT FRUSTRATE AND CRASH THE PLAYER!!!
	 * SEE DANGERZONE.VERSIONSTRING
	 * 
	 * Return your own copy of DangerZone.versionstring
	 */
	public String versionBuiltWith()
	{
		return "0.9";
	}
	
	/*
	 * It is IMPORTANT TO NOTE that itemIDs and blockIDs (and most others) are INDETERMINATE during loading.
	 * In other words, they can change!!!! Do not use itemIDs or blockIDs in the registerThings() routine!!!!
	 * 
	 * This routine is for REGISTRATION and comes before anything else.
	 */
	public void registerThings(){
		
		//We need some content in the world!
		
		//Make a couple dimensions!
		Dimensions.registerDimension(Dimensions.overworlddimension);
		Dimensions.registerDimension(Dimensions.bigroundtreedimension);
		Dimensions.registerDimension(Dimensions.pathwaydimension);
		Dimensions.registerDimension(Dimensions.ruggedhillsdimension);
		Dimensions.registerDimension(Dimensions.skyislandsdimension);
				
		//make biomes and managers for the new dimensions
		my_biomemanager1 = new BiomeManager1();
		my_biome1 = new Biome1("DangerZone:Overworld Forest");		
		//register manager with dimension
		Dimensions.overworlddimension.registerBiomeManager(my_biomemanager1);
		//register biome with manager
		my_biomemanager1.registerBiome(my_biome1, my_biomemanager1.getFreeBiomeID());
	
		my_biomemanager2 = new BiomeManager2();
		my_biome2 = new Biome2("DangerZone:Big Trees");
		Dimensions.bigroundtreedimension.registerBiomeManager(my_biomemanager2);
		my_biomemanager2.registerBiome(my_biome2, my_biomemanager2.getFreeBiomeID());
		
		my_biomemanager3 = new BiomeManager3();
		my_biome3 = new Biome3("DangerZone:Pathway");
		Dimensions.pathwaydimension.registerBiomeManager(my_biomemanager3);
		my_biomemanager3.registerBiome(my_biome3, my_biomemanager3.getFreeBiomeID());
		
		my_biomemanager4 = new BiomeManager4();
		my_biome4 = new Biome4("DangerZone:Rugged");
		Dimensions.ruggedhillsdimension.registerBiomeManager(my_biomemanager4);
		my_biomemanager4.registerBiome(my_biome4, my_biomemanager4.getFreeBiomeID());
		
		my_biomemanager5 = new BiomeManager5();
		my_biome5= new Biome5("DangerZone:Sky");
		Dimensions.skyislandsdimension.registerBiomeManager(my_biomemanager5);
		my_biomemanager5.registerBiome(my_biome5, my_biomemanager5.getFreeBiomeID());
		

		
		Entities.registerEntity(EntityTrophy.class, "DangerZone:EntityTrophy", new ModelTrophy());
		
		Entities.registerEntity(Butterfly.class, "DangerZone:Butterfly", modelbutterfly);
		Entities.registerEntity(Ghost.class, "DangerZone:Ghost", modelghost);
		Entities.registerEntity(GhostSkelly.class, "DangerZone:GhostSkelly", modelghostskelly);
		Entities.registerEntity(Rat.class, "DangerZone:Rat", modelrat);
		Entities.registerEntity(Cockroach.class, "DangerZone:Cockroach", modelcockroach);
		Entities.registerEntity(Moose.class, "DangerZone:Moose", modelmoose);
		Entities.registerEntity(EntityChest.class, "DangerZone:EntityChest", null);
		Entities.registerEntity(EntityFurnace.class, "DangerZone:EntityFurnace", null);
		Entities.registerEntity(Sparklemuffin.class, "DangerZone:Sparklemuffin", modelfuzzbutt);
		Entities.registerEntity(Skeletorus.class, "DangerZone:Skeletorus", modelfuzzbutt);
		Entities.registerEntity(Goose.class, "DangerZone:Goose", modelgoose);
		Entities.registerEntity(Gosling.class, "DangerZone:Gosling", modelgoose);
		Entities.registerEntity(Ostrich.class, "DangerZone:Ostrich", modelostrich);
		Entities.registerEntity(Anteater.class, "DangerZone:Anteater", modelanteater);
		Entities.registerEntity(Werewolf.class, "DangerZone:Werewolf", modelhumanoid);
		Entities.registerEntity(Vampire.class, "DangerZone:Vampire", modelhumanoid);
		Entities.registerEntity(TheCount.class, "DangerZone:The Count", modelhumanoid);
		Entities.registerEntity(VampireMoose.class, "DangerZone:Vampire Moose", modelmoose);
		Entities.registerEntity(Fish.class, "DangerZone:Fish", modelfish);
		
		Entities.registerEntity(ThrownBlockItem.class, "DangerZone:ThrownBlockItem", new ModelEntityBlockItem());
		Entities.registerEntity(ThrownInstability.class, "DangerZone:ThrownInstability", new ModelEntityBlockItem());
		Entities.registerEntity(ThrownFireball.class, "DangerZone:ThrownFireball", new ModelFireball());
		Entities.registerEntity(EntityFire.class, "DangerZone:Fire", new ModelFire());
		Entities.registerEntity(EntitySpawner.class, "DangerZone:EntitySpawner", new ModelSpawner());
		Entities.registerEntity(EntityLightning.class, "DangerZone:Lightning", modellightning);
		Entities.registerEntity(EntityCloud.class, "DangerZone:Cloud", modelcloud);
		Entities.registerEntity(EntityExplosion.class, "DangerZone:Explosion", null);
		Entities.registerEntity(EntityExtendedRangeDamage.class, "DangerZone:ExtendedRangeDamage", null);
		
		Particles.registerParticle(ParticleBreak.class, "DangerZone:ParticleBreak");
		Particles.registerParticle(ParticleHurt.class, "DangerZone:ParticleHurt");
		Particles.registerParticle(ParticleDeath.class, "DangerZone:ParticleDeath");
		Particles.registerParticle(ParticleSmoke.class, "DangerZone:ParticleSmoke");
		Particles.registerParticle(ParticleFire.class, "DangerZone:ParticleFire");
		Particles.registerParticle(ParticleHappy.class, "DangerZone:ParticleHappy");
		Particles.registerParticle(ParticleSparkle.class, "DangerZone:ParticleSparkle");
		Particles.registerParticle(ParticleRain.class, "DangerZone:ParticleRain");
		Particles.registerParticle(ParticleDroplet.class, "DangerZone:ParticleDroplet");
		Particles.registerParticle(ParticleDust.class, "DangerZone:ParticleDust");
		
		Blocks.registerBlock(Blocks.stopblock);
		Blocks.registerBlock(Blocks.stone);
		Blocks.registerBlock(Blocks.stone2);
		Blocks.registerBlock(Blocks.stone3);
		Blocks.registerBlock(Blocks.stone4);
		Blocks.registerBlock(Blocks.greystone);
		Blocks.registerBlock(Blocks.greystone2);
		Blocks.registerBlock(Blocks.greystone3);
		Blocks.registerBlock(Blocks.greystone4);
		Blocks.registerBlock(Blocks.dirt);
		Blocks.registerBlock(Blocks.sand);
		Blocks.registerBlock(Blocks.grassblock);
		Blocks.registerBlock(Blocks.roachnest);
		Blocks.registerBlock(Blocks.oresilver);
		Blocks.registerBlock(Blocks.orecopper);
		Blocks.registerBlock(Blocks.oretin);
		Blocks.registerBlock(Blocks.oreplatinum);
		Blocks.registerBlock(Blocks.orelight);
		Blocks.registerBlock(Blocks.oredark);
		Blocks.registerBlock(Blocks.orediamond);
		Blocks.registerBlock(Blocks.oreemerald);
		Blocks.registerBlock(Blocks.orebloodstone);
		Blocks.registerBlock(Blocks.oresunstone);
		Blocks.registerBlock(Blocks.blockdark);
		Blocks.registerBlock(Blocks.blocklight);
		Blocks.registerBlock(Blocks.blockplatinum);
		Blocks.registerBlock(Blocks.blocksilver);
		Blocks.registerBlock(Blocks.blockcopper);
		Blocks.registerBlock(Blocks.blocktin);
		Blocks.registerBlock(Blocks.blockdiamond);
		Blocks.registerBlock(Blocks.blockemerald);
		Blocks.registerBlock(Blocks.blockbloodstone);
		Blocks.registerBlock(Blocks.blocksunstone);
		Blocks.registerBlock(Blocks.whitestone);
		Blocks.registerBlock(Blocks.hardrock);
		Blocks.registerBlock(Blocks.firestone);
		
				
		Blocks.registerBlock(Blocks.redwoodlog);
		Blocks.registerBlock(Blocks.darkplywood);
		Blocks.registerBlock(Blocks.redwoodleaves);
		Blocks.registerBlock(Blocks.log);
		Blocks.registerBlock(Blocks.plywood);
		Blocks.registerBlock(Blocks.leaves);
		Blocks.registerBlock(Blocks.willowlog);
		Blocks.registerBlock(Blocks.lightplywood);
		Blocks.registerBlock(Blocks.willowleaves);

		Blocks.registerBlock(Blocks.grass);
		Blocks.registerBlock(Blocks.peachleaves);
		Blocks.registerBlock(Blocks.cherryleaves);
		Blocks.registerBlock(Blocks.appleleaves);
		
		Blocks.registerBlock(Blocks.workbench);
		Blocks.registerBlock(Blocks.chest);
		Blocks.registerBlock(Blocks.furnace);
		Blocks.registerBlock(Blocks.furnaceOn);
		
		Blocks.registerBlock(Blocks.lightstick);
		Blocks.registerBlock(Blocks.darkstick);
		
		Blocks.registerBlock(Blocks.water);
		Blocks.registerBlock(Blocks.watersource);
		Blocks.registerBlock(Blocks.corn_plant);
		Blocks.registerBlock(Blocks.corn_plant1);
		Blocks.registerBlock(Blocks.corn_plant2);
		Blocks.registerBlock(Blocks.corn_plant3);

		Blocks.registerBlock(Blocks.flower_red);
		Blocks.registerBlock(Blocks.flower_pink);
		Blocks.registerBlock(Blocks.flower_purple);
		Blocks.registerBlock(Blocks.flower_yellow);
		Blocks.registerBlock(Blocks.butterfly_plant);
		Blocks.registerBlock(Blocks.butterfly_plant1);
		Blocks.registerBlock(Blocks.butterfly_plant2);
		Blocks.registerBlock(Blocks.butterfly_plant3);
		
		Blocks.registerBlock(Blocks.radish_plant);
		Blocks.registerBlock(Blocks.radish_plant1);
		Blocks.registerBlock(Blocks.radish_plant2);
		Blocks.registerBlock(Blocks.radish_plant3);
		Blocks.registerBlock(Blocks.rice_plant);
		Blocks.registerBlock(Blocks.rice_plant1);
		Blocks.registerBlock(Blocks.rice_plant2);
		Blocks.registerBlock(Blocks.rice_plant3);

		Blocks.registerBlock(Blocks.glass);
		Blocks.registerBlock(Blocks.blueglass);
		Blocks.registerBlock(Blocks.greenglass);
		Blocks.registerBlock(Blocks.redglass);
		Blocks.registerBlock(Blocks.violetglass);
		Blocks.registerBlock(Blocks.yellowglass);
		
		Blocks.registerBlock(Blocks.stickyblock);
		Blocks.registerBlock(Blocks.coloringblock);
		Blocks.registerBlock(Blocks.doortop);
		Blocks.registerBlock(Blocks.doorbottom);
		
		Blocks.registerBlock(Blocks.cloud_light);
		Blocks.registerBlock(Blocks.cloud_rain);
		Blocks.registerBlock(Blocks.cloud_thunder);
		
		Blocks.registerBlock(Blocks.butterflyspawner);
		Blocks.registerBlock(Blocks.ghostspawner);
		Blocks.registerBlock(Blocks.ghostskellyspawner);
		Blocks.registerBlock(Blocks.ratspawner);
		Blocks.registerBlock(Blocks.cockroachspawner);
		Blocks.registerBlock(Blocks.moosespawner);
		Blocks.registerBlock(Blocks.sparklemuffinspawner);
		Blocks.registerBlock(Blocks.skeletorusspawner);
		Blocks.registerBlock(Blocks.goosespawner);
		Blocks.registerBlock(Blocks.goslingspawner);
		Blocks.registerBlock(Blocks.ostrichspawner);
		Blocks.registerBlock(Blocks.anteaterspawner);
		Blocks.registerBlock(Blocks.werewolfspawner);
		Blocks.registerBlock(Blocks.vampirespawner);
		Blocks.registerBlock(Blocks.thecountspawner);
		Blocks.registerBlock(Blocks.vampiremoosespawner);
		Blocks.registerBlock(Blocks.fishspawner);
				
		Blocks.registerBlock(Blocks.block_lightgrey);
		Blocks.registerBlock(Blocks.block_lightgreen);
		Blocks.registerBlock(Blocks.block_lightred);
		Blocks.registerBlock(Blocks.block_lightblue);
		Blocks.registerBlock(Blocks.block_lightyellow);
		Blocks.registerBlock(Blocks.block_lightorange);
		Blocks.registerBlock(Blocks.block_lightpurple);
		Blocks.registerBlock(Blocks.block_lightviolet);
		Blocks.registerBlock(Blocks.block_lightbrown);
		
		Blocks.registerBlock(Blocks.block_grey);
		Blocks.registerBlock(Blocks.block_green);
		Blocks.registerBlock(Blocks.block_red);
		Blocks.registerBlock(Blocks.block_blue);
		Blocks.registerBlock(Blocks.block_yellow);
		Blocks.registerBlock(Blocks.block_orange);
		Blocks.registerBlock(Blocks.block_purple);
		Blocks.registerBlock(Blocks.block_violet);
		Blocks.registerBlock(Blocks.block_brown);
		
		Blocks.registerBlock(Blocks.block_darkgrey);
		Blocks.registerBlock(Blocks.block_darkgreen);
		Blocks.registerBlock(Blocks.block_darkred);
		Blocks.registerBlock(Blocks.block_darkblue);
		Blocks.registerBlock(Blocks.block_darkyellow);
		Blocks.registerBlock(Blocks.block_darkorange);
		Blocks.registerBlock(Blocks.block_darkpurple);
		Blocks.registerBlock(Blocks.block_darkviolet);
		Blocks.registerBlock(Blocks.block_darkbrown);
		
		//register some ores!
		Ores.registerOre(Blocks.orecopper, Blocks.stone, null, null, 30, 80, 20, 8, 0);
		Ores.registerOre(Blocks.oretin, Blocks.stone, null, null, 10, 70, 20, 6, 0);
		Ores.registerOre(Blocks.oresilver, Blocks.stone, null, null, 10, 50, 15, 4, 0);
		Ores.registerOre(Blocks.oreplatinum, Blocks.stone, null, null, 0, 20, 10, 2, 0);
		Ores.registerOre(Blocks.coloringblock, Blocks.stone, null, null, 0, 10, 5, 2, 0);
		Ores.registerOre(Blocks.orelight, Blocks.stone, null, null, 35, 45, 35, 12, 0);
		Ores.registerOre(Blocks.oredark, Blocks.stone, null, null, 0, 10, 15, 6, 0); //random-ish
		Ores.registerOre(Blocks.sand, Blocks.stone, null, null, 10, 40, 10, 40, 1); //layer-ish
		Ores.registerOre(Blocks.dirt, Blocks.stone, null, null, 10, 40, 5, 40, 2);  //clump-ish
		Ores.registerOre(Blocks.orediamond, Blocks.stone, null, null, 0, 20, 6, 2, 0);
		Ores.registerOre(Blocks.oreemerald, Blocks.stone, null, null, 0, 20, 8, 2, 0);
		Ores.registerOre(Blocks.orebloodstone, Blocks.stone, null, null, 0, 20, 8, 2, 0);
		//Ores.registerOre(Blocks.oresunstone, Blocks.stone, null, null, 0, 20, 6, 2, 0); Only in sky island dimension!!!
		
		//Now register them a little higher up for the sky dimension
		Ores.registerOre(Blocks.orecopper, Blocks.stone, Dimensions.skyislandsdimension, null, 120, 200, 20, 8, 0);
		Ores.registerOre(Blocks.oretin, Blocks.stone, Dimensions.skyislandsdimension, null, 120, 200, 20, 6, 0);
		Ores.registerOre(Blocks.oresilver, Blocks.stone, Dimensions.skyislandsdimension, null, 120, 200, 15, 4, 0);
		Ores.registerOre(Blocks.oreplatinum, Blocks.stone, Dimensions.skyislandsdimension, null, 200, 250, 10, 2, 0);
		Ores.registerOre(Blocks.orelight, Blocks.stone, Dimensions.skyislandsdimension, null, 75, 115, 35, 12, 0);
		Ores.registerOre(Blocks.oredark, Blocks.stone, Dimensions.skyislandsdimension, null, 0, 65, 15, 6, 0); //nice random-ish
		Ores.registerOre(Blocks.sand, Blocks.stone, Dimensions.skyislandsdimension, null, 10, 200, 10, 40, 1); //layer-ish
		Ores.registerOre(Blocks.dirt, Blocks.stone, Dimensions.skyislandsdimension, null, 10, 175, 5, 40, 2);  //clump-ish
		Ores.registerOre(Blocks.orediamond, Blocks.stone, Dimensions.skyislandsdimension, null, 200, 250, 6, 2, 0);
		Ores.registerOre(Blocks.oreemerald, Blocks.stone, Dimensions.skyislandsdimension, null, 200, 250, 8, 2, 0);
		Ores.registerOre(Blocks.orebloodstone, Blocks.stone, Dimensions.skyislandsdimension, null, 200, 250, 8, 2, 0);
		Ores.registerOre(Blocks.oresunstone, Blocks.stone, Dimensions.skyislandsdimension, null, 200, 250, 6, 2, 0);
	
		
		Items.registerItem(Items.woodensword);
		Items.registerItem(Items.woodenpickaxe);
		Items.registerItem(Items.woodenaxe);
		Items.registerItem(Items.woodenshovel);
		Items.registerItem(Items.woodenhoe);
		Items.registerItem(Items.stonesword);
		Items.registerItem(Items.stonepickaxe);
		Items.registerItem(Items.stoneaxe);
		Items.registerItem(Items.stoneshovel);
		Items.registerItem(Items.stonehoe);
		Items.registerItem(Items.coppersword);
		Items.registerItem(Items.copperpickaxe);
		Items.registerItem(Items.copperaxe);
		Items.registerItem(Items.coppershovel);
		Items.registerItem(Items.copperhoe);	
		Items.registerItem(Items.tinsword);
		Items.registerItem(Items.tinpickaxe);
		Items.registerItem(Items.tinaxe);
		Items.registerItem(Items.tinshovel);
		Items.registerItem(Items.tinhoe);	
		Items.registerItem(Items.silversword);
		Items.registerItem(Items.silverpickaxe);
		Items.registerItem(Items.silveraxe);
		Items.registerItem(Items.silvershovel);
		Items.registerItem(Items.silverhoe);	
		Items.registerItem(Items.platinumsword);
		Items.registerItem(Items.platinumpickaxe);
		Items.registerItem(Items.platinumaxe);
		Items.registerItem(Items.platinumshovel);
		Items.registerItem(Items.platinumhoe);
		
		Items.registerItem(Items.lumpcopper);
		Items.registerItem(Items.lumptin);
		Items.registerItem(Items.lumpsilver);
		Items.registerItem(Items.lumpplatinum);
		Items.registerItem(Items.coingold);
		Items.registerItem(Items.coinsilver);
		Items.registerItem(Items.coinplatinum);
		Items.registerItem(Items.diamond);
		Items.registerItem(Items.emerald);
		Items.registerItem(Items.bloodstone);
		Items.registerItem(Items.sunstone);
		Items.registerItem(Items.light);
		Items.registerItem(Items.dark);
		Items.registerItem(Items.stick);

		Items.registerItem(Items.corn);
		Items.registerItem(Items.moosemeat);
		Items.registerItem(Items.moosemeat_cooked);
		Items.registerItem(Items.goosemeat);
		Items.registerItem(Items.goosemeat_cooked);
		Items.registerItem(Items.ostrichmeat);
		Items.registerItem(Items.ostrichmeat_cooked);
		Items.registerItem(Items.fishmeat);
		Items.registerItem(Items.fishmeat_cooked);
		Items.registerItem(Items.radish);
		Items.registerItem(Items.rice);
		Items.registerItem(Items.peach);
		Items.registerItem(Items.apple);
		Items.registerItem(Items.cherries);
		Items.registerItem(Items.deadbug);
		Items.registerItem(Items.moosebone);
		Items.registerItem(Items.feather);
		Items.registerItem(Items.peachseed);
		Items.registerItem(Items.appleseed);
		Items.registerItem(Items.cherryseed);		
		
		Items.registerItem(Items.trophycockroach);
		Items.registerItem(Items.trophybutterfly);
		Items.registerItem(Items.trophyrat);
		Items.registerItem(Items.trophymoose);
		Items.registerItem(Items.trophyghost);
		Items.registerItem(Items.trophyghostskelly);
		Items.registerItem(Items.trophygoose);
		Items.registerItem(Items.trophygosling);
		Items.registerItem(Items.trophyostrich);
		Items.registerItem(Items.trophysparklemuffin);
		Items.registerItem(Items.trophyskeletorus);
		Items.registerItem(Items.trophyanteater);
		Items.registerItem(Items.trophywerewolf);
		Items.registerItem(Items.trophyvampire);
		Items.registerItem(Items.trophythecount);
		Items.registerItem(Items.trophyvampiremoose);
		Items.registerItem(Items.trophyfish);
		
		Items.registerItem(Items.eggbutterfly);
		Items.registerItem(Items.eggghost);
		Items.registerItem(Items.eggghostskelly);
		Items.registerItem(Items.eggrat);
		Items.registerItem(Items.eggcockroach);
		Items.registerItem(Items.eggmoose);
		Items.registerItem(Items.egggoose);
		Items.registerItem(Items.egggosling);
		Items.registerItem(Items.eggostrich);
		Items.registerItem(Items.eggsparklemuffin);
		Items.registerItem(Items.eggskeletorus);
		Items.registerItem(Items.egganteater);
		Items.registerItem(Items.eggwerewolf);
		Items.registerItem(Items.eggvampire);
		Items.registerItem(Items.eggthecount);
		Items.registerItem(Items.eggvampiremoose);
		Items.registerItem(Items.eggfish);
		
		Items.registerItem(Items.eggcloud);
		
		Items.registerItem(Items.copperhelmet);
		Items.registerItem(Items.copperchestplate);
		Items.registerItem(Items.copperleggings);
		Items.registerItem(Items.copperboots);
		Items.registerItem(Items.tinhelmet);
		Items.registerItem(Items.tinchestplate);
		Items.registerItem(Items.tinleggings);
		Items.registerItem(Items.tinboots);
		Items.registerItem(Items.silverhelmet);
		Items.registerItem(Items.silverchestplate);
		Items.registerItem(Items.silverleggings);
		Items.registerItem(Items.silverboots);
		Items.registerItem(Items.platinumhelmet);
		Items.registerItem(Items.platinumchestplate);
		Items.registerItem(Items.platinumleggings);
		Items.registerItem(Items.platinumboots);
		
		Items.registerItem(Items.furball);
		Items.registerItem(Items.vampireteeth);
		Items.registerItem(Items.instability);
		Items.registerItem(Items.instabilitylarge);
		Items.registerItem(Items.instabilityhuge);
		
		Items.registerItem(Items.firestick);
		Items.registerItem(Items.spidersilk);
		Items.registerItem(Items.bucket);
		Items.registerItem(Items.bucketwater);
		Items.registerItem(Items.bucketmilk);
		Items.registerItem(Items.door);
		Items.registerItem(Items.fireball);
		
		//register some cooking and smelting!
		Cooking.registerCookingRecipe(Blocks.orecopper, Items.lumpcopper, 20);
		Cooking.registerCookingRecipe(Blocks.oretin, Items.lumptin, 25);
		Cooking.registerCookingRecipe(Blocks.oresilver, Items.lumpsilver, 30);
		Cooking.registerCookingRecipe(Blocks.oreplatinum, Items.lumpplatinum, 45);
		Cooking.registerCookingRecipe(Blocks.sand, Blocks.glass, 60);
		Cooking.registerCookingRecipe(Items.moosemeat, Items.moosemeat_cooked, 20);
		Cooking.registerCookingRecipe(Items.goosemeat, Items.goosemeat_cooked, 35);
		Cooking.registerCookingRecipe(Items.ostrichmeat, Items.ostrichmeat_cooked, 40);
		Cooking.registerCookingRecipe(Items.fishmeat, Items.fishmeat_cooked, 25);
		
		//Make some noise!
		DangerZone.soundmangler.registerSound("DangerZone:pop", "res/sounds/pop.wav");
		DangerZone.soundmangler.registerSound("DangerZone:blockbreak", "res/sounds/blockbreak.wav");
		DangerZone.soundmangler.registerSound("DangerZone:blockplace", "res/sounds/blockplace.wav");
		DangerZone.soundmangler.registerSound("DangerZone:blockhit", "res/sounds/blockhit.wav");
		DangerZone.soundmangler.registerSound("DangerZone:leavesbreak", "res/sounds/leavesbreak.wav");
		DangerZone.soundmangler.registerSound("DangerZone:leavesplace", "res/sounds/leavesplace.wav");
		DangerZone.soundmangler.registerSound("DangerZone:leaves_hit", "res/sounds/leaves_hit.wav");	
		DangerZone.soundmangler.registerSound("DangerZone:ghost_sound", "res/sounds/ghost_sound.wav");
		DangerZone.soundmangler.registerSound("DangerZone:ratdead1", "res/sounds/ratdead1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:ratdead2", "res/sounds/ratdead2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:ratdead3", "res/sounds/ratdead3.wav");
		DangerZone.soundmangler.registerSound("DangerZone:chain_rattles", "res/sounds/chain_rattles.wav");		
		DangerZone.soundmangler.registerSound("DangerZone:rathit", "res/sounds/rathit.wav");
		DangerZone.soundmangler.registerSound("DangerZone:ratlive", "res/sounds/ratlive.wav");
		DangerZone.soundmangler.registerSound("DangerZone:woodbreak", "res/sounds/woodbreak.wav");
		DangerZone.soundmangler.registerSound("DangerZone:woodplace", "res/sounds/woodplace.wav");
		DangerZone.soundmangler.registerSound("DangerZone:woodhit", "res/sounds/woodhit.wav");	
		DangerZone.soundmangler.registerSound("DangerZone:stonebreak", "res/sounds/stonebreak.wav");
		DangerZone.soundmangler.registerSound("DangerZone:stoneplace", "res/sounds/stoneplace.wav");
		DangerZone.soundmangler.registerSound("DangerZone:stonehit", "res/sounds/stonehit.wav");
		DangerZone.soundmangler.registerSound("DangerZone:big_splat", "res/sounds/big_splat.wav");
		DangerZone.soundmangler.registerSound("DangerZone:big_splash", "res/sounds/big_splash.wav");
		DangerZone.soundmangler.registerSound("DangerZone:ouch1", "res/sounds/ouch1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:ouch2", "res/sounds/ouch2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:ouch3", "res/sounds/ouch3.wav");
		DangerZone.soundmangler.registerSound("DangerZone:eating", "res/sounds/eating.wav");
		DangerZone.soundmangler.registerSound("DangerZone:crystalblockbreak", "res/sounds/crystalblockbreak.wav");
		DangerZone.soundmangler.registerSound("DangerZone:crystalblockhit", "res/sounds/crystalblockhit.wav");
		DangerZone.soundmangler.registerSound("DangerZone:crystalblockplace", "res/sounds/crystalblockplace.wav");
		DangerZone.soundmangler.registerSound("DangerZone:furnace_ding", "res/sounds/furnace_ding.wav");
		DangerZone.soundmangler.registerSound("DangerZone:moose_hit", "res/sounds/moose_hit.wav");
		DangerZone.soundmangler.registerSound("DangerZone:moose_death", "res/sounds/moose_death.wav");
		DangerZone.soundmangler.registerSound("DangerZone:burp", "res/sounds/burp.wav");
		DangerZone.soundmangler.registerSound("DangerZone:burp1", "res/sounds/burp1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:burp2", "res/sounds/burp2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:burp3", "res/sounds/burp3.wav");
		DangerZone.soundmangler.registerSound("DangerZone:goose_hit", "res/sounds/goose_hit.wav");
		DangerZone.soundmangler.registerSound("DangerZone:goose_death", "res/sounds/goose_death.wav");
		DangerZone.soundmangler.registerSound("DangerZone:goose_living", "res/sounds/goose_living.wav");
		DangerZone.soundmangler.registerSound("DangerZone:dirt_hit", "res/sounds/dirt_hit.wav");
		DangerZone.soundmangler.registerSound("DangerZone:dirt_place", "res/sounds/dirt_place.wav");
		DangerZone.soundmangler.registerSound("DangerZone:fuzzbutt_hit", "res/sounds/fuzzbutt_hit.wav");
		DangerZone.soundmangler.registerSound("DangerZone:fuzzbutt_death", "res/sounds/fuzzbutt_death.wav");
		DangerZone.soundmangler.registerSound("DangerZone:fuzzbutt_living", "res/sounds/fuzzbutt_living.wav");
		DangerZone.soundmangler.registerSound("DangerZone:anteater_hit", "res/sounds/anteater_hit.wav");
		DangerZone.soundmangler.registerSound("DangerZone:little_splat", "res/sounds/little_splat.wav");
		DangerZone.soundmangler.registerSound("DangerZone:little_splash", "res/sounds/little_splash.wav");
		DangerZone.soundmangler.registerSound("DangerZone:bow", "res/sounds/bow.wav");
		DangerZone.soundmangler.registerSound("DangerZone:vampire_living", "res/sounds/vampire_living.wav");
		DangerZone.soundmangler.registerSound("DangerZone:werewolf_attack", "res/sounds/werewolf_attack.wav");
		DangerZone.soundmangler.registerSound("DangerZone:werewolf_death", "res/sounds/werewolf_death.wav");
		DangerZone.soundmangler.registerSound("DangerZone:werewolf_living", "res/sounds/werewolf_living.wav");
		DangerZone.soundmangler.registerSound("DangerZone:small_explosion1", "res/sounds/small_explosion1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:small_explosion2", "res/sounds/small_explosion2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:small_explosion3", "res/sounds/small_explosion3.wav");
		DangerZone.soundmangler.registerSound("DangerZone:small_explosion4", "res/sounds/small_explosion4.wav");
		DangerZone.soundmangler.registerSound("DangerZone:small_explosion5", "res/sounds/small_explosion5.wav");
		DangerZone.soundmangler.registerSound("DangerZone:large_explosion1", "res/sounds/large_explosion1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:large_explosion2", "res/sounds/large_explosion2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:large_explosion3", "res/sounds/large_explosion3.wav");
		DangerZone.soundmangler.registerSound("DangerZone:cryo_hurt", "res/sounds/cryo_hurt.wav");
		DangerZone.soundmangler.registerSound("DangerZone:cryo_death", "res/sounds/cryo_death.wav");
		DangerZone.soundmangler.registerSound("DangerZone:chest_open", "res/sounds/chest_open.wav");
		DangerZone.soundmangler.registerSound("DangerZone:chest_close", "res/sounds/chest_close.wav");
		DangerZone.soundmangler.registerSound("DangerZone:coin_deposit", "res/sounds/coin_deposit.wav");
		DangerZone.soundmangler.registerSound("DangerZone:coin_drop", "res/sounds/coin_drop.wav");
		DangerZone.soundmangler.registerSound("DangerZone:coin_jingle", "res/sounds/coin_jingle.wav");
		DangerZone.soundmangler.registerSound("DangerZone:coin_shake", "res/sounds/coin_shake.wav");
		
		DangerZone.soundmangler.registerSound("DangerZone:dirt1", "res/sounds/dirt1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:dirt2", "res/sounds/dirt2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:dirt3", "res/sounds/dirt3.wav");
		
		DangerZone.soundmangler.registerSound("DangerZone:grass1", "res/sounds/grass1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:grass2", "res/sounds/grass2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:grass3", "res/sounds/grass3.wav");
		DangerZone.soundmangler.registerSound("DangerZone:grass4", "res/sounds/grass4.wav");
		
		DangerZone.soundmangler.registerSound("DangerZone:leaves1", "res/sounds/leaves1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:leaves2", "res/sounds/leaves2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:leaves3", "res/sounds/leaves3.wav");
		DangerZone.soundmangler.registerSound("DangerZone:leaves4", "res/sounds/leaves4.wav");
		
		DangerZone.soundmangler.registerSound("DangerZone:sand1", "res/sounds/sand1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:sand2", "res/sounds/sand2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:sand3", "res/sounds/sand3.wav");
		
		DangerZone.soundmangler.registerSound("DangerZone:stone1", "res/sounds/stone1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:stone2", "res/sounds/stone2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:stone3", "res/sounds/stone3.wav");
		
		DangerZone.soundmangler.registerSound("DangerZone:wood1", "res/sounds/wood1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:wood2", "res/sounds/wood2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:wood3", "res/sounds/wood3.wav");
		DangerZone.soundmangler.registerSound("DangerZone:wood4", "res/sounds/wood4.wav");
		
		DangerZone.soundmangler.registerSound("DangerZone:thunder1", "res/sounds/thunder1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:thunder2", "res/sounds/thunder2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:thunder3", "res/sounds/thunder3.wav");
		DangerZone.soundmangler.registerSound("DangerZone:thunder4", "res/sounds/thunder4.wav");
		
		DangerZone.soundmangler.registerSound("DangerZone:rain1", "res/sounds/rain1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:rain2", "res/sounds/rain2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:rain3", "res/sounds/rain3.wav");
		DangerZone.soundmangler.registerSound("DangerZone:rain4", "res/sounds/rain4.wav");
		DangerZone.soundmangler.registerSound("DangerZone:rain5", "res/sounds/rain5.wav");
		DangerZone.soundmangler.registerSound("DangerZone:rain6", "res/sounds/rain6.wav");
		DangerZone.soundmangler.registerSound("DangerZone:rain7", "res/sounds/rain7.wav");
		DangerZone.soundmangler.registerSound("DangerZone:rain8", "res/sounds/rain8.wav");
		
		DangerZone.soundmangler.registerSound("DangerZone:teleport1", "res/sounds/teleport1.wav");
		DangerZone.soundmangler.registerSound("DangerZone:teleport2", "res/sounds/teleport2.wav");
		DangerZone.soundmangler.registerSound("DangerZone:teleport3", "res/sounds/teleport3.wav");

		
		Crafting.registerCraftingRecipe(Blocks.redwoodlog, null, null, null, null, null, null, null, null, Blocks.darkplywood, 4, false);
		Crafting.registerCraftingRecipe(Blocks.log, null, null, null, null, null, null, null, null, Blocks.plywood, 4, false);
		Crafting.registerCraftingRecipe(Blocks.willowlog, null, null, null, null, null, null, null, null, Blocks.lightplywood, 4, false);
		
		Crafting.registerCraftingRecipe(Blocks.plywood, null, null, null, null, null, null, null, null, Items.stick, 4, false);
		Crafting.registerCraftingRecipe(Blocks.darkplywood, null, null, null, null, null, null, null, null, Items.stick, 4, false);
		Crafting.registerCraftingRecipe(Blocks.lightplywood, null, null, null, null, null, null, null, null, Items.stick, 4, false);
		
		Crafting.registerCraftingRecipe(Blocks.plywood, Blocks.plywood, Blocks.plywood, Blocks.plywood, null, null, null, null, null, Blocks.workbench, 1, false);
		Crafting.registerCraftingRecipe(Blocks.lightplywood, Blocks.lightplywood, Blocks.lightplywood, Blocks.lightplywood, null, null, null, null, null, Blocks.workbench, 1, false);
		Crafting.registerCraftingRecipe(Blocks.darkplywood, Blocks.darkplywood, Blocks.darkplywood, Blocks.darkplywood, null, null, null, null, null, Blocks.workbench, 1, false);		
		
		Crafting.registerCraftingRecipe(Items.stick, Items.light, null, null, null, null, null, null, null, Blocks.lightstick, 4, false);
		Crafting.registerCraftingRecipe(Items.stick, Items.dark, null, null, null, null, null, null, null, Blocks.darkstick, 4, false);
		
		Crafting.registerCraftingRecipe(Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Blocks.blockcopper, 1, false);
		Crafting.registerCraftingRecipe(Blocks.blockcopper, null, null, null, null, null, null, null, null, Items.lumpcopper, 9, false);

		Crafting.registerCraftingRecipe(Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, Blocks.blocktin, 1, false);
		Crafting.registerCraftingRecipe(Blocks.blocktin, null, null, null, null, null, null, null, null, Items.lumptin, 9, false);

		Crafting.registerCraftingRecipe(Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Blocks.blocksilver, 1, false);
		Crafting.registerCraftingRecipe(Blocks.blocksilver, null, null, null, null, null, null, null, null, Items.lumpsilver, 9, false);

		Crafting.registerCraftingRecipe(Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Blocks.blockplatinum, 1, false);
		Crafting.registerCraftingRecipe(Blocks.blockplatinum, null, null, null, null, null, null, null, null, Items.lumpplatinum, 9, false);

		Crafting.registerCraftingRecipe(Items.light, Items.light, Items.light, Items.light, Items.light, Items.light, Items.light, Items.light, Items.light, Blocks.blocklight, 1, false);
		Crafting.registerCraftingRecipe(Blocks.blocklight, null, null, null, null, null, null, null, null, Items.light, 9, false);

		Crafting.registerCraftingRecipe(Items.dark, Items.dark, Items.dark, Items.dark, Items.dark, Items.dark, Items.dark, Items.dark, Items.dark, Blocks.blockdark, 1, false);
		Crafting.registerCraftingRecipe(Blocks.blockdark, null, null, null, null, null, null, null, null, Items.dark, 9, false);

		Crafting.registerCraftingRecipe(Items.spidersilk, Items.spidersilk, Items.spidersilk, Items.spidersilk, null, null, null, null, null, Blocks.stickyblock, 1, false);
		Crafting.registerCraftingRecipe(Items.lumpcopper, null, Items.lumpcopper, Items.lumpcopper, null, Items.lumpcopper, null, Items.lumpcopper, null, Items.bucket, 1, true);

		Crafting.registerCraftingRecipe(Items.diamond, Items.diamond, Items.diamond, Items.diamond, Items.diamond, Items.diamond, Items.diamond, Items.diamond, Items.diamond, Blocks.blockdiamond, 1, false);
		Crafting.registerCraftingRecipe(Blocks.blockdiamond, null, null, null, null, null, null, null, null, Items.diamond, 9, false);
		
		Crafting.registerCraftingRecipe(Items.emerald, Items.emerald, Items.emerald, Items.emerald, Items.emerald, Items.emerald, Items.emerald, Items.emerald, Items.emerald, Blocks.blockemerald, 1, false);
		Crafting.registerCraftingRecipe(Blocks.blockemerald, null, null, null, null, null, null, null, null, Items.emerald, 9, false);
		
		Crafting.registerCraftingRecipe(Items.bloodstone, Items.bloodstone, Items.bloodstone, Items.bloodstone, Items.bloodstone, Items.bloodstone, Items.bloodstone, Items.bloodstone, Items.bloodstone, Blocks.blockbloodstone, 1, false);
		Crafting.registerCraftingRecipe(Blocks.blockbloodstone, null, null, null, null, null, null, null, null, Items.bloodstone, 9, false);
		
		Crafting.registerCraftingRecipe(Items.sunstone, Items.sunstone, Items.sunstone, Items.sunstone, Items.sunstone, Items.sunstone, Items.sunstone, Items.sunstone, Items.sunstone, Blocks.blocksunstone, 1, false);
		Crafting.registerCraftingRecipe(Blocks.blocksunstone, null, null, null, null, null, null, null, null, Items.sunstone, 9, false);
		
		//wooden sword
		craftSword(Blocks.plywood, Items.woodensword);
		craftSword(Blocks.lightplywood, Items.woodensword);
		craftSword(Blocks.darkplywood, Items.woodensword);
						
		//wooden axe
		craftAxe(Blocks.plywood, Items.woodenaxe);
		craftAxe(Blocks.lightplywood, Items.woodenaxe);
		craftAxe(Blocks.darkplywood, Items.woodenaxe);
		
		//wooden pickaxe
		craftPickaxe(Blocks.plywood, Items.woodenpickaxe);
		craftPickaxe(Blocks.lightplywood, Items.woodenpickaxe);
		craftPickaxe(Blocks.darkplywood, Items.woodenpickaxe);
		
		//wooden hoe
		craftHoe(Blocks.plywood, Items.woodenhoe);
		craftHoe(Blocks.lightplywood, Items.woodenhoe);
		craftHoe(Blocks.darkplywood, Items.woodenhoe);
		
		//wooden shovel
		craftShovel(Blocks.plywood, Items.woodenshovel);
		craftShovel(Blocks.lightplywood, Items.woodenshovel);
		craftShovel(Blocks.darkplywood, Items.woodenshovel);
		
		//copper things
		craftSword(Items.lumpcopper, Items.coppersword);
		craftAxe(Items.lumpcopper, Items.copperaxe);
		craftPickaxe(Items.lumpcopper, Items.copperpickaxe);
		craftHoe(Items.lumpcopper, Items.copperhoe);
		craftShovel(Items.lumpcopper, Items.coppershovel);
		
		//tin things
		craftSword(Items.lumptin, Items.tinsword);
		craftAxe(Items.lumptin, Items.tinaxe);
		craftPickaxe(Items.lumptin, Items.tinpickaxe);
		craftHoe(Items.lumptin, Items.tinhoe);
		craftShovel(Items.lumptin, Items.tinshovel);
		
		//silver things
		craftSword(Items.lumpsilver, Items.silversword);
		craftAxe(Items.lumpsilver, Items.silveraxe);
		craftPickaxe(Items.lumpsilver, Items.silverpickaxe);
		craftHoe(Items.lumpsilver, Items.silverhoe);
		craftShovel(Items.lumpsilver, Items.silvershovel);
		
		//platinum things
		craftSword(Items.lumpplatinum, Items.platinumsword);
		craftAxe(Items.lumpplatinum, Items.platinumaxe);
		craftPickaxe(Items.lumpplatinum, Items.platinumpickaxe);
		craftHoe(Items.lumpplatinum, Items.platinumhoe);
		craftShovel(Items.lumpplatinum, Items.platinumshovel);
		
		//stone things
		craftSword(Blocks.stone, Items.stonesword);
		craftAxe(Blocks.stone, Items.stoneaxe);
		craftPickaxe(Blocks.stone, Items.stonepickaxe);
		craftHoe(Blocks.stone, Items.stonehoe);
		craftShovel(Blocks.stone, Items.stoneshovel);
		
		//chests
		craftChest(Blocks.plywood);
		craftChest(Blocks.lightplywood);
		craftChest(Blocks.darkplywood);
		
		//furnace
		Crafting.registerCraftingRecipe(Blocks.stone, Blocks.stone, Blocks.stone, Blocks.stone, null, Blocks.stone, Blocks.stone, Blocks.stone, Blocks.stone, Blocks.furnace, 1, true);
		//coloring block
		Crafting.registerCraftingRecipe(Blocks.stone, Blocks.stone, Blocks.stone, Blocks.stone, Blocks.stickyblock, Blocks.stone, Blocks.stone, Blocks.stone, Blocks.stone, Blocks.coloringblock, 1, true);
		
		//And now for some action!
		//spawn rates are chance in 1000, not 100.
		//Register an entity with NULL world. 			
		
		Spawnlist.registerSpawn(new Butterfly(null), Dimensions.overworlddimension, null, 50, 110, 20, 3, CreatureTypes.AIR, CreatureTypes.TRANSIENT); //2% (ish) chance of around 3 spawning in air
		Spawnlist.registerSpawn(new Cockroach(null), Dimensions.overworlddimension, null, 30, 100, 25, 3, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new Skeletorus(null), Dimensions.overworlddimension, null, 0, 20, 700, 4, CreatureTypes.UNDERGROUND, CreatureTypes.TRANSIENT);
		Spawnlist.registerSpawn(new Rat(null), Dimensions.overworlddimension, null, 0, 20, 800, 10, CreatureTypes.UNDERGROUND, CreatureTypes.TRANSIENT);		
		Spawnlist.registerSpawn(new Ghost(null), Dimensions.overworlddimension, null, 30, 100, 175, 3, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new GhostSkelly(null), Dimensions.overworlddimension, null, 30, 100, 75, 1, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new Moose(null), Dimensions.overworlddimension, null, 60, 90, 5, 5, CreatureTypes.LAND, CreatureTypes.PERMANENT); 
		
		Spawnlist.registerSpawn(new Butterfly(null), Dimensions.bigroundtreedimension, null, 50, 110, 20, 3, CreatureTypes.AIR, CreatureTypes.TRANSIENT); //2% (ish) chance of around 3 spawning in air
		Spawnlist.registerSpawn(new Cockroach(null), Dimensions.bigroundtreedimension, null, 30, 100, 25, 3, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new Skeletorus(null), Dimensions.bigroundtreedimension, null, 0, 20, 700, 4, CreatureTypes.UNDERGROUND, CreatureTypes.TRANSIENT);
		Spawnlist.registerSpawn(new Rat(null), Dimensions.bigroundtreedimension, null, 0, 20, 800, 10, CreatureTypes.UNDERGROUND, CreatureTypes.TRANSIENT);		
		Spawnlist.registerSpawn(new Rat(null), Dimensions.bigroundtreedimension, null, 20, 100, 150, 5, CreatureTypes.LAND, CreatureTypes.TRANSIENT);
		Spawnlist.registerSpawn(new Goose(null), Dimensions.bigroundtreedimension, null, 40, 70, 80, 5, CreatureTypes.WATER, CreatureTypes.PERMANENT); 
		Spawnlist.registerSpawn(new Sparklemuffin(null), Dimensions.bigroundtreedimension, null, 60, 90, 100, 3, CreatureTypes.LAND, CreatureTypes.TRANSIENT);
		Spawnlist.registerSpawn(new Anteater(null), Dimensions.bigroundtreedimension, null, 60, 90, 5, 8, CreatureTypes.LAND, CreatureTypes.PERMANENT);
		Spawnlist.registerSpawn(new Fish(null), Dimensions.bigroundtreedimension, null, 40, 70, 100, 5, CreatureTypes.WATER, CreatureTypes.TRANSIENT); 
		
		Spawnlist.registerSpawn(new Butterfly(null), Dimensions.pathwaydimension, null, 50, 110, 20, 3, CreatureTypes.AIR, CreatureTypes.TRANSIENT); //2% (ish) chance of around 3 spawning in air
		Spawnlist.registerSpawn(new Cockroach(null), Dimensions.pathwaydimension, null, 30, 100, 25, 3, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new Skeletorus(null), Dimensions.pathwaydimension, null, 0, 20, 700, 4, CreatureTypes.UNDERGROUND, CreatureTypes.TRANSIENT);
		Spawnlist.registerSpawn(new Rat(null), Dimensions.pathwaydimension, null, 0, 20, 800, 10, CreatureTypes.UNDERGROUND, CreatureTypes.TRANSIENT);		
		Spawnlist.registerSpawn(new Goose(null), Dimensions.pathwaydimension, null, 40, 70, 100, 5, CreatureTypes.WATER, CreatureTypes.PERMANENT); 
		Spawnlist.registerSpawn(new Skeletorus(null), Dimensions.pathwaydimension, null, 60, 90, 100, 2, CreatureTypes.LAND, CreatureTypes.TRANSIENT);
		Spawnlist.registerSpawn(new Anteater(null), Dimensions.pathwaydimension, null, 60, 90, 5, 8, CreatureTypes.LAND, CreatureTypes.PERMANENT);
		Spawnlist.registerSpawn(new Fish(null), Dimensions.pathwaydimension, null, 40, 70, 100, 5, CreatureTypes.WATER, CreatureTypes.TRANSIENT); 
		
		Spawnlist.registerSpawn(new Butterfly(null), Dimensions.ruggedhillsdimension, null, 50, 110, 20, 3, CreatureTypes.AIR, CreatureTypes.TRANSIENT); //2% (ish) chance of around 3 spawning in air
		Spawnlist.registerSpawn(new Cockroach(null), Dimensions.ruggedhillsdimension, null, 30, 100, 25, 3, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new Skeletorus(null), Dimensions.ruggedhillsdimension, null, 0, 20, 700, 4, CreatureTypes.UNDERGROUND, CreatureTypes.TRANSIENT);
		Spawnlist.registerSpawn(new Rat(null), Dimensions.ruggedhillsdimension, null, 0, 20, 800, 10, CreatureTypes.UNDERGROUND, CreatureTypes.TRANSIENT);		
		Spawnlist.registerSpawn(new Ghost(null), Dimensions.ruggedhillsdimension, null, 60, 110, 150, 4, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new GhostSkelly(null), Dimensions.ruggedhillsdimension, null, 60, 110, 50, 2, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new Werewolf(null), Dimensions.ruggedhillsdimension, null, 60, 110, 250, 5, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new VampireMoose(null), Dimensions.ruggedhillsdimension, null, 60, 110, 50, 2, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new Fish(null), Dimensions.ruggedhillsdimension, null, 40, 70, 100, 5, CreatureTypes.WATER, CreatureTypes.TRANSIENT); 
		
		Spawnlist.registerSpawn(new Butterfly(null), Dimensions.skyislandsdimension, null, 50, 110, 20, 3, CreatureTypes.AIR, CreatureTypes.TRANSIENT); //2% (ish) chance of around 3 spawning in air
		Spawnlist.registerSpawn(new Cockroach(null), Dimensions.skyislandsdimension, null, 30, 100, 25, 3, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 	
		Spawnlist.registerSpawn(new Butterfly(null), Dimensions.skyislandsdimension, null, 100, 220, 20, 3, CreatureTypes.AIR, CreatureTypes.TRANSIENT); //2% (ish) chance of around 3 spawning in air
		Spawnlist.registerSpawn(new Ghost(null), Dimensions.skyislandsdimension, null, 100, 220, 100, 3, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new GhostSkelly(null), Dimensions.skyislandsdimension, null, 100, 220, 50, 1, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new Rat(null), Dimensions.skyislandsdimension, null, 100, 180, 150, 5, CreatureTypes.LAND, CreatureTypes.TRANSIENT);
		Spawnlist.registerSpawn(new Cockroach(null), Dimensions.skyislandsdimension, null, 100, 180, 25, 3, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new Vampire(null), Dimensions.skyislandsdimension, null, 100, 220, 200, 3, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new TheCount(null), Dimensions.skyislandsdimension, null, 100, 220, 50, 1, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new VampireMoose(null), Dimensions.skyislandsdimension, null, 100, 220, 50, 1, CreatureTypes.LAND, CreatureTypes.TRANSIENT); 
		Spawnlist.registerSpawn(new Ostrich(null), Dimensions.skyislandsdimension, null, 100, 180, 15, 4, CreatureTypes.LAND, CreatureTypes.PERMANENT); 
		
		chestpacket = new ChestInventoryPacket();
		CustomPackets.registerCustomPacket(chestpacket); //register my receivers!!!
		furnacepacket = new FurnaceInventoryPacket();
		CustomPackets.registerCustomPacket(furnacepacket); //register my receivers!!!
		
		//more crafting...
		Crafting.registerCraftingRecipe(Items.peach, null, null, null, null, null, null, null, null, Items.peachseed, 1, false);
		Crafting.registerCraftingRecipe(Items.cherries, null, null, null, null, null, null, null, null, Items.cherryseed, 3, false);
		Crafting.registerCraftingRecipe(Items.apple, null, null, null, null, null, null, null, null, Items.appleseed, 6, false);
		Crafting.registerCraftingRecipe(Blocks.glass, Blocks.flower_pink, null, null, null, null, null, null, null, Blocks.blueglass, 1, false);
		Crafting.registerCraftingRecipe(Blocks.glass, Blocks.flower_red, null, null, null, null, null, null, null, Blocks.redglass, 1, false);
		Crafting.registerCraftingRecipe(Blocks.glass, Blocks.grass, null, null, null, null, null, null, null, Blocks.greenglass, 1, false);
		Crafting.registerCraftingRecipe(Blocks.glass, Blocks.flower_purple, null, null, null, null, null, null, null, Blocks.violetglass, 1, false);
		Crafting.registerCraftingRecipe(Blocks.glass, Blocks.flower_yellow, null, null, null, null, null, null, null, Blocks.yellowglass, 1, false);
		
		Crafting.registerCraftingRecipe(Blocks.stone, Blocks.stone, null, null, null, null, null, null, null, Blocks.stone2, 2, false);
		Crafting.registerCraftingRecipe(Blocks.stone, Blocks.stone, Blocks.stone, null, null, null, null, null, null, Blocks.stone3, 3, false);
		Crafting.registerCraftingRecipe(Blocks.stone, Blocks.stone, Blocks.stone, Blocks.stone, null, null, null, null, null, Blocks.stone4, 4, false);
		Crafting.registerCraftingRecipe(Blocks.greystone, Blocks.greystone, null, null, null, null, null, null, null, Blocks.greystone2, 2, false);
		Crafting.registerCraftingRecipe(Blocks.greystone, Blocks.greystone, Blocks.greystone, null, null, null, null, null, null, Blocks.greystone3, 3, false);
		Crafting.registerCraftingRecipe(Blocks.greystone, Blocks.greystone, Blocks.greystone, Blocks.greystone, null, null, null, null, null, Blocks.greystone4, 4, false);
		
		//armor
		Crafting.registerCraftingRecipe(null, null, null, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, null, Items.lumpcopper, Items.copperhelmet, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, null, Items.lumpcopper, null, null, null, Items.copperhelmet, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpcopper, null, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.copperchestplate, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, Items.lumpcopper, null, Items.lumpcopper, Items.lumpcopper, null, Items.lumpcopper, Items.copperleggings, 1, true);
		Crafting.registerCraftingRecipe(null, null, null, Items.lumpcopper, null, Items.lumpcopper, Items.lumpcopper, null, Items.lumpcopper, Items.copperboots, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpcopper, null, Items.lumpcopper, Items.lumpcopper, null, Items.lumpcopper, null, null, null, Items.copperboots, 1, true);

		Crafting.registerCraftingRecipe(null, null, null, Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, null, Items.lumptin, Items.tinhelmet, 1, true);
		Crafting.registerCraftingRecipe(Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, null, Items.lumptin, null, null, null, Items.tinhelmet, 1, true);
		Crafting.registerCraftingRecipe(Items.lumptin, null, Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, Items.tinchestplate, 1, true);
		Crafting.registerCraftingRecipe(Items.lumptin, Items.lumptin, Items.lumptin, Items.lumptin, null, Items.lumptin, Items.lumptin, null, Items.lumptin, Items.tinleggings, 1, true);
		Crafting.registerCraftingRecipe(null, null, null, Items.lumptin, null, Items.lumptin, Items.lumptin, null, Items.lumptin, Items.tinboots, 1, true);
		Crafting.registerCraftingRecipe(Items.lumptin, null, Items.lumptin, Items.lumptin, null, Items.lumptin, null, null, null, Items.tinboots, 1, true);

		Crafting.registerCraftingRecipe(null, null, null, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, null, Items.lumpsilver, Items.silverhelmet, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, null, Items.lumpsilver, null, null, null, Items.silverhelmet, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpsilver, null, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.silverchestplate, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, Items.lumpsilver, null, Items.lumpsilver, Items.lumpsilver, null, Items.lumpsilver, Items.silverleggings, 1, true);
		Crafting.registerCraftingRecipe(null, null, null, Items.lumpsilver, null, Items.lumpsilver, Items.lumpsilver, null, Items.lumpsilver, Items.silverboots, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpsilver, null, Items.lumpsilver, Items.lumpsilver, null, Items.lumpsilver, null, null, null, Items.silverboots, 1, true);

		Crafting.registerCraftingRecipe(null, null, null, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, null, Items.lumpplatinum, Items.platinumhelmet, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, null, Items.lumpplatinum, null, null, null, Items.platinumhelmet, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpplatinum, null, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.platinumchestplate, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, Items.lumpplatinum, null, Items.lumpplatinum, Items.lumpplatinum, null, Items.lumpplatinum, Items.platinumleggings, 1, true);
		Crafting.registerCraftingRecipe(null, null, null, Items.lumpplatinum, null, Items.lumpplatinum, Items.lumpplatinum, null, Items.lumpplatinum, Items.platinumboots, 1, true);
		Crafting.registerCraftingRecipe(Items.lumpplatinum, null, Items.lumpplatinum, Items.lumpplatinum, null, Items.lumpplatinum, null, null, null, Items.platinumboots, 1, true);

		Crafting.registerCraftingRecipe(Items.light, Items.dark, null, null, null, null, null, null, null, Items.instability, 2, false);
		Crafting.registerCraftingRecipe(Blocks.blocklight, Blocks.blockdark, null, null, null, null, null, null, null, Items.instabilitylarge, 2, false);
		Crafting.registerCraftingRecipe(Items.instability, Items.instability, Items.instability, Items.instability, Items.instability, Items.instability, Items.instability, Items.instability, Items.instability, Items.instabilitylarge, 1, false);
		Crafting.registerCraftingRecipe(Items.instabilitylarge, Items.instabilitylarge, Items.instabilitylarge, Items.instabilitylarge, Items.instabilitylarge, Items.instabilitylarge, Items.instabilitylarge, Items.instabilitylarge, Items.instabilitylarge, Items.instabilityhuge, 1, false);
		Crafting.registerCraftingRecipe(Items.instability, Items.stick, null, null, null, null, null, null, null, Items.firestick, 1, false);
		
		//door
		Crafting.registerCraftingRecipe(Blocks.plywood, Blocks.plywood, null, Blocks.plywood, Blocks.plywood, null, Blocks.plywood, Blocks.plywood, null, Items.door, 1, true);
		Crafting.registerCraftingRecipe(Blocks.darkplywood, Blocks.darkplywood, null, Blocks.darkplywood, Blocks.darkplywood, null, Blocks.darkplywood, Blocks.darkplywood, null, Items.door, 1, true);
		Crafting.registerCraftingRecipe(Blocks.lightplywood, Blocks.lightplywood, null, Blocks.lightplywood, Blocks.lightplywood, null, Blocks.lightplywood, Blocks.lightplywood, null, Items.door, 1, true);

		Crafting.registerCraftingRecipe(null, Blocks.plywood, Blocks.plywood, null, Blocks.plywood, Blocks.plywood, null, Blocks.plywood, Blocks.plywood, Items.door, 1, true);
		Crafting.registerCraftingRecipe(null, Blocks.darkplywood, Blocks.darkplywood, null, Blocks.darkplywood, Blocks.darkplywood, null, Blocks.darkplywood, Blocks.darkplywood, Items.door, 1, true);
		Crafting.registerCraftingRecipe(null, Blocks.lightplywood, Blocks.lightplywood, null, Blocks.lightplywood, Blocks.lightplywood, null, Blocks.lightplywood, Blocks.lightplywood, Items.door, 1, true);

		//add some color!
		fengshui = new WorldDecorator();
		WorldDecorators.registerWorldDecorator(fengshui);
		
		//and a command handler!
		CommandHandlers.registerCommandHandler(new DZCommandHandler());
		
	}
	
	
	/*
	 * This is the second stage of mod initialization.
	 * Everything from all active mods has been registered.
	 * ItemIDs, blockIDs and dimensionIDs are now stable. Maybe. Not necessarily for real server connections...
	 * Go ahead and finish whatever initialization, if any, you need to do here.
	 * 
	 * From world to world, your ItemIDs and blockIDs may change.
	 * But for any one world, your Item and Block IDs are fixed in stone.
	 * 
	 * 
	 */
	public void postLoadProcessing(){
		//String world_directory_where_i_should_save_files = DangerZone.getWorldDirectoryPath();

	}
			

}
