package dangerzone.threads;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.ListInt;
import dangerzone.Player;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ColoringBlock;
import dangerzone.entities.Entity;


public class Server implements Runnable {
	

	ServerSocket myServerSocket;
	public  List<ListInt> server_thread_list; // a list of little things that index into
	public ServerThread players[];           // an array of big things that we don't want Java to copy!
	public int max_players = 256;
	public  Lock player_list_lock = new ReentrantLock();
	private Player plyr;
	public ServerEntityUpdateLoop entityManager = null;

	public void run() {
		Socket sock;
		ServerThread st;
		server_thread_list = new ArrayList<ListInt>();
		
		try {
			myServerSocket = new ServerSocket(DangerZone.server_port);
		} catch (IOException e) {
			return;
		}
		
		entityManager = new ServerEntityUpdateLoop();
		Thread it = new Thread(entityManager);	//Fire up the entity runner!
		//it.setPriority(Thread.MAX_PRIORITY);
		it.start();	
		
		players = new ServerThread[max_players]; //Make room for players!
		int i;
		for(i=0;i<max_players;i++){
			players[i] = null;
		}
		
		//Need to register the dynamic coloring blocks before we start the block ticker, just in case it ticks something next to one...
		//Also need to send them to remote players.
		String cbname = new String();
		int bid;
		ColoringBlock cb = null;
		for(i=0;i<100;i++){
			cbname = String.format("DangerZone:Coloring Block %2d", i);
			bid = Blocks.lookup(cbname);
			if(bid > 0){
				cb = new ColoringBlock(cbname, String.format("worlds/%s/coloring/coloringblock%2d.png", DangerZone.worldname, i));
				cb.blockID = bid;
				Blocks.BlockArray[bid] = cb;
			}
		}

		Thread ftb = new Thread(new FastBlockTicker());	//Fire up the fast block ticker!
		ftb.start();
		
		Thread nty = new Thread(new NotifyBlockTicker());	//Fire up the notify block ticker!
		nty.start();
		
		Thread itb = new Thread(new BlockTickerThread());	//Fire up the block ticker!
		itb.start();	
		
		Thread its = new Thread(new SpawnerThread());	//Fire up the spawn ticker!
		its.start();	
		

		
		//wait for players!
		while(DangerZone.gameover == 0){
			try {
				sock = myServerSocket.accept();
			} catch (IOException e) {
				return;
			}

			player_list_lock.lock(); 
			
			i = find_player_slot();
			if(i < 0){
				try {
					sock.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
				player_list_lock.unlock();
				continue;
			}
			
			plyr = new Player(DangerZone.server_world);
			plyr.toClient = sock;
			st = new ServerThread(plyr);
			players[i] = st;
			server_thread_list.add(new ListInt(i));			
			player_list_lock.unlock();
			
			Thread pit = new Thread(st);	//Send the connection off to a thread for processing!
			pit.start();				
		}		
	}
	
	private int find_player_slot(){
		int i;
		for(i=0;i<max_players;i++){
			if(players[i] == null)return i;
		}
		return -1;
	}
	
	//
	public void sendChunkToAll(Chunk c){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p.dimension == c.dimension){
				//send to everyone in same dimension, cuz they may have an old copy in their cache...
				players[st.index].sendChunkToPlayer(c);
			}
		}		
		player_list_lock.unlock();
	}
	
	public void sendBlockToAll(int d, int x, int y, int z, int id, int meta){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p.dimension == d){
				//send to everyone in same dimension, cuz they may have an old copy in their cache...
				players[st.index].sendBlockToPlayer(d, x, y, z, id, meta);
			}
		}		
		player_list_lock.unlock();
	}
	
	public void sendEntityDeathToAll(Entity e){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p.dimension == e.dimension && e.getDistanceFromEntity(players[st.index].p) < DangerZone.entityupdatedist){
				//send to everyone
				players[st.index].sendEntityDeathToPlayer(e.entityID);
			}
		}		
		player_list_lock.unlock();
	}

	public void sendEntityDeathToAllExcept(Player pl, Entity e){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p != pl && players[st.index].p.dimension == e.dimension && e.getDistanceFromEntity(players[st.index].p) < DangerZone.entityupdatedist){
				//send to everyone
				players[st.index].sendEntityDeathToPlayer(e.entityID);
			}
		}		
		player_list_lock.unlock();
	}
	
	public void sendSpawnParticleToAllExcept(Player pl, String s, int hm, int d, float x, float y, float z){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p != pl && players[st.index].p.dimension == d && players[st.index].p.getDistanceFromEntityCenter(x, y, z) < 256){
				//send to everyone
				players[st.index].sendSpawnParticleToPlayer(s, hm, d, x, y, z);
			}
		}		
		player_list_lock.unlock();
	}
	
	public void sendEntityRemoveToAll(Entity e){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null){
				//send to everyone
				players[st.index].sendEntityRemoveToPlayer(e.entityID);
			}
		}		
		player_list_lock.unlock();
	}

	public void sendEntityRemoveToAllExcept(Player pl, Entity e){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p != pl){
				//send to everyone
				players[st.index].sendEntityRemoveToPlayer(e.entityID);
			}
		}		
		player_list_lock.unlock();
	}
	
	
	public void sendEntityHitToAll(Entity e){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p.dimension == e.dimension && e.getDistanceFromEntity(players[st.index].p) < DangerZone.entityupdatedist){
				//send to everyone
				players[st.index].sendEntityHitToPlayer(e.entityID, e.getHealth());
			}
		}		
		player_list_lock.unlock();
	}
	
	public void sendChatToAll(String s){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null){
				//send to everyone
				players[st.index].sendChatToPlayer(s);
			}
		}		
		player_list_lock.unlock();
	}
	
	public void sendCommandToAll(String s){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null){
				//send to everyone
				players[st.index].sendCommandToPlayer(s);
			}
		}		
		player_list_lock.unlock();
	}
	
	public void savePlayers(){
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null){
				//Save player!
				//System.out.printf("Player save\n");
				players[st.index].storePlayer();
			}
		}		
		player_list_lock.unlock();
	}
	
	
	public void sendEntityUpdateToAll(Entity e, boolean force){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			//If close enough for the player to care...
			//if(players[st.index] != null && players[st.index].p.dimension == e.dimension && e.getDistanceFromEntity(players[st.index].p) < DangerZone.entityupdatedist){
			if(!force){
				if(players[st.index] != null && players[st.index].p.dimension == e.dimension && e.getDistanceFromEntity(players[st.index].p) < e.maxrenderdist){
					//send
					players[st.index].sendEntityUpdateToPlayer(e);
				}
			}else{
				if(players[st.index] != null){
					//send
					players[st.index].sendEntityUpdateToPlayer(e);
				}
			}
		}		
		player_list_lock.unlock();
		//Now that they are all updated, clear the entity change flags!
		if(e.changed != 0){
			e.changed = 0;
			for(int i=0;i<e.maxinv;i++){
				e.changes[i] = 0;
			}				
		}
	}
	
	public void sendPlayerUpdateToAllExcept(Entity e, Player p, boolean forceall){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(!forceall){
				if(players[st.index] != null && players[st.index].p != p && players[st.index].p.dimension == e.dimension && e.getDistanceFromEntity(players[st.index].p) < DangerZone.entityupdatedist){
					//send
					players[st.index].sendEntityUpdateToPlayer(e);
					//players[st.index].flushSend();
				}
			}else{
				//probably a player changing dimension.... let everyone everywhere know!
				if(players[st.index] != null && players[st.index].p != p){
					//send
					players[st.index].sendEntityUpdateToPlayer(e);
					//players[st.index].flushSend();
				}
			}
		}		
		player_list_lock.unlock();
		//Now that they are updated, clear the entity change flags!
		if(e.changed != 0){
			e.changed = 0;
			for(int i=0;i<e.maxinv;i++){
				e.changes[i] = 0;
			}				
		}
	}
	
	public void sendPlayerActionToAllExcept(Player p, int which, int what){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p != p && players[st.index].p.dimension == p.dimension && p.getDistanceFromEntity(players[st.index].p) < DangerZone.entityupdatedist){
				//send to everyone, cuz they may have an old copy in their cache...
				players[st.index].sendPlayerAction(p, which, what);
			}
		}		
		player_list_lock.unlock();
	}
	
	public void sendSpawnEntityToAll(Entity e){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p.dimension == e.dimension && e.getDistanceFromEntity(players[st.index].p) < DangerZone.entityupdatedist){
				//send to everyone in same dimension
				players[st.index].sendSpawnEntityToPlayer(e);
			}
		}		
		player_list_lock.unlock();
	}
	
	public void sendTimeToAll(int t, int l){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null)players[st.index].sendTimeToPlayer(t, l);
		}		
		player_list_lock.unlock();
	}
	
	public void sendBlockToAllExcept(ServerThread stp, int d, int x, int y, int z, int id, int meta){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index] != stp){
				if(players[st.index].p.dimension == d){
					//send to everyone in same dimension, cuz they may have an old copy in their cache...
					players[st.index].sendBlockToPlayer(d, x, y, z, id, meta);
				}
			}
		}		
		player_list_lock.unlock();
	}
	
	public void flushAll(){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		int i;
		while(ii.hasNext()){
			i = ii.next().index;
			if(players[i] != null)players[i].flushSend();
		}		
		player_list_lock.unlock();
	}
	
	public Player getRandomPlayer(Random rand){
		Player p = null;
		player_list_lock.lock();
		if(server_thread_list.size() != 0){
			if(server_thread_list.size() == 1){
				p = players[server_thread_list.get(0).index].p;
			}else{
				int i = rand.nextInt(server_thread_list.size());
				p = players[server_thread_list.get(i).index].p;
			}
		}
		player_list_lock.unlock();
		return p;		
	}
	
	public boolean isAPlayerInDimension(int d){
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index].p.dimension == d){
				player_list_lock.unlock();
				return true;
			}
		}		
		player_list_lock.unlock();
		return false;		
	}
	
	public boolean isPlayerCloseInDimension(Entity e){
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index].p.dimension == e.dimension){
				if(e.getDistanceFromEntity(players[st.index].p) < DangerZone.entityupdatedist){
					player_list_lock.unlock();
					return true;
				}
			}
		}		
		player_list_lock.unlock();
		return false;		
	}
	
	public boolean isPlayerCloseInDimension(Entity e, float dist){
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index].p.dimension == e.dimension){
				if(e.getDistanceFromEntity(players[st.index].p) < dist){
					player_list_lock.unlock();
					return true;
				}
			}
		}		
		player_list_lock.unlock();
		return false;		
	}
	
	public void removeMe(ServerThread stp){
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] == stp){
				ii.remove();
				players[st.index] = null;
				break;
			}
		}		
		player_list_lock.unlock();
	}
	
	public Player findNearestPlayer(Entity e){
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		float dist = 999.0f;
		Player p = null;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index].p.dimension == e.dimension){
				if(e.getDistanceFromEntity(players[st.index].p) < dist){
					p = players[st.index].p;
					dist = e.getDistanceFromEntity(players[st.index].p);					
				}
			}
		}		
		player_list_lock.unlock();
		return p;		
	}
	
	public Player findNearestPlayerToHere(int d, int x, int y, int z){
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		float dist = 999.0f;
		Player p = null;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index].p.dimension == d){
				float dx, dy, dz;
				float curdist;
				dx = players[st.index].p.posx - x;
				dy = players[st.index].p.posy - y;
				dz = players[st.index].p.posz - z;
				curdist = (float) Math.sqrt((dx*dx)+(dy*dy)+(dz*dz));
				if(curdist < dist){
					p = players[st.index].p;
					dist = curdist;					
				}
			}
		}		
		player_list_lock.unlock();
		return p;		
	}
	
	public float distToNearestPlayerFromHere(int d, int x, int y, int z){
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		float dist = 999.0f;
	
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index].p.dimension == d){
				float dx, dy, dz;
				float curdist;
				dx = players[st.index].p.posx - x;
				dy = players[st.index].p.posy - y;
				dz = players[st.index].p.posz - z;
				curdist = (float) Math.sqrt((dx*dx)+(dy*dy)+(dz*dz));
				if(curdist < dist){
					dist = curdist;					
				}
			}
		}		
		player_list_lock.unlock();
		return dist;		
	}
	
	public float findNearestPlayerDistToHere(int d, int x, int z){
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		float dist = 9999.0f;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index].p.dimension == d){
				float dx, dz;
				float curdist;
				dx = players[st.index].p.posx - x;
				dz = players[st.index].p.posz - z;
				curdist = (float) Math.sqrt((dx*dx)+(dz*dz));
				if(curdist < dist){
					dist = curdist;					
				}
			}
		}		
		player_list_lock.unlock();
		return dist;		
	}
	
	public void sendSoundToAllExcept(Player pl, String name, int pd, float px, float py, float pz, float vol, float freq){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p != pl && players[st.index].p.dimension == pl.dimension && pl.getDistanceFromEntity(players[st.index].p) < DangerZone.entityupdatedist){
				players[st.index].sendSound(name, pd, px, py, pz, vol, freq);
			}
		}		
		player_list_lock.unlock();
	}
	
	public void sendSoundToAll(String name, int pd, float px, float py, float pz, float vol, float freq){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null && players[st.index].p.dimension == pd && players[st.index].p.getDistanceFromEntityCenter(px, py, pz) < DangerZone.entityupdatedist){
				players[st.index].sendSound(name, pd, px, py, pz, vol, freq);
			}
		}		
		player_list_lock.unlock();
	}
	
	
	public void sendColoringBlockToAll(String name, int bid, float colordata[][][]){
		if(DangerZone.gameover != 0)return;
		player_list_lock.lock();
		Iterator<ListInt> ii = server_thread_list.iterator();
		ListInt st;
		while(ii.hasNext()){
			st = ii.next();
			if(players[st.index] != null){
				players[st.index].sendColoringBlock(name, bid, colordata, true);
			}
		}		
		player_list_lock.unlock();
	}
	
}
