package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

import org.newdawn.slick.opengl.Texture;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.items.Items;


public class Goose extends EntityLiving {
	
	private GenericTargetSorter FoodSorter = null;
	public int breeding = 0;

	public Goose(World w) {
		super(w);
		maxrenderdist = 120; //in blocks
		this.height = 1.25f;
		this.width = 0.75f;
		uniquename = "DangerZone:Goose";
		moveSpeed = 0.10f;
		setMaxHealth(10.0f);
		setHealth(10.0f);
		setDefense(1.0f);
		setAttackDamage(0f);
		movefrequency = 55;
		setExperience(14);
		canSwim = true;
		swimoffset = -0.75f;
		setCanDespawn(false);
		takesFallDamage = false;
		setOnGround(true); //so the trophy doesn't flap!
	}
	
	public void init(){
		super.init();
		FoodSorter = new GenericTargetSorter(this);
	}
	
	public String getLivingSound(){
		return "DangerZone:goose_living";
	}
	
	public String getHurtSound(){
		return "DangerZone:goose_hit";
	}
	
	public String getDeathSound(){
		return "DangerZone:goose_death";
	}
	
	public boolean isFoodItem(int foodid){
		if(foodid == Items.corn.itemID)return true;
		return false;
	}
	
	public Entity followFood(){	
		List<Entity> nearby_list = null;
		//Get a list of entities within reach of largest mob expected because we may hit their hitbox!
		nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange((this.width/2) + 10, dimension, posx, posy, posz);
		if(nearby_list != null){
			if(!nearby_list.isEmpty()){
				Entity e = null;
				ListIterator<Entity> li;
				//Sort them out based on size and distance
				Collections.sort(nearby_list, this.FoodSorter);
				li = nearby_list.listIterator();
				while(li.hasNext()){
					e = (Entity)li.next();
					if(e instanceof Player){
						Player p = (Player)e;
						InventoryContainer ic = p.getHotbar(p.gethotbarindex());
						if(ic != null && isFoodForMe(ic.bid, ic.iid))return e;
					}
				}								
			}			
		}
		return null;
	}
	
	public Entity findMate(){	
		List<Entity> nearby_list = null;
		//Get a list of entities within reach of largest mob expected because we may hit their hitbox!
		nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange((this.width/2) + 10, dimension, posx, posy, posz);
		if(nearby_list != null){
			if(!nearby_list.isEmpty()){
				Entity e = null;
				ListIterator<Entity> li;
				//Sort them out based on size and distance
				Collections.sort(nearby_list, this.FoodSorter);
				li = nearby_list.listIterator();
				while(li.hasNext()){
					e = (Entity)li.next();
					if(e instanceof Goose && e != this){
						return e;
					}
				}								
			}			
		}
		return null;
	}
	
	public void doEntityAction(float deltaT){	
		if(breeding > 0)breeding--;
		
		//follow food!
		if(breeding == 0 && target == null && world.rand.nextInt(movefrequency/10) == 1){
			Entity e = followFood();
			if(e != null){ 
				target = new TargetHelper(e, e.posx, e.posy, e.posz);
			}			
		}	
		//find a mate!
		if(breeding != 0 && target == null && world.rand.nextInt(movefrequency/6) == 1){
			Entity e = findMate();
			if(e != null){ 
				Goose g = (Goose)e;
				target = new TargetHelper(g, g.posx, g.posy, g.posz);
				//see if we are already close enough
				if(g.breeding != 0 && getDistanceFromEntity(g) < this.width*2 && world.rand.nextInt(2) == 1){
					breeding = 0;
					g.breeding = 0;
					int howmany = 3 + world.rand.nextInt(5);
					for(int j=0;j<howmany;j++){
						Entity newme = world.createEntityByName("DangerZone:Gosling", dimension, (posx+g.posx)/2, (posy+g.posy)/2, (posz+g.posz)/2);
						if(newme != null){
							newme.init();				
							world.spawnEntityInWorld(newme);
							world.playSound("DangerZone:pop", dimension, (posx+g.posx)/2, (posy+g.posy)/2, (posz+g.posz)/2, 1.0f, 1.0f+(world.rand.nextFloat()-world.rand.nextFloat())*0.3f);
						}
					}
				}
			}
		}
		if(breeding != 0){
			if(world.rand.nextInt(5) == 0)Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 2, this.dimension, posx, posy+height, posz);
		}
		super.doEntityAction(deltaT);
	}
	
	public boolean rightClickedByPlayer(Player p, InventoryContainer ic){	
		//Most stuff gets done on the server, except naming, which requires a GUI!
		if(world.isServer){
			//breeding
			if(ic != null && isFoodForMe(ic.bid, ic.iid)){
				if(world.rand.nextInt(3) == 1){
					Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, posx, posy+height, posz);
					heal(10);
					breeding = 200 + world.rand.nextInt(200);
				}
				playburp();			
				return true; //decrement inventory!
			}
		}
		return false;
	}
	
	public void doDeathDrops(){
		Utils.doDropRand(world, 0, Items.trophygoose.itemID, 1f, dimension, posx, posy, posz);
		Utils.doDropRand(world, 0, Items.goosemeat.itemID, 1f, dimension, posx, posy, posz);
		int i=1+world.rand.nextInt(4);
		for(int j=0;j<i;j++){
			Utils.doDropRand(world, 0, Items.feather.itemID, 1.5f, dimension, posx, posy, posz);
		}
		//easter egg!
		if(world.rand.nextInt(1000) == 42){
			for(int j=0;j<1000;j++){
				Utils.doDropRand(world, 0, Items.feather.itemID, 3.5f, dimension, posx, posy, posz);
			}
		}
	}
	
	public void update(float deltaT){
		if(this.world.isServer){
			if(world.rand.nextInt(5000) == 1){
				Utils.doDropRand(world, 0, Items.egggosling.itemID, 0.1f, dimension, posx, posy, posz);
			}
		}
		super.update(deltaT);
	}
		
	//Model calls back out to see what texture to use.
	public Texture getTexture(){
		if(texture == null){
			//ENTITIES MUST USE TEXTUREMAPPER.GETTEXTURE()!!!!
			texture = TextureMapper.getTexture("res/skins/"+ "Goosetexture.png");	//this is not fast, so we keep our own pointer!
		}
		return texture;
	}

}
