package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


import java.util.Collections;
import java.util.List;
import java.util.ListIterator;


import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.gui.PlayerPetNameGUI;
import dangerzone.items.Items;



public class EntityTameable extends EntityLiving {
	private int secondcounter = 0;
	private GenericTargetSorter FoodSorter = null;
	public float maxdisttoowner = 14f;
	public int foodsearchDistance = 12;
	
	public	EntityTameable(World w){
		super(w);
		canSwim = true;
		setCanDespawn(false);
		maxdisttoowner = 14f;
		foodsearchDistance = 12;
	}
	
	public void init(){
		super.init();
		FoodSorter = new GenericTargetSorter(this);
	}
	
	public boolean rightClickedByPlayer(Player p, InventoryContainer ic){	
		//Most stuff gets done on the server, except naming, which requires a GUI!
		if(world.isServer){
			//taming
			if(ic != null && isFoodForMe(ic.bid, ic.iid) && getOwnerName() == null){
				if(world.rand.nextInt(3) == 1){
					setOwnerName(p.myname);
					Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, posx, posy+height, posz);
					heal(10);
				}
				playburp();			
				return true; //decrement inventory!
			}

			//feeding
			if(ic != null && isFoodForMe(ic.bid, ic.iid) && getOwnerName() != null && p.myname.equals(getOwnerName())){
				Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 10, this.dimension, posx, posy+height, posz);
				playburp();
				heal(5);
				return true; //decrement inventory!
			}

			//naming
			if(ic != null && ic.iid == Items.moosebone.itemID && getOwnerName() != null && p.myname.equals(getOwnerName())){
				Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, posx, posy+height, posz);
				heal(1);
				world.playSound("DangerZone:pop", dimension, posx, posy, posz, 1.0f, 1.0f+(world.rand.nextFloat()-world.rand.nextFloat())*0.3f);
				return true; //decrement inventory!
			}
			
			if(ic != null && ic.iid == Items.vampireteeth.itemID && getOwnerName() != null && p.myname.equals(getOwnerName())){
				Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 10, this.dimension, posx, posy+height, posz);
				setStaying(false);
				setOwnerName(null);
				setPetName(null);
				world.playSound("DangerZone:pop", dimension, posx, posy, posz, 1.0f, 1.0f+(world.rand.nextFloat()-world.rand.nextFloat())*0.3f);
				return true; //decrement inventory!
			}

			//sit/unsit
			if(ic != null && getOwnerName() != null && p.myname.equals(getOwnerName()) && getRiderEntity() == null){
				if(getStaying()){
					setStaying(false);
					Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, posx, posy+height, posz);
				}else{
					setStaying(true);
					setAttacking(false);
					motionx = motionz = 0;
					target = null;
					Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 10, this.dimension, posx, posy+height, posz);
				}
			}
		}else{
			//naming
			if(ic != null && ic.iid == Items.moosebone.itemID && getOwnerName() != null && p.myname.equals(getOwnerName())){
				PlayerPetNameGUI pg = new PlayerPetNameGUI(this);
				DangerZone.setActiveGui(pg);
				return false; //no decrement inventory!
			}
		}
		return false; //do not decrement inventory
	}
	
	public void findNewTargetNearOwner(Entity e){
		float newdir, newdist, newy, newx, newz;
		int intdist;

		if(target == null)target = new TargetHelper(e.posx, e.posy, e.posz);
		
		int tries = 8; //max tries per cycle. better luck next time!
		while(tries > 0){
			tries--;
			newdir = world.rand.nextFloat()-world.rand.nextFloat();
			newdir *= 180f;
			newdir += this.rotation_yaw; //grab a new general direction towards where we are already pointing
			newdist = 2.0f + world.rand.nextFloat()*width*height*2; //get a new general distance
			intdist = (int) (newdist+0.995f);
			newx = (float) (e.posx+Math.cos(newdir)*newdist);
			newz = (float) (e.posz+Math.sin(newdir)*newdist);
			newy = e.posy;
			for(int i=intdist;i>-intdist;i--){
				newy = posy+i;
				if(!isSolidAtLevel(dimension, newx, newy+1, newz)){
					if(isSolidAtLevel(dimension, newx, newy, newz) && CanProbablySee(dimension, newx, newy+1, newz, (int)newdist)){
						if(!canSwim && Blocks.isLiquid(world.getblock(dimension, (int)newx, (int)newy+1, (int)newz))){
							break;
						}
						newy += 1;
						newy = (int)newy;
						target.setTarget(newx, newy, newz);
						newtargetnow = false;
						//System.out.printf("New Target set %f,  %f, %f\n", newx, newy, newz);
						return;
					}
				}
			}
		}
	}
	
	public void doEntityAction(float deltaT){

		secondcounter++;
		if(secondcounter > 10){
			secondcounter = world.rand.nextInt(5); // just to slow things down a little. no sense scanning constantly.
			accellerator = 1.0f;
			//if we are tamed, stay within range of owner
			if(getOwnerName() != null && !getStaying()){
				Entity e = DangerZone.server.entityManager.findPlayerByName(getOwnerName());
				if(e != null){
					float dist = getDistanceFromEntity(e);
					if(dist > maxdisttoowner){
						accellerator = 1.75f; //move a little faster when out of range!
						findNewTargetNearOwner(e);
						if(dist > maxdisttoowner*2){
							//teleport to owner
							target = null;
							accellerator = 1.0f;
							if(e.getOnGround())Dimensions.DimensionArray[e.dimension].teleportToDimension(this, world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz);
						}
					}
				}
			}
			
			//follow held food...
			if(target == null && !getStaying()){
				Entity e = followFood();
				if(e != null){				
					target = new TargetHelper(e.posx, e.posy, e.posz);
				}
			}
			
			//search for something to eat
			if(target == null){
				Entity e = findSomethingToEat();
				this.setAttacking(false);
				if(e != null){				
					if(e.getDistanceFromEntity(this) < 3){
						e.deadflag = true;
						playburp();
						heal(2);
						target = null;						
					}else if(!getStaying()){
						target = new TargetHelper(e.posx, e.posy, e.posz);
						this.setAttacking(true);
					}
				}
			}else{
				if(target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3){
					Entity e = findSomethingToEat();
					if(e != null && e.getDistanceFromEntity(this) < 3){
						e.deadflag = true;
						playburp();
						heal(2);
						target = null;
						this.setAttacking(false);
					}
				}
			}
		}

		//do some generic movement?
		if(!getStaying()){
			super.doEntityAction(deltaT);	
		}
	}
	
	public void update(float deltaT){
		//pets heal slowly, regardless
		if(world.isServer && world.rand.nextInt(200) == 1)heal(1);
		super.update(deltaT);
	}
	
	public float getDefense(){
		float df = super.getDefense();
		if(getOwnerName() != null && df < 2)df = 2; //a little tougher when tamed
		return df;
	}

	
	public Entity findSomethingToEat(){	
		List<Entity> nearby_list = null;
		//Get a list of entities within reach of largest mob expected because we may hit their hitbox!
		nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange((this.width/2) + foodsearchDistance, dimension, posx, posy, posz);
		if(nearby_list != null){
			if(!nearby_list.isEmpty()){
				Entity e = null;
				ListIterator<Entity> li;
				//Sort them out based on size and distance
				Collections.sort(nearby_list, this.FoodSorter);
				li = nearby_list.listIterator();
				while(li.hasNext()){
					e = (Entity)li.next();
					if(isSuitableFood(e)){ 
						return e;
					}
				}								
			}			
		}
		return null;
	}

	//Look for food!
	public boolean isSuitableFood(Entity e){
		if(!(e instanceof EntityBlockItem))return false;
		EntityBlockItem eb = (EntityBlockItem)e;
		if(!isFoodForMe(eb.getBID(), eb.getIID()))return false;
		if(getOwnerName() != null){
			Entity p = DangerZone.server.entityManager.findPlayerByName(getOwnerName());
			if(p != null){
				if(p.getDistanceFromEntity(eb) > maxdisttoowner){
					return false;
				}
			}
		}
		if(!CanProbablySeeEntity(eb))return false; //final check, cuz its the slowest
		return true;
	}
	
	public Entity followFood(){	
		List<Entity> nearby_list = null;
		//Get a list of entities within reach of largest mob expected because we may hit their hitbox!
		nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange((this.width/2) + foodsearchDistance, dimension, posx, posy, posz);
		if(nearby_list != null){
			if(!nearby_list.isEmpty()){
				Entity e = null;
				ListIterator<Entity> li;
				//Sort them out based on size and distance
				Collections.sort(nearby_list, this.FoodSorter);
				li = nearby_list.listIterator();
				while(li.hasNext()){
					e = (Entity)li.next();
					if(e instanceof Player){
						Player p = (Player)e;
						InventoryContainer ic = p.getHotbar(p.gethotbarindex());
						if(ic != null && isFoodForMe(ic.bid, ic.iid))return e;
					}
				}								
			}			
		}
		return null;
	}
	

}
