package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


import java.util.Collections;
import java.util.List;
import java.util.ListIterator;



import dangerzone.DamageTypes;
import dangerzone.DangerZone;
import dangerzone.GameModes;
import dangerzone.Player;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.Items;
import dangerzone.threads.LightingThread;


public class EntityLiving extends Entity {
	
	private float deathfactor = 0.0f;
	public TargetHelper target = null;
	public TargetHelper idletarget = null;
	public float moveSpeed = 0.25f;
	public float accellerator = 1.0f;
	public boolean newtargetnow = false;
	public int movefrequency = 100; //Higher = less often! Lower = more often!
	public int damage_backoff = 0;
	public int fallcount = 0;
	public int lastbx, lastby, lastbz, lastbd;
	public boolean canSwim = true;
	public float eyeheight = 1f;
	public float swimoffset = 0;
	public int closest = 99999;
	public int tx = 0, ty = 0, tz = 0;
	public int tickadjust = 0;
	private GenericTargetSorter LookTargetSorter = null;
	public float lookDistance = 16;
	public boolean knockbackcheck = false;
	public float jumpstrength = 1.0f;
	public boolean canBreateUnderWater = false;
	public boolean isImmuneToFire = false;
	public boolean targetLiquidOnly = false;
	
	public	EntityLiving(World w){
		super(w);	
		setMaxHealth(1.0f); //default
		setHealth(1.0f);
		setDefense(1.0f); //default - attack damage is DIVIDED by this.
		deathfactor = 0;
		takesFallDamage = true;
		canSwim = true;
		setMaxAir(40);
		setAir(40);
		setCanDespawn(true);
	}
	
	public void init(){
		super.init();
		eyeheight = height*9/10;
		LookTargetSorter = new GenericTargetSorter(this);
		lookDistance = width*20; //default
		if(lookDistance > 64)lookDistance = 64;
		jumpstrength = 0.15f * height;
	}
	
	//Check all around entity WIDTH to stop from running into things
	//make entity just a little fatter (0.01) so that isSolidAtLevel doesn't accidentally get triggered true
	public boolean doSolidsPushback(float kf, float deltaT){
		int intwidth = (int)((width/2.0f)+0.995f);
		int i, j;
		int itemp;
		float dx, dz;
		float dxsave;
		float tmx = motionx*deltaT;
		float tmz = motionz*deltaT;
		float rate = (float)((float)DangerZone.entityupdaterate/DangerZone.serverentityupdaterate);
		if(!world.isServer){
			tmx *= rate;
			tmz *= rate;
		}
		boolean hitsomething = false;
		float dist = (float) Math.sqrt(tmx*tmx + tmz*tmz);
		float curdist = 0.0f;
		
		if(dist == 0)return false;
		/*
		 * Have to increment this out like a big fat ray for things that are moving fast!
		 */
		while(curdist < dist && !hitsomething){
			curdist += 0.1f;	
			if(curdist > dist)curdist = dist;
			float mx = (curdist/dist)*tmx;
			float mz = (curdist/dist)*tmz;
			float upx = posx + mx;
			float upz = posz + mz;
			//int bx, bz;

			for(i=-intwidth;i<=intwidth;i++){
				for(j=-intwidth;j<=intwidth;j++){
					if(Blocks.isSolid(this.world.getblock(dimension, (int)upx+i, (int)(posy+kf), (int)upz+j), this.world, dimension, (int)upx+i, (int)(posy+kf), (int)upz+j)){
						/*
						bx = (int)(upx)+i;
						bz = (int)(upz)+j;
						if(upx+width/2 < bx && upx-width/2 < bx || upx+width/2 > bx+1 && upx-width/2 > bx+1 ){
							//no match
						}else{
							//match in x direction!
							if(upz+width/2 < bz && upz-width/2 < bz || upz+width/2 > bz+1 && upz-width/2 > bz+1 ){
								//no match
							}else{
								//hit in x & z direction!
								//now figure out what to do...
								dx = curdist - 0.1f;
								if(dx < 0)dx = 0;
								motionx = motionx * (dx/dist);
								motionz = motionz * (dx/dist);
								
							}
						}
						*/
						
												
						
						itemp = (int)(upx)+i;
						dx = ((float)itemp + 0.5f) - posx;
						itemp = (int)(upz)+j;
						dz = ((float)itemp + 0.5f) - posz;
						//if(this instanceof Player){
						//	System.out.printf("solid\n");
						//}

						if(Math.abs(dx)-(0.51f + (width/2)) < 0 && Math.abs(dz)-(0.51f + (width/2)) < 0){
							//already in a block. probably just jumped off. give them a nudge...
							if(dx > 0){
								posx -= 0.02f;
							}else{
								posx += 0.02f;
							}
							if(dz > 0){
								posz -= 0.02f;
							}else{
								posz += 0.02f;
							}
							itemp = (int)(posx)+i;
							dx = ((float)itemp + 0.5f) - posx;
							itemp = (int)(posz)+j;
							dz = ((float)itemp + 0.5f) - posz;						
						}
						dxsave = dx;
						if(dx < 0 && mx < 0){
							//heading towards the solid, negative
							//but would I even hit it in the z direction?
							if(Math.abs(dz) < (0.51f + (width/2))){
								dx += 0.51f;
								dx += width/2;
								if(dx > mx){
									motionx = dx/deltaT;
									hitsomething = true;
								}
							}
						}else if(dx > 0 && mx > 0){
							//heading towards the solid, positive
							//but would I even hit it in the z direction?
							if(Math.abs(dz) < (0.51f + (width/2))){
								dx -= 0.51f;
								dx -= width/2;
								if(dx < mx){
									motionx = dx/deltaT;
									hitsomething = true;
								}
							}
						}
						dx = dxsave;
						if(dz < 0 && mz < 0){
							//heading towards the solid, negative
							//but would I even hit it in the x direction?
							if(Math.abs(dx) < (0.51f + (width/2))){
								dz += 0.51f;
								dz += width/2;
								if(dz > mz){
									motionz = dz/deltaT;
									hitsomething = true;
								}
							}
						}else if(dz > 0 && mz > 0){
							//heading towards the solid, positive
							//but would I even hit it in the x direction?
							if(Math.abs(dx) < (0.51f + (width/2))){
								dz -= 0.51f;
								dz -= width/2;
								if(dz < mz){
									motionz = dz/deltaT;
									hitsomething = true;
								}
							}
						}
						
					}
				}
			}
		}
		return hitsomething;
	}
	
	public boolean wouldBump(float x, float y, float z, float w){
		int intwidth = (int)((w/2.0f)+0.995f);
		int i, j;
		int itemp;
		float dx, dz;
		for(i=-intwidth;i<=intwidth;i++){
			for(j=-intwidth;j<=intwidth;j++){
				if(Blocks.isSolid(this.world.getblock(dimension, (int)x+i, (int)y, (int)z+j), this.world, dimension, (int)x+i, (int)y, (int)z+j)){
					itemp = (int)(posx)+i;
					dx = x - ((float)itemp + 0.5f);
					itemp = (int)(posz)+j;
					dz = z - ((float)itemp + 0.5f);	
					if(Math.sqrt((dx*dx)+(dz*dz)) < (0.5f + (w/2.0f))){
						return true;
					}
				}
			}
		}
		return false;
	}
	
	//Check all around the entity WIDTH to see if it is solid.
	//Used for Y collisions
	public boolean isSolidAtLevel(int d, float x, float y, float z){
		int intwidth = (int)((width/2.0f)+0.995f);
		int i, j;
		int itemp;
		float dx, dz;
		
		for(i=-intwidth;i<=intwidth;i++){
			for(j=-intwidth;j<=intwidth;j++){
				if(Blocks.isSolid(this.world.getblock(d, (int)x+i, (int)y, (int)z+j), this.world, d, (int)x+i, (int)y, (int)z+j)){
					itemp = (int)(x)+i;
					dx = x - ((float)itemp + 0.5f);
					dx = Math.abs(dx);
					if(dx < (0.49f + (width/2.0f))){
						itemp = (int)(z)+j;
						dz = z - ((float)itemp + 0.5f);
						dz = Math.abs(dz);
						if(dz < (0.49f + (width/2.0f))){
							return true;
						}
					}
				}
			}
		}
		return false;
	}
	
	public boolean isLiquidAtLevel(int d, float x, float y, float z){
		int intwidth = (int)((width/2.0f)+0.995f);
		int i, j;
		int itemp;
		float dx, dz;
		
		for(i=-intwidth;i<=intwidth;i++){
			for(j=-intwidth;j<=intwidth;j++){
				if(Blocks.isLiquid(this.world.getblock(d, (int)x+i, (int)y, (int)z+j))){
					itemp = (int)(x)+i;
					dx = x - ((float)itemp + 0.5f);
					dx = Math.abs(dx);
					if(dx < (0.49f + (width/2.0f))){
						itemp = (int)(z)+j;
						dz = z - ((float)itemp + 0.5f);
						dz = Math.abs(dz);
						if(dz < (0.49f + (width/2.0f))){
							return true;
						}
					}
				}
			}
		}
		return false;
	}
	
	
	public boolean isDying(){
		if(deathfactor > 0 && deathfactor < 8.0f)return true;
		return false;
	}
	
	public void doDeathAnimation(){
		deathfactor = 0.9f; //start
		motiony = motionx = motionz = 0;
	}
	
	public float getDeathFactor(){
		return deathfactor;
	}
	
	//Only called on server
	public void doEntityCollisions(float deltaT){
		List<Entity> nearby_list = null;
		ListIterator<Entity> li;
		Entity ridden = getRiddenEntity();
		Entity rider = getRiderEntity();
		int riddenid = 0;
		int riderid = 0;
		if(ridden != null)riddenid = ridden.entityID;
		if(rider != null)riderid = rider.entityID;

		//Get a list of entities within reach of largest mob expected because we may hit their hitbox!
		nearby_list = DangerZone.server.entityManager.findEntitiesInRange((this.width/2) + 10f, dimension, posx, posy, posz);

		if(nearby_list != null){
			if(!nearby_list.isEmpty()){
				double dir;
				double dist;
				Entity e = null;
				li = nearby_list.listIterator();
				while(li.hasNext()){
					e = (Entity)li.next();
					if(e != this && !e.ignoreCollisions){ //don't bump self!
						if((e.posy > posy && e.posy < posy+height)
						|| (e.posy+e.height > posy && e.posy+e.height < posy+height)
						|| (posy > e.posy && posy < e.posy+e.height)
						|| (posy+height > e.posy && posy+height < e.posy+e.height)){
							dist = e.getHorizontalDistanceFromEntity(this); //Center to center
							dist -= (this.width/2); //width of me
							dist -= (e.width/2); //width of it
							if(dist < 0){
								//Bumped something!
								if(riddenid == e.entityID || riderid == e.entityID)continue; //oops nevermind...
								//do x-z bumping...
								dir = Math.atan2(e.posz-this.posz, e.posx-this.posx);
								motionx += Math.cos(dir)*dist*deltaT;
								motionz += Math.sin(dir)*dist*deltaT;
							}
						}
					}
				}								
			}			
		}				
	}
			

	/*
	 * Update entity motion
	 * 
	 * 
	 */
	public void update(float deltaT){
		int k, i, intheight;
		float startheight;
		int imax, bid, lbid;
		float gravity = 0.045f * deltaT;
		float rate = (float)((float)DangerZone.entityupdaterate/DangerZone.serverentityupdaterate); // ~1/6
		Entity rider = null;
		
		if(damage_backoff > 0)damage_backoff--;
		if(hurtanimationtimer > 0)hurtanimationtimer--;
		if(madtimer > 0)madtimer--;
		if(this.deadflag)deathfactor += 0.11f; //Delta death animation expander
		if(deathfactor > 8.0f)this.deadflag = true;
		if(isDying())this.deadflag = true;
		
		
		if(this.world.isServer){
			if(!this.isHurt() && !deadflag){
				if(this.world.rand.nextInt(100) == 1){
					this.world.playSound(getLivingSound(), dimension, posx, posy+height/2, posz, getLivingSoundVolume(), getLivingSoundPitch());					
				}				
			}
		}
		
		
		if(ignoreCollisions){
			//Ghost mode (noClip) just update motion as per caller...
			if(getOnFire() > 0){
				setOnFire(0);
			}
			super.update(deltaT);
			return;
		}
		
		if(this.world.isServer){		
			gravity = 0.20f * deltaT;	
			if(!(this instanceof Player)){
				//ENTITY ON SERVER
				if(getOnFire() > 0){
					setOnFire(getOnFire()-1);
					firecounter++;
					if(firecounter > 20){
						doAttackFrom(this, DamageTypes.FIRE, 1);
						firecounter = 0;
					}
				}
				/*
				 * Normal solids collision for player on client or entities on server
				 */			
				//x and z direction block collisions
				
				startheight = height/4;//if it is less then 1/4 our height, we can cross automatically
				while(startheight < height){
					doSolidsPushback(startheight, deltaT);
					startheight += 1.0f;
					if(startheight > height){
						doSolidsPushback(height, deltaT);
					}
				}

				//y direction (down)
				if(getInLiquid())gravity = gravity/5;
				motiony -= gravity;			
				if(isSolidAtLevel(dimension, posx, posy, posz)){
					//I am in a solid
					motiony += gravity*2;
				}

				float df = motiony*deltaT;
				int idf = (int)df;
				df -= idf;
				//System.out.printf("stay %f\n", df);
				if(motiony < 0){
					for(i=0;i>=idf;i--){
						if(isSolidAtLevel(dimension, posx, posy+df+i, posz)){ 
							imax = (int)((float)posy+df+i) + 1;
							motiony = 0;
							posy = imax+0.01f;
							//System.out.printf("stay %f\n", df);
							if(fallcount > 7){
								//System.out.printf("fallcount ouch = %d, eid %d\n", fallcount, this.entityID);
								doAttackFrom(this, DamageTypes.FALL, getAdjustedFallDamage(fallcount-7));
							}
							fallcount = 0;
							break;
						}
					}
				}			

				//y direction (up)	
				if(motiony >= 0){
					if(!isSolidAtLevel(dimension, posx, posy+height, posz)){
						df = motiony*deltaT;
						idf = (int)df;
						df -= idf;
						for(i=0;i<=idf;i++){
							if(isSolidAtLevel(dimension, posx, posy+df+height+i, posz)){ 
								imax = (int)((float)posy+df+height+i);
								motiony = 0;
								posy = (float)imax-height-0.01f;									
								fallcount = 0;
								break;
							}
						}
					}
				}
				
				if(!isSolidAtLevel(dimension, posx, posy-0.15f, posz) && getRiddenEntity() == null){
					setOnGround(false);					
					if(!takesFallDamage){
						fallcount = 0;
					}else{
						if(motiony < 0){
							fallcount++;
							//System.out.printf("fallcount == %d for %s\n", fallcount, uniquename);
						}
					}
					lastbx = lastby = lastbz = lastbd = 0;
				}else{
					setOnGround(true);
					fallcount = 0;							
					//ENTITY ON SERVER
					//Use the block directly underneath...
					bid = this.world.getblock(dimension, (int)posx, (int)(posy-0.25f), (int)posz);
					float ff = Blocks.getFriction(bid);
					if(ff != 0){
						ff = 1.0f - ff;
						if(ff < 0)ff = 0;
						motionx *= ff;
						motionz *= ff;
					}
					if(dimension != lastbd || (int)posx != lastbx || (int)(posy-0.25f) != lastby || (int)posz != lastbz ){
						lastbd = dimension;
						lastbx = (int)posx;
						lastby = (int)(posy-0.25f);
						lastbz = (int)posz;
						Blocks.doSteppedOn(bid, this, world, dimension, (int)posx, (int)(posy-0.25f), (int)posz);
					}
				}
				
				//is in a liquid?
				intheight = (int)height;
				intheight++;
				boolean tmpb = false;
				boolean tmps = false;
				int sbid = 0;
				lbid = 0;
				for(k=0;k<intheight;k++){
					bid = world.getblock(dimension, (int)posx, (int)posy+k, (int)posz);
					if(Blocks.isLiquid(bid)){
						tmpb = true;
						lbid = bid;
					}
					if(Blocks.isSquishy(bid)){
						tmps = true;
						sbid = bid;
					}
				}
				setInLiquid(tmpb);
				if(getInLiquid()){
					fallcount = 0;
					float ff = Blocks.getFriction(lbid);
					if(ff != 0){
						ff = 1.0f - ff;
						if(ff < 0)ff = 0;
						motionx *= ff;
						motionz *= ff;
						motiony *= ff;
					}
				}
				if(tmps){
					fallcount = 0;
					float ff = Blocks.getFriction(sbid);
					if(ff != 0){
						ff = 1.0f - ff;
						if(ff < 0)ff = 0;
						motionx *= ff;
						motionz *= ff;
						motiony *= ff;
					}
				}
				
				if(getInLiquid() && canSwim){
					if(Blocks.isLiquid(world.getblock(dimension, (int)posx, (int)(posy+(height*3/4) + swimoffset),(int)posz))){				
						if(world.rand.nextInt(9) != 0){
							motiony += 0.08f;
						}				
					}
				}
				bid = world.getblock(dimension, (int)posx, (int)(posy+eyeheight), (int)posz);
				if(!Blocks.isLiquid(bid)){
					setAir(getMaxAir());
				}else{
					setAir(getAir()-0.06f*deltaT);
				}
				if(getAir() < 0){
					doAttackFrom(null, DamageTypes.WATER, 2.5f*deltaT);
				}
				
				if(has_inventory){
					//tick the armor being worn...
					Item it = Items.getItem(getHelmetID());
					ItemArmor ia = null;
					if(it instanceof ItemArmor){
						ia = (ItemArmor)it;
						ia.inUseTick(this);
					}
					it = Items.getItem(getChestplateID());
					if(it instanceof ItemArmor){
						ia = (ItemArmor)it;
						ia.inUseTick(this);
					}
					it = Items.getItem(getLeggingsID());
					if(it instanceof ItemArmor){
						ia = (ItemArmor)it;
						ia.inUseTick(this);
					}
					it = Items.getItem(getBootsID());
					if(it instanceof ItemArmor){
						ia = (ItemArmor)it;
						ia.inUseTick(this);
					}
					if(posy < 0){
						float h = getHealth();
						if(h > 20){
							setHealth(getHealth()/4);
						}else{
							setHealth(getHealth()-1.0f);
						}
					}
				}
				
			}			
		}else{
			//client side!
			if(getOnFire() != 0){
				if(world.rand.nextInt(60) == 0){
					LightingThread.addRequest(dimension, (int)posx, (int)(posy+height/2), (int)posz, 0.55f); //make some light!
				}
			}
			if(this instanceof Player){				
				//ME!
				if(this == DangerZone.player){				
					/*
					 * Body should follow head...
					 */			
					float cdir = (float) Math.toRadians(rotation_yaw);
					float tdir = (float) Math.toRadians(rotation_yaw_head);
					float ddiff = tdir - cdir;
					while(ddiff>Math.PI)ddiff -= Math.PI*2;
					while(ddiff<-Math.PI)ddiff += Math.PI*2;	    	
					rotation_yaw += (ddiff*180f/Math.PI)/10f;	
					
					if(getOnFire() > 0){
						if(world.rand.nextInt(6) == 0)setOnFire(getOnFire()-1);
						firecounter++;
						if(firecounter/6 > 20){
							doAttackFrom(this, DamageTypes.FIRE, 1);
							firecounter = 0;
						}
					}
					
					if(DangerZone.player.getGameMode() == GameModes.GHOST){
						//is in a liquid?
						intheight = (int)height;
						intheight++;
						boolean tmpb = false;
						lbid = 0;
						for(k=0;k<intheight;k++){
							bid = world.getblock(dimension, (int)posx, (int)posy+k, (int)posz);
							if(Blocks.isLiquid(bid)){
								tmpb = true;
								lbid = bid;
							}
						}
						setInLiquid(tmpb);
						super.update(deltaT);
						return;
					}
					/*
					 * Normal solids collision for player on client or entities on server
					 */			
					//x and z direction block collisions
					startheight = height/4;//if it is less then 1/4 our height, we can cross automatically
					while(startheight < height){
						doSolidsPushback(startheight, deltaT);
						startheight += 1.0f;
						if(startheight > height){
							doSolidsPushback(height, deltaT);
						}
					}

					//y direction (down)
					if(getInLiquid())gravity = gravity/5;
					motiony -= gravity;		
					//System.out.printf("motiony = %f\n", (float)motiony);
					//if(Blocks.isSolid(world.getblock(dimension, (int)posx, (int)posy, (int)posz))){
					if(isSolidAtLevel(dimension, posx, posy, posz)){
						//I am in a solid
						motiony += gravity*2;
						//System.out.printf("g*2\n");
					}

					float df = motiony*deltaT*rate;
					int idf = (int)df;
					df -= idf;
					//System.out.printf("df %f\n", df);
					if(motiony < 0){
						for(i=0;i>=idf;i--){
							if(isSolidAtLevel(dimension, posx, posy+df+i, posz)){ 
								imax = (int)((float)posy+df+i) + 1;
								motiony = 0;
								posy = imax+0.001f;
								//if(fallcount > 0)System.out.printf("fallcount = %d, rate = %f\n", fallcount, rate);
								if(fallcount > 40){
									//System.out.printf("fallcount = %d\n", fallcount);
									doAttackFrom(this, DamageTypes.FALL, getAdjustedFallDamage((fallcount-40)*rate));
								}
								fallcount = 0;
								break;
							}
						}
					}

					//y direction (up)	
					if(motiony >= 0){
						if(!isSolidAtLevel(dimension, posx, posy+height, posz)){
							df = motiony*deltaT*rate;
							idf = (int)df;
							df -= idf;
							for(i=0;i<=idf;i++){
								if(isSolidAtLevel(dimension, posx, posy+df+height+i, posz)){ 
									imax = (int)((float)posy+df+height+i);
									motiony = 0;
									posy = (float)imax-height-0.01f;									
									fallcount = 0;
									break;
								}
							}
						}
					}
					
					
					//airborne or not?
					if(!isSolidAtLevel(dimension, posx, posy-0.10f, posz) && getRiddenEntity() == null){
						setOnGround(false)	;			
						if(motiony < 0){
							fallcount++;
						}
						if(this.getGameMode() != GameModes.SURVIVAL)fallcount = 0;	
						lastbx = lastby = lastbz = lastbd = 0;
					}else{
						setOnGround(true);
						fallcount = 0;
						
						//update motion based on block friction!
						if(this.getGameMode() != GameModes.GHOST){				
							//ME!
							bid = this.world.getblock(dimension, (int)posx, (int)(posy-0.25f), (int)posz);
							float ff = Blocks.getFriction(bid);
							if(ff != 0){
								ff = 1.0f - ff;
								if(ff < 0)ff = 0;
								motionx *= ff;
								motionz *= ff;
							}
							if(dimension != lastbd || (int)posx != lastbx || (int)(posy-0.25f) != lastby || (int)posz != lastbz ){
								lastbd = dimension;
								lastbx = (int)posx;
								lastby = (int)(posy-0.25f);
								lastbz = (int)posz;
								Blocks.doSteppedOn(bid, this, world, dimension, (int)posx, (int)(posy-0.25f), (int)posz);
							}
						}				
					}
					
					//is in a liquid?
					intheight = (int)height;
					intheight++;
					boolean tmpb = false;
					boolean tmps = false;
					int sbid = 0;
					lbid = 0;
					for(k=0;k<intheight;k++){
						bid = world.getblock(dimension, (int)posx, (int)posy+k, (int)posz);
						if(Blocks.isLiquid(bid)){
							tmpb = true;
							lbid = bid;
						}
						if(Blocks.isSquishy(bid)){
							tmps = true;
							sbid = bid;
						}
					}
					setInLiquid(tmpb);
					if(getInLiquid()){
						fallcount = 0;
						if(this.getGameMode() != GameModes.GHOST){	
							float ff = Blocks.getFriction(lbid);
							if(ff != 0){
								ff = 1.0f - ff;
								if(ff < 0)ff = 0;
								motionx *= ff;
								motionz *= ff;
								motiony *= ff;
							}
						}
					}
					if(tmps){
						fallcount = 0;
						if(this.getGameMode() != GameModes.GHOST){	
							float ff = Blocks.getFriction(sbid);
							if(ff != 0){
								ff = 1.0f - ff;
								if(ff < 0)ff = 0;
								motionx *= ff;
								motionz *= ff;
								motiony *= ff;
							}
						}
					}
					
					bid = world.getblock(dimension, (int)posx, (int)(posy+eyeheight), (int)posz);
					if(!Blocks.isLiquid(bid)){
						setAir(getMaxAir());
					}else{
						if(getGameMode() == GameModes.SURVIVAL)setAir(getAir()-(0.02f*deltaT));
					}
					if(getAir() < 0){
						if(getGameMode() == GameModes.SURVIVAL)doAttackFrom(null, DamageTypes.WATER, (1.5f*deltaT));
					}
					
					tickadjust++; //so player armor ticks match other armor wearers...
					if(has_inventory && tickadjust >= 6){
						tickadjust = 0;
						//tick the armor being worn...
						Item it = Items.getItem(getHelmetID());
						ItemArmor ia = null;
						if(it instanceof ItemArmor){
							ia = (ItemArmor)it;
							ia.inUseTick(this);
						}
						it = Items.getItem(getChestplateID());
						if(it instanceof ItemArmor){
							ia = (ItemArmor)it;
							ia.inUseTick(this);
						}
						it = Items.getItem(getLeggingsID());
						if(it instanceof ItemArmor){
							ia = (ItemArmor)it;
							ia.inUseTick(this);
						}
						it = Items.getItem(getBootsID());
						if(it instanceof ItemArmor){
							ia = (ItemArmor)it;
							ia.inUseTick(this);
						}		
					}
					if(getGameMode() == GameModes.SURVIVAL){
						if(posy < 0){
							float h = getHealth();
							if(h > 10){
								setHealth(getHealth()-1.0f);
							}else{
								setHealth(getHealth()-0.01f);
							}
						}
					}
				}				
			}else{
				rider = getRiderEntity();
				if(rider != null && rider.entityID == DangerZone.player.entityID){
					//do just the basic collision! We are riding this thing...
					//System.out.printf("got here for %d\n", this.entityID);
					//x and z direction block collisions
					startheight = height/4;//if it is less then 1/4 our height, we can cross automatically
					while(startheight < height){
						doSolidsPushback(startheight, deltaT);
						startheight += 1.0f;
						if(startheight > height){
							doSolidsPushback(height, deltaT);
						}
					}
					
					float df = motiony*deltaT*rate;
					int idf = (int)df;
					df -= idf;
					
					if(motiony < 0){
						for(i=0;i>=idf;i--){
							if(isSolidAtLevel(dimension, posx, posy+df+i, posz)){ 
								imax = (int)((float)posy+df+i) + 1;
								motiony = 0;
								posy = imax+0.001f;
								//if(fallcount > 0)System.out.printf("fallcount = %d, rate = %f\n", fallcount, rate);
								if(fallcount > 40){
									//System.out.printf("fallcount = %d\n", fallcount);
									doAttackFrom(this, DamageTypes.FALL, getAdjustedFallDamage((fallcount-40)*rate));
								}
								fallcount = 0;
								break;
							}
						}
					}

					//y direction (up)	
					if(motiony >= 0){
						if(!isSolidAtLevel(dimension, posx, posy+height, posz)){
							df = motiony*deltaT*rate;
							idf = (int)df;
							df -= idf;
							for(i=0;i<=idf;i++){
								if(isSolidAtLevel(dimension, posx, posy+df+height+i, posz)){ 
									imax = (int)((float)posy+df+height+i);
									motiony = 0;
									posy = (float)imax-height-0.01f;									
									fallcount = 0;
									break;
								}
							}
						}
					}				
				}
			}
		}

		super.update(deltaT);

	}
	
	public int getHelmetID(){
		if(getArmor(0) != null){
			return getArmor(0).iid;
		}
		return 0;
	}
	
	public int getChestplateID(){
		if(getArmor(1) != null){
			return getArmor(1).iid;
		}
		return 0;
	}
	
	public int getLeggingsID(){
		if(getArmor(2) != null){
			return getArmor(2).iid;
		}
		return 0;
	}
	
	public int getBootsID(){
		if(getArmor(3) != null){
			return getArmor(3).iid;
		}
		return 0;
	}

	/*
	 * return total defense of player. Add it all up!
	 */
	public float getDefense(){
		float df = super.getDefense();
		if(has_inventory){
			Item it = Items.getItem(getHelmetID());
			ItemArmor ia = null;
			if(it instanceof ItemArmor){
				ia = (ItemArmor)it;
				df += ia.protection;
			}
			it = Items.getItem(getChestplateID());
			if(it instanceof ItemArmor){
				ia = (ItemArmor)it;
				df += ia.protection;
			}
			it = Items.getItem(getLeggingsID());
			if(it instanceof ItemArmor){
				ia = (ItemArmor)it;
				df += ia.protection;
			}
			it = Items.getItem(getBootsID());
			if(it instanceof ItemArmor){
				ia = (ItemArmor)it;
				df += ia.protection;
			}
		}
		return df;
	}
	
	//only called from server side.
	//damage the armor and update inventory in client
	public void doArmorDamage(Entity e, /*DamageTypes*/int dt, float pain){
		super.doArmorDamage(e, dt, pain);
		if(pain <= 0)return;
		int which = world.rand.nextInt(4); //which piece takes the hit?
		if(getArmor(which) != null){
			int ad = (int)(pain+1);
			getArmor(which).currentuses += ad;			
			if(getArmor(which).currentuses >= Items.getMaxUses(getArmor(which).iid)){
				//TODO play sound!
				setArmor(which, null);
			}
			if(this instanceof Player){
				Player pl = (Player)this;
				pl.server_thread.sendInventoryUpdateToPlayer(2, which, getArmor(which));
			}else{
				setArmorChanged(which); //force update
			}
		}		
	}
	
	public void doHurtAnimation(){
		hurtanimationtimer = 35;
		madtimer = world.rand.nextInt(200)+60;
		jump();
	}
	
	public boolean isHurt(){
		if(hurtanimationtimer > 0)return true;
		return false;
	}
	
	public void jump(){
		Entity e = getRiddenEntity();
		if(e != null){
			e.jump();
			return;
		}
		if(getInLiquid() && canSwim){
			if(Blocks.isLiquid(world.getblock(dimension, (int)posx, (int)(posy+(height*3/4) + swimoffset),(int)posz))){				
				if(world.rand.nextInt(2) == 0){
					motiony += 0.155f;
					if(isSolidAtLevel(dimension, posx, posy-0.35f, posz))motiony += 0.55f;
				}				
			}
		}
		//Gotta be on solid ground to jump!
		if(!isSolidAtLevel(dimension, posx, posy-0.10f, posz))return;
		if(Math.abs(motiony)>0.15f)return;
		this.motiony += (0.75f + jumpstrength);
	}
	
	
	/*
	 * Entity is BEING attacked by this.
	 */
	public void doAttackFrom(/*entity that hit me*/Entity e, /*DamageTypes*/int dt, float pain){	

		if(!world.isServer)return;
		
		if(dt == DamageTypes.FIRE && isImmuneToFire)return;
		if(dt == DamageTypes.WATER && canBreateUnderWater)return;
		
		if(    dt != DamageTypes.FALL 
			&& dt != DamageTypes.HUNGER
			&& dt != DamageTypes.WATER
			&& dt != DamageTypes.DAYTIME
			&& dt != DamageTypes.EXPLOSIVE
			&& dt != DamageTypes.FIRE
			&& dt != DamageTypes.LIGHTNING
				){		
			if(damage_backoff > 0)return; //not yet!!!
			damage_backoff = 5; //5 ticks
		}
		
		float dfn = this.getDefense();
		if(dfn <= 0.1f)dfn = 0.1f; //set a minimum defense
		if(dfn > 1000.0f)dfn = 1000.0f; //Set a maximum defense
		float totalpain = pain / dfn; //Divide intended damage by total defense
		//is it immune to this type of damage?
		if(!takesDamageFrom(dt))totalpain = 0;
		if(totalpain == 0)return;
		if(has_inventory)this.doArmorDamage(e, dt, pain);
		totalpain = getHealth() - totalpain;
		if(totalpain > getMaxHealth())totalpain = getMaxHealth(); //in case its actually healing...
		setHealth(totalpain);	
		if(this instanceof Player){
			Player pl = (Player)this;
			if(totalpain < 0)totalpain -= 10; //make sure we both know he's dead and stays dead!
			pl.server_thread.sendVarFloatUpdate(1, totalpain); //Send health update to player!
		}
		
		//And now for a little default knockback
		if(e != null){
			if(		   dt != DamageTypes.FALL
					&& dt != DamageTypes.DAYTIME
					&& dt != DamageTypes.FIRE
					&& dt != DamageTypes.HUNGER
					&& dt != DamageTypes.WATER ){

				float dir = (float) Math.atan2(this.posz - e.posz, this.posx - e.posx);
				float sf = e.height*e.width;
				if(sf < 0.25f)sf = 0.25f;
				if(sf > 100)sf = 100;
				this.motionx += Math.cos(dir)*0.55f*sf;
				this.motionz += Math.sin(dir)*0.55f*sf;
				this.motiony += 0.15f*sf;
				if(this instanceof Player){
					Player pl = (Player)this;
					pl.server_thread.sendVelocityUpdateToPlayer(motionx, motiony, motionz);
				}
			}
		}
		
		newtargetnow = true; //yikes! Run!
		
		if(getHealth() > 0){		
			if(getHurtSound() != null){
				this.world.playSound(getHurtSound(), dimension, posx, posy+height/2, posz, 1.0f, 1.0f+(world.rand.nextFloat()-world.rand.nextFloat())*0.2f);
			}
			DangerZone.server.sendEntityHitToAll(this);
		}else{

			if(getDeathSound() != null){
				this.world.playSound(getDeathSound(), dimension, posx, posy+height/2, posz, 1.0f, 1.0f+(world.rand.nextFloat()-world.rand.nextFloat())*0.1f);
			}
			if(e != null && e != this){
				e.onKill(this);
			}
			
			this.doDeathDrops();			
			this.deadflag = true;
			this.onDeath();
			
			DangerZone.server.sendEntityDeathToAll(this);
		}
	}
	
	public void onDeath(){	
		if(this.world.isServer){
			//make some Experience particles!
			int iexp = this.getExperience();
			while(iexp >= 1000){
				EntityExp e = (EntityExp)world.createEntityByName("DangerZone:Experience", this.dimension, this.posx,this.posy,this.posz);
				if(e != null){
					e.setBID(0);
					e.setIID(0);
					e.setExperience(1000);
					e.rotation_pitch = 0;
					e.rotation_yaw = world.rand.nextInt(360);
					e.rotation_roll = 0;
					e.motionx = (world.rand.nextFloat()-world.rand.nextFloat())*this.width; 
					e.motiony = world.rand.nextFloat()*this.height/4;
					e.motionz = (world.rand.nextFloat()-world.rand.nextFloat())*this.width;
					world.spawnEntityInWorld(e);
				}				
				iexp -= 1000;
			}
			while(iexp >= 100){
				EntityExp e = (EntityExp)world.createEntityByName("DangerZone:Experience", this.dimension, this.posx,this.posy,this.posz);
				if(e != null){
					e.setBID(0);
					e.setIID(0);
					e.setExperience(100);
					e.rotation_pitch = 0;
					e.rotation_yaw = world.rand.nextInt(360);
					e.rotation_roll = 0;
					e.motionx = (world.rand.nextFloat()-world.rand.nextFloat())*this.width; 
					e.motiony = world.rand.nextFloat()*this.height/4;
					e.motionz = (world.rand.nextFloat()-world.rand.nextFloat())*this.width;
					world.spawnEntityInWorld(e);
				}				
				iexp -= 100;
			}
			while(iexp >= 10){
				EntityExp e = (EntityExp)world.createEntityByName("DangerZone:Experience", this.dimension, this.posx,this.posy,this.posz);
				if(e != null){
					e.setBID(0);
					e.setIID(0);
					e.setExperience(10);
					e.rotation_pitch = 0;
					e.rotation_yaw = world.rand.nextInt(360);
					e.rotation_roll = 0;
					e.motionx = (world.rand.nextFloat()-world.rand.nextFloat())*this.width; 
					e.motiony = world.rand.nextFloat()*this.height/4;
					e.motionz = (world.rand.nextFloat()-world.rand.nextFloat())*this.width;
					world.spawnEntityInWorld(e);
				}				
				iexp -= 10;
			}
			while(iexp >= 1){
				EntityExp e = (EntityExp)world.createEntityByName("DangerZone:Experience", this.dimension, this.posx,this.posy,this.posz);
				if(e != null){
					e.setBID(0);
					e.setIID(0);
					e.setExperience(1);
					e.rotation_pitch = 0;
					e.rotation_yaw = world.rand.nextInt(360);
					e.rotation_roll = 0;
					e.motionx = (world.rand.nextFloat()-world.rand.nextFloat())*this.width; 
					e.motiony = world.rand.nextFloat()*this.height/4;
					e.motionz = (world.rand.nextFloat()-world.rand.nextFloat())*this.width;
					world.spawnEntityInWorld(e);
				}				
				iexp -= 1;
			}
		}
		super.onDeath();
	}
	
	public void doEntityAction(float deltaT){	

		//non-player rider support...
		Entity rider = getRiderEntity();
		if(rider != null && rider instanceof EntityLiving && !(rider instanceof Player)){
			//fetch the rider's target.
			EntityLiving erider = (EntityLiving)rider;
			target = erider.target;
			if(target != null){
				if(target.getDistanceToTarget(posx, posy, posz) < this.width/2){ //got there!
					erider.target = null;
					target = null;
				}
			}else{
				float cdir = (float) Math.toRadians(rotation_yaw);
				float tdir = (float) Math.toRadians(erider.rotation_yaw);
				float ddiff = tdir - cdir;
				while(ddiff>Math.PI)ddiff -= Math.PI*2;
				while(ddiff<-Math.PI)ddiff += Math.PI*2;
				rotation_yaw_motion += (ddiff*180f/Math.PI)/10;
			}
		} 

		if(this.world.rand.nextInt(movefrequency) == 0 || newtargetnow){		
			findNewTarget();
			idletarget = null;
		}		
		if(target != null && this.target.getDistanceToTarget(posx, posy, posz) > this.width/2){
			moveTowardsTarget(deltaT);				
		}else{
			target = null;
			if(this.world.rand.nextInt(movefrequency/10 + 1) == 0){
				Entity lookentity = findEntityToLookAt();
				if(lookentity != null){
					idletarget = new TargetHelper(lookentity, lookentity.posx, lookentity.posy, lookentity.posz);
				}else{
					idletarget = null;
				}
			}
		}

		doLookAction();
		
		super.doEntityAction(deltaT);
	}
	
	public void doLookAction(){
		// look around!
		TargetHelper look = target;
		if(look == null){
			look = idletarget;
			if(look != null && look.te != null){
				look.setTarget(look.te.posx, look.te.posy, look.te.posz);
			}
		}
		if(look != null){
			//look where we are going! (or at what we are fighting!!!)
			float cdir = (float) Math.toRadians(rotation_yaw_head);
			float tdir = (float) Math.atan2(look.targetx - posx, look.targetz - posz);
			float ddiff = tdir - cdir;
			float ht = 0, mht = 0;;
			while(ddiff>Math.PI)ddiff -= Math.PI*2;
			while(ddiff<-Math.PI)ddiff += Math.PI*2;
			rotation_yaw_head += (ddiff*180f/Math.PI)/5f;
			if(look.te != null){
				ht = look.te.height*7/8;
				mht = eyeheight;
			}
			cdir = (float) Math.toRadians(rotation_pitch_head);
			tdir = (float) Math.atan2((posy+mht) - (look.targety+ht), look.getDistanceToTarget(posx, look.targety, posz));
			ddiff = tdir - cdir;
			while(ddiff>Math.PI)ddiff -= Math.PI*2;
			while(ddiff<-Math.PI)ddiff += Math.PI*2;
			rotation_pitch_head += (ddiff*180f/Math.PI)/5f;

			//turn body towards look target...
			cdir = (float) Math.toRadians(rotation_yaw);
			tdir = (float) Math.atan2(look.targetx - posx, look.targetz - posz);
			ddiff = tdir - cdir;
			while(ddiff>Math.PI)ddiff -= Math.PI*2;
			while(ddiff<-Math.PI)ddiff += Math.PI*2;
			rotation_yaw_motion += (ddiff*180f/Math.PI)/50f; //slowly!
		}
	}
	
	public Entity findEntityToLookAt(){	
		List<Entity> nearby_list = null;
		//Get a list of entities within reach
		nearby_list = DangerZone.server.entityManager.findEntitiesInRange((this.width/2) + lookDistance, dimension, posx, posy, posz);
		if(nearby_list != null){
			if(!nearby_list.isEmpty()){
				Entity e = null;
				ListIterator<Entity> li;
				//Sort them out based on size and distance
				Collections.sort(nearby_list, this.LookTargetSorter);
				li = nearby_list.listIterator();
				//preference to players!
				while(li.hasNext()){
					e = (Entity)li.next();
					if(e instanceof Player){
						if(isSuitableLookTarget(e)){ 
							//System.out.printf("look at player\n");
							return e;
						}
					}
				}
				while(li.hasNext()){
					e = (Entity)li.next();
					if(isSuitableLookTarget(e)){ 
						return e;
					}
				}	
			}			
		}
		return null;
	}

	public boolean isSuitableLookTarget(Entity e){
		if(e == this)return false;
		if(!CanProbablySeeEntity(e))return false; //final check, cuz its the slowest
		return true;
	}
	
	public void moveTowardsTarget(float deltaT){
		int intheight, startheight, k;
    	float cdir = (float) Math.toRadians(rotation_yaw);
    	float tdir = (float) Math.atan2(target.targetx - posx, target.targetz - posz);
    	float ddiff = tdir - cdir;
    	float dist;
    	float speed;
    	while(ddiff>Math.PI)ddiff -= Math.PI*2;
    	while(ddiff<-Math.PI)ddiff += Math.PI*2;
    	rotation_yaw_motion += (ddiff*180f/Math.PI)/10;
    	dist = target.getDistanceToTarget(posx,  posy,  posz);
    	speed = (float) Math.sqrt(motionx*motionx + motionz*motionz);
    	speed = dist/(speed*10);
    	if(speed > 1)speed = 1; 
    	
    	//no movement until we hit ground after knockback!
    	if(damage_backoff > 0){
    		knockbackcheck = true;
    	}
    	if(getOnGround()){
    		knockbackcheck = false;
    	}
    	if(!knockbackcheck){
    		motionx += moveSpeed*accellerator*speed*Math.sin(tdir);
    		motionz += moveSpeed*accellerator*speed*Math.cos(tdir);
    	}
    	
    	//can we even go this way?
    	if(!isSolidAtLevel(dimension, posx+motionx*deltaT, posy-1, posz+motionz*deltaT)){
    		if(!isSolidAtLevel(dimension, posx+motionx*deltaT, (posy-height/4f)-2, posz+motionz*deltaT)){
    			//would probably fall!
    			//but is it a liquid and we can swim?
    			if(isLiquidAtLevel(dimension, posx+motionx*deltaT, (posy-height/4f)-2, posz+motionz*deltaT) && canSwim){
    				//it's ok, we can swim...
    			}else{
    				if(!knockbackcheck)motionx = motionz = 0;
    				//System.out.printf("Newtarget from fall\n");
    				newtargetnow = true;
    				return;
    			}
    		}
    	}
    	
    	Entity e = getRiddenEntity();
    	float useheight = height;
    	float usewidth = width;
    	float usex = posx+motionx*deltaT;
    	float usey = posy;
    	float usez = posz+motionz*deltaT;
    	if(e != null){
    		useheight = e.height;
    		usewidth = e.width;
    		usex = e.posx+motionx*deltaT;
        	usey = e.posy;
        	usez = e.posz+motionz*deltaT;
    	}
    	
		//x and z direction block collisions
		intheight = (int)(useheight+0.995f);
		startheight = (int)useheight/4; //if it is less then 1/4 our height, we can cross automatically
		for(k=startheight;k<intheight;k++){		
			if(wouldBump(usex, usey+k, usez, usewidth)){
				if(k <= startheight+1){
					if(world.rand.nextInt(3) == 0){
						jump();
						break;
					}
				}else{
	    			//motionx = motionz = 0;
					motionx /= 2*deltaT;
					motionz /= 2*deltaT;
					newtargetnow = true;
					//System.out.printf("Newtarget from bump\n");
					break;
				}				
			}
		}   	
	}
	
	public void findNewTarget(){
		float newdir, newdist, newy, newx, newz;
		int intdist;

		//if(target == null)target = new TargetHelper(posx, posy, posz);
		
		//forward
		int tries = 4; //max tries per cycle. better luck next time!
		while(tries > 0){
			tries--;
			newdir = world.rand.nextFloat()-world.rand.nextFloat();
			newdir *= 90f;
			newdir += this.rotation_yaw; //grab a new general direction towards where we are already pointing
			newdist = 2.0f + world.rand.nextFloat()*width*height*2; //get a new general distance
			intdist = (int) (newdist+0.995f);
			newx = (float) (posx+Math.cos(newdir)*newdist);
			newz = (float) (posz+Math.sin(newdir)*newdist);
			newy = posy;
			for(int i=intdist;i>-intdist;i--){
				newy = posy+i;
				if(!isSolidAtLevel(dimension, newx, newy+1, newz)){
					if(!targetLiquidOnly && isSolidAtLevel(dimension, newx, newy, newz) && CanProbablySee(dimension, newx, newy+1, newz, (int)newdist)){
						if(!canSwim && Blocks.isLiquid(world.getblock(dimension, (int)newx, (int)newy+1, (int)newz))){
							break;
						}
						newy += 1;
						newy = (int)newy;
						target = new TargetHelper(null, newx, newy, newz);
						newtargetnow = false;
						//System.out.printf("New Target set %f,  %f, %f\n", newx, newy, newz);
						return;
					}
					if(canSwim && isLiquidAtLevel(dimension, newx, newy, newz) && CanProbablySee(dimension, newx, newy+1, newz, (int)newdist)){
						newy += 1;
						newy = (int)newy;
						target = new TargetHelper(null, newx, newy, newz);
						newtargetnow = false;
						//System.out.printf("New Target set %f,  %f, %f\n", newx, newy, newz);
						return;
					}
				}
			}
		}
		
		//can't go that way?
		//try backward
		tries = 1; //max tries per cycle. better luck next time!
		while(tries > 0){
			tries--;
			newdir = world.rand.nextFloat()-world.rand.nextFloat();
			newdir *= 90f;
			newdir += this.rotation_yaw+180f; //try backwards
			newdist = 2.0f + world.rand.nextFloat()*width*height*4; //get a new general distance
			intdist = (int) (newdist+0.995f);
			newx = (float) (posx+Math.cos(newdir)*newdist);
			newz = (float) (posz+Math.sin(newdir)*newdist);
			newy = posy;
			for(int i=intdist;i>-intdist;i--){
				newy = posy+i;
				if(!isSolidAtLevel(dimension, newx, newy+1, newz)){
					if(!targetLiquidOnly && isSolidAtLevel(dimension, newx, newy, newz) && CanProbablySee(dimension, newx, newy+1, newz, (int)newdist)){
						if(!canSwim && Blocks.isLiquid(world.getblock(dimension, (int)newx, (int)newy+1, (int)newz))){
							break;
						}
						newy += 1;
						newy = (int)newy;
						target = new TargetHelper(null, newx, newy, newz);
						newtargetnow = false;
						//System.out.printf("New back Target set %f,  %f, %f\n", newx, newy, newz);
						return;
					}
				}
				if(canSwim && isLiquidAtLevel(dimension, newx, newy, newz) && CanProbablySee(dimension, newx, newy+1, newz, (int)newdist)){
					newy += 1;
					newy = (int)newy;
					target = new TargetHelper(null, newx, newy, newz);
					newtargetnow = false;
					//System.out.printf("New Target set %f,  %f, %f\n", newx, newy, newz);
					return;
				}
			}
		}		
	}
	
	 /*
	  * Cheap and dirty canSee() 
	  * 
	  * Scans out one delta block at a time checking for solids that probably block vision of object.
	  */
	 public boolean CanProbablySee(int d, float x, float y, float z, int distinblocks)
	 {
		 float startx;
		 float starty;
		 float startz;
		 double xzoff = this.width/2;
		 double cx, cz;
		 float dx;
		 float dy;
		 float dz;
		 int i;
		 int nblks = distinblocks;
		 
		 //Calculate approximately where eyes should be
		 cx = this.posx+(xzoff*Math.cos(Math.toRadians(this.rotation_yaw)));
		 cz = this.posz+(xzoff*Math.sin(Math.toRadians(this.rotation_yaw)));
		 startx = (float) (cx);
		 starty = (float) (this.posy+(this.height*7/8));
		 startz = (float) (cz);
		 dx = (float) ((x-startx)/distinblocks);
		 dy = (float) ((y-starty)/distinblocks);
		 dz = (float) ((z-startz)/distinblocks);

		 if(Math.abs(dx) > 1.0){
			 dy = dy/Math.abs(dx);
			 dz = dz/Math.abs(dx);
			 nblks *= Math.abs(dx);
			 if(dx > 1)dx = 1;
			 if(dx < -1)dx = -1;
		 }
		 if(Math.abs(dy) > 1.0){
			 dx = dx/Math.abs(dy);
			 dz = dz/Math.abs(dy);
			 nblks *= Math.abs(dy);
			 if(dy > 1)dy = 1;
			 if(dy < -1)dy = -1;
		 }
		 if(Math.abs(dz) > 1.0){
			 dy = dy/Math.abs(dz);
			 dx = dx/Math.abs(dz);
			 nblks *= Math.abs(dz);
			 if(dz > 1)dz = 1;
			 if(dz < -1)dz = -1;
		 }

		 for(i=0;i<nblks;i++){
			 startx += dx;
			 starty += dy;
			 startz += dz;
			 //TODO FIXME - get blockid and check for clear solids or opaque liquids!
			 if(Blocks.isSolid(this.world.getblock(d, (int)startx, (int)starty, (int)startz), this.world, d, (int)startx, (int)starty, (int)startz))return false;
		 } 


		 return true;
	 }
	 
	 /*
	  * Cheap and dirty canSee() 
	  * 
	  * Scans out one delta block at a time checking for solids that probably block vision of object.
	  */
	 public boolean CanProbablySeeEntity(Entity e)
	 {
		 float startx;
		 float starty;
		 float startz;
		 double xzoff = this.width/2;
		 double cx, cz;
		 float dx;
		 float dy;
		 float dz;
		 int i;
		 int nblks = (int) getDistanceFromEntity(e);
		 if(nblks < 1)return true;

		 //check direction! Are we even facing the other entity?
		 float cdir = (float) Math.toRadians(rotation_yaw);
		 float tdir = (float) Math.atan2(e.posx - posx, e.posz - posz);	
		 float ddiff = tdir - cdir;
		 while(ddiff>Math.PI)ddiff -= Math.PI*2;
		 while(ddiff<-Math.PI)ddiff += Math.PI*2;
		 //System.out.printf("cdir, tdir, diff == %f, %f, %f\n", cdir, tdir, ddiff);
		 if(ddiff > Math.PI*3/4)return false; //a little more than 180 vision range
		 if(ddiff < -Math.PI*3/4)return false;

		 //Calculate approximately where eyes should be
		 cx = this.posx+(xzoff*Math.cos(Math.toRadians(this.rotation_yaw)));
		 cz = this.posz+(xzoff*Math.sin(Math.toRadians(this.rotation_yaw)));
		 startx = (float) (cx);
		 starty = (float) (this.posy+(this.height*7/8));
		 startz = (float) (cz);
		 dx = (float) ((e.posx-startx)/nblks);
		 dy = (float) (((e.posy+(e.height*7/8))-starty)/nblks);
		 dz = (float) ((e.posz-startz)/nblks);

		 if(Math.abs(dx) > 1.0){
			 dy = dy/Math.abs(dx);
			 dz = dz/Math.abs(dx);
			 nblks *= Math.abs(dx);
			 if(dx > 1)dx = 1;
			 if(dx < -1)dx = -1;
		 }
		 if(Math.abs(dy) > 1.0){
			 dx = dx/Math.abs(dy);
			 dz = dz/Math.abs(dy);
			 nblks *= Math.abs(dy);
			 if(dy > 1)dy = 1;
			 if(dy < -1)dy = -1;
		 }
		 if(Math.abs(dz) > 1.0){
			 dy = dy/Math.abs(dz);
			 dx = dx/Math.abs(dz);
			 nblks *= Math.abs(dz);
			 if(dz > 1)dz = 1;
			 if(dz < -1)dz = -1;
		 }

		 for(i=0;i<nblks;i++){
			 startx += dx;
			 starty += dy;
			 startz += dz;
			 //TODO FIXME - get blockid and check for clear solids or opaque liquids!
			 if(Blocks.isSolid(this.world.getblock(dimension, (int)startx, (int)starty, (int)startz), this.world, dimension, (int)startx, (int)starty, (int)startz))return false;
		 } 
		 return true;
	 }
	 
	 public void findBlockFood(int maxdist, int healamount, int eatitdistance){
			int i, j;
			//System.out.printf("Searching for food %d\n",this.getBaryonyxHealth()); 
			//Very efficient search from near to far.
			closest = 99999;
			tx = ty = tz = 0;
			for(i=1;i<maxdist;i++){
				j = i;
				if(j > 3)j = 3; //Limit y range
				if(scan_it((int)this.posx, (int)this.posy+1, (int)this.posz, i, j, i) == true)break;
				if(i>=6)i++; //skip to reduce long-range intensive processing...
			}

			if(closest < 99999){
				//System.out.printf("Food found at %d distance\n", closest);
				target = new TargetHelper(tx, ty-1, tz);
				if(closest < (eatitdistance)){
					//System.out.printf("Food eaten\n");
					this.heal(healamount);
					doEatFoodAction(dimension, tx,  ty,  tz);
					target = null;
				}
			}		
	 }
	 
	 public void doEatFoodAction(int d, int x, int y, int z){
			if(world.rand.nextInt(4) == 1)playburp();
			this.world.setblockandmeta(d, x,  y,  z,  0, 0);
	 }
	 
	 public void playburp(){
		 int which = world.rand.nextInt(4);
		 if(which == 0)world.playSound("DangerZone:burp1", dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f+((world.rand.nextFloat()-world.rand.nextFloat())*0.25f));
		 if(which == 1)world.playSound("DangerZone:burp2", dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f+((world.rand.nextFloat()-world.rand.nextFloat())*0.25f));
		 if(which == 2)world.playSound("DangerZone:burp3", dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f+((world.rand.nextFloat()-world.rand.nextFloat())*0.25f));
		 if(which == 3)world.playSound("DangerZone:burp", dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f+((world.rand.nextFloat()-world.rand.nextFloat())*0.25f));
	 }

	 
	   
	 public boolean scan_it(int x, int y, int z, int dx, int dy, int dz){
		 int found = 0;
		 int i, j, bid, d;

		 //Fixed x, scan two sides of 3d rectangle
		 for(i=-dy;i<=dy;i++){
			 for(j=-dz;j<=dz;j++){
				 bid = this.world.getblock(dimension, x+dx, y+i, z+j);
				 if(isFoodBlock(bid)){
					 d = dx*dx + j*j + i*i;
					 if(d < closest){
						 closest = d;
						 tx = x+dx; ty = y+i; tz = z+j;
						 found++;
					 }
				 }
				 bid = this.world.getblock(dimension, x-dx, y+i, z+j);
				 if(isFoodBlock(bid)){
					 d = dx*dx + j*j + i*i;
					 if(d < closest){
						 closest = d;
						 tx = x-dx; ty = y+i; tz = z+j;
						 found++;
					 }
				 } 			
			 }
		 }
		 //Fixed y, scan two sides of 3d rectangle
		 for(i=-dx;i<=dx;i++){
			 for(j=-dz;j<=dz;j++){
				 bid = this.world.getblock(dimension, x+i, y+dy, z+j);
				 if(isFoodBlock(bid)){
					 d = dy*dy + j*j + i*i;
					 if(d < closest){
						 closest = d;
						 tx = x+i; ty = y+dy; tz = z+j;
						 found++;
					 }
				 }
				 bid = this.world.getblock(dimension, x+i, y-dy, z+j);
				 if(isFoodBlock(bid)){
					 d = dy*dy + j*j + i*i;
					 if(d < closest){
						 closest = d;
						 tx = x+i; ty = y-dy; tz = z+j;
						 found++;
					 }
				 } 			
			 }
		 }    	
		 //Fixed z, scan two sides of 3d rectangle
		 for(i=-dx;i<=dx;i++){
			 for(j=-dy;j<=dy;j++){
				 bid = this.world.getblock(dimension, x+i, y+j, z+dz);
				 if(isFoodBlock(bid)){
					 d = dz*dz + j*j + i*i;
					 if(d < closest){
						 closest = d;
						 tx = x+i; ty = y+j; tz = z+dz;
						 found++;
					 }
				 }
				 bid = this.world.getblock(dimension, x+i, y+j, z-dz);
				 if(isFoodBlock(bid)){
					 d = dz*dz + j*j + i*i;
					 if(d < closest){
						 closest = d;
						 tx = x+i; ty = y+j; tz = z-dz;
						 found++;
					 }
				 } 			
			 }
		 }    	

		 if(found != 0)return true;
		 return false;
	 }
	 
	 public float getAdjustedFallDamage(float ouch){
		 float damage = ouch;
		 if(getOwnerName() != null){
			 if(damage > 1)damage = 1;
		 }
		 return damage;
	 }
	 



}
