package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

import dangerzone.DamageTypes;
import dangerzone.DangerZone;
import dangerzone.GameModes;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.items.Item;
import dangerzone.items.ItemAxe;
import dangerzone.items.ItemPickAxe;
import dangerzone.items.ItemShovel;
import dangerzone.items.ItemSword;
import dangerzone.items.Items;





public class EntityHostile extends EntityLiving {

	private GenericTargetSorter TargetSorter = null;
	public float searchDistance = 16f;
	public float attackRange = 2.0f;
	public int searchcounter = 0;
	public Entity hurtMe = null;
	public Entity targetentity = null;
	public boolean daytimecheck = true;
	public float armangle = 0f;
	public int armdir = 0;

	public EntityHostile(World w) {
		super(w);		
	}

	public void init(){
		super.init();
		TargetSorter = new GenericTargetSorter(this);
	}
	
	public void doAttackFrom(Entity e, /*DamageTypes*/int dt, float pain){	
		if(e != this && !DangerZone.playnicely)hurtMe = e; //revenge target!
		super.doAttackFrom(e, dt, pain);
	}

	public void doEntityAction(float deltaT){	
	
		/*
		 * See if there is something around to chase...
		 */
		searchcounter++;
		if(searchcounter >= 10){ //re-target about once a second
			searchcounter = world.rand.nextInt(4);
			if(hurtMe != null && hurtMe.deadflag)hurtMe = null;
			if(this.world.rand.nextInt(15) == 1)hurtMe = null;
			targetentity = hurtMe;
			if(targetentity == null)targetentity = findSomethingToAttack();
			if(targetentity != null){
				//System.out.printf("attackable entity found!\n");
				target = new TargetHelper(targetentity, targetentity.posx, targetentity.posy, targetentity.posz);
				setAttacking(true);
			}else{
				setAttacking(false);
			}
		}
		
		/*
		 * See if we should attack!
		 */
		if(targetentity != null && this.world.rand.nextInt(10) == 1){ //about once a second
			if(this.getDistanceFromEntity(targetentity) < attackRange+targetentity.width/2+this.width/2){
				doAttack();
			}
		}

		/*
		 * Do generic movement
		 */
		super.doEntityAction(deltaT);
	}
	
	public void doAttack(){
		float dmg = this.getAttackDamage();
		int dt = DamageTypes.HOSTILE;
		if(has_inventory){					
			InventoryContainer ic = this.getHotbar(this.gethotbarindex());
			if(ic != null){
				if(ic.bid != 0){
					dt = DamageTypes.BLOCK;
				}else{
					if(ic.iid > 0 && ic.iid < Items.itemsMAX){
						dmg = Items.getAttackStrength(ic.iid);
						dt = DamageTypes.GENERIC;
						Item it = ic.getItem();
						if(it != null){
							if(it instanceof ItemSword)dt = DamageTypes.SWORD;
							if(it instanceof ItemPickAxe)dt = DamageTypes.TOOL;
							if(it instanceof ItemAxe)dt = DamageTypes.TOOL;
							if(it instanceof ItemShovel)dt = DamageTypes.TOOL;
						}
					}
				}
			}
		}
		targetentity.doAttackFrom(this, dt, dmg);
	}
	
	public float getRightArmAngle(){
		return -armangle;
	}

	public Entity findSomethingToAttack(){	
		List<Entity> nearby_list = null;
		//Get a list of entities within reach of largest mob expected because we may hit their hitbox!
		nearby_list = DangerZone.server.entityManager.findEntitiesInRange((this.width/2) + searchDistance, dimension, posx, posy, posz);
		if(nearby_list != null){
			if(!nearby_list.isEmpty()){
				Entity e = null;
				ListIterator<Entity> li;
				//Sort them out based on size and distance
				Collections.sort(nearby_list, this.TargetSorter);
				li = nearby_list.listIterator();
				while(li.hasNext()){
					e = (Entity)li.next();
					if(isSuitableTarget(e)){ 
						return e;
					}
				}								
			}			
		}
		return null;
	}

	//default cockroaches and players only
	public boolean isSuitableTarget(Entity e){
		if(isIgnorable(e))return false;
		if( e instanceof Cockroach){
			if(CanProbablySeeEntity(e))return true;
			return false;
		}
		if( e instanceof Player){
			if(CanProbablySeeEntity(e))return true;
			return false;
		}
		return false;
	}

	//screen out the obvious non-attackable types
	public boolean isIgnorable(Entity e){
		if(DangerZone.playnicely)return true;
		if(e == this)return true;
		if(!(e instanceof EntityLiving))return true;
		if(e.deadflag)return true;
		if(e instanceof Player && e.getGameMode() != GameModes.SURVIVAL)return true;
		return false;
	}
	
	//only at night where it's dark
	public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z){
		if(daytimecheck){
			if(w.isDaytime())return false;
			if(getLightAtLocation(w, dimension, x, y, z) > 0.35f)return false;
		}
		return true;
	}
	
	public void update( float deltaT){

		//server side sets attacking or not.
		//both sides read it and set armdir. Only client actually displays...
		if(getAttacking()){
			if(armdir == 0)armdir = 1;
		}
		if(armdir != 0){
			if(armdir > 0){
				armangle += 22f*deltaT;
				if(armangle > 150f){
					armdir = -1;
				}
			}
			if(armdir < 0){
				armangle -= 22f*deltaT;
				if(armangle <= 0){
					armdir = 0;
					armangle = 0;
				}
			}
		}
		
		if(getCanDespawn()){
			if(this.world.isServer){	
				if(daytimecheck){
					if(this.world.isDaytime()){
						if(this.world.rand.nextInt(100) == 1){					
							float dist = 0;
							Player p = DangerZone.server.findNearestPlayer(this);
							if(p == null){
								this.deadflag = true;
							}else{
								dist = Utils.getDistanceBetweenEntities(this, p);
								if(dist > maxrenderdist){
									this.deadflag = true;
								}
								if(dist > world.rand.nextInt(100)+16){
									this.deadflag = true;
								}
							}
						}
					}
				}else{
					if(this.world.rand.nextInt(1000) == 1){					
						float dist = 0;
						Player p = DangerZone.server.findNearestPlayer(this);
						if(p == null){
							this.deadflag = true;
						}else{
							dist = Utils.getDistanceBetweenEntities(this, p);
							if(dist > maxrenderdist){
								this.deadflag = true;
							}
							if(dist > world.rand.nextInt(100)+16){
								this.deadflag = true;
							}
						}
					}
				}
			}
		}
		super.update(deltaT);
	}
	



}

