package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.GameModes;
import dangerzone.InventoryContainer;
import dangerzone.ModelBase;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldRendererUtils;


public class Entity {
	public int dimension;
	public float posx;
	public float posy;
	public float posz;
	public float motionx;
	public float motiony;
	public float motionz;
	public float rotation_yaw;
	public float rotation_pitch;
	public float rotation_roll;
	public volatile float rotation_yaw_head;
	public volatile float rotation_pitch_head;
	public float rotation_roll_head;
	public float rotation_yaw_motion;
	public float rotation_pitch_motion;
	public float rotation_roll_motion;

	public int prevdimension;
	public float prevposx;
	public float prevposy;
	public float prevposz;
	public float prevrotation_yaw;
	public float prevrotation_pitch;
	public float prevrotation_roll;
	public float prevrotation_yaw_head;
	public float prevrotation_pitch_head;
	public float prevrotation_roll_head;
	
	public float display_posx; //For display purposes, to help keep rider and mount in sync.
	public float display_posy;
	public float display_posz;
	public float display_rotation_yaw;
	public float display_rotation_pitch;
	public float display_rotation_roll;

	public float width = 0.75f;
	public float height = 1.95f;
	public boolean deadflag = false;
	//Globally unique ID for each individual entity across server and all clients.
	public int entityID = 0;
	public long lasttime = System.currentTimeMillis();
	public long currtime;
	public World world = null;
	public int maxrenderdist = 256; //In blocks
	public String uniquename;
	public long lifetimeticker;
	public int hurtanimationtimer;
	public int madtimer = 0;
	public int diffticker;
	//Draw me!
	//All entities of the same type share the same model and texture(s)
	//This is so that they don't eat up GPU memory, which they would exhaust rapidly...
	//The model can call back into the entity to get state when it needs to.
	public ModelBase model;
	public Texture texture;
	
	//These are extra variables that go from server to client (for non-player entities).
	//(they go client to server for players!)
	//Use the set/get functions for accessing them.
	//Your changes will get sent on the next update packet, usually in about 1/10th of a second.
	//No, there aren't any variables that go from client to server for non-player entities.
	//NOT access-locked. A bit risky, i know...
	// -- maxinv must be > maxvars !!!!
	//0-20 ARE RESERVED!!! USE ONLY 21-31
	public final int maxvars = 32; // ********* 0-20 ARE RESERVED!!! USE ONLY 21-31
	//0-75 ARE RESERVED!!! USE ONLY 76-99
	public final int maxinv = 100; // ********* 0-75 ARE RESERVED!!! USE ONLY 76-99
	
	public short changed;
	public short changes[];
	public int entity_ints[];
	public float entity_floats[];
	public String entity_strings[];
	
	public InventoryContainer entity_inventory[];
	public boolean has_inventory = false;
	
	public boolean takesFallDamage = false;
	public boolean ignoreCollisions = false;
	public boolean canthitme = false; //yes, you can hit me.
	public boolean isHostile = false;
	public boolean movement_friction = true;
	public int stray_entity_ticker = 0;
	public int firecounter = 0;
	public boolean sit_when_riding = true;	
	public boolean always_draw = false;

	
	public Entity(World w){
		world = w; //CAREFULL!!!! WORLD CAN BE NULL if this is a spawn list entry!!!
		posx = 0;
		posy = 0;
		posz = 0;
		rotation_yaw = 0;
		rotation_pitch = 0;
		rotation_roll = 0;
		rotation_yaw_head = 0;
		rotation_pitch_head = 0;
		rotation_roll_head = 0;
		prevdimension = dimension = 1;
		prevposx = prevposy = prevposz = 0;
		prevrotation_yaw = prevrotation_pitch = prevrotation_roll = 0;
		prevrotation_yaw_head = prevrotation_pitch_head = prevrotation_roll_head = 0;
		deadflag = false;
		lifetimeticker = 0;
		uniquename = "DangerZone:BaseEntity";
		changed = 0;
		
		entity_ints = new int[maxvars];
		entity_floats = new float[maxvars];
		entity_strings = new String[maxvars];
		for(int i=0;i<maxvars;i++){
			entity_ints[i] = 0;
			entity_floats[i] = 0;
			entity_strings[i] = null;
		}
		
		changes = new short[maxinv];
		for(int i=0;i<maxinv;i++){
			changes[i] = 0;
		}
		entity_inventory = new InventoryContainer[maxinv];
		for(int i=0;i<maxinv;i++){
			entity_inventory[i] = null;
		}

		hurtanimationtimer = 0;
		texture = null;
		canthitme = false;
		setCanDespawn(true);
		diffticker = 0;
	};
	
	public void init(){
		//Do any special stuff you can't do in your constructor, here.
		//This is AFTER it is read from disk (readself()) or spawned.		
		//clear mount/mounted!
		setVarInt(10, 0); //rider
		setVarInt(11, 0); //ridee
		setSitting(false);

	}
	
	public void de_init(){
		//Do any special stuff you can't do in your destructor, here.
		//This is just before it is written to disk (writeself()) on the SERVER side.
		int i = getVarInt(10);
		int j = getVarInt(11);
		setVarInt(10, 0);
		setVarInt(11, 0);
		if(i != 0 || j != 0){			
			setSitting(false);
		}
	}
	
	public int getVarInt(int index){
		if(index < 0 || index >= maxvars)return 0;
		return entity_ints[index];
	}
	
	public float getVarFloat(int index){
		if(index < 0 || index >= maxvars)return 0;
		return entity_floats[index];
	}
	
	public String getVarString(int index){
		if(index < 0 || index >= maxvars)return null;
		return entity_strings[index];
	}
	
	public InventoryContainer getVarInventory(int index){
		if(!has_inventory)return null;
		if(index < 0 || index >= maxinv)return null;
		return entity_inventory[index];
	}
	
	public void setVarInt(int index, int val){
		if(index < 0 || index >= maxvars)return;
		if(entity_ints[index] != val){
			entity_ints[index] = val;
			changes[index] |= 0x01;
			changed = 1;
		}
	}
	
	public void setVarFloat(int index, float val){
		if(index < 0 || index >= maxvars)return;
		if(entity_floats[index] != val){
			entity_floats[index] = val;
			changes[index] |= 0x02;
			changed = 1;
		}
	}
	
	public void setVarString(int index, String val){
		if(index < 0 || index >= maxvars)return;
		if(entity_strings[index] != val){
			entity_strings[index] = val;
			changes[index] |= 0x04;
			changed = 1;
		}
	}
	
	public void setVarInventory(int index, InventoryContainer val){
		if(!has_inventory)return;
		if(index < 0 || index >= maxinv)return;
		if(val == null && entity_inventory[index] == null)return;
		entity_inventory[index] = val;
		changes[index] |= 0x08;
		changed = 1;
	}
	public void setVarInventoryChanged(int index){
		if(!has_inventory)return;
		if(index < 0 || index >= maxinv)return;
		changes[index] |= 0x08;
		changed = 1;
	}

	//recommended range 1-10000
	public void setMaxHealth(float f){
		setVarFloat(0, f);
	}
	
	public float getMaxHealth(){
		return getVarFloat(0);
	}
	
	public void setHealth(float f){
		setVarFloat(1, f);
	}
	
	public void heal(float f){
		float mh = getMaxHealth();
		float newhealth = getHealth() + f;
		if(newhealth > mh)newhealth = mh;
		setHealth(newhealth);		
	}
	
	public float getHealth(){
		return getVarFloat(1);
	}
	
	//recommended range 1-100
	public void setDefense(float f){
		setVarFloat(2, f);
	}
	
	public float getDefense(){ //attack damage is DIVIDED by this.
		return getVarFloat(2);
	}
	
	//recommended range 1-100
	public void setAttackDamage(float f){
		setVarFloat(3, f);
	}
	
	public float getAttackDamage(){ 
		return getVarFloat(3);
	}
	
	public void setMaxHunger(float f){
		setVarFloat(4, f);
	}
	
	public float getMaxHunger(){
		return getVarFloat(4);
	}
	
	public void setHunger(float f){
		setVarFloat(5, f);
	}
	
	public float getHunger(){
		return getVarFloat(5);
	}
	
	public void setMaxAir(float f){
		setVarFloat(6, f);
	}
	
	public float getMaxAir(){
		return getVarFloat(6);
	}
	
	public void setAir(float f){
		setVarFloat(7, f);
	}
	
	public float getAir(){
		return getVarFloat(7);
	}
	
	public void setBID(int f){
		setVarInt(0, f);
	}
	
	public int getBID(){
		return getVarInt(0);
	}
	
	public void setIID(int f){
		setVarInt(1, f);
	}
	
	public int getIID(){
		return getVarInt(1);
	}
	
	public int getGameMode(){
		return getVarInt(2);
	}
	
	public void setGameMode(int f){
		setVarInt(2, f);
	}
	
	public void sethotbarindex(int f){
		setVarInt(3, f);
	}
	
	public int gethotbarindex(){
		return getVarInt(3);
	}
	
	public void setItemDamage(int f){
		setVarInt(4, f);
	}
	
	public int getItemDamage(){
		return getVarInt(4);
	}
	
	public void setAttacking(boolean tf){
		int f = getVarInt(5);
		if(tf){
			f |= 0x01;
		}else{
			f &= 0xfffffffe;
		}
		setVarInt(5, f);
	}	
	public boolean getAttacking(){
		if((getVarInt(5)&0x01) == 0x01)return true;
		return false;
	}
	
	public void setInLiquid(boolean tf){
		int f = getVarInt(5);
		if(tf){
			f |= 0x02;
		}else{
			f &= 0xfffffffd;
		}
		setVarInt(5, f);
	}	
	public boolean getInLiquid(){
		if((getVarInt(5)&0x02) == 0x02)return true;
		return false;
	}
	
	public void setOnGround(boolean tf){
		int f = getVarInt(5);
		if(tf){
			f |= 0x04;
		}else{
			f &= 0xfffffffb;
		}
		setVarInt(5, f);
	}	
	public boolean getOnGround(){
		if((getVarInt(5)&0x04) == 0x04)return true;
		return false;
	}
	
	public void setStaying(boolean tf){
		int f = getVarInt(5);
		if(tf){
			f |= 0x08;
		}else{
			f &= 0xfffffff7;
		}
		setVarInt(5, f);
	}	
	public boolean getStaying(){
		if((getVarInt(5)&0x08) == 0x08)return true;
		return false;
	}
	
	public void setCanDespawn(boolean tf){
		int f = getVarInt(5);
		if(tf){
			f |= 0x10;
		}else{
			f &= 0xffffffef;
		}
		setVarInt(5, f);
	}	
	public boolean getCanDespawn(){
		if((getVarInt(5)&0x10) == 0x10)return true;
		return false;
	}
	
	public void setSitting(boolean tf){
		int f = getVarInt(5);
		if(tf){
			f |= 0x020;
		}else{
			f &= 0xffffffdf;
		}
		setVarInt(5, f);
	}	
	public boolean getSitting(){
		if((getVarInt(5)&0x020) == 0x020)return true;
		return false;
	}
	
	public void setBaby(boolean tf){
		int f = getVarInt(5);
		if(tf){
			f |= 0x040;
		}else{
			f &= 0xffffffbf;
		}
		setVarInt(5, f);
	}	
	public boolean getBaby(){
		if((getVarInt(5)&0x040) == 0x040)return true;
		return false;
	}
	
	public void setQuiet(boolean tf){
		int f = getVarInt(5);
		if(tf){
			f |= 0x080;
		}else{
			f &= 0xffffff7f;
		}
		setVarInt(5, f);
	}	
	public boolean getQuiet(){
		if((getVarInt(5)&0x080) == 0x080)return true;
		return false;
	}
	
	public void setSinging(boolean tf){
		int f = getVarInt(5);
		if(tf){
			f |= 0x100;
		}else{
			f &= 0xfffffeff;
		}
		setVarInt(5, f);
	}	
	public boolean getSinging(){
		if((getVarInt(5)&0x100) == 0x100)return true;
		return false;
	}
	
	public void setExperience(int f){
		setVarInt(6, f);
	}
	
	public int getExperience(){
		return getVarInt(6);
	}
	
	public void setInitialized(int f){
		setVarInt(8, f);
	}
	
	public int getInitialized(){
		return getVarInt(8);
	}
	
	public void setOnFire(int f){
		setVarInt(9, f);
	}
	
	public void doSetOnFire(int f){
		if(!(this instanceof Player)){
			setVarInt(9, f);
		}else{
			if(world.isServer){
				Player p = (Player)this;
				p.server_thread.sendVarIntUpdate(9, f);
			}
		}
	}
	
	public int getOnFire(){
		return getVarInt(9);
	}
	
	public String getOwnerName(){
		return getVarString(0);
	}
	
	public void setOwnerName(String s){
		setVarString(0, s);
	}
	
	public String getPetName(){
		return getVarString(1);
	}
	
	public void setPetName(String s){
		setVarString(1, s);
	}
	
	public void Mount(Entity rider){
		//if(getVarInt(10) != 0)return; //already mounted!
		if(rider == null)return;
		setVarInt(10, rider.entityID); //set rider		
		rider.setVarInt(11, this.entityID);

		if(world.isServer){
			rider.setSitting(sit_when_riding);
			if(rider instanceof Player){
				Player p = (Player)rider;
				p.server_thread.sendMountCommand(this.entityID);
			}
		}
		
	}
	
	public void unMount(Entity rider){
		setVarInt(10, 0);
		if(rider != null){
			rider.setVarInt(11, 0);
		}
		if(world.isServer && rider != null){
			rider.setSitting(false);
			if(rider instanceof Player){
				Player p = (Player)rider;
				p.server_thread.sendMountCommand(0);
			}
		}		
	}
	
	public boolean isMountedBy(Entity e){
		if(getVarInt(10) == e.entityID)return true;
		return false;
	}
	
	//returns the thing we are RIDING ON
	public Entity getRiddenEntity(){
		Entity mounted = null;
		int i = getVarInt(11);
		if(i == 0)return null;
		if(world.isServer){
			mounted = DangerZone.server.entityManager.findEntityByID(i);
		}else{
			mounted = DangerZone.entityManager.findEntityByID(i);
		}
		
		return mounted;
	}
	
	public float getRiderYoffset(){
		return height; //This is most assuredly wrong... override for your ride able critter!
	}
	
	public float getRiderXZoffset(){
		return 0;
	}
	
	//returns the thing that is RIDING US
	public Entity getRiderEntity(){
		Entity rider = null;
		int i = getVarInt(10);
		if(i == 0)return null;
		if(world.isServer){
			rider = DangerZone.server.entityManager.findEntityByID(i);
		}else{
			rider = DangerZone.entityManager.findEntityByID(i);
		}
		return rider;
	}
	
	public void setForward(boolean tf){
		int f = getVarInt(12);
		if(tf){
			f |= 0x01;
		}else{
			f &= 0xfffffffe;
		}
		setVarInt(12, f);
	}	
	public boolean getForward(){
		if((getVarInt(12)&0x01) == 0x01)return true;
		return false;
	}
	
	public void setBackward(boolean tf){
		int f = getVarInt(12);
		if(tf){
			f |= 0x02;
		}else{
			f &= 0xfffffffd;
		}
		setVarInt(12, f);
	}	
	public boolean getBackward(){
		if((getVarInt(12)&0x02) == 0x02)return true;
		return false;
	}
	
	public void setLeft(boolean tf){
		int f = getVarInt(12);
		if(tf){
			f |= 0x04;
		}else{
			f &= 0xfffffffb;
		}
		setVarInt(12, f);
	}	
	public boolean getLeft(){
		if((getVarInt(12)&0x04) == 0x04)return true;
		return false;
	}
	
	public void setRight(boolean tf){
		int f = getVarInt(12);
		if(tf){
			f |= 0x08;
		}else{
			f &= 0xfffffff7;
		}
		setVarInt(12, f);
	}	
	public boolean getRight(){
		if((getVarInt(12)&0x08) == 0x08)return true;
		return false;
	}
	
	public void setUp(boolean tf){
		int f = getVarInt(12);
		if(tf){
			f |= 0x10;
		}else{
			f &= 0xffffffef;
		}
		setVarInt(12, f);
	}	
	public boolean getUp(){
		if((getVarInt(12)&0x10) == 0x10)return true;
		return false;
	}
	
	public void setDown(boolean tf){
		int f = getVarInt(12);
		if(tf){
			f |= 0x20;
		}else{
			f &= 0xffffffdf;
		}
		setVarInt(12, f);
	}	
	public boolean getDown(){
		if((getVarInt(12)&0x20) == 0x20)return true;
		return false;
	}

	public InventoryContainer getInventory(int i){
		if(i >= 0 && i <= 49){
			return getVarInventory(i);
		}
		return null;
	}
	public InventoryContainer getHotbar(int i){
		if(i >= 0 && i <= 9){
			return getVarInventory(i+50);
		}
		return null;
	}
	public InventoryContainer getArmor(int i){
		if(i >= 0 && i <= 3){
			return getVarInventory(i+60);
		}
		return null;
	}
	
	public void setInventory(int i, InventoryContainer ic){
		if(i >= 0 && i <= 49){
			setVarInventory(i, ic);
		}
	}
	public void setInventoryChanged(int i){
		if(i >= 0 && i <= 49){
			setVarInventoryChanged(i);
		}
	}
	
	public void setHotbar(int i, InventoryContainer ic){
		if(i >= 0 && i <= 9){
			setVarInventory(i+50, ic);
		}
	}
	public void setHotbarChanged(int i){
		if(i >= 0 && i <= 9){
			setVarInventoryChanged(i+50);
		}
	}
	
	public void setArmor(int i, InventoryContainer ic){
		if(i >= 0 && i <= 3){
			setVarInventory(i+60, ic);
		}
	}
	public void setArmorChanged(int i){
		if(i >= 0 && i <= 3){
			setVarInventoryChanged(i+60);
		}
	}
	
	public void doAttackFrom(Entity e, /*DamageTypes*/int dt, float ouch){		
	}
	
	public boolean takesDamageFrom(/*DamageTypes*/int dt){
		return true;
	}
	
	public void doHurtAnimation(){
	}
	
	public void onDeath(){
		Entity ridden = getRiddenEntity();
		Entity rider = getRiderEntity();
		if(rider != null){
			unMount(rider);
		}
		if(ridden != null){
			ridden.unMount(this);
		}
	}
	
	public void doArmorDamage(Entity e, /*DamageTypes*/int dt, float pain){
	}
	
	public void jump(){
	}
	
	public float getRightArmAngle(){
		return 0.0f;
	}
	
	public boolean isHurt(){
		return false;
	}
	
	public boolean isMad(){
		return false;
	}
	
	public boolean isDying(){
		return false;
	}
	
	public String getLivingSound(){
		return null;
	}
	
	public float getLivingSoundPitch(){
		return 1.0f+(DangerZone.rand.nextFloat()-DangerZone.rand.nextFloat())*0.2f;
	}
	
	public float getLivingSoundVolume(){
		return 1.0f;
	}
	
	public String getHurtSound(){
		return null;
	}
	
	public String getDeathSound(){
		return null;
	}
	
	//TODO FIXME! Make sure I get added to attacks!
	public String getAttackSound(){
		return null;
	}
	
	public void doDeathAnimation(){
	}
	
	public float getDeathFactor(){
		return 0;
	}
	
	public void writeSelf(Properties prop, String tag){
		
		while(rotation_yaw < 0)rotation_yaw += 360f;
		rotation_yaw %= 360f;
		while(rotation_pitch < 0)rotation_pitch += 360f;
		rotation_pitch %= 360f;
		while(rotation_roll < 0)rotation_roll += 360f;
		rotation_roll %= 360f;
		
		while(rotation_yaw_head < 0)rotation_yaw_head += 360f;
		rotation_yaw_head %= 360f;
		while(rotation_pitch_head < 0)rotation_pitch_head += 360f;
		rotation_pitch_head %= 360f;
		while(rotation_roll_head < 0)rotation_roll_head += 360f;
		rotation_roll_head %= 360f;
		
		prop.setProperty(String.format("%s%s", tag, "posx"), String.format("%f", posx));
		prop.setProperty(String.format("%s%s", tag, "posy"), String.format("%f", posy));
		prop.setProperty(String.format("%s%s", tag, "posz"), String.format("%f", posz));
		prop.setProperty(String.format("%s%s", tag, "dimension"), String.format("%d", dimension));
		prop.setProperty(String.format("%s%s", tag, "rotation_yaw"), String.format("%f", rotation_yaw));
		prop.setProperty(String.format("%s%s", tag, "rotation_pitch"), String.format("%f", rotation_pitch));
		prop.setProperty(String.format("%s%s", tag, "rotation_roll"), String.format("%f", rotation_roll));
		prop.setProperty(String.format("%s%s", tag, "rotation_yaw_motion"), String.format("%f", rotation_yaw_motion));
		prop.setProperty(String.format("%s%s", tag, "rotation_pitch_motion"), String.format("%f", rotation_pitch_motion));
		prop.setProperty(String.format("%s%s", tag, "rotation_roll_motion"), String.format("%f", rotation_roll_motion));
		prop.setProperty(String.format("%s%s", tag, "motionx"), String.format("%f", motionx));
		prop.setProperty(String.format("%s%s", tag, "motiony"), String.format("%f", motiony));
		prop.setProperty(String.format("%s%s", tag, "motionz"), String.format("%f", motionz));
		prop.setProperty(String.format("%s%s", tag, "width"), String.format("%f", width));
		prop.setProperty(String.format("%s%s", tag, "height"), String.format("%f", height));
		prop.setProperty(String.format("%s%s", tag, "maxrenderdist"), String.format("%d", maxrenderdist));
		prop.setProperty(String.format("%s%s", tag, "lifetimeticker"), String.format("%d", lifetimeticker));
		prop.setProperty(String.format("%s%s", tag, "rotation_yaw_head"), String.format("%f", rotation_yaw_head));
		prop.setProperty(String.format("%s%s", tag, "rotation_pitch_head"), String.format("%f", rotation_pitch_head));
		prop.setProperty(String.format("%s%s", tag, "rotation_roll_head"), String.format("%f", rotation_roll_head));
			
		
		for(int i=0;i<maxvars;i++){
			if(entity_ints[i] != 0)prop.setProperty(String.format("%s%s%d", tag, "varint", i), String.format("%d", entity_ints[i]));
			if(entity_floats[i] != 0)prop.setProperty(String.format("%s%s%d", tag, "varfloat", i), String.format("%f", entity_floats[i]));
			if(entity_strings[i] != null)prop.setProperty(String.format("%s%s%d", tag, "varstring", i), entity_strings[i]);
		}
		
		if(has_inventory){
			String s;
			for(int i=0;i<maxinv;i++){
				s = String.format("%sInventory_%d:", tag, i);
				if(entity_inventory[i] != null){					
					prop.setProperty(String.format("%s%s", s, "data"), "valid");				
					entity_inventory[i].writeSelf(prop, s);
				}else{
					//Because it's Java, and there is no DELETE property...
					prop.setProperty(String.format("%s%s", s, "data"), "null");
				}
			}
		}
		
	}
	
	public void readSelf(Properties prop, String tag){

		posx = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "posx"), 0, Float.MAX_VALUE, 10000f);
		posy = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "posy"), 0, 256, 75f);
		posz = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "posz"), 0, Float.MAX_VALUE, 10000f);
		dimension = Utils.getPropertyInt(prop, String.format("%s%s", tag, "dimension"), 1, Dimensions.dimensionsMAX, 1);
		rotation_yaw = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw"), 0, 360, 0f);
		rotation_pitch = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch"), 0, 360, 00f);
		rotation_roll = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll"), 0, 360, 00f);
		rotation_yaw_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw_motion"), -300, 300, 0f);
		rotation_pitch_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch_motion"), -300, 300, 0f);
		rotation_roll_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll_motion"), -300, 300, 0f);
		motionx = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motionx"), -10, 10, 0f);
		motiony = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motiony"), -10, 10, 0f);
		motionz = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motionz"), -10, 10, 0f);
		width = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "width"), 0.1f, 30f, width);
		height = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "height"), 0.1f, 50f, height);
		maxrenderdist = Utils.getPropertyInt(prop, String.format("%s%s", tag, "maxrenderdist"), 2, 512, 16*DangerZone.renderdistance);
		lifetimeticker = Utils.getPropertyLong(prop, String.format("%s%s", tag, "lifetimeticker"), 0, Long.MAX_VALUE, 0);
		rotation_yaw_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw_head"), 0, 360, 0f);
		rotation_pitch_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch_head"), 0, 360, 00f);
		rotation_roll_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll_head"), 0, 360, 00f);
		
		
		for(int i=0;i<maxvars;i++){
			entity_ints[i] = Utils.getPropertyInt(prop, String.format("%s%s%d", tag, "varint", i), Integer.MIN_VALUE, Integer.MAX_VALUE, entity_ints[i]);
			if(entity_ints[i] != 0){
				changed = 1;
				changes[i] |= 0x01;
			}
			entity_floats[i] = Utils.getPropertyFloat(prop, String.format("%s%s%d", tag, "varfloat", i), -Float.MAX_VALUE, Float.MAX_VALUE, entity_floats[i]);
			if(entity_floats[i] != 0){
				changed = 1;
				changes[i] |= 0x02;
			}
			entity_strings[i] = Utils.getPropertyString(prop, String.format("%s%s%d", tag, "varstring", i), entity_strings[i]);	
			if(entity_strings[i] != null){
				changed = 1;
				changes[i] |= 0x04;
			}
		}
		
		
		
		if(has_inventory){
			String s;
			String n;
			for(int i=0;i<maxinv;i++){
				entity_inventory[i] = null;
				s = String.format("%sInventory_%d:", tag, i);
				n = prop.getProperty(String.format("%s%s", s, "data"));
				if(n != null){
					if(!n.equals("null")){
						entity_inventory[i] = new InventoryContainer();
						entity_inventory[i].readSelf(prop, s);
					}
				}		
			}
		}

	}
	
	public void doEntityCollisions(float deltaT){		
	}
	
	/* only called on server*/
	public void doEntityAction(float deltaT){		
	}
	
	/*
	 * Here is where you should drop all your stuff
	 * Called server side.
	 */
	public void doDeathDrops(){
		if(has_inventory){
			InventoryContainer ic;
			float mdst = height*2;
			if(mdst > 10)mdst = 10;
			for(int i=0;i<maxinv;i++){
				ic = getVarInventory(i);			
				if(ic != null){
					setVarInventory(i, null);
					if(this instanceof Player){
						Player ple = (Player)this;
						ple.sendInventoryUpdate(3, i, null);
					}
					Utils.doDropRand(world, ic, mdst, dimension, posx, posy, posz); //multi-item drop
				}
			}
		}		
	}
	
	/*
	 * Adds motion, tidys up, sends update if necessary
	 */
	public void update(float deltaT){
		long too_long;
		int different = 0;
		//Server updates entities (motion, collisions, actions) 10 times a second.
		//Client updates entities (motion only) 60 times a second.
		//Scale the difference so we are at least close!
		float rate = DangerZone.entityupdaterate;
		rate /= DangerZone.serverentityupdaterate;
		//rate *= 0.75f;
		
		lifetimeticker++; //Mostly just for renderers, but can be used for other things too. Different on client and server!
		if(deltaT > 1.5f)lifetimeticker += (int)((deltaT+0.5f)-1);

		//because we got blown into the low 20,000's one time... oops!
		if(posy > 1024 && motiony > 0){
			posy = 1024;
			motiony = -1;
		}
		
		if(posy < -1024 && motiony < 0){
			posy = -1024;
			motiony = 1;
		}
		
		//Standard movement processing
		if(!this.world.isServer){			
			if(this instanceof Player){
				Player p = (Player)this;
				if(p.getGameMode() == GameModes.GHOST){
					motiony *= (1.0f-(0.15f*deltaT*rate));
				}
			}
			
			if(movement_friction){
				motionx *= (1.0f-(0.35f*deltaT*rate));
				motiony *= (1.0f-(0.05f*deltaT*rate));
				motionz *= (1.0f-(0.35f*deltaT*rate));			
				rotation_pitch_motion *= (1.0f-(0.25f*deltaT*rate));
				rotation_yaw_motion *= (1.0f-(0.25f*deltaT*rate));
				rotation_roll_motion *= (1.0f-(0.25f*deltaT*rate));
			}
			posy += motiony*deltaT*rate;
			posx += motionx*deltaT*rate;
			posz += motionz*deltaT*rate;
			rotation_pitch += rotation_pitch_motion*deltaT*rate;
			if(this instanceof Player){
				rotation_yaw_head += rotation_yaw_motion*deltaT*rate;
			}else{
				rotation_yaw += rotation_yaw_motion*deltaT*rate;
			}
			rotation_roll += rotation_roll_motion*deltaT*rate;
			
			display_posx = posx;
			display_posy = posy;
			display_posz = posz;
			display_rotation_pitch = rotation_pitch;
			display_rotation_yaw = rotation_yaw;
			display_rotation_roll = rotation_roll;
			
		}else{
			if(movement_friction){
				motionx *= (1.0f-(0.35f*deltaT));
				motiony *= (1.0f-(0.05f*deltaT));
				motionz *= (1.0f-(0.35f*deltaT));
				rotation_pitch_motion *= (1.0f-(0.25f*deltaT));
				rotation_yaw_motion *= (1.0f-(0.25f*deltaT));
				rotation_roll_motion *= (1.0f-(0.25f*deltaT));
			}
			posy += motiony*deltaT;
			posx += motionx*deltaT;
			posz += motionz*deltaT;
			rotation_pitch += rotation_pitch_motion*deltaT;
			rotation_yaw += rotation_yaw_motion*deltaT;
			rotation_roll += rotation_roll_motion*deltaT;
		}
		
		while(rotation_yaw < 0)rotation_yaw += 360f;
		rotation_yaw %= 360f;
		while(rotation_pitch < 0)rotation_pitch += 360f;
		rotation_pitch %= 360f;
		while(rotation_roll < 0)rotation_roll += 360f;
		rotation_roll %= 360f;	
		
		while(rotation_yaw_head < 0)rotation_yaw_head += 360f;
		rotation_yaw_head %= 360f;
		while(rotation_pitch_head < 0)rotation_pitch_head += 360f;
		rotation_pitch_head %= 360f;
		while(rotation_roll_head < 0)rotation_roll_head += 360f;
		rotation_roll_head %= 360f;	
				
		
		//Try to make sure rider and mount are in sync...
		Entity e = getRiddenEntity();
		if(e != null){
			motionx = e.motionx;
			motiony = e.motiony;
			motionz = e.motionz;
			posx = (float) (e.posx+(Math.sin(Math.toRadians(e.rotation_yaw))*e.getRiderXZoffset()));
			posy = e.posy+e.getRiderYoffset();
			posz = (float) (e.posz+(Math.cos(Math.toRadians(e.rotation_yaw))*e.getRiderXZoffset()));	
			display_posx = posx;
			display_posy = posy;
			display_posz = posz;
		}
		e = getRiderEntity();
		if(e != null){
			e.motionx = motionx;
			e.motiony = motiony;
			e.motionz = motionz;
			e.posx = (float) (posx+(Math.sin(Math.toRadians(rotation_yaw))*getRiderXZoffset()));
			e.posy = posy+getRiderYoffset();
			e.posz = (float) (posz+(Math.cos(Math.toRadians(rotation_yaw))*getRiderXZoffset()));	
			e.display_posx = e.posx;
			e.display_posy = e.posy;
			e.display_posz = e.posz;
		}
				
		
		if(this.world.isServer && this instanceof Player)return; //Players on server DO NOT send packets!
		if(!this.world.isServer && this != DangerZone.player)return; //Only player on Client sends packets.
		
		different = 0;
		//See if we should send a position/rotation update to someone...
		currtime = System.currentTimeMillis();
		too_long = currtime - lasttime;			
		if(too_long >= 1000)different++; //At least every second, regardless.
//		if(too_long >= update_interval){
			if(changed != 0)different++;			
			if(prevdimension != dimension || prevposx != posx || prevposy != posy || prevposz != posz)different++;
			if(prevrotation_yaw != rotation_yaw || prevrotation_pitch != rotation_pitch || prevrotation_roll != rotation_roll)different++;
			if(prevrotation_yaw_head != rotation_yaw_head || prevrotation_pitch_head != rotation_pitch_head || prevrotation_roll_head != rotation_roll_head)different++;
			if(different == 0){ //keep sending for a few more...
				diffticker++;
				if(diffticker < 10){
					different++;
				}
			}else{
				diffticker = 0;
			}
			
			
			if(different != 0){
				lasttime = currtime;
				prevdimension = dimension;
				prevposy = posy;
				prevposx = posx;
				prevposz = posz;
				prevrotation_yaw = rotation_yaw;
				prevrotation_pitch = rotation_pitch;
				prevrotation_roll = rotation_roll;
				prevrotation_yaw_head = rotation_yaw_head;
				prevrotation_pitch_head = rotation_pitch_head;
				prevrotation_roll_head = rotation_roll_head;
				if(this instanceof Player){
					if(!this.world.isServer){
						if(this == DangerZone.player){
							//System.out.printf("client fire = %d, %d, %d\n", getOnFire(), changed, changes[9]);
							DangerZone.server_connection.sendPlayerEntityUpdate(this); //Send MY player update to server
						}
					}
				}else{
					if(this.world.isServer){
						//System.out.printf("time = %d\n", (int)(currtime%1000));
						DangerZone.server.sendEntityUpdateToAll(this, false);
					}					
				}
			}			
		//}
		
	}
	
	public float getAdjustedFallDamage(float damage){
		if(!takesFallDamage)return 0;
		return damage;
	}
	
	public float getDistanceFromEntity(Entity p){
		float d1, d2, d3;
		d1 = p.posx - this.posx;
		d2 = p.posy - this.posy;
		d3 = p.posz - this.posz;
		if(p.dimension != this.dimension)return 9999.0f;
		return (float)Math.sqrt((d1*d1)+(d2*d2)+(d3*d3));
	}
	
	public float getDistanceFromEntityCenter(Entity p){
		float d1, d2, d3;
		d1 = p.posx - this.posx;
		d2 = (p.posy+p.height/2) - (this.posy+this.height/2);
		d3 = p.posz - this.posz;
		return (float)Math.sqrt((d1*d1)+(d2*d2)+(d3*d3));
	}
	
	public float getHorizontalDistanceFromEntity(Entity p){
		float d1, d3;
		d1 = p.posx - this.posx;
		d3 = p.posz - this.posz;
		return (float)Math.sqrt((d1*d1)+(d3*d3));
	}
	
	public float getHorizontalDistanceFromEntity(float x, float z){
		float d1, d3;
		d1 = x - this.posx;
		d3 = z - this.posz;
		return (float)Math.sqrt((d1*d1)+(d3*d3));
	}
	
	public float getDistanceFromEntityCenter(float x, float y, float z){
		float d1, d2, d3;
		d1 = x - this.posx;
		d2 = y - (this.posy+(this.height/2));
		d3 = z - this.posz;
		return (float)Math.sqrt((d1*d1)+(d2*d2)+(d3*d3));
	}
	
	/* only called by server */
	public boolean rightClickedByPlayer(Player p, InventoryContainer ic){
		return false; //do not decrement inventory
	}
	
	/* only called by server */
	public boolean leftClickedByPlayer(Player p, InventoryContainer ic){
		return true; //continue with attack damage
	}
	
	public void onKill(Entity deadthing){
		//only called on server, when something kills something else!
	}
	
	
	public Texture getTexture(){
		//MAKE SURE YOU USE TextureMapper.getTexture(string) when getting the texture(s) for your entity!
		return texture;
	}
	
	public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z){
		//USE "w" if you need world access. entity.world is null in this routine!
		//ONLY called through an inert/inactive entity on the server.
		return true;
	}
	
	public boolean isFoodForMe(int bid, int iid){
		if(isFoodBlock(bid) || isFoodItem(iid))return true;
		return false;
	}
	
	public boolean isFoodBlock(int bid){
		return false;
	}
	
	public boolean isFoodItem(int iid){
		return false;
	}
	
	 public void findBlockFood(int maxdist, int healamount, int eatitdistance){
	 }
	 
	 public void playburp(){
	 }
	 
	 public float getSpinz(){
		 return 0;
	 }


	 public float getLightAtLocation(World w, int d, int x, int y, int z){
		 if(!w.isServer){
			 return WorldRendererUtils.getTotalLightAt(w, d, x, y, z);
		 }else{
			 if(DangerZone.start_client){ //single player maybe?
				 WorldRendererUtils.getTotalLightAt(DangerZone.world, d, x, y, z);
			 }
			 //have to go ask a real client!!! That's where the lightmaps are...
			 Player p = DangerZone.server.findNearestPlayerToHere(d, x, y, z);
			 if(p != null){
				 return p.server_thread.doLightingRequest(d, x, y, z);
			 }			
		 }		
		 return w.rand.nextFloat(); //punt
	 }

}
