package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */




import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

import org.newdawn.slick.opengl.Texture;

import dangerzone.DamageTypes;
import dangerzone.DangerZone;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.items.Items;


public class Anteater extends EntityTameable {
	
	//Borrow a few things from entityhostile, because we actually chase and kill bugs!
	Entity targetentity = null;
	Entity hurtMe = null;
	float attackRange = 0;
	int searchDistance = 14;
	int searchcounter = 0;
	private GenericTargetSorter TargetSorter = null;
	
	public	Anteater(World w){
		super(w);
		maxrenderdist = 130; //in blocks
		this.height = 1.25f;
		this.width = 0.95f;
		uniquename = "DangerZone:Anteater";
		moveSpeed = 0.25f;
		setMaxHealth(50.0f);
		setHealth(50.0f);
		setDefense(3.0f);
		setAttackDamage(5.0f);
		attackRange = 3.5f;
		movefrequency = 45;
		setExperience(50);
		searchDistance = 14;
		canSwim = true;
		setCanDespawn(false);
		maxdisttoowner = 14f;
	}
	
	public void init(){
		super.init();
		TargetSorter = new GenericTargetSorter(this);
	}
	
	public boolean isFoodItem(int foodid){
		if(foodid == Items.deadbug.itemID)return true;
		return false;
	}
	
	public void doAttackFrom(/*entity that hit me*/Entity e, /*DamageTypes*/int dt, float pain){	
		if(world.isServer && e != this && e != null){
			Entity eo = DangerZone.server.entityManager.findPlayerByName(getOwnerName());
			if(e != eo){
				if(!DangerZone.playnicely)hurtMe = e;
				setStaying(false);
			}			
		}
		super.doAttackFrom(e, dt, pain);
	}
	
	public void doEntityAction(float deltaT){
		/*
		 * See if there is something around to chase...
		 * We are hostile to bugs.
		 */
		if(!getStaying()){
			searchcounter++;
			if(searchcounter >= 10){ //re-target about once a second
				searchcounter = world.rand.nextInt(4);
				if(hurtMe != null && hurtMe.deadflag)hurtMe = null;
				if(this.world.rand.nextInt(10) == 1)hurtMe = null;
				targetentity = hurtMe;
				if(targetentity == null)targetentity = findSomethingToAttack();
				if(targetentity != null){
					//System.out.printf("attackable entity found!\n");
					target = new TargetHelper(targetentity.posx, targetentity.posy, targetentity.posz);
					setAttacking(true);
				}else{
					setAttacking(false);
				}
			}

			/*
			 * See if we should attack!
			 */
			if(targetentity != null && this.world.rand.nextInt(10) == 1){ //about once a second
				if(this.getDistanceFromEntity(targetentity) < attackRange+targetentity.width/2+this.width/2){
					targetentity.doAttackFrom(this, DamageTypes.HOSTILE, this.getAttackDamage());
				}
			}
		}

		//something else we should be doing?
		super.doEntityAction(deltaT);	
	}
	
	public Entity findSomethingToAttack(){	
		List<Entity> nearby_list = null;
		//Get a list of entities within reach of largest mob expected because we may hit their hitbox!
		nearby_list = DangerZone.server.entityManager.findEntitiesInRange((this.width/2) + searchDistance, dimension, posx, posy, posz);
		if(nearby_list != null){
			if(!nearby_list.isEmpty()){
				Entity e = null;
				ListIterator<Entity> li;
				//Sort them out based on size and distance
				Collections.sort(nearby_list, this.TargetSorter);
				li = nearby_list.listIterator();
				while(li.hasNext()){
					e = (Entity)li.next();
					if(isSuitableTarget(e)){ 
						return e;
					}
				}								
			}			
		}
		return null;
	}
	
	//we attack all small things!
	public boolean isSuitableTarget(Entity e){
		if(DangerZone.playnicely)return false;
		if(getOwnerName() != null){
			if(getDistanceFromEntity(e) > maxdisttoowner){
				return false;
			}
		}
		if(!(e instanceof EntityLiving))return false;
		if(e.deadflag)return false;
		if(e.width*e.height > 0.063f)return false;
		if(!CanProbablySeeEntity(e))return false;
		return true;
	}
		
	
	public String getLivingSound(){
		return null;
	}
	
	public String getHurtSound(){
		return "DangerZone:anteater_hit";
	}
	
	public String getDeathSound(){
		return null;
	}
	
	public void doDeathDrops(){		
		Utils.doDropRand(world, 0, Items.trophyanteater.itemID, 1f, dimension, posx, posy, posz);
		super.doDeathDrops();
	}
	
	//Model calls back out to see what texture to use.
	public Texture getTexture(){
		if(texture == null){
			//ENTITIES MUST USE TEXTUREMAPPER.GETTEXTURE()!!!!
			texture = TextureMapper.getTexture("res/skins/"+ "Anteatertexture.png");	//this is not fast, so we keep our own pointer!
		}
		return texture;
	}
	

}
