package dangerzone.blocks;
import dangerzone.Player;
import dangerzone.World;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class BlockLiquid extends Block {

	public BlockLiquid(String n, String txt) {
		super(n, txt);
		alwaystick = true;
		isSolidForRendering = false;
		isTranslucent = true;
		isSolid = false;
		isLiquid = true;
		friction = 0.10f;
		maxstack = 16;
		//renderAllSides = true;
	}
	
	public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z){
		int meta = w.getblockmeta(dimension, x, y, z);
		if(meta != 0)return 0;
		return super.getBlockDrop(p, w, dimension, x, y, z);
	}
	
	public void tickMe(World w, int d, int x, int y, int z){

		int meta = w.getblockmeta(d, x, y, z);
		int i, tv, j, k, bid, nm, nma, metaave;
		
		//should we just fall?
		bid = w.getblock(d, x, y-1, z);
		if(bid == 0 || Blocks.isLeaves(bid)){
			Blocks.doBreakBlock(bid, w, d, x, y-1, z);
			if(meta == 0)meta = 1; //falling liquid cannot be a source!
			w.setblockandmeta(d, x, y-1, z, blockID, meta);			
			w.setblock(d, x, y, z, 0);
			return;
		}
		
		//if(meta != 0)
			//tick self down
		//
		if(meta != 0){
			switch(w.rand.nextInt(4)){
			case 0:							//fl
				i = (meta>>12)&0x0f;
				if(i<0x0f)i++;
				meta = (meta&0xfff)|(i<<12);
				break;
			case 1:							//fr
				i = (meta>>8)&0x0f;
				if(i<0x0f)i++;
				meta = (meta&0xf0ff)|(i<<8);
				break;
			case 2:							//bl
				i = (meta>>4)&0x0f;
				if(i<0x0f)i++;
				meta = (meta&0xff0f)|(i<<4);
				break;
			case 3:							//br
				i = (meta)&0x0f;
				if(i<0x0f)i++;
				meta = (meta&0xfff0)|(i);
				break;
			}
			w.setblockandmeta(d, x, y, z, this.blockID, meta);
		}
		
		if(meta == 0xffff){
			w.setblockandmeta(d, x, y, z, 0, 0);
			return; //bye!
		}
		
		i = (meta>>12)&0x0f;
		i += (meta>>8)&0x0f;
		i += (meta>>4)&0x0f;
		i += (meta)&0x0f;
		metaave = i/4; //MY average meta..
		
		//for water at level and level-1
			//if level < mine-2
				//increase level
					//spread here too! if(level-1 = solid)
		bid = w.getblock(d, x, y-1, z);
		if(bid != blockID && metaave < 14){
			for(j=0;j>=-1;j--){
				for(i=-1;i<=1;i++){
					for(k=-1;k<=1;k++){
						bid = w.getblock(d, x+i, y+j, z+k);
						if(bid == blockID){ //it's water!
							nm = w.getblockmeta(d, x+i, y+j, z+k);
							nma = (nm>>12)&0x0f;
							nma += (nm>>8)&0x0f;
							nma += (nm>>4)&0x0f;
							nma += (nm)&0x0f;
							nma = nma/4; //average meta..
							if(nma > metaave+2+j){
								//it is much lower than we are
								//inc it one all around!
								tv = (nm>>12)&0x0f;
								if(tv > 0)tv--;
								nm &= 0x0fff;
								nm |= (tv<<12);

								tv = (nm>>8)&0x0f;
								if(tv > 0)tv--;
								nm &= 0xf0ff;
								nm |= (tv<<8);

								tv = (nm>>4)&0x0f;
								if(tv > 0)tv--;
								nm &= 0xff0f;
								nm |= (tv<<4);

								tv = (nm)&0x0f;
								if(tv > 0)tv--;
								nm &= 0xfff0;
								nm |= (tv);
								w.setblockandmeta(d, x+i, y+j, z+k, blockID, nm);							

							}
						}
						if(bid == 0 || Blocks.isLeaves(bid)){
							Blocks.doBreakBlock(bid, w, d, x+i, y+j, z+k);
							w.setblockandmeta(d, x+i, y+j, z+k, blockID, 0xeeee); //start small!
						}
					}
				}
			}
		}

	}
	
	//public boolean leftClickOnBlock(Player p, int dimension, int x, int y, int z){
	//	return false; // can't hit me!
	//}
	

}
