package dangerzone;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


import java.util.Properties;

import org.newdawn.slick.opengl.Texture;

import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.items.Item;
import dangerzone.items.Items;



public class InventoryContainer {
	public int count;
	public int bid;
	public int iid;
	public int currentuses = 0;
	
	public InventoryContainer(){
		count = bid = iid = 0;
	}
	
	public InventoryContainer(String uniquename, int incount){
		bid = Blocks.findByName(uniquename);
		if(bid == 0){
			iid = Items.findByName(uniquename);
		}
		count = 0;
		if(bid != 0 || iid != 0){
			count = incount;
		}
	}
	
	public InventoryContainer(int inbid, int iniid, int incount, int incurrentuses){
		bid = inbid;
		iid = iniid;
		count = incount;
		currentuses = incurrentuses;
	}
	
	//TODO - add ticking to player inventory?
	
	public void writeSelf(Properties prop, String tag){
		prop.setProperty(String.format("%s%s", tag, "BID"), String.format("%d", bid));
		prop.setProperty(String.format("%s%s", tag, "IID"), String.format("%d", iid));
		prop.setProperty(String.format("%s%s", tag, "count"), String.format("%d", count));
		prop.setProperty(String.format("%s%s", tag, "currentuses"), String.format("%d", currentuses));
	}
	
	public void readSelf(Properties prop, String tag){
		bid = Utils.getPropertyInt(prop, String.format("%s%s", tag, "BID"), 0, Blocks.blocksMAX-1, 0);
		iid = Utils.getPropertyInt(prop, String.format("%s%s", tag, "IID"), 0, Items.itemsMAX-1, 0);
		count = Utils.getPropertyInt(prop, String.format("%s%s", tag, "count"), 0, 128, 1);
		currentuses = Utils.getPropertyInt(prop, String.format("%s%s", tag, "currentuses"), 0, Integer.MAX_VALUE, 0);
	}
	
	public Texture getTexture(){
		if(count <= 0)return null;
		if(bid!=0)return Blocks.getTexture(bid);
		if(iid!=0)return Items.getTexture(iid);
		return null;
	}
	
	public String getUniqueName(){
		if(count <= 0)return null;
		if(bid!=0)return Blocks.getUniqueName(bid);
		if(iid!=0)return Items.getUniqueName(iid);
		return null;
	}
	
	public int getMaxStack(){
		if(bid!=0)return Blocks.getMaxStack(bid);
		if(iid!=0)return Items.getMaxStack(iid);
		return 1;
	}
	
	public Item getItem(){
		if(bid != 0)return null;
		return Items.getItem(iid);		
	}
	
	public Block getBlock(){
		if(iid != 0)return null;
		return Blocks.getBlock(bid);		
	}

}
