package dangerzone.threads;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import javax.imageio.ImageIO;

import dangerzone.Chunk;
import dangerzone.CommandHandler;
import dangerzone.Coords;
import dangerzone.CustomPackets;
import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.PacketTypes;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ColoringBlock;
import dangerzone.entities.Entities;
import dangerzone.entities.Entity;
import dangerzone.items.Items;


public class ServerThread implements Runnable {
	
	public Player p;
	ObjectInputStream objectInput = null;;
	ObjectOutputStream objectOutput = null;
	BufferedOutputStream bufobjectOutput = null;
	BufferedInputStream bufobjectInput = null;
	private volatile int blockcount = 0;
	private volatile int particlecount = 0;
	private volatile int chunkcount = 0;
	private Lock lock = new ReentrantLock(); //send lock so we don't intertwine packets!
	private Lock lightinglock = new ReentrantLock();
	public volatile int fatal_error = 0;
	private volatile int updatecount = 0;
	private volatile int ready = 0;
	private volatile boolean lightready = false;
	private volatile float lightvalue = 0.0f;
	private int save_ticker = 0;
	private ChunkSender chunker = null;
	
	
	ServerThread(Player pl){
		p = pl;
		p.server_thread = this;
	}
	
	public void run()  {
		int d, x, y, z, id, iid, meta, pd;
		float px, py, pz, pitch, yaw, roll, mx, my, mz, vol, freq;
		String name = null;
		int which, slot, count, bid, what, uses;
		InventoryContainer ic;
		boolean forceall = false;
		int packettype = 0;
		boolean do_respawn = false;
		
		lock.lock();
		
		try {
			p.toClient.setReceiveBufferSize(1024*128);
		} catch (SocketException e2) {
			e2.printStackTrace();
		}
		
		try {
			p.toClient.setSendBufferSize(1024*1024*10);
		} catch (SocketException e2) {
			e2.printStackTrace();
		}
		
		try {
			p.toClient.setSoTimeout(10000); //ten seconds is more than enough. Then fail and give up!
		} catch (SocketException e2) {
			e2.printStackTrace();
		} 
		
		
		//System.out.printf("Got connection!\n");
		try {
			bufobjectInput = new BufferedInputStream(p.toClient.getInputStream(), 1024*128);
			objectInput = new ObjectInputStream(bufobjectInput);	
			packettype = objectInput.readInt();	
			if(packettype != PacketTypes.CONNECT){
				objectInput.close();
				return;
			}
			
			bufobjectOutput = new BufferedOutputStream(p.toClient.getOutputStream(), 1024*128);
			objectOutput = new ObjectOutputStream(bufobjectOutput);
			
			//version check!!!
			String clientversion = (String) objectInput.readObject();
			if(clientversion.equals(DangerZone.versionstring)){
				objectOutput.writeObject(DangerZone.versionstring);
				objectOutput.flush();
				packettype = objectInput.readInt();	//fetch whether clients wants to sync up...
				String playername = (String) objectInput.readObject();	//get my name!
				if(packettype != 0){
					//Now send back the items, blocks, and dimension IDs we are using!								
					getSkin();
					sendModNames();
					sendServerIDs();
					//Now find a new name for this player if we need to!
					if(playername.equals("Player") || DangerZone.server.entityManager.findPlayerByName(playername)!= null){
						while(true){
							String newname = String.format("Player %d", DangerZone.rand.nextInt(1000));
							if(DangerZone.server.entityManager.findPlayerByName(newname)==null){
								playername = newname;
								break;
							}
						}
					}
					objectOutput.writeObject(playername);
					objectOutput.flush();				
				}
				
				p.myname = playername;
				p.setPetName(playername);
				do_respawn = loadPlayer(p);
				p.myname = playername;
				p.setPetName(playername);
				
				//System.out.printf("Player load\n");
				p.world = DangerZone.server_world;
				p.init();
				if(p.getHealth() <= 0){
					//System.out.printf("player was dead.\n");
					p.setHealth(p.getMaxHealth());
					p.setExperience(0);
					for(int iw=0;iw<p.maxinv;iw++){
						p.setVarInventory(iw, null); //just to make sure!
					}
					do_respawn = true;
				}

				
				//Send FULL player info back to client!
				sendPlayerToPlayer(p);

				id = DangerZone.server.entityManager.addEntity(p); //get an entity ID to respond with!
				if(id <= 0){
					fatal_error = 1;
				}else{
					objectOutput.writeInt(p.entityID);
					objectOutput.flush();
				}
			}else{
				objectOutput.writeObject(DangerZone.versionstring);
				objectOutput.flush();
				fatal_error = 1;
			}
		} catch (IOException e) {
			System.out.printf("ServerThread client connection failed...\n");
			fatal_error = 1;
		} catch (ClassNotFoundException e) {
			System.out.printf("ServerThread client connection failed...\n");
			fatal_error = 1;
		}

		//Fire up a chunk sender!
		chunker = new ChunkSender(p, this);
		Thread cnk = new Thread(chunker);
		cnk.start();	
		
		ready = 1;
		
		lock.unlock();
		
		
		if(do_respawn){
			//System.out.printf("player respawn.\n");
			p.posx += (DangerZone.server_world.rand.nextFloat()-DangerZone.server_world.rand.nextFloat())*64f;
			p.posz += (DangerZone.server_world.rand.nextFloat()-DangerZone.server_world.rand.nextFloat())*64f;
			Dimensions.DimensionArray[p.dimension].teleportToDimension(p, DangerZone.server_world, p.dimension, (int)p.posx, (int)p.posy, (int)p.posz);
			sendTeleportToPlayer(p.dimension, p.posx, p.posy, p.posz); //Let him know he's been moved!
		}
		
		try {

			while(DangerZone.gameover == 0 && fatal_error == 0){

				//System.out.printf("Waiting for an int...\n");

				packettype = objectInput.readInt();

				//-------------------------------------------------------------------------------------
				if(packettype == PacketTypes.GETCHUNK){ //Wants a decorated chunk!

					d = objectInput.readInt();
					x = objectInput.readInt();
					y = objectInput.readInt();
					z = objectInput.readInt();
					
					//Send chunk request off to the thread that handles them...
					//No reason to clog up and delay the network here!
					Coords cl = new Coords();
					cl.d = d;
					cl.x = x >> 4;
					cl.z = z >> 4;
					chunker.addCoords(cl);
					continue;
				}
				
				//-------------------------------------------------------------------------------------
				if(packettype == PacketTypes.BLOCK){ //Telling us a block changed
					d = objectInput.readInt();
					x = objectInput.readInt();
					y = objectInput.readInt();
					z = objectInput.readInt();
					id = objectInput.readInt();
					meta = objectInput.readInt();
					//System.out.printf("Block changed %d,  %d, %d : %d\n", x>>4, y, z>>4, id);
					DangerZone.server_world.setblockandmeta(d, x, y, z, id, meta);
					DangerZone.server.sendBlockToAllExcept(this, d, x, y, z, id, meta);
					continue;
				}
				
				
				//-------------------------------------------------------------------------------------
				if(packettype == PacketTypes.LIGHTINGREQUEST){ //Response to a lighting request
					lightvalue = objectInput.readFloat();
					lightready = true;
					continue;
				}

				//-------------------------------------------------------------------------------------
				if(packettype == PacketTypes.INVENTORYUPDATE){ //Telling us inventory changed (should be obsolete already...)
					which = objectInput.readInt();
					slot = objectInput.readInt();
					bid = objectInput.readInt();
					iid = objectInput.readInt();
					count = objectInput.readInt();
					uses = objectInput.readInt();
					if(count == 0){
						ic = null;
					}else{
						ic = new InventoryContainer();
						ic.bid = bid;
						ic.iid = iid;
						ic.count = count;
						ic.currentuses = uses;
					}
					if(which == 0){
						p.setHotbar(slot, ic);
					}
					if(which == 1){
						p.setInventory(slot, ic);
					}
					continue;
				}
				
				//-------------------------------------------------------------------------------------
				if(packettype == PacketTypes.PLAYERACTION){ //Telling player did something
					which = objectInput.readInt();
					what = objectInput.readInt();
					d = objectInput.readInt(); //entityID
					if(which == 0){ //Player click
						DangerZone.server.sendPlayerActionToAllExcept(p, which, what);
						if(what == 0)p.leftclick(DangerZone.server_world, 0, 0, 0, d); //Do it! (see if we hit an ENTITY)
						if(what == 1)p.rightclick(DangerZone.server_world, 0, 0, 0, 0, d); //Do it! (see if we hit an ENTITY)
					}	
					continue;
				}
				
				//------------------------------------------------------------------------------------------
				if(packettype == PacketTypes.CHATMESSAGE){ //Chat!
					String s = (String) objectInput.readObject();
					DangerZone.server.sendChatToAll(s); //got from single client, send out to all
					continue;
				}
				
				//------------------------------------------------------------------------------------------
				if(packettype == PacketTypes.PETNAME){ //name a pet
					int whichpet = objectInput.readInt();
					int namelen = objectInput.readInt();
					String s = null;
					if(namelen > 0)s = (String) objectInput.readObject();
					Entity ent = DangerZone.server.entityManager.findEntityByID(whichpet);
					if(ent != null){
						ent.setPetName(s);
					}							
					continue;
				}
				
				//------------------------------------------------------------------------------------------
				if(packettype == PacketTypes.COMMANDMESSAGE){ //Chat!
					String s = (String) objectInput.readObject();
					
					//DO COMMAND!
					CommandHandler.doCommand(p, s);					
					DangerZone.server.sendCommandToAll(s); //got from single client, send out to all
					continue;
				}
				
				//------------------------------------------------------------------------------------------
				if(packettype == PacketTypes.SPAWNPARTICLES){ //Chat!
					String s = (String) objectInput.readObject();
					which = objectInput.readInt(); //really how many!
					d = objectInput.readInt(); //dimension
					px = objectInput.readFloat();
					py = objectInput.readFloat();
					pz = objectInput.readFloat();	
					DangerZone.server.sendSpawnParticleToAllExcept(p, s, which, d, px, py, pz); //got from single client, send out to all except self
					continue;
				}
				
				//------------------------------------------------------------------------------------------
				if(packettype == PacketTypes.PLAYERTELEPORT){ 
					d = objectInput.readInt(); //dimension
					px = objectInput.readFloat();
					py = objectInput.readFloat();
					pz = objectInput.readFloat();	
					Utils.doTeleport(p, d, px, py, pz);				
					continue;
				}
				
				//-------------------------------------------------------------------------------------
				//SHOULD ONLY BE RECEIVING PLAYER...
				if(packettype == PacketTypes.ENTITYUPDATE){ //Yay!
					d = objectInput.readInt(); //throw away - because it should ONLY BE ME!
					//Entity ex = DangerZone.server.entityManager.findEntityByID(d);
					//if(ex != null){
					//	if(!(ex instanceof Player))System.out.printf("WTF NOT player?\n");
					//}
					d = objectInput.readInt(); //If dimension changes, we have to tell everyone!!!
					forceall = false;
					if(d != p.dimension)forceall = true;
					p.dimension = d;					
					p.posx = objectInput.readFloat();
					p.posy = objectInput.readFloat();
					p.posz = objectInput.readFloat();
					p.motionx = objectInput.readFloat();
					p.motiony = objectInput.readFloat();
					p.motionz = objectInput.readFloat();
					p.rotation_pitch = objectInput.readFloat();
					p.rotation_yaw = objectInput.readFloat();
					p.rotation_roll = objectInput.readFloat();
					p.rotation_pitch_head = objectInput.readFloat();
					p.rotation_yaw_head = objectInput.readFloat();
					p.rotation_roll_head = objectInput.readFloat();
					p.rotation_pitch_motion = objectInput.readFloat();
					p.rotation_yaw_motion = objectInput.readFloat();
					p.rotation_roll_motion = objectInput.readFloat();
					d = objectInput.readInt();
					if(d != 0){
						p.deadflag = true;
					}else{
						p.deadflag = false;
					}
					readVarsIntoEntity(p);
					//System.out.printf("Server fire = %d,  %d, %d\n", p.getOnFire(), p.changed, p.changes[9]);
					
					save_ticker++;
					if(save_ticker > 600){ //about once a minute
						savePlayer(p);
						save_ticker = 0;
					}

					//Tell all the other players!
					DangerZone.server.sendPlayerUpdateToAllExcept(p, p, forceall);
					continue;
				}
				
				//-------------------------------------------------------------------------------------
				if(packettype == PacketTypes.SPAWNENTITY){ //			
					name = (String) objectInput.readObject();
					pd = objectInput.readInt();
					px = objectInput.readFloat();
					py = objectInput.readFloat();
					pz = objectInput.readFloat();					
					pitch = objectInput.readFloat();
					yaw = objectInput.readFloat();
					roll = objectInput.readFloat();
					mx = objectInput.readFloat();
					my = objectInput.readFloat();
					mz = objectInput.readFloat();
					Entity e = doSpawnEntity(name, pd, px, py, pz, pitch, yaw, roll, mx, my, mz);
					if(e != null){
						readVarsIntoEntity(e);
						e.init();
						if(DangerZone.server.entityManager.addEntity(e) > 0){
							DangerZone.server.sendSpawnEntityToAll(e);
						}
					}else{
						readVarsIntoNull();
					}
					continue;
				}
				
				//-------------------------------------------------------------------------------------
				if(packettype == PacketTypes.PLAYSOUND){ //						
					name = (String) objectInput.readObject();					
					pd = objectInput.readInt();
					px = objectInput.readFloat();
					py = objectInput.readFloat();
					pz = objectInput.readFloat();					
					vol = objectInput.readFloat();
					freq = objectInput.readFloat();
					DangerZone.server.sendSoundToAllExcept(p, name, pd, px, py, pz, vol, freq); //client will play his own!		
					continue;
				}
				
				//-------------------------------------------------------------------------------------
				if(packettype == PacketTypes.WHATISTHISENTITY){ //								
					id = objectInput.readInt(); //Client is asking what this is!				
					Entity e = DangerZone.server.entityManager.findEntityByID(id);
					if(e != null){
						sendSpawnEntityToPlayer(e); //Respond with a spawn command.
						if(e instanceof Player){
							sendSkinToPlayer(e);
						}
					}
					continue;
				}				
				
				//-------------------------------------------------------------------------------------
				if(packettype == PacketTypes.KILLME){ //								
					id = objectInput.readInt(); //Kill this thing...	
					Entity e = DangerZone.server.entityManager.findEntityByID(id);
					if(e != null){
						int ieid = DangerZone.server.entityManager.removeEntityByID(id);
						e.deadflag = true;
						if(ieid == id){
							DangerZone.server.sendEntityDeathToAll(e);
						}
					}
					continue;
				}
				
				//-------------------------------------------------------------------------------------
				if(packettype == PacketTypes.COLORINGBLOCK){ //			
					iid = objectInput.readInt(); //really bid
					d = objectInput.readInt();
					x = objectInput.readInt();
					y = objectInput.readInt();
					z = objectInput.readInt();
					float colordata[][][] = new float[16][16][4];
					for(int i=0;i<16;i++){
						for(int j=0;j<16;j++){
							for(int k=0;k<4;k++){
								colordata[i][j][k] = objectInput.readFloat();
							}
						}
					}
					doSaveColoringBlock(iid, d, x, y, z, colordata);					
					continue;
				}
				
				//-------------------------------------------------------------------------------------
				//hopefully it's a custom packet!
				CustomPackets.messageFromClient(packettype, this.p, objectInput);
				
			}
		} catch (ClassNotFoundException e1) {
			fatal_error = 1;
		} catch (IOException e1) {
			//	System.out.printf("ServerThread barfed on read. Did client exit?\n");
			fatal_error = 1;
		}
		
		savePlayer(p);
		
		DangerZone.server.sendEntityRemoveToAllExcept(this.p, this.p);
		DangerZone.server.entityManager.removeEntityByID(this.p.entityID);		
		DangerZone.server.removeMe(this);
		
		try {
			if(objectInput != null)objectInput.close();
		} catch (IOException e) {

		}
		try {
			if(objectOutput != null)objectOutput.close();
		} catch (IOException e) {

		}
		try {
			p.toClient.close();
		} catch (IOException e) {

		}
		
		//let the chunker know we are leaving!
		fatal_error = 1;
		
	}
	
	private void checkReady(){
		while(true && fatal_error == 0 && DangerZone.gameover == 0){
			if(ready != 0)return;
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				e.printStackTrace();
				fatal_error = 1;
			}
		}
	}
	
	public void sendSpawnEntityToPlayer(Entity e){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();	
		try {
			int pt = PacketTypes.SPAWNENTITY;
			int i;
			objectOutput.writeInt(pt);
			objectOutput.writeObject(e.uniquename);
			objectOutput.writeInt(e.entityID);
			objectOutput.writeInt(e.dimension);
			objectOutput.writeFloat(e.posx);
			objectOutput.writeFloat(e.posy);
			objectOutput.writeFloat(e.posz);
			objectOutput.writeFloat(e.rotation_pitch);
			objectOutput.writeFloat(e.rotation_yaw);
			objectOutput.writeFloat(e.rotation_roll);
			objectOutput.writeFloat(e.rotation_pitch_head);
			objectOutput.writeFloat(e.rotation_yaw_head);
			objectOutput.writeFloat(e.rotation_roll_head);
			objectOutput.writeFloat(e.motionx);
			objectOutput.writeFloat(e.motiony);
			objectOutput.writeFloat(e.motionz);
			
			//bang out ints
			for(i=0;i<e.maxvars;i++){
				if(e.entity_ints[i] != 0){
					objectOutput.writeInt(i);
					objectOutput.writeInt(e.entity_ints[i]);						
				}
			}
			pt = -1; //packet separator
			objectOutput.writeInt(pt);

			//bang out floats
			for(i=0;i<e.maxvars;i++){
				if(e.entity_floats[i] != 0){
					objectOutput.writeInt(i);
					objectOutput.writeFloat(e.entity_floats[i]);						
				}
			}
			pt = -1; //packet separator
			objectOutput.writeInt(pt);

			//bang out strings
			for(i=0;i<e.maxvars;i++){
				if(e.entity_strings[i] != null){
					objectOutput.writeInt(i);
					objectOutput.writeObject(e.entity_strings[i]);						
				}
			}
			pt = -1; //packet separator
			objectOutput.writeInt(pt);	
			
			InventoryContainer ic = null;
			for(i=0;i<e.maxinv;i++){
				ic = e.getVarInventory(i);
				if(ic != null){
					objectOutput.writeInt(i);
					objectOutput.writeInt(ic.bid);
					objectOutput.writeInt(ic.iid);
					objectOutput.writeInt(ic.count);
					objectOutput.writeInt(ic.currentuses);
				}				
			}				
			pt = -1; //packet separator
			objectOutput.writeInt(pt);
			
			pt = -2; //packet terminator!
			objectOutput.writeInt(pt);
			
			flushSendLocked();
		} catch (IOException err) {
			//System.out.printf("Server spawnEntity send failed.\n");
			fatal_error = 1;
		} 
		lock.unlock();
	}
	
	public void sendChunkToPlayer(Chunk c){
		checkReady();
		DangerZone.packets_per_second++;
		DangerZone.chunks_per_second++;
		lock.lock();
		if(chunkcount > 20){ //20 is enough
			flushSendLocked();
		}
		chunkcount++;
		int pt = PacketTypes.CHUNK;
		short curval;
		short curcount;
		int indx;

		try {
			int separator = -1;
			int i;
			objectOutput.writeInt(pt); //packet type
			objectOutput.writeInt(c.chunkX);
			objectOutput.writeInt(c.chunkZ);
			objectOutput.writeInt(c.dimension);
			objectOutput.writeInt(c.isDecorated);
			objectOutput.writeInt(c.isChanged);
			objectOutput.writeInt(c.isValid);
			objectOutput.writeInt(c.must_be_written);
			
			objectOutput.writeInt(separator);
			
			for(i=0;i<256;i++){
				if(c.blockdata[i] != null){
					objectOutput.writeInt(i); //current index
					//old way
					//sending a 50*50 chunk cache of the world is the equivalent of sending about 100MB of data. (2500 *40K)
					//not fast
					//objectOutput.writeObject(c.blockdata[i]);
					//
					//new way
					//cheap and dirty run-length encoding
					//very fast
					//
					curval = c.blockdata[i][0];
					curcount = 0;
					for(indx=0;indx<256;indx++){
						if(c.blockdata[i][indx] == curval){
							curcount++;
						}else{
							objectOutput.writeShort(curcount);
							objectOutput.writeShort(curval);
							curcount = 1;
							curval = c.blockdata[i][indx];
						}						
					}					
					objectOutput.writeShort(curcount);
					objectOutput.writeShort(curval);
					
				}
			}
			
			objectOutput.writeInt(separator);
			
			for(i=0;i<256;i++){
				if(c.metadata[i] != null){
					objectOutput.writeInt(i);
					objectOutput.writeObject(c.metadata[i]);
				}
			}
			
			objectOutput.writeInt(separator);
			
			//flushSendLocked();
			
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}

		lock.unlock();
	}
	

	public void sendBlockToPlayer(int d, int x, int y, int z, int id, int meta){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		//System.out.printf("Sending block\n");
		if(blockcount > 200){ //200 is enough
			//DangerZone.packets_per_second++;
			//System.out.printf("Sending %d blocks\n", blockcount);
			flushSendLocked();
		}
		blockcount++;
		
		int pt = PacketTypes.BLOCK;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeInt(d);
			objectOutput.writeInt(x);
			objectOutput.writeInt(y);
			objectOutput.writeInt(z);
			objectOutput.writeInt(id);
			objectOutput.writeInt(meta);

			//DON'T FLUSH!
			//objectOutput.flush();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}

		lock.unlock();
	}
	
	public void sendEntityDeathToPlayer(int eid){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		int pt = PacketTypes.ENTITYDEATH;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeInt(eid);
			flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	public void sendChatToPlayer(String s){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		int pt = PacketTypes.CHATMESSAGE;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeObject(s);
			flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	public void sendCommandToPlayer(String s){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		int pt = PacketTypes.COMMANDMESSAGE;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeObject(s);
			flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	public void sendSpawnParticleToPlayer(String s, int hm, int d, float x, float y, float z){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		if(particlecount > 500){ //500 is enough
			//DangerZone.packets_per_second++;
			//System.out.printf("Sending %d blocks\n", blockcount);
			flushSendLocked();
		}
		particlecount++;
		int pt = PacketTypes.SPAWNPARTICLES;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeObject(s);
			objectOutput.writeInt(hm);
			objectOutput.writeInt(d);
			objectOutput.writeFloat(x);
			objectOutput.writeFloat(y);
			objectOutput.writeFloat(z);
			//let them stack together a little....   //flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	public void sendVelocityUpdateToPlayer(float newx, float newy, float newz){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		int pt = PacketTypes.PLAYERVELOCITY;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeFloat(newx);
			objectOutput.writeFloat(newy);
			objectOutput.writeFloat(newz);
			flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	public void sendTeleportToPlayer(int dim, float newx, float newy, float newz){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		int pt = PacketTypes.PLAYERTELEPORT;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeInt(dim);
			objectOutput.writeFloat(newx);
			objectOutput.writeFloat(newy);
			objectOutput.writeFloat(newz);
			flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	public void sendEntityRemoveToPlayer(int eid){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		int pt = PacketTypes.ENTITYREMOVE;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeInt(eid);
			flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	public float doLightingRequest(int d, int x, int y, int z){
		checkReady();
		DangerZone.packets_per_second++;
		//System.out.printf("trying for light\n");
		lightinglock.lock();
		lightready = false;
		lightvalue = DangerZone.server_world.rand.nextFloat();
		lock.lock();
		int pt = PacketTypes.LIGHTINGREQUEST;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeInt(d);
			objectOutput.writeInt(x);
			objectOutput.writeInt(y);
			objectOutput.writeInt(z);
			flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
			lock.unlock();
			return 0.0f;
		}
		lock.unlock();
		
		int tries = 100; //Don't try too hard!!!
		while(tries > 0 && !lightready){
			try {
				Thread.sleep(1);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			tries--;
		}
		//System.out.printf("got %f after %d tries\n",  lightvalue, 2000-tries);
		
		//these don't happen very frequently, or I'd have to do something less kludgy...
		float lv = lightvalue;		
		lightready = false; //done!
		lightinglock.unlock();
		return lv;
	}
	
	public void sendEntityHitToPlayer(int eid, float newhealth){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		int pt = PacketTypes.ENTITYHIT;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeInt(eid);
			objectOutput.writeFloat(newhealth);
			flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	public void sendPlayerAction(Player p, int which, int what){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();		
		try {
			int pt = PacketTypes.PLAYERACTION;
			objectOutput.writeInt(pt);
			objectOutput.writeInt(p.entityID);
			objectOutput.writeInt(which);
			objectOutput.writeInt(what);
			flushSendLocked();
		} catch (IOException e) {
			//System.out.printf("Client entity playeraction send failed.\n");
			fatal_error = 1;
		} 
		lock.unlock();
	}
	
	public void sendExpAdjust(int what){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();		
		try {
			int pt = PacketTypes.ADJUSTEXP;
			objectOutput.writeInt(pt);
			objectOutput.writeInt(what);
			flushSendLocked();
		} catch (IOException e) {
			//System.out.printf("Client entity playeraction send failed.\n");
			fatal_error = 1;
		} 
		lock.unlock();
	}
	
	public void sendVarIntUpdate(int which, int val){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();		
		try {
			int pt = PacketTypes.VARINTUPDATE;
			objectOutput.writeInt(pt);
			objectOutput.writeInt(which);
			objectOutput.writeInt(val);
			flushSendLocked();
		} catch (IOException e) {
			//System.out.printf("Client entity playeraction send failed.\n");
			fatal_error = 1;
		} 
		lock.unlock();
	}
	
	public void sendVarFloatUpdate(int which, float val){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();		
		try {
			int pt = PacketTypes.VARFLOATUPDATE;
			objectOutput.writeInt(pt);
			objectOutput.writeInt(which);
			objectOutput.writeFloat(val);
			flushSendLocked();
		} catch (IOException e) {
			//System.out.printf("Client entity playeraction send failed.\n");
			fatal_error = 1;
		} 
		lock.unlock();
	}
	
	public void sendMountCommand(int which){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();		
		try {
			int pt = PacketTypes.MOUNTENTITY;
			objectOutput.writeInt(pt);
			objectOutput.writeInt(which);
			flushSendLocked();
		} catch (IOException e) {
			//System.out.printf("Client entity playeraction send failed.\n");
			fatal_error = 1;
		} 
		lock.unlock();
	}
	
	public void sendInventoryUpdateToPlayer(int which, int slot, InventoryContainer ic){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		int pt = PacketTypes.INVENTORYUPDATE;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeInt(which);
			objectOutput.writeInt(slot);
			if(ic != null){
				objectOutput.writeInt(ic.bid);
				objectOutput.writeInt(ic.iid);
				objectOutput.writeInt(ic.count);
				objectOutput.writeInt(ic.currentuses);
			}else{
				pt = 0;
				objectOutput.writeInt(pt);
				objectOutput.writeInt(pt);
				objectOutput.writeInt(pt);
				objectOutput.writeInt(pt);
			}
			flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	public void sendEntityUpdateToPlayer(Entity e){
		checkReady();
		if(e.entityID == p.entityID)return; //NOT self!!!
		
		DangerZone.packets_per_second++;
		lock.lock();
				
		if(updatecount > 100){
			flushSendLocked();
		}
		updatecount++;
		
		int pt = PacketTypes.ENTITYUPDATE;
		int i;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeInt(e.entityID);
			objectOutput.writeInt(e.dimension);
			objectOutput.writeFloat(e.posx);
			objectOutput.writeFloat(e.posy);
			objectOutput.writeFloat(e.posz);
			objectOutput.writeFloat(e.motionx);
			objectOutput.writeFloat(e.motiony);
			objectOutput.writeFloat(e.motionz);
			objectOutput.writeFloat(e.rotation_pitch);
			objectOutput.writeFloat(e.rotation_yaw);
			objectOutput.writeFloat(e.rotation_roll);
			objectOutput.writeFloat(e.rotation_pitch_head);
			objectOutput.writeFloat(e.rotation_yaw_head);
			objectOutput.writeFloat(e.rotation_roll_head);
			objectOutput.writeFloat(e.rotation_pitch_motion);
			objectOutput.writeFloat(e.rotation_yaw_motion);
			objectOutput.writeFloat(e.rotation_roll_motion);
			if(e.deadflag){
				pt = 1;
				objectOutput.writeInt(pt);
			}else{
				pt = 0;
				objectOutput.writeInt(pt);
			}
			
			//The *ToAll* routine will clear the changed flags when it is done.
			if(e.changed != 0){
				//bang out ints that changed
				for(i=0;i<e.maxvars;i++){
					if((e.changes[i]&0x01) == 0x01){
						objectOutput.writeInt(i);
						objectOutput.writeInt(e.entity_ints[i]);						
					}
				}
				pt = -1; //packet separator
				objectOutput.writeInt(pt);
				
				//bang out floats that changed
				for(i=0;i<e.maxvars;i++){
					if((e.changes[i]&0x02) == 0x02){
						objectOutput.writeInt(i);
						objectOutput.writeFloat(e.entity_floats[i]);						
					}
				}
				pt = -1; //packet separator
				objectOutput.writeInt(pt);
				
				//bang out strings that changed
				for(i=0;i<e.maxvars;i++){
					if((e.changes[i]&0x04) == 0x04){
						objectOutput.writeInt(i);
						objectOutput.writeObject(e.entity_strings[i]);						
					}
				}
				pt = -1; //packet separator
				objectOutput.writeInt(pt);
				
				InventoryContainer ic = null;
				for(i=0;i<e.maxinv;i++){
					if((e.changes[i]&0x08) == 0x08){
						objectOutput.writeInt(i);
						ic = e.getVarInventory(i);
						if(ic != null){
							objectOutput.writeInt(ic.bid);
							objectOutput.writeInt(ic.iid);
							objectOutput.writeInt(ic.count);
							objectOutput.writeInt(ic.currentuses);
						}else{
							pt = 0;
							objectOutput.writeInt(pt);
							objectOutput.writeInt(pt);
							objectOutput.writeInt(pt);
							objectOutput.writeInt(pt);
						}
					}
				}				
				pt = -1; //packet separator
				objectOutput.writeInt(pt);
							
			}
			
			pt = -2; //packet terminator!
			objectOutput.writeInt(pt);
								
			//objectOutput.flush();
		} catch (IOException ex) {
			//ex.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();

	}
	
	//Server just read/created player. Send complete into back to them.
	public void sendPlayerToPlayer(Player e){

		int pt = 0;
		
		
		try {
			objectOutput.writeInt(e.dimension);
			objectOutput.writeFloat(e.posx);
			objectOutput.writeFloat(e.posy);
			objectOutput.writeFloat(e.posz);
			objectOutput.writeFloat(e.motionx);
			objectOutput.writeFloat(e.motiony);
			objectOutput.writeFloat(e.motionz);
			objectOutput.writeFloat(e.rotation_pitch);
			objectOutput.writeFloat(e.rotation_yaw);
			objectOutput.writeFloat(e.rotation_roll);
			objectOutput.writeFloat(e.rotation_pitch_head);
			objectOutput.writeFloat(e.rotation_yaw_head);
			objectOutput.writeFloat(e.rotation_roll_head);
			objectOutput.writeFloat(e.rotation_pitch_motion);
			objectOutput.writeFloat(e.rotation_yaw_motion);
			objectOutput.writeFloat(e.rotation_roll_motion);

			if(e.deadflag){
				pt = 1;
				objectOutput.writeInt(pt);
			}else{
				pt = 0;
				objectOutput.writeInt(pt);
			}
			
			//if(e.changed != 0){
				//bang out ints that changed
				for(int i=0;i<e.maxvars;i++){
					//if((e.changes[i]&0x01) == 0x01){
						objectOutput.writeInt(i);
						objectOutput.writeInt(e.entity_ints[i]);						
					//}
				}
				pt = -1; //packet separator
				objectOutput.writeInt(pt);
				
				//bang out floats that changed
				for(int i=0;i<e.maxvars;i++){
					//if((e.changes[i]&0x02) == 0x02){
						objectOutput.writeInt(i);
						objectOutput.writeFloat(e.entity_floats[i]);						
					//}
				}
				pt = -1; //packet separator
				objectOutput.writeInt(pt);
				
				//bang out strings that changed
				for(int i=0;i<e.maxvars;i++){
					//if((e.changes[i]&0x04) == 0x04){
						objectOutput.writeInt(i);
						objectOutput.writeObject(e.entity_strings[i]);						
					//}
				}
				pt = -1; //packet separator
				objectOutput.writeInt(pt);
				
				InventoryContainer ic = null;
				for(int i=0;i<e.maxinv;i++){
					//if((e.changes[i]&0x08) == 0x08){
						objectOutput.writeInt(i);
						ic = e.getVarInventory(i);
						if(ic != null){
							objectOutput.writeInt(ic.bid);
							objectOutput.writeInt(ic.iid);
							objectOutput.writeInt(ic.count);
							objectOutput.writeInt(ic.currentuses);
						}else{
							pt = 0;
							objectOutput.writeInt(pt);
							objectOutput.writeInt(pt);
							objectOutput.writeInt(pt);
							objectOutput.writeInt(pt);
						}
					//}
				}				
				pt = -1; //packet separator
				objectOutput.writeInt(pt);
							
			//}
			
			pt = -2; //packet terminator!
			objectOutput.writeInt(pt);
								
			//objectOutput.flush();
		} catch (IOException ex) {
			//ex.printStackTrace();
			fatal_error = 1;
		}

	}
	
	public void sendTimeToPlayer(int t, int l){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();
		int pt = PacketTypes.TIME;
		try {
			objectOutput.writeInt(pt);
			objectOutput.writeInt(t);
			objectOutput.writeInt(l);
			flushSendLocked();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	//Called from outside
	public void flushSend(){
		checkReady();
		lock.lock();
		try {
			blockcount = 0;
			updatecount = 0;
			chunkcount = 0;
			particlecount = 0;
			objectOutput.flush();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
		lock.unlock();
	}
	
	//internal
	public void flushSendLocked(){
		try {
			blockcount = 0;
			updatecount = 0;
			particlecount = 0;
			chunkcount = 0;
			objectOutput.flush();
		} catch (IOException e) {
			//e.printStackTrace();
			fatal_error = 1;
		}
	}
	
	
	public Entity doSpawnEntity(String name, int pd, float px, float py, float pz, float pitch, float yaw, float roll, float mx, float my, float mz){
		Entity e = Entities.spawnEntityByName(name, DangerZone.server_world);
		if(e != null){
			e.posx = px;
			e.posy = py;
			e.posz = pz;
			e.rotation_pitch = pitch;
			e.rotation_yaw = yaw;
			e.rotation_roll = roll;
			e.rotation_pitch_head = pitch;
			e.rotation_yaw_head = yaw;
			e.rotation_roll_head = roll;
			e.motionx = mx;
			e.motiony = my;
			e.motionz = mz;
			e.dimension = pd;
			//e.init();
			//if(DangerZone.server.entityManager.addEntity(e) <= 0)return null; //oops! Nevermind!
		}
		return e;
	}
	
	//track changes in (player) so that they are forwarded to all!
	private void readVarsIntoEntity(Entity ent){
		int index;
		try {
			index = objectInput.readInt();
			if(index != -2){ //contains vars!
				while(index >= 0){
					if(index < ent.maxvars){
						ent.entity_ints[index] = objectInput.readInt();					
						ent.changed = 1;
						ent.changes[index] |= 0x01;
					}
					index = objectInput.readInt();
				}
				//floats that changed
				index = objectInput.readInt();
				while(index >= 0){
					if(index < ent.maxvars){
						ent.entity_floats[index] = objectInput.readFloat();					
						ent.changed = 1;
						ent.changes[index] |= 0x02;
					}
					index = objectInput.readInt();
				}
				//strings that changed
				index = objectInput.readInt();
				while(index >= 0){
					try {
						if(index < ent.maxvars){
							ent.entity_strings[index] = (String) objectInput.readObject();						
							ent.changed = 1;
							ent.changes[index] |= 0x04;
						}
					} catch (ClassNotFoundException e) {
						e.printStackTrace();
						fatal_error = 1;
					}
					index = objectInput.readInt();
				}
				index = objectInput.readInt();
				
				InventoryContainer ic;
				int bid, iid, count, uses;
				while(index >= 0){
					bid = objectInput.readInt();
					iid = objectInput.readInt();
					count = objectInput.readInt();
					uses = objectInput.readInt();
					if(count == 0){
						ic = null;
					}else{
						ic = new InventoryContainer();
						ic.bid = bid;
						ic.iid = iid;
						ic.count = count;
						ic.currentuses = uses;
					}
					ent.setVarInventory(index, ic);
					ent.setVarInventoryChanged(index);
					
					index = objectInput.readInt();
				}
				index = objectInput.readInt();
			}
			if(index != -2){
				System.out.printf("packet terminator failure on enitity update!\n");
				fatal_error = 1;
			}
		} catch (IOException e1) {
			e1.printStackTrace();
			fatal_error = 1;
		}
	}
	
	private void readVarsIntoNull(){
		int index = 0;
		//ints that changed
		try {
			index = objectInput.readInt();
			if(index != -2){ //contains vars!
				while(index >= 0){
					objectInput.readInt();
					index = objectInput.readInt();
				}
				//floats that changed
				index = objectInput.readInt();
				while(index >= 0){
					objectInput.readFloat();
					index = objectInput.readInt();
				}
				//strings that changed
				index = objectInput.readInt();
				while(index >= 0){
					try {
						objectInput.readObject();
					} catch (ClassNotFoundException e) {
						e.printStackTrace();
					}
					index = objectInput.readInt();
				}
				index = objectInput.readInt();
				while(index >= 0){
					objectInput.readInt();
					objectInput.readInt();
					objectInput.readInt();
					objectInput.readInt();
					index = objectInput.readInt();
				}
				index = objectInput.readInt();
			}
		} catch (IOException e1) {
			e1.printStackTrace();
			fatal_error = 1;
		}
		if(index != -2){
			System.out.printf("packet terminator failure on enitity update!\n");
			fatal_error = 1;
		}			
	}
	
	public void sendSound(String name, int pd, float px, float py, float pz, float vol, float freq){
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();	
		try {
			int pt = PacketTypes.PLAYSOUND;
			objectOutput.writeInt(pt);
			objectOutput.writeObject(name);
			objectOutput.writeInt(pd);
			objectOutput.writeFloat(px);
			objectOutput.writeFloat(py);
			objectOutput.writeFloat(pz);
			objectOutput.writeFloat(vol);
			objectOutput.writeFloat(freq);
			
			flushSendLocked();
		} catch (IOException err) {
			//System.out.printf("Server sendsound send failed.\n");
			fatal_error = 1;
		} 
		lock.unlock();
	
	}
	
	/*
	 * Makes sure Client agrees with our IDs!
	 */
	public void sendServerIDs(){
		int i, j;

		try {
			for(i=1;i<Items.itemsMAX;i++){
				if(Items.ItemArray[i] != null){
					objectOutput.writeInt(i);
					objectOutput.writeObject(Items.ItemArray[i].uniquename);
				}
			}
			i = -1;
			objectOutput.writeInt(i); //separator
			
			for(i=1;i<Blocks.blocksMAX;i++){
				if(Blocks.BlockArray[i] != null){
					objectOutput.writeInt(i);
					objectOutput.writeObject(Blocks.BlockArray[i].uniquename);
				}
			}
			i = -1;
			objectOutput.writeInt(i); //separator
			
			for(i=1;i<Dimensions.dimensionsMAX;i++){
				if(Dimensions.DimensionArray[i] != null){
					objectOutput.writeInt(i);
					objectOutput.writeObject(Dimensions.DimensionArray[i].uniquename);
				}
			}
			i = -1;
			objectOutput.writeInt(i); //separator		
			
			for(i=1;i<CustomPackets.CustomPacketsMAX;i++){
				if(CustomPackets.CustomPacketsArray[i] != null){
					objectOutput.writeInt(i);
					objectOutput.writeObject(CustomPackets.CustomPacketsArray[i].uniquename);
				}
			}
			i = -1;
			objectOutput.writeInt(i); //separator	
			
			//Send the coloring blocks!
			String name;
			int bid;
			float colordata[][][] = new float[16][16][4];
			for(bid=1;bid<Blocks.blocksMAX;bid++){
				name = Blocks.getUniqueName(bid);
				if(name != null && name.startsWith("DangerZone:Coloring Block ")){ //notice the space!
					BufferedImage bi = ImageIO.read(new File(Blocks.BlockArray[bid].texturepath));
					if(bi != null){
						int r, g, b, color;
						for(j=0; j<16;j++){
							for(i=0;i<16;i++){
								color = bi.getRGB(i, j);
								r = (color >> 16) & 0xff;
								g = (color >> 8) & 0xff;
								b = (color) & 0xff;								
								colordata[i][15-j][0] = r; 								
								colordata[i][15-j][1] = g; 				
								colordata[i][15-j][2] = b; 
								colordata[i][15-j][3] = 255f;			
							}
						}								
						sendColoringBlock(name, bid, colordata, false);
					}
				}				
			}
			
			i = -1;
			objectOutput.writeInt(i); //separator	
			
			objectOutput.flush();			
		} catch (IOException err) {
			//System.out.printf("Server sendsound send failed.\n");
			fatal_error = 1;
		} 

	}
	
	public void sendModNames(){
		int i = DangerZone.all_the_mods.size();

		try {
			objectOutput.writeInt(i); //write number of mod names
			for(int k=0;k<i;k++){
				String s = DangerZone.all_the_mods.get(k).modname;				
				objectOutput.writeObject(s);
				//System.out.printf("Sent mod name %s\n", s);
			}
			objectOutput.writeObject(DangerZone.worldname);
			objectOutput.flush();			
		} catch (IOException err) {
			//System.out.printf("Server sendsound send failed.\n");
			fatal_error = 1;
		} 

	}
	
	private void getSkin(){
		int seq;
		int len;
		byte b[];
		
		try {
			seq = objectInput.readInt();
			if(seq != -3){
				fatal_error = 1;
				return;
			}
			len = objectInput.readInt();
			b = (byte[]) objectInput.readObject();  //FIX ME! I CRASH!!!!!!
			if(len != b.length){
				fatal_error = 1;
				return;
			}
			
			//System.out.printf("Got skin len = %d\n", len);
			if(len < 8192){
				fatal_error = 1;
				return;
			}
			p.tdata = b; //got it! save it!!!
			
		} catch (IOException | ClassNotFoundException e) {
			e.printStackTrace();
			fatal_error = 1;
		}
	}
	
	private void sendSkinToPlayer(Entity e){
		Player pe = (Player)e;
		
		checkReady();
		DangerZone.packets_per_second++;
		lock.lock();	
		try {
			int pt = pe.tdata.length;
			objectOutput.writeInt(pt);
			objectOutput.writeObject(pe.tdata);			
			flushSendLocked();
		} catch (IOException err) {
			//System.out.printf("Server sendSkinToPlayer failed.\n");
			fatal_error = 1;
		} 
		lock.unlock();
		
		
	}
	
	public ObjectOutputStream getOutputStream(){
		checkReady();
		DangerZone.packets_per_second++;		
		lock.lock();
		return objectOutput;
	}
	
	public void releaseOutputStream(){
		try {
			objectOutput.flush();
		} catch (IOException e) {
			System.out.printf("Server thread barfed on releaseOutputStream. \n");
			fatal_error = 1;
		}	
		lock.unlock();
	}
	

	public static boolean loadPlayer(Player p){
		InputStream input = null;
		Properties playerprop = new Properties();
		String filepath = new String();		
		filepath = String.format("worlds/%s/players/%s.dat", DangerZone.worldname, p.myname);	
		boolean isnew = false;
		try {	 
			input = new FileInputStream(filepath);
	 
			// load a properties file
			playerprop.load(input);

		} catch (IOException ex) {
			//ex.printStackTrace();
			input = null;
			isnew = true;
		}
		if (input != null) {
			try {
				input.close();
			} catch (IOException e) {
				//e.printStackTrace();
			}
		}
		p.readSelf(playerprop, "player:");
		return isnew;
	}
	
	public void storePlayer(){
		p.de_init();
		savePlayer(p);
	}
	
	public static void savePlayer(Player p){
		Properties playerprop = new Properties();
		OutputStream output = null;
		String filepath = new String();		
		filepath = String.format("worlds/%s/players/%s.dat", DangerZone.worldname, p.myname);	
		File f = new File(filepath);		
		f.getParentFile().mkdirs();	
		
		p.writeSelf(playerprop, "player:");
		
		try {	 
			output = new FileOutputStream(filepath);	 

			// save properties
			playerprop.store(output, null);
	 
		} catch (IOException io) {
			io.printStackTrace();
		}
		if (output != null) {
			try {
				output.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}		
	}
	
	public void sendColoringBlock(String name,  int bid, float colordata[][][], boolean check){
		if(check)checkReady();
		DangerZone.packets_per_second++;
		lock.lock();	
		try {
			int pt = PacketTypes.COLORINGBLOCK;
			objectOutput.writeInt(pt);
			objectOutput.writeObject(name);
			objectOutput.writeInt(bid);
			for(int i=0;i<16;i++){
				for(int j=0;j<16;j++){
					for(int k=0;k<4;k++){
						objectOutput.writeFloat(colordata[i][j][k]);
					}
				}
			}
			
			flushSendLocked();
		} catch (IOException err) {
			//System.out.printf("Server sendsound send failed.\n");
			fatal_error = 1;
		} 
		lock.unlock();	
	}
	
	private void doSaveColoringBlock(int bid, int dim, int px, int py, int pz, float colordata[][][]){
		int newbid = bid;
		String blkname = Blocks.getUniqueName(bid);
		if(blkname == null)return;
		if(!blkname.equals("DangerZone:Coloring Block")){ //existing block!
			//Overwrite existing block. Hopefully a coloring block! Doh!
			String fp = Blocks.BlockArray[bid].texturepath;
			if(fp == null)return;
			File file = new File(fp);	
			int width = 16;
			int height = 16;
			String format = "PNG"; 
			BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
			   
			for(int x = 0; x < width; x++){
			    for(int y = 0; y < height; y++){
			        int r = ((int)colordata[x][y][0]) & 0xFF;
			        int g = ((int)colordata[x][y][1]) & 0xFF;
			        int b = ((int)colordata[x][y][2]) & 0xFF;
			        image.setRGB(x, height - (y + 1), (0xFF << 24) | (r << 16) | (g << 8) | b);
			    }
			}
			   
			try {
			    ImageIO.write(image, format, file);
			} catch (IOException e) { e.printStackTrace(); }
			image.flush();
			DangerZone.server.sendColoringBlockToAll(blkname, newbid, colordata);
			return;
		}
		//Have to make a new one.
		int index = 0;
		int blkindex = 0;
		boolean ok = false;
		boolean found = false;
		for(index = 0;index < 100;index++){
			blkname = String.format("DangerZone:Coloring Block %2d", index);
			found = false;
			for(blkindex=1;blkindex<Blocks.blocksMAX;blkindex++){
				if(Blocks.BlockArray[blkindex] != null){
					if(blkname.equals(Blocks.getUniqueName(blkindex))){
						found = true;
						break;
					}
				}
			}			
			if(found)continue;
			ok = true;
			for(blkindex=1;blkindex<Blocks.blocksMAX;blkindex++){
				if(Blocks.BlockArray[blkindex] == null)break;
			}
			break;			
		}
		if(!ok)return; //too many!
		//index = color name
		//blkindex = bid
		String fp = String.format("worlds/%s/coloring/coloringblock%2d.png", DangerZone.worldname, index);
		File file = new File(fp);	
		int width = 16;
		int height = 16;
		String format = "PNG"; 
		BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		file.mkdirs();
		   
		for(int x = 0; x < width; x++){
		    for(int y = 0; y < height; y++){
		        int r = ((int)colordata[x][y][0]) & 0xFF;
		        int g = ((int)colordata[x][y][1]) & 0xFF;
		        int b = ((int)colordata[x][y][2]) & 0xFF;
		        image.setRGB(x, height - (y + 1), (0xFF << 24) | (r << 16) | (g << 8) | b);
		    }
		}
		   
		try {
		    ImageIO.write(image, format, file);
		} catch (IOException e) { e.printStackTrace(); }
		image.flush();
		
		ColoringBlock cb = new ColoringBlock(blkname, "");
		cb.texturepath = file.getAbsolutePath();
		cb.blockID = blkindex;
		Blocks.BlockArray[blkindex] = cb;		//Hope there wasn't anything there! :)
		Blocks.addthis(blkname, blkindex);
		Blocks.save(); //Save it so we can find it when we start again next time.
		
		DangerZone.server.sendColoringBlockToAll(blkname, blkindex, colordata);
		DangerZone.server_world.setblock(dim, px, py, pz, blkindex);
	}

}
