package dangerzone.threads;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;


import dangerzone.DangerZone;
import dangerzone.particles.Particle;


public class ParticleUpdateLoop  implements Runnable   {

	public  List<Particle> particle_list; 	// a list of little things that index into

	public  Lock particle_list_lock = new ReentrantLock();

	public void run()  {
		long lasttime = System.currentTimeMillis();
		long currtime, tlong;
		long loop_interval = DangerZone.entityupdaterate; //millsecs
		float deltaT;
		particle_list = new ArrayList<Particle>();
		Particle ent = null;
		
		//sleep just a little!
		try {
			Thread.sleep(1500);
		} catch (InterruptedException ex) {
			// TODO Auto-generated catch block
			ex.printStackTrace();
			System.exit(1);
		}

		while(true){
			if(DangerZone.gameover != 0)return;
			//Cache cleanup!
			
			currtime = System.currentTimeMillis();
			tlong = currtime - lasttime;
			tlong = loop_interval - tlong;
			if(tlong < 0)tlong = 0;
			if(tlong > loop_interval)tlong = loop_interval;
			if(tlong > 0){
				try {
					Thread.sleep(tlong);
				} catch (InterruptedException ex) {
					// TODO Auto-generated catch block
					ex.printStackTrace();
					System.exit(1);
				}
				currtime = System.currentTimeMillis();
			}
			tlong = currtime - lasttime;
			lasttime = currtime;
			deltaT = tlong;
			if(deltaT < 16)deltaT = 16;
			if(deltaT > 200)deltaT = 200;
			deltaT = deltaT / loop_interval; //Scale!
			
			//These are quick. Just lock the list and hammer on through them!
			particle_list_lock.lock();	
			Iterator<Particle> it = particle_list.iterator();
			while(it.hasNext()){
				ent = (Particle) it.next();
				ent.update(deltaT);
				if(ent.lifetimeticker > ent.maxlifetime || ent.dimension != DangerZone.player.dimension){
					it.remove();
				}				
			}
			particle_list_lock.unlock();

			
		}

	}
	
	//Add a new particle!
	public void addParticle(Particle e){
		particle_list_lock.lock(); 		
		particle_list.add(e);			
		particle_list_lock.unlock();
		return;
	}
	


}
