package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import org.newdawn.slick.opengl.Texture;

import dangerzone.DangerZone;
import dangerzone.ModelBase;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;

public class EntitySpawner extends Entity {
	
	Entity trophyentity = null;
	ModelBase trophymodel = null;
	float trophyscale = 1.0f;
	int timer = 100;

	public EntitySpawner(World w) {
		super(w);
		uniquename = "DangerZone:EntitySpawner";
		ignoreCollisions = true;
		canthitme = true;
		width = 0.25f;
		height = 0.25f;
	}
	
	
	public void update(float deltaT){
		int bid = 0;
		if(trophyentity == null){
			trophyentity = world.createEntityByName(getVarString(0), dimension, posx, posy, posz);
			if(trophyentity != null){
				trophymodel = trophyentity.model;
				trophyscale = getVarFloat(0);
			}
		}
		
		if(world.isServer){
			if(DangerZone.server.isPlayerCloseInDimension(this, 14.0f)){
				timer--;
				if(timer <= 0){
					timer = getVarInt(0); //reset timer!
					float lv = getLightAtLocation(world, dimension, (int)posx, (int)posy, (int)posz); //range is like -1 to +2;
					//System.out.printf("light = %f,  min %f, max %f\n", lv, getVarFloat(1), getVarFloat(2));
					if(lv > getVarFloat(1) && lv < getVarFloat(2)){ //check to make sure light range is ok
						Entity tmpe = world.createEntityByName(getVarString(0), dimension, posx, posy+1f, posz); //we need this just to get width and height!
						if(tmpe != null){ 
							for(int i = 0; i < getVarInt(1); i++){ //loop for the number we should spawn
								//try to find a reasonable place to spawn this thing!
								int range = (int) tmpe.width;
								range+=3; //at least a few..
								int ht = (int)tmpe.height;
								ht++; //at least 1
								float px, py, pz;
								boolean fits = false;
								px = posx;
								py = posy;
								pz = posz;
								//try a few randomish places
								for(int tries=0;tries<10 && !fits;tries++){
									px = posx + world.rand.nextInt(range)*(world.rand.nextInt(2)-world.rand.nextInt(2));
									pz = posz + world.rand.nextInt(range)*(world.rand.nextInt(2)-world.rand.nextInt(2));
									py = posy;							
									for(int k = -1; k<=ht && !fits;k++){	//search up!							
										if(isSolidHere(world, dimension, px, py+k, pz, tmpe.width)){
											if(!isSolidHere(world, dimension, px, py+k+1, pz, tmpe.width)){
												//found an empty spot over a solid. See if we fit here...
												fits = true; //almost!
												if(ht > 1){ //check entire height
													for(int j=2;j<=ht && fits;j++){
														if(isSolidHere(world, dimension, px, py+k+j, pz, tmpe.width))fits = false;
													}
												}
												if(fits){
													py = py+k+1;
												}
											}
										}
									}							
								}							
								if(fits){
									Entity e = world.createEntityByName(getVarString(0), dimension, px, py, pz);
									if(e != null){
										e.init();
										world.spawnEntityInWorld(e);
									}
								}
							}
						}
					}
				}
				bid = world.getblock(dimension, (int)posx, (int)posy, (int)posz);
				if(bid == 0){
					this.deadflag = true; //block broken!
				}
				if(world.rand.nextInt(timer+1) == 1){ //more activity as time gets closer!
					Utils.spawnParticlesFromServer(world, "DangerZone:ParticleFire", 4, dimension, posx, posy+0.25f, posz);
					Utils.spawnParticlesFromServer(world, "DangerZone:ParticleSparkle", 6, dimension, posx, posy+0.25f, posz);
				}
			}
		}
		
		motionx = motiony = motionz = 0;
		rotation_yaw_motion = 10;
		super.update(deltaT);
	}
	
	public Texture getTexture(){
		if(trophyentity != null){
			return trophyentity.getTexture();
		}
		return null;
	}
	
	//Check all around the entity WIDTH to see if it is solid.
	//Used for Y collisions
	private boolean isSolidHere(World w, int d, float x, float y, float z, float width){
		int intwidth = (int)((width/2.0f)+0.5f);
		int i, j;
		int itemp;
		float dx, dz;
		for(i=-intwidth;i<=intwidth;i++){
			for(j=-intwidth;j<=intwidth;j++){
				if(Blocks.isSolid(w.getblock(d, (int)x+i, (int)y, (int)z+j))){
					itemp = (int)(x)+i;
					dx = x - ((float)itemp + 0.5f);
					dx = Math.abs(dx);
					if(dx < (0.49f + (width/2.0f))){
						itemp = (int)(z)+j;
						dz = z - ((float)itemp + 0.5f);
						dz = Math.abs(dz);
						if(dz < (0.49f + (width/2.0f))){
							return true;
						}
					}
				}
			}
		}
		return false;
	}

}
