package dangerzone.biomes;
import dangerzone.Chunk;
import dangerzone.Ores;
import dangerzone.World;
import dangerzone.blocks.Blocks;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class Biome1 extends Biome {
	Trees tr;
		
	public Biome1(String n){
		super(n);
		tr = new Trees();
	}
	
	/*
	 * USE ONLY CHUNK.set/get functions!!! Otherwise infinite recursion may occur!
	 * THIS ROUTINE IS JUST FOR SUPPLYING IN-CHUNK DATA, LIKE TERRAIN!!!
	 * THINK INSIDE THE CHUNK... er... BOX!
	 * Most parameters passed in for reference only. 
	 * Mostly what you need here is just the chunk itself.
	 */
	public void generate(World w, int d, Chunk c, int cx, int cz){

		int i, j, k;

		int stoneheight[][] = new int[16][16];
		int dirtheight[][] = new int[16][16];
		float noise[][] = new float[16][16];
		float noise2[][] = new float[16][16];

		int dirtamp = 2;
		int stoneamp = 5;
		int dx = cx << 4;
		int dz = cz << 4;
		double t;			

		//slow rolling base
		for(i=0;i<16;i++){
			for(k=0;k<16;k++){
				noise[i][k] = (float) Math.sin((double)((dx+i)/256d)%Math.PI)*2;
				noise[i][k] += (float) Math.sin((double)((dz+k)/256d)%Math.PI)*2;

				noise2[i][k] = (float) Math.sin((double)((dx+i)/128d)%Math.PI)*2;
				noise2[i][k] += (float) Math.sin((double)((dz+k)/128d)%Math.PI)*2;
			}
		}

		for(i=0;i<16;i++){
			for(k=0;k<16;k++){
				noise[i][k] += (float) Math.sin((double)((dx+i)/128d)%Math.PI)*2;
				noise[i][k] += (float) Math.sin((double)((dz+k)/128d)%Math.PI)*2;

				noise2[i][k] += (float) Math.sin((double)((dx+i)/64d)%Math.PI)*2;
				noise2[i][k] += (float) Math.sin((double)((dz+k)/64d)%Math.PI)*2;						
			}
		}

		for(i=0;i<16;i++){
			for(k=0;k<16;k++){
				t = noise[i][k]*stoneamp + 50;
				stoneheight[i][k] = (int) t;

				t = noise2[i][k]/2*dirtamp;
				dirtheight[i][k] = (int)t;
				if(dirtheight[i][k] < 0)dirtheight[i][k] = 0;
				
			}
		}


		for(j=0;j<128;j++){
			for(i=0;i<16;i++){
				for(k=0;k<16;k++){
					if(j < stoneheight[i][k]){
						c.setblock(i, j, k, Blocks.stone.blockID);
					}else{
						if(j < stoneheight[i][k]+dirtheight[i][k])c.setblock(i, j, k, Blocks.dirt.blockID);
						if(j == stoneheight[i][k]+dirtheight[i][k] && c.getblock(i,  j-1,  k) == Blocks.dirt.blockID){
							c.setblock(i, j, k, Blocks.grassblock.blockID);
							c.setblockmeta(i, j, k, w.rand.nextInt(4) << 12);  //random Y orientation. looks nicer!
						}
					}
					if(j == 0)c.setblock(i, j, k, Blocks.stopblock.blockID);
				}
			}			
		}
		
		//Put in a few ores now!
		Ores.generate(w, d, this, c, cx, cz);
		
	}

		
	
	/*
	 * You can (and probably should) use world.set/get calls here. 
	 * That's what this is for... structures that can cross chunk boundaries!
	 * Note that structures larger than 16*16 chunks (256*256 blocks) can cause slowness...
	 * Large trees and dungeons are welcome here...
	 * 
	 */
	public void decorate(World world, int d, Chunk c, int chunkx, int chunkz){
		tr.addWoodTrees(world, d, chunkx<<4, chunkz<<4, c);
		tr.addGrass(world, d, chunkx<<4, chunkz<<4, c);
	}

}
