package dangerzone;

import dangerzone.biomes.Biome;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityChest;
import dangerzone.items.Items;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class WorldDecorator {
	
	//stuff you can find in a chest...
	public static StuffList[] things = new StuffList[] { 
			//Block or Item, min, max, %chance
			new StuffList(Items.coinsilver, 5, 25, 75),
			new StuffList(Items.coingold, 3, 15, 65),			
			new StuffList(Items.coinplatinum, 1, 5, 55),
			new StuffList(Items.diamond, 1, 5, 55),
			new StuffList(Items.emerald, 1, 5, 55),
			new StuffList(Items.bloodstone, 1, 5, 55),
			new StuffList(Items.sunstone, 1, 5, 55),
		
			new StuffList(Items.woodenaxe, 1, 1, 25),
			new StuffList(Items.woodenshovel, 1, 1, 25),
			new StuffList(Items.woodenhoe, 1, 1, 25),
			new StuffList(Items.woodenpickaxe, 1, 1, 25),
			new StuffList(Items.woodensword, 1, 1, 25),
			new StuffList(Items.silveraxe, 1, 1, 20),
			new StuffList(Items.silvershovel, 1, 1, 20),
			new StuffList(Items.silverhoe, 1, 1, 20),
			new StuffList(Items.silverpickaxe, 1, 1, 20),
			new StuffList(Items.silversword, 1, 1, 20),
			new StuffList(Items.tinsword, 1, 1, 20),
			new StuffList(Items.tinaxe, 1, 1, 20),
			new StuffList(Items.tinshovel, 1, 1, 20),
			new StuffList(Items.tinhoe, 1, 1, 20),
			new StuffList(Items.tinpickaxe, 1, 1, 20),
			new StuffList(Items.coppersword, 1, 1, 20),
			new StuffList(Items.copperaxe, 1, 1, 20),
			new StuffList(Items.coppershovel, 1, 1, 20),
			new StuffList(Items.copperhoe, 1, 1, 20),
			new StuffList(Items.copperpickaxe, 1, 1, 20),
			
			new StuffList(Items.platinumaxe, 1, 1, 15),
			new StuffList(Items.platinumshovel, 1, 1, 15),
			new StuffList(Items.platinumhoe, 1, 1, 15),
			new StuffList(Items.platinumpickaxe, 1, 1, 15),
			new StuffList(Items.platinumsword, 1, 1, 15),
			new StuffList(Items.furball, 1, 16, 65),
			new StuffList(Items.furball, 1, 16, 65),
			new StuffList(Items.furball, 1, 16, 65),
			new StuffList(Items.furball, 1, 16, 65),
			new StuffList(Items.instability, 1, 16, 25),
			new StuffList(Items.instabilitylarge, 1, 16, 20),
			new StuffList(Items.instabilityhuge, 1, 16, 15),
			new StuffList(Items.corn, 1, 16, 45),
			new StuffList(Items.corn, 1, 16, 45),
			new StuffList(Items.radish, 1, 16, 45),
			new StuffList(Items.radish, 1, 16, 45),					
			new StuffList(Items.moosemeat, 1, 16, 45),
			new StuffList(Items.moosemeat_cooked, 1, 16, 35),
			new StuffList(Items.moosebone, 1, 16, 45),
			new StuffList(Items.goosemeat, 1, 16, 45),
			new StuffList(Items.goosemeat_cooked, 1, 16, 35),
			new StuffList(Items.feather, 1, 16, 45),
			new StuffList(Items.ostrichmeat, 1, 16, 35),
			new StuffList(Items.ostrichmeat_cooked, 1, 16, 45),
			new StuffList(Items.silverhelmet, 1, 1, 20),
			new StuffList(Items.silverchestplate, 1, 1, 20),
			new StuffList(Items.silverleggings, 1, 1, 20),
			new StuffList(Items.silverboots, 1, 1, 20),
			new StuffList(Items.platinumhelmet, 1, 1, 15),
			new StuffList(Items.platinumchestplate, 1, 1, 15),
			new StuffList(Items.platinumleggings, 1, 1, 15),
			new StuffList(Items.platinumboots, 1, 1, 15),
			new StuffList(Items.copperhelmet, 1, 1, 20),
			new StuffList(Items.copperchestplate, 1, 1, 20),
			new StuffList(Items.copperleggings, 1, 1, 20),
			new StuffList(Items.copperboots, 1, 1, 20),
			new StuffList(Items.tinhelmet, 1, 1, 20),
			new StuffList(Items.tinchestplate, 1, 1, 20),
			new StuffList(Items.tinleggings, 1, 1, 20),
			new StuffList(Items.tinboots, 1, 1, 20),
			new StuffList(Items.firestick, 1, 1, 45),
			new StuffList(Items.deadbug, 1, 16, 45),
			new StuffList(Items.peachseed, 1, 16, 45),
			new StuffList(Items.appleseed, 1, 16, 45),
			new StuffList(Items.cherryseed, 1, 16, 45),
			new StuffList(Items.dark, 1, 16, 25),
			new StuffList(Items.light, 1, 16, 25),
			
			new StuffList(Items.eggbutterfly, 1, 6, 15),
			new StuffList(Items.eggghost, 1, 6, 15),
			new StuffList(Items.eggghostskelly, 1, 6, 15),
			new StuffList(Items.eggrat, 1, 6, 15),
			new StuffList(Items.eggcockroach, 1, 6, 15),
			new StuffList(Items.eggmoose, 1, 6, 15),
			new StuffList(Items.egggoose, 1, 6, 15),
			new StuffList(Items.egggosling, 1, 6, 15),
			new StuffList(Items.eggostrich, 1, 6, 15),
			new StuffList(Items.eggsparklemuffin, 1, 6, 15),
			new StuffList(Items.eggskeletorus, 1, 6, 15),
			new StuffList(Items.egganteater, 1, 6, 15),
			new StuffList(Items.eggvampire, 1, 6, 15),
			new StuffList(Items.eggthecount, 1, 6, 15),
			new StuffList(Items.eggwerewolf, 1, 6, 15),
			

			new StuffList(Blocks.stone, 1, 5, 10),
			new StuffList(Blocks.greystone, 1, 5, 10),
			new StuffList(Blocks.lightstick, 1, 16, 10),
			new StuffList(Blocks.darkstick, 1, 16, 10),
			new StuffList(Blocks.blocklight, 1, 1, 5),
			new StuffList(Blocks.blockdark, 1, 1, 5),
			new StuffList(Blocks.blocksilver, 1, 1, 5),
			new StuffList(Blocks.blockcopper, 1, 1, 15),
			new StuffList(Blocks.blocktin, 1, 1, 15),
			new StuffList(Blocks.blockplatinum, 1, 1, 5),
			new StuffList(Blocks.oresilver, 5, 10, 15),
			new StuffList(Blocks.oreplatinum, 5, 10, 10),
			new StuffList(Blocks.log, 5, 10, 25),
			new StuffList(Blocks.willowlog, 5, 10, 25),
			new StuffList(Blocks.redwoodlog, 5, 10, 25),
			new StuffList(Blocks.stopblock, 1, 5, 10)
			};
	
	//This is the best and easiest place to add decorations to the given chunk.
	//It is ONLY run on the server when creating new chunks.
	//NOT dimension or biome specific. YOU need to check.
	//just make another class that inherits from this, and override this function!
	//Oh, and then register your class with WorldDecorators...
	//That's it! You don't even need to call super() because this one registers itself.
	public void decorate(World world, int dimension, int chunkx, int chunkz){
		if(!world.isServer)return;
		
		Trees tr = new Trees();
		Biome b = world.getBiome(dimension, chunkx<<4,  0, chunkz<<4);
		
		
		//First things first... we need to finish the large terrain structures!
		//Let's add some caves!!!
		if(b.should_add_caves)add_cave(world, dimension, chunkx, chunkz);
		
		//And now for some dungeons!
		if(b.should_add_dungeons)add_dungeon(world, dimension, chunkx, chunkz);
		
		//default decorator! Woohoo!
		//see if we can put down a few cockroach nests...
		//ALL dimensions, hence no checks for dimension name
		if(b.should_add_roaches && world.rand.nextInt(40) == 1){
			int howmany = 1 + world.rand.nextInt(3);
			for(int m = 0;m<howmany;m++){
				int ix = (chunkx<<4)+world.rand.nextInt(16);
				int iz = (chunkz<<4)+world.rand.nextInt(16);
				int iy;
				for(iy=150;iy>60;iy--){
					if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
						if(world.getblock(dimension, ix, iy+1, iz) == 0){
							world.setblock(dimension, ix, iy, iz, Blocks.roachnest.blockID);
							break;
						}
					}
				}				
			}
		}
		
		//and a few butterfly plants!
		if(b.should_add_butterflies && world.rand.nextInt(50) == 1){
			int howmany = 1 + world.rand.nextInt(3);
			for(int m = 0;m<howmany;m++){
				int ix = (chunkx<<4)+world.rand.nextInt(16);
				int iz = (chunkz<<4)+world.rand.nextInt(16);
				int iy;
				for(iy=150;iy>70;iy--){
					if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
						if(world.getblock(dimension, ix, iy+1, iz) == 0){
							world.setblock(dimension, ix, iy+1, iz, Blocks.butterfly_plant.blockID);
							break;
						}
					}
				}				
			}
		}
		
		//Red and yellow flowers go everywhere...
		if(b.should_add_flowers && world.rand.nextInt(12) == 1){
			int howmany = 1 + world.rand.nextInt(5);
			for(int m = 0;m<howmany;m++){
				int ix = (chunkx<<4)+world.rand.nextInt(16);
				int iz = (chunkz<<4)+world.rand.nextInt(16);
				int iy;
				for(iy=165;iy>60;iy--){
					if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
						if(world.getblock(dimension, ix, iy+1, iz) == 0){
							world.setblock(dimension, ix, iy+1, iz, Blocks.flower_red.blockID);
							break;
						}
					}
				}				
			}
		}
		
		if(b.should_add_flowers && world.rand.nextInt(12) == 1){
			int howmany = 1 + world.rand.nextInt(6);
			for(int m = 0;m<howmany;m++){
				int ix = (chunkx<<4)+world.rand.nextInt(16);
				int iz = (chunkz<<4)+world.rand.nextInt(16);
				int iy;
				for(iy=180;iy>60;iy--){
					if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
						if(world.getblock(dimension, ix, iy+1, iz) == 0){
							world.setblock(dimension, ix, iy+1, iz, Blocks.flower_yellow.blockID);
							break;
						}
					}
				}				
			}
		}
				
		
		//plant some corn in the overworld
		if(Dimensions.getName(dimension).equals("DangerZone: Overworld Dimension") || Dimensions.getName(dimension).equals("DangerZone: Rugged Hills Dimension")){
			if(world.rand.nextInt(64) == 1){
				int howmany = 1 + world.rand.nextInt(5);
				for(int m = 0;m<howmany;m++){
					int ix = (chunkx<<4)+world.rand.nextInt(16);
					int iz = (chunkz<<4)+world.rand.nextInt(16);
					int iy;
					for(iy=100;iy>50;iy--){
						if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
							if(world.getblock(dimension, ix, iy+1, iz) == 0){
								world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
								world.setblock(dimension, ix, iy+1, iz, Blocks.MyCornPlant1.blockID);
								break;
							}
						}
					}				
				}
			}
		}
		
		if(Dimensions.getName(dimension).equals("DangerZone: Big Round Tree Dimension")){
			if(world.rand.nextInt(7) == 1){
				int howmany = 2 + world.rand.nextInt(5);
				for(int m = 0;m<howmany;m++){
					int ix = (chunkx<<4)+world.rand.nextInt(16);
					int iz = (chunkz<<4)+world.rand.nextInt(16);
					int iy;
					for(iy=100;iy>50;iy--){
						if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
							if(world.getblock(dimension, ix, iy+1, iz) == 0){
								world.setblock(dimension, ix, iy+1, iz, Blocks.flower_pink.blockID);
								break;
							}
						}
					}				
				}
			}
			if(world.rand.nextInt(64) == 1){
				int howmany = 1 + world.rand.nextInt(5);
				for(int m = 0;m<howmany;m++){
					int ix = (chunkx<<4)+world.rand.nextInt(16);
					int iz = (chunkz<<4)+world.rand.nextInt(16);
					int iy;
					for(iy=100;iy>50;iy--){
						if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
							if(world.getblock(dimension, ix, iy+1, iz) == 0){
								world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
								world.setblock(dimension, ix, iy+1, iz, Blocks.radish_plant.blockID);
								break;
							}
						}
					}				
				}
			}
		}
		
		if(Dimensions.getName(dimension).equals("DangerZone: Pathway Dimension")){
			if(world.rand.nextInt(8) == 1){
				int howmany = 2 + world.rand.nextInt(6);
				for(int m = 0;m<howmany;m++){
					int ix = (chunkx<<4)+world.rand.nextInt(16);
					int iz = (chunkz<<4)+world.rand.nextInt(16);
					int iy;
					for(iy=100;iy>50;iy--){
						if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
							if(world.getblock(dimension, ix, iy+1, iz) == 0){
								world.setblock(dimension, ix, iy+1, iz, Blocks.flower_purple.blockID);
								break;
							}
						}
					}				
				}
			}
			if(world.rand.nextInt(64) == 1){
				int howmany = 1 + world.rand.nextInt(5);
				for(int m = 0;m<howmany;m++){
					int ix = (chunkx<<4)+world.rand.nextInt(16);
					int iz = (chunkz<<4)+world.rand.nextInt(16);
					int iy;
					for(iy=100;iy>50;iy--){
						if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
							if(world.getblock(dimension, ix, iy+1, iz) == 0){
								world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
								world.setblock(dimension, ix, iy+1, iz, Blocks.rice_plant.blockID);
								break;
							}
						}
					}				
				}
			}

				
			//Make some fruit trees!
			if(world.rand.nextInt(3) == 0){

				int howmany = 0;
				int what = world.rand.nextInt(3);
				howmany = world.rand.nextInt(6);

				for(int i = 0; i < howmany; i++) {
					int posX = 4 + (chunkx<<4) + world.rand.nextInt(12);
					int posZ = 4 + (chunkz<<4) + world.rand.nextInt(12);    
					for(int posY = 90; posY > 50; posY--) //Start high and search down until we find a grass/dirt block.
					{
						//Must be in air (empty block), and on a grass block
						if(world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY-1, posZ) == Blocks.grassblock.blockID)
						{					
							if(what == 0){
								tr.makeFruitTree(world, dimension, posX, posY-1, posZ, Blocks.MyCherryLeaves.blockID);
							}else if(what == 1){
								tr.makeFruitTree(world, dimension, posX, posY-1, posZ, Blocks.MyAppleLeaves.blockID);
							}
							break;
						}	     	
					}
				}
			}
		}	
		
		if(Dimensions.getName(dimension).equals("DangerZone: Rugged Hills Dimension")){
			if(world.rand.nextInt(18) == 1){
				int howmany = 2 + world.rand.nextInt(6);
				for(int m = 0;m<howmany;m++){
					int ix = (chunkx<<4)+world.rand.nextInt(16);
					int iz = (chunkz<<4)+world.rand.nextInt(16);
					int iy;
					for(iy=100;iy>50;iy--){
						if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
							if(world.getblock(dimension, ix, iy+1, iz) == 0){
								world.setblock(dimension, ix, iy+1, iz, Blocks.flower_purple.blockID);
								break;
							}
						}
					}				
				}
			}
			if(world.rand.nextInt(100) == 1){
				int howmany = 1 + world.rand.nextInt(5);
				for(int m = 0;m<howmany;m++){
					int ix = (chunkx<<4)+world.rand.nextInt(16);
					int iz = (chunkz<<4)+world.rand.nextInt(16);
					int iy;
					for(iy=100;iy>50;iy--){
						if(world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID){
							if(world.getblock(dimension, ix, iy+1, iz) == 0){
								world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
								world.setblock(dimension, ix, iy+1, iz, Blocks.rice_plant.blockID);
								break;
							}
						}
					}				
				}
			}

				
			//Make some fruit trees!
			if(world.rand.nextInt(30) == 0){

				int howmany = 1;
				int what = world.rand.nextInt(3);

				for(int i = 0; i < howmany; i++) {
					int posX = 4 + (chunkx<<4) + world.rand.nextInt(12);
					int posZ = 4 + (chunkz<<4) + world.rand.nextInt(12);    
					for(int posY = 90; posY > 50; posY--) //Start high and search down until we find a grass/dirt block.
					{
						//Must be in air (empty block), and on a grass block
						if(world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY-1, posZ) == Blocks.grassblock.blockID)
						{					
							if(what == 0){
								tr.makeFruitTree(world, dimension, posX, posY-1, posZ, Blocks.MyPeachLeaves.blockID);
							}else if(what == 1){
								tr.makeFruitTree(world, dimension, posX, posY-1, posZ, Blocks.MyAppleLeaves.blockID);
							}
							break;
						}	     	
					}
				}
			}
		}		
	}
	
	/*
	 * Generates a cave. Der....
	 */
	public void add_cave(World world, int dimension, int chunkx, int chunkz){
		float startx, starty, startz;
		float dxz, dy;
		float ddxz, ddy;
		float width;
		float length;
		float currentwidth;
		float currad;
		float curx, cury, curz;
		float tx, tz;
		float ty;
		float dirang;
		float tt;
		float dirax, diraz;
		int da;
		int bid;
		
		if(!DangerZone.generatecaves)return;
		if(world.rand.nextInt(5+((chunkx+chunkz)&0x3f)*2) != 0)return; //clumpy, but not too many or it overloads the graphics memory...
		
		starty = 10f + world.rand.nextFloat()*60;
		startx = world.rand.nextFloat()*16;
		startz = world.rand.nextFloat()*16;
		dxz = world.rand.nextFloat()*360f;
		dy = (world.rand.nextFloat()-world.rand.nextFloat())*25f;
		ddxz = world.rand.nextFloat()-world.rand.nextFloat();
		ddy = world.rand.nextFloat()-world.rand.nextFloat();
		ddxz *= 2;
		width = 3 + world.rand.nextFloat()*6;
		length = 150 + world.rand.nextFloat()*300;
		curx = startx + (chunkx << 4);
		cury = starty;
		curz = startz + (chunkz << 4);
		for(int i = 0;i<length;i++){
			if(cury > 35){
				if(dy>0)dy=-dy;
				if(ddy>0)ddy=-ddy;
			}
			if(cury < 0){
				if(dy<0)dy=-dy;
				if(ddy<0)ddy=-ddy;
			}
			currentwidth = (float) Math.sin((float)i/length*Math.PI)*width;
			if(currentwidth > 1){
				da = 10;
				if(currentwidth < 4)da = 15;
				if(currentwidth > 6)da = 5;
				dirang = (float) Math.toRadians(dxz-90);
				dirax = (float) Math.cos(dirang);
				diraz = (float) Math.sin(dirang);
				for(int j=0;j<360;j+=da){
					currad = 0;				
					ty = (float) Math.sin(Math.toRadians(j));
					tt = (float) Math.cos(Math.toRadians(j));
					tx = (float) (dirax*tt);
					tz = (float) (diraz*tt);				
					while(currad < currentwidth){
						currad += 0.20f;
						if((int)(cury + ty*currad) > 0){
							bid = world.getblock(dimension, (int)(curx + tx*currad), (int)(cury + ty*currad), (int)(curz + tz*currad));
							if(Blocks.isSolid(bid))world.setblocknonotify(dimension, (int)(curx + tx*currad), (int)(cury + ty*currad), (int)(curz + tz*currad), 0);
						}
					}				
				}
			}
			curx += Math.cos(Math.toRadians(dxz));
			curz += Math.sin(Math.toRadians(dxz));
			dxz += ddxz;
			cury += Math.sin(Math.toRadians(dy));
			dy += ddy;
			//maybe do some direction changes...
			if(world.rand.nextInt(20) == 1){
				dy = (world.rand.nextFloat()-world.rand.nextFloat())*25f;
				ddy = world.rand.nextFloat()-world.rand.nextFloat();
			}
			if(world.rand.nextInt(50) == 1){
				dxz += world.rand.nextFloat()*45f;
				ddxz = world.rand.nextFloat()-world.rand.nextFloat();
				ddxz *= 2;
			}
		}				
	}
	
	public void add_dungeon(World world, int dimension, int chunkx, int chunkz){
		if(world.rand.nextInt(64) != 0)return;
		int xoff, yoff, zoff;
		int x = chunkx << 4;
		int z = chunkz << 4;
		int i, j, k;
		int bid, type;
		xoff = world.rand.nextInt(16);
		zoff = world.rand.nextInt(16);
		yoff = world.rand.nextInt(40) + 5;
		
		//Let's just go ahead and assume it's a good spot. They are fairly rare...
		for(i=0;i<11;i++){
			for(j=0;j<5;j++){
				for(k=0;k<11;k++){
					bid = 0;
					if(i==0 || i == 10)bid = Blocks.greystone.blockID;
					if(j==0 || j == 4)bid = Blocks.greystone.blockID;
					if(k==0 || k == 10)bid = Blocks.greystone.blockID;
					world.setblocknonotify(dimension, x+xoff+i, yoff+j, z+zoff+k, bid);
				}
			}
		}
		
		//Add a spawner
		type = world.rand.nextInt(3); //0=rat, 1=werewolf, 2=vampire
		bid = Blocks.ratspawner.blockID;
		if(type == 1)bid = Blocks.werewolfspawner.blockID;
		if(type == 2)bid = Blocks.vampirespawner.blockID;
		world.setblock(dimension, x+xoff+5, yoff+1, z+zoff+5, bid);
		
		//Now add a chest and put some things in it
		world.setblock(dimension, x+xoff+5, yoff+1, z+zoff+1, Blocks.chest.blockID); //hopefully it's pointing the right way!
		Entity eb = world.createEntityByName("DangerZone:EntityChest", dimension, (float)(x+xoff+5)+0.5f, (float)(yoff+1)+0.05f, (float)(z+zoff+1)+0.5f);
		if(eb != null){
			if(!world.isServer)eb.init();
			//put some things into our new chest entity **BEFORE** we spawn it.
			//(So when the client chest spawns it automatically requests an inventory update, and gets it!)
			//oh geez... why did I do this this way? oh yeah... a custom packet example... doh...
			//would have been so much easier to use the built-in inventory. sheesh.
			//oh, wait, this isn't so bad... :)
			EntityChest ec = (EntityChest)eb;
			int nthings = world.rand.nextInt(25)+20; //lots of "tries"
			int where;
			int val, which, howmany;

			for(i=0;i<nthings;i++){
				where = world.rand.nextInt(ec.inventory.length);
				val = world.rand.nextInt(100);
				which = world.rand.nextInt(things.length);
				if(val <= things[which].chance){
					howmany = things[which].min;
					if(things[which].max - things[which].min > 0){
						howmany += world.rand.nextInt((things[which].max - things[which].min)+1);
					}
					//ec.inventory[where] = new InventoryContainer(things[which].getbid(), things[which].getiid(), howmany, 0);
					//could also (should?) use:
					ec.entity_inventory[where] = new InventoryContainer(things[which].getbid(), things[which].getiid(), howmany, 0); //client side filling!!!!
				}
			}
			//spawn the chest entity!	
			if(world.isServer)ec.init();
			world.spawnEntityInWorld(eb);
		}
		
	}

}
