package dangerzone;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.HashMap;
import java.util.Map;

import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.util.ResourceLoader;


public class SoundManager {
	
	private class Soundinfo {
		public String filepath;
		public Audio sound;
		Soundinfo(String f){
			filepath = f;
			sound = null;
		}
	}
	
	Map <String, Soundinfo> soundmap;
	public int master_volume = 10;
	
	public SoundManager(){
		soundmap = new HashMap<String, Soundinfo>();		
	}
	
	public void registerSound(String soundname, String filepath){
		soundmap.put(soundname, new Soundinfo(filepath));
	}
	
	public void playSound(String soundname, float vol, float freq, int d, float px, float py, float pz){
		Soundinfo s = soundmap.get(soundname);
		if(s != null && !s.equals("")){
			if(s.sound == null){
				try {
					//System.out.printf("load sound file %s\n", s.filepath);
					s.sound = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream(s.filepath));
				} catch (Exception e) {
					System.out.printf("Failed to load sound file: %s\n", s.filepath);
					e.printStackTrace();
					s.sound = null;
					soundmap.remove(soundname);
				}
			}
			if(s.sound != null && master_volume > 0){				
				if(DangerZone.start_client && d == DangerZone.player.dimension){
					float mx = DangerZone.player.getDistanceFromEntityCenter(px, py, pz);
					float mv = (float)master_volume;
					mv /= 10f;
					mx -= 2;
					if(mx < 1)mx = 1;
					mx = mx/8; //scale it! 
					mx = mx*mx; //Drop off with distance squared...
					if(mx < 1)mx = 1;
					if(mx < 1024){ //too far away to bother
						mx = vol / mx;
						mx *= mv;
						try{
							s.sound.playAsSoundEffect(freq,  mx, false);
						}catch(Exception e){
							System.out.printf("Sound broke again...\n");
						}
						//System.out.printf("plyz = %f,  %f, %f   exyz = %f, %f, %f\n", DangerZone.player.posx, DangerZone.player.posy,DangerZone.player.posz, px, py, pz);
						//float at = (float) Math.atan2(DangerZone.player.posz-pz, DangerZone.player.posx-px);
						//at += (float)Math.toRadians(DangerZone.player.rotation_yaw_head-90);
						//s.sound.playAsSoundEffect(freq, mx, false, x, y, z);
					}
				}
			}
		}		
	}

}
