package dangerzone;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.StringTokenizer;

import dangerzone.entities.Entity;



public class CommandHandler {
	
	public static void doCommand(Player pl, String cmd){
		String s;
		StringTokenizer st = new StringTokenizer(cmd);
		while(st.hasMoreTokens()){
			s = st.nextToken();
			if(s.equalsIgnoreCase("time")){
				if(st.hasMoreTokens()){
					s = st.nextToken();
					if(s.equalsIgnoreCase("set")){
						if(st.hasMoreTokens()){
							s = st.nextToken();
							if(s.equalsIgnoreCase("day")){
								DangerZone.server_world.timetimer = DangerZone.server_world.lengthOfDay/4; //noon!
								DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
								break;
							}else if(s.equalsIgnoreCase("night")){
								DangerZone.server_world.timetimer = DangerZone.server_world.lengthOfDay*3/4; //midnight!
								DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
								break;
							}else if(s.equalsIgnoreCase("dawn")){
								DangerZone.server_world.timetimer = 0; 									//morning
								DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
								break;
							}else if(s.equalsIgnoreCase("dusk")){
								DangerZone.server_world.timetimer = DangerZone.server_world.lengthOfDay/2; //evening!
								DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
								break;
							}else{
								int newtime;
								try{
									newtime = Integer.parseInt(s);
								}catch(NumberFormatException e){
									newtime = 0;
								}
								if(newtime >= 0 && newtime <= DangerZone.server_world.lengthOfDay){
									DangerZone.server_world.timetimer = newtime;
									DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
									break;
								}
							}
						}
					}
				}
			}else if(s.equalsIgnoreCase("tp") || s.equalsIgnoreCase("teleport") ){
				if(st.hasMoreTokens()){
					s = st.nextToken();
					Entity e = DangerZone.server.entityManager.findPlayerByName(s);
					if(e != null){
						
						Utils.doTeleport(pl, e.dimension, e.posx, e.posy, e.posz);		
						
					}else{
						int newx, newy, newz;
						newx=newy=newz=0;
						try{
							newx = Integer.parseInt(s);
						}catch(NumberFormatException ex){
							newx = 0;
						}
						if(st.hasMoreTokens()){
							s = st.nextToken();
							try{
								newy = Integer.parseInt(s);
							}catch(NumberFormatException ex){
								newy = 0;
							}
						}
						if(st.hasMoreTokens()){
							s = st.nextToken();
							try{
								newz = Integer.parseInt(s);
							}catch(NumberFormatException ex){
								newz = 0;
							}
						}
						if(newx > 0 && newy > 0 && newy < 256 && newz > 0){
							//close enough. go!
							
							Utils.doTeleport(pl, pl.dimension, (float)newx, (float)newy, (float)newz);		
							
						}
					}
				}
			}else if(s.equalsIgnoreCase("stop") || s.equalsIgnoreCase("shutdown") ){
				DangerZone.gameover = 1;
			}else if(s.equalsIgnoreCase("show")){
				if(st.hasMoreTokens()){
					s = st.nextToken();
					if(s.equalsIgnoreCase("eid")){
						int i;
						for(i=1;i<DangerZone.max_entities;i++){
							Entity e = DangerZone.server.entityManager.findEntityByID(i);
							if(e != null){
								e.setPetName(String.format("%d", i));
							}
						}
					}else{
						int i;
						for(i=1;i<DangerZone.max_entities;i++){
							Entity e = DangerZone.server.entityManager.findEntityByID(i);
							if(e != null){
								e.setPetName(null);
							}
						}
					}
				}
			}else if(s.equalsIgnoreCase("mount")){
				int rider=0, ridden=0;
				if(st.hasMoreTokens()){
					s = st.nextToken();
					try{
						rider = Integer.parseInt(s);
					}catch(NumberFormatException ex){
						rider = 0;
					}
				}
				if(st.hasMoreTokens()){
					s = st.nextToken();
					try{
						ridden = Integer.parseInt(s);
					}catch(NumberFormatException ex){
						ridden = 0;
					}
				}
				if(rider != 0 && ridden != 0){
					Entity top, bottom;
					top =  DangerZone.server.entityManager.findEntityByID(rider);
					if(top != null){
						bottom =  DangerZone.server.entityManager.findEntityByID(ridden);
						if(bottom != null){
							bottom.Mount(top);
						}						
					}
				}
			}
		}

	}

}
