/*
 * Decompiled with CFR 0.152.
 */
package slick;

import java.io.Serializable;
import java.nio.FloatBuffer;
import slick.Renderer;
import slick.SGL;

public class ColorSlick
implements Serializable {
    private static final long serialVersionUID = 1393939L;
    protected transient SGL GL = Renderer.get();
    public static final ColorSlick transparent = new ColorSlick(0.0f, 0.0f, 0.0f, 0.0f);
    public static final ColorSlick white = new ColorSlick(1.0f, 1.0f, 1.0f, 1.0f);
    public static final ColorSlick yellow = new ColorSlick(1.0f, 1.0f, 0.0f, 1.0f);
    public static final ColorSlick red = new ColorSlick(1.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorSlick blue = new ColorSlick(0.0f, 0.0f, 1.0f, 1.0f);
    public static final ColorSlick green = new ColorSlick(0.0f, 1.0f, 0.0f, 1.0f);
    public static final ColorSlick black = new ColorSlick(0.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorSlick gray = new ColorSlick(0.5f, 0.5f, 0.5f, 1.0f);
    public static final ColorSlick cyan = new ColorSlick(0.0f, 1.0f, 1.0f, 1.0f);
    public static final ColorSlick darkGray = new ColorSlick(0.3f, 0.3f, 0.3f, 1.0f);
    public static final ColorSlick lightGray = new ColorSlick(0.7f, 0.7f, 0.7f, 1.0f);
    public static final ColorSlick pink = new ColorSlick(255, 175, 175, 255);
    public static final ColorSlick orange = new ColorSlick(255, 200, 0, 255);
    public static final ColorSlick magenta = new ColorSlick(255, 0, 255, 255);
    public float r;
    public float g;
    public float b;
    public float a = 1.0f;

    public ColorSlick(ColorSlick color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
    }

    public ColorSlick(FloatBuffer buffer) {
        this.r = buffer.get();
        this.g = buffer.get();
        this.b = buffer.get();
        this.a = buffer.get();
    }

    public ColorSlick(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0f;
    }

    public ColorSlick(float r, float g, float b, float a) {
        this.r = Math.min(r, 1.0f);
        this.g = Math.min(g, 1.0f);
        this.b = Math.min(b, 1.0f);
        this.a = Math.min(a, 1.0f);
    }

    public ColorSlick(int r, int g, int b) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.a = 1.0f;
    }

    public ColorSlick(int r, int g, int b, int a) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.a = (float)a / 255.0f;
    }

    public ColorSlick(int value) {
        int r = (value & 0xFF0000) >> 16;
        int g = (value & 0xFF00) >> 8;
        int b = value & 0xFF;
        int a = (value & 0xFF000000) >> 24;
        if (a < 0) {
            a += 256;
        }
        if (a == 0) {
            a = 255;
        }
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.a = (float)a / 255.0f;
    }

    public static ColorSlick decode(String nm) {
        return new ColorSlick(Integer.decode(nm));
    }

    public void bind() {
        this.GL.glColor4f(this.r, this.g, this.b, this.a);
    }

    public int hashCode() {
        return (int)(this.r + this.g + this.b + this.a) * 255;
    }

    public boolean equals(Object other) {
        if (other instanceof ColorSlick) {
            ColorSlick o = (ColorSlick)other;
            return o.r == this.r && o.g == this.g && o.b == this.b && o.a == this.a;
        }
        return false;
    }

    public String toString() {
        return "Color (" + this.r + "," + this.g + "," + this.b + "," + this.a + ")";
    }

    public ColorSlick darker() {
        return this.darker(0.5f);
    }

    public ColorSlick darker(float scale) {
        scale = 1.0f - scale;
        ColorSlick temp = new ColorSlick(this.r * scale, this.g * scale, this.b * scale, this.a);
        return temp;
    }

    public ColorSlick brighter() {
        return this.brighter(0.2f);
    }

    public int getRed() {
        return (int)(this.r * 255.0f);
    }

    public int getGreen() {
        return (int)(this.g * 255.0f);
    }

    public int getBlue() {
        return (int)(this.b * 255.0f);
    }

    public int getAlpha() {
        return (int)(this.a * 255.0f);
    }

    public int getRedByte() {
        return (int)(this.r * 255.0f);
    }

    public int getGreenByte() {
        return (int)(this.g * 255.0f);
    }

    public int getBlueByte() {
        return (int)(this.b * 255.0f);
    }

    public int getAlphaByte() {
        return (int)(this.a * 255.0f);
    }

    public ColorSlick brighter(float scale) {
        ColorSlick temp = new ColorSlick(this.r * (scale += 1.0f), this.g * scale, this.b * scale, this.a);
        return temp;
    }

    public ColorSlick multiply(ColorSlick c) {
        return new ColorSlick(this.r * c.r, this.g * c.g, this.b * c.b, this.a * c.a);
    }

    public void add(ColorSlick c) {
        this.r += c.r;
        this.g += c.g;
        this.b += c.b;
        this.a += c.a;
    }

    public void scale(float value) {
        this.r *= value;
        this.g *= value;
        this.b *= value;
        this.a *= value;
    }

    public ColorSlick addToCopy(ColorSlick c) {
        ColorSlick copy = new ColorSlick(this.r, this.g, this.b, this.a);
        copy.r += c.r;
        copy.g += c.g;
        copy.b += c.b;
        copy.a += c.a;
        return copy;
    }

    public ColorSlick scaleCopy(float value) {
        ColorSlick copy = new ColorSlick(this.r, this.g, this.b, this.a);
        copy.r *= value;
        copy.g *= value;
        copy.b *= value;
        copy.a *= value;
        return copy;
    }
}

