/*
 * Decompiled with CFR 0.152.
 */
package nameserver;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.FloatBuffer;
import java.security.CodeSource;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import nameserver.NServer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import slick.Audio;
import slick.AudioLoader;
import slick.ColorSlick;
import slick.Inputs;
import slick.Matrix4f;
import slick.ResourceLoader;
import slick.SoundStore;
import slick.Texture;
import slick.TextureLoader;
import slick.TrueTypeFont;
import slick.Vector3f;

public class NameServerCode {
    public String version_string = "1.0";
    public String windowTitle = "DangerZone NameServer";
    public Font awtfont = null;
    public TrueTypeFont font = null;
    private Texture logotexture = null;
    public int screen_width = 1000;
    public int screen_height = 600;
    private Texture pic1 = null;
    private Texture pic2 = null;
    private Texture pic3 = null;
    private Texture pic4 = null;
    private Texture pic5 = null;
    public boolean quit = false;
    public boolean quitfile = false;
    public List<ButtonHandler> buttons;
    public boolean escaped = false;
    public boolean entered = false;
    public Properties prop = new Properties();
    public int picnum = 0;
    public int picnum_counter = 0;
    public int current_screen = 0;
    public Audio popsound;
    public NServer nserver = null;
    public int server_port = 18669;
    public Lock proplock = new ReentrantLock();
    public boolean usegui = true;
    public boolean printit = false;
    private long window;
    public Inputs input;
    GLFWFramebufferSizeCallback fbCallback;
    public boolean windowed = true;
    private long monitor = 0L;
    private static final Class[] parameters = new Class[]{URL.class};

    public void startGUI() {
        this.input = new Inputs(1000, 600);
        GLFW.glfwInit();
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131075, (int)1);
        GLFW.glfwWindowHint((int)131076, (int)0);
        this.monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)this.monitor);
        if (!this.windowed) {
            this.input.setScreenWidthHeight(vidMode.width(), vidMode.width());
        }
        this.window = GLFW.glfwCreateWindow((int)this.input.getScreenWidth(), (int)this.input.getScreenHeight(), (CharSequence)"DangerZone NameServer :: LWJGL3", (long)0L, (long)0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create window");
        }
        GLFW.glfwSetKeyCallback((long)this.window, (GLFWKeyCallbackI)this.input.getKeyboardCallback());
        GLFW.glfwSetCursorPosCallback((long)this.window, (GLFWCursorPosCallbackI)this.input.getMouseMoveCallback());
        GLFW.glfwSetMouseButtonCallback((long)this.window, (GLFWMouseButtonCallbackI)this.input.getMouseButtonsCallback());
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, (GLFWFramebufferSizeCallbackI)this.input.getFrameSizeCallback());
        GLFW.glfwSetScrollCallback((long)this.window, (GLFWScrollCallbackI)this.input.getScrollCallback());
        if (this.windowed) {
            GLFW.glfwSetWindowPos((long)this.window, (int)((vidMode.width() - this.input.getScreenWidth()) / 2), (int)((vidMode.height() - this.input.getScreenHeight()) / 2));
        }
        GLFW.glfwSetInputMode((long)this.window, (int)208897, (int)212993);
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)0);
        GLFW.glfwShowWindow((long)this.window);
        GL.createCapabilities();
        GL11.glClearColor((float)0.97f, (float)0.97f, (float)0.97f, (float)1.0f);
        GLFW.glfwWindowHint((int)131076, (int)1);
        try {
            SoundStore.get().init();
        }
        catch (Exception e1) {
            System.out.printf("Something went horribly wrong with initialization!\n", new Object[0]);
            e1.printStackTrace();
            System.exit(1);
        }
        System.out.printf("Finished init\n", new Object[0]);
    }

    public void stopGUI() {
        GLFW.glfwDestroyWindow((long)this.window);
        GLFW.glfwTerminate();
        this.input.destroy();
    }

    public void main(String[] args) throws InterruptedException, IOException {
        String curdir = System.getProperty("user.dir");
        File libfile = new File(String.valueOf(curdir) + "/DangerZone_lib/native");
        File stopfile = new File(String.valueOf(curdir) + "/stop.txt");
        if (libfile.exists()) {
            System.setProperty("org.lwjgl.librarypath", String.valueOf(curdir) + "/DangerZone_lib/native");
        }
        CodeSource codeSource = NameServerCode.class.getProtectionDomain().getCodeSource();
        try {
            File myfile = new File(codeSource.getLocation().toURI().getPath());
            this.addFile(myfile);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (args.length > 1) {
            int arglen = args.length;
            int i = 0;
            while (i < arglen) {
                if (args[i].contains("nogui")) {
                    this.usegui = false;
                }
                if (args[i].contains("print")) {
                    this.printit = true;
                }
                ++i;
            }
        }
        if (this.usegui) {
            this.startGUI();
            this.awtfont = new Font("Times New Roman", 0, 36);
            this.font = new TrueTypeFont(this.awtfont, false);
            try {
                this.logotexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/logo.png"));
                this.pic1 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/pic1.png"));
                this.pic2 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/pic2.png"));
                this.pic3 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/pic3.png"));
                this.pic4 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/pic4.png"));
                this.pic5 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/pic5.png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.popsound = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("nsres/sounds/pop.wav"));
            }
            catch (Exception e) {
                this.popsound = null;
            }
        }
        this.readConfig();
        this.picnum = 0;
        this.picnum_counter = 0;
        float heightAboveGround = 0.0f;
        Vector3f dir = new Vector3f();
        Vector3f right = new Vector3f();
        Matrix4f mat = new Matrix4f();
        FloatBuffer fb = BufferUtils.createFloatBuffer(16);
        Vector3f pos = new Vector3f(0.0f, heightAboveGround, 0.0f);
        float rotX = 0.0f;
        float rotY = 0.0f;
        dir.x = 1.0f;
        right.z = 1.0f;
        if (this.usegui) {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadMatrixf((FloatBuffer)mat.setPerspective((float)Math.toRadians(45.0), (float)this.input.getScreenWidth() / (float)this.input.getScreenHeight(), 1.0f, 100.0f, false).get(fb));
            GL11.glMatrixMode((int)5888);
            mat.identity().rotateX(rotX).rotateY(rotY);
            GL11.glLoadMatrixf((FloatBuffer)mat.get(fb));
            GL11.glViewport((int)0, (int)0, (int)this.input.getScreenWidth(), (int)this.input.getScreenHeight());
            GL11.glClear((int)16384);
            GL11.glTranslatef((float)pos.x, (float)pos.y, (float)pos.z);
            GL11.glDisable((int)2929);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)this.input.getScreenWidth(), (double)0.0, (double)this.input.getScreenHeight(), (double)-30.0, (double)30.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.showLogo();
            this.textAt(25.0f, this.input.getScreenHeight() - 50, "NameServer Version " + this.version_string);
            GLFW.glfwSwapBuffers((long)this.window);
        }
        this.nserver = new NServer();
        Thread st = new Thread(this.nserver);
        st.start();
        Thread.sleep(1000L);
        this.picnum = 1;
        while (!this.quit && !this.quitfile) {
            if (stopfile.exists()) {
                stopfile.delete();
                this.quitfile = true;
            }
            ++this.picnum_counter;
            if (this.picnum_counter > 300) {
                this.picnum_counter = 0;
                ++this.picnum;
                if (this.picnum > 5) {
                    this.picnum = 1;
                    this.writeConfig();
                }
            }
            if (this.usegui) {
                GL11.glMatrixMode((int)5889);
                GL11.glLoadMatrixf((FloatBuffer)mat.setPerspective((float)Math.toRadians(45.0), (float)this.input.getScreenWidth() / (float)this.input.getScreenHeight(), 1.0f, 100.0f, false).get(fb));
                GL11.glMatrixMode((int)5888);
                mat.identity().rotateX(rotX).rotateY(rotY);
                GL11.glLoadMatrixf((FloatBuffer)mat.get(fb));
                GL11.glViewport((int)0, (int)0, (int)this.input.getScreenWidth(), (int)this.input.getScreenHeight());
                GL11.glClear((int)16384);
                GL11.glTranslatef((float)pos.x, (float)pos.y, (float)pos.z);
                GL11.glDisable((int)2929);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GL11.glOrtho((double)0.0, (double)this.input.getScreenWidth(), (double)0.0, (double)this.input.getScreenHeight(), (double)-30.0, (double)30.0);
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.showLogo();
                if (this.current_screen == 0) {
                    this.doHomeScreen();
                }
                GLFW.glfwSwapBuffers((long)this.window);
            }
            Thread.sleep(100L);
            if (this.usegui) {
                this.quit = GLFW.glfwWindowShouldClose((long)this.window);
                if (this.input.isKeyDown(256)) {
                    this.quit = true;
                }
                if (this.quit) break;
            }
            if (!this.usegui) continue;
            SoundStore.get().poll(0);
            GLFW.glfwPollEvents();
        }
        if (this.usegui) {
            this.picnum = 0;
            this.showLogo();
            this.textAt(10.0f, 10.0f, "Bye!");
            GLFW.glfwSwapBuffers((long)this.window);
        }
        Thread.sleep(1000L);
        this.writeConfig();
        Thread.sleep(100L);
        if (this.usegui) {
            this.stopGUI();
        }
        System.exit(0);
    }

    private void showLogo() {
        GL11.glPushMatrix();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.picnum == 0) {
            this.logotexture.bind();
        }
        if (this.picnum == 1) {
            this.pic1.bind();
        }
        if (this.picnum == 2) {
            this.pic2.bind();
        }
        if (this.picnum == 3) {
            this.pic3.bind();
        }
        if (this.picnum == 4) {
            this.pic4.bind();
        }
        if (this.picnum == 5) {
            this.pic5.bind();
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        float x = 210.0f;
        float y = 200.0f;
        if (this.picnum > 0) {
            x = 480.0f;
            y = 280.0f;
        }
        GL11.glTranslatef((float)(this.input.getScreenWidth() / 2), (float)(this.input.getScreenHeight() / 2), (float)-5.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(-x), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-x), (float)(-y), (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)x, (float)(-y), (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void textAt(float xpos, float ypos, String text) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)this.font.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.font.drawString(0.0f, 0.0f, text, ColorSlick.white);
        GL11.glPopMatrix();
    }

    public void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize) {
        float w = t.getWidth();
        float h = t.getHeight();
        t.bind();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glScalef((float)(xsize / t.getWidth()), (float)(ysize / t.getHeight()), (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)w, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)h);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)w, (float)h);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private void readConfig() {
        FileInputStream input = null;
        this.proplock.lock();
        try {
            input = new FileInputStream("NameServer.properties");
            this.prop.load(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.proplock.unlock();
    }

    private void writeConfig() {
        FileOutputStream output = null;
        this.proplock.lock();
        try {
            output = new FileOutputStream("NameServer.properties");
            this.prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.proplock.unlock();
    }

    public String getpwdfor(String username) {
        String pwd = null;
        String tstring = username.toLowerCase();
        this.proplock.lock();
        pwd = this.prop.getProperty(tstring);
        this.proplock.unlock();
        return pwd;
    }

    public void setpwdfor(String username, String pwd, String ias) {
        String tstring = username.toLowerCase();
        this.proplock.lock();
        this.prop.setProperty(tstring, pwd);
        this.prop.setProperty(String.valueOf(tstring) + "_ipaddress", ias);
        this.proplock.unlock();
    }

    public void doHomeScreen() {
        this.proplock.lock();
        int sz = this.prop.size();
        this.proplock.unlock();
        this.textAt(25.0f, this.screen_height - 55, "Hi!");
        this.textAt(25.0f, this.screen_width - 95, String.format("Registered Names: %d", sz / 2));
        if (this.input.isKeyDown(256)) {
            this.quit = true;
        }
        if (this.input.isKeyDown(88)) {
            this.quit = true;
        }
        if (this.input.isKeyDown(81)) {
            this.quit = true;
        }
    }

    public int getPropertyInt(Properties prop, String propname, int min, int max, int dflt) {
        int retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Integer.parseInt(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public long getPropertyLong(Properties prop, String propname, long min, long max, long dflt) {
        long retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Long.parseLong(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public float getPropertyFloat(Properties prop, String propname, float min, float max, float dflt) {
        float retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Float.parseFloat(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public double getPropertyDouble(Properties prop, String propname, double min, double max, double dflt) {
        double retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Double.parseDouble(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public boolean getPropertyBoolean(Properties prop, String propname, boolean dflt) {
        boolean retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Boolean.parseBoolean(s);
        }
        return retval;
    }

    public String getPropertyString(Properties prop, String propname, String dflt) {
        String retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = s;
        }
        return retval;
    }

    public void addFile(File f) throws IOException {
        this.addURL(f.toURI().toURL());
    }

    public void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public class ButtonHandler {
        Texture t;
        int x;
        int y;
        int xsize;
        int ysize;
        String s;
        int which;

        public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int b) {
            this.x = xpos;
            this.y = ypos;
            this.xsize = bxsize;
            this.ysize = bysize;
            this.t = tx;
            this.s = ot;
            this.which = b;
        }

        public void leftclickhandler() {
            NameServerCode.this.popsound.playAsSoundEffect(1.0f, 1.0f, false);
        }

        public void rightclickhandler() {
        }

        public void draw() {
            if (this.t != null) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                NameServerCode.this.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
            }
            if (this.s != null && !this.s.equals("")) {
                NameServerCode.this.textAt(this.x + 6, this.y, this.s);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

