/*
 * Decompiled with CFR 0.152.
 */
package nameserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import nameserver.NameServer;

public class NSServerThread
implements Runnable {
    Socket sock;
    int fatal_error = 0;
    ObjectInputStream objectInput = null;
    ObjectOutputStream objectOutput = null;
    BufferedOutputStream bufobjectOutput = null;
    BufferedInputStream bufobjectInput = null;

    NSServerThread(Socket insock) {
        this.sock = insock;
    }

    @Override
    public void run() {
        int packettype = 0;
        int result = 0;
        try {
            this.sock.setSoTimeout(5000);
            this.bufobjectInput = new BufferedInputStream(this.sock.getInputStream());
            this.objectInput = new ObjectInputStream(this.bufobjectInput);
            this.bufobjectOutput = new BufferedOutputStream(this.sock.getOutputStream());
            this.objectOutput = new ObjectOutputStream(this.bufobjectOutput);
            packettype = this.objectInput.readInt();
            if (packettype != -1) {
                this.objectInput.close();
                this.bufobjectInput.close();
                this.objectOutput.close();
                this.bufobjectOutput.close();
                this.sock.close();
                return;
            }
            this.objectOutput.writeInt(packettype);
            this.objectOutput.flush();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        try {
            while (!NameServer.nsc.quit && this.fatal_error == 0) {
                packettype = this.objectInput.readInt();
                if (packettype == 0) {
                    String username = (String)this.objectInput.readObject();
                    String userpwd = (String)this.objectInput.readObject();
                    if (username != null && userpwd != null && username.length() >= 4 && username.length() <= 16 && userpwd.length() == 32) {
                        String dbpasswd = NameServer.nsc.getpwdfor(username);
                        result = 0;
                        if (dbpasswd != null && userpwd.equals(dbpasswd)) {
                            result = 1;
                        }
                        if (NameServer.nsc.printit) {
                            System.out.printf("Verify: %s,  result %d\n", username, result);
                        }
                        Thread.sleep(250L);
                        this.objectOutput.writeInt(result);
                        this.objectOutput.flush();
                    }
                } else if (packettype == 1) {
                    String username = (String)this.objectInput.readObject();
                    if (username != null && username.length() >= 4 && username.length() <= 16) {
                        String dbpasswd = NameServer.nsc.getpwdfor(username);
                        result = 0;
                        if (dbpasswd != null) {
                            result = 1;
                        }
                        if (NameServer.nsc.printit) {
                            System.out.printf("Check: %s,  result %d\n", username, result);
                        }
                        Thread.sleep(250L);
                        this.objectOutput.writeInt(result);
                        this.objectOutput.flush();
                    }
                } else if (packettype == 2) {
                    String username = (String)this.objectInput.readObject();
                    String userpwd = (String)this.objectInput.readObject();
                    InetAddress ia = this.sock.getInetAddress();
                    String ias = ia.getHostAddress();
                    if (username != null && userpwd != null && username.length() >= 4 && username.length() <= 16 && userpwd.length() == 32 && !this.isBadName(username)) {
                        String dbpasswd = NameServer.nsc.getpwdfor(username);
                        if (dbpasswd != null) {
                            result = 0;
                        } else {
                            NameServer.nsc.setpwdfor(username, userpwd, ias);
                            result = 1;
                        }
                        if (NameServer.nsc.printit) {
                            System.out.printf("Register: %s,  result %d\n", username, result);
                        }
                        Thread.sleep(250L);
                        this.objectOutput.writeInt(result);
                        this.objectOutput.flush();
                    }
                } else if (packettype == 3) {
                    String username = (String)this.objectInput.readObject();
                    String userpwd = (String)this.objectInput.readObject();
                    String newpasswd = (String)this.objectInput.readObject();
                    InetAddress ia = this.sock.getInetAddress();
                    String ias = ia.getHostAddress();
                    if (username != null && userpwd != null && username.length() >= 4 && username.length() <= 16 && userpwd.length() == 32 && newpasswd.length() == 32) {
                        result = 0;
                        String dbpasswd = NameServer.nsc.getpwdfor(username);
                        if (dbpasswd != null && dbpasswd.equals(userpwd)) {
                            NameServer.nsc.setpwdfor(username, newpasswd, ias);
                            result = 1;
                        }
                        if (NameServer.nsc.printit) {
                            System.out.printf("Change password: %s,  result %d\n", username, result);
                        }
                        Thread.sleep(250L);
                        this.objectOutput.writeInt(result);
                        this.objectOutput.flush();
                    }
                } else {
                    if (packettype != 4) continue;
                    String username = (String)this.objectInput.readObject();
                    String userpwd = (String)this.objectInput.readObject();
                    if (username != null && userpwd != null && username.length() >= 4 && username.length() <= 16 && userpwd.length() == 32) {
                        String dbpasswd = NameServer.nsc.getpwdfor(username);
                        result = 0;
                        if (dbpasswd != null && userpwd.equals(dbpasswd)) {
                            result = 1;
                        }
                        Thread.sleep(250L);
                        this.objectOutput.writeInt(result);
                        this.objectOutput.flush();
                        Thread.sleep(250L);
                        if (NameServer.nsc.printit) {
                            System.out.printf("Remote Shutdown: %s,  result %d\n", username, result);
                        }
                        if (username.toLowerCase().equals("theycallmedanger") && result != 0) {
                            NameServer.nsc.quit = true;
                        }
                    }
                }
            }
        }
        catch (IOException e1) {
            this.fatal_error = 1;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            if (this.bufobjectInput != null) {
                this.bufobjectInput.close();
            }
            if (this.bufobjectOutput != null) {
                this.bufobjectOutput.close();
            }
            if (this.objectInput != null) {
                this.objectInput.close();
            }
            if (this.objectOutput != null) {
                this.objectOutput.close();
            }
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fatal_error = 1;
    }

    public boolean isBadName(String in) {
        String check = in.toLowerCase();
        if (check.equals("player")) {
            return true;
        }
        if (check.equals("null")) {
            return true;
        }
        return check.contains(" ");
    }
}

