/*
 * Decompiled with CFR 0.152.
 */
package gamerunner;

import gamerunner.Runnit;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class GameRunner {
    public static int client_max_g = 3;
    public static int single_max_g = 4;
    public static int server_max_g = 2;

    public static void main(String[] args) throws InterruptedException, IOException {
        String curdir = System.getProperty("user.dir");
        ArrayList<String> cmdarray = new ArrayList<String>();
        Thread.sleep(1500L);
        GameRunner.readConfig();
        if (args.length > 1) {
            int arglen = args.length;
            int i = 0;
            while (i < arglen) {
                if (args[i].contains("client")) {
                    try {
                        cmdarray.add(Runnit.getJreExecutable().toString());
                    }
                    catch (FileNotFoundException e) {
                        break;
                    }
                    cmdarray.add(String.format("-Xmx%dg", client_max_g));
                    String where = String.valueOf(curdir) + "/DangerZone.jar";
                    cmdarray.add("-jar");
                    cmdarray.add(where);
                    cmdarray.add("client");
                    cmdarray.add("-client");
                    cmdarray.add("--client");
                    try {
                        Runnit.launch("client", cmdarray, 1000);
                    }
                    catch (IOException | InterruptedException e) {}
                    break;
                }
                if (args[i].contains("server")) {
                    try {
                        cmdarray.add(Runnit.getJreExecutable().toString());
                    }
                    catch (FileNotFoundException e) {
                        break;
                    }
                    cmdarray.add(String.format("-Xmx%dg", server_max_g));
                    String where = String.valueOf(curdir) + "/DangerZone.jar";
                    cmdarray.add("-jar");
                    cmdarray.add(where);
                    cmdarray.add("server");
                    cmdarray.add("-server");
                    cmdarray.add("--server");
                    try {
                        Runnit.launch("server", cmdarray, 100000);
                    }
                    catch (IOException | InterruptedException e) {}
                    break;
                }
                if (args[i].contains("singleplayer")) {
                    try {
                        cmdarray.add(Runnit.getJreExecutable().toString());
                    }
                    catch (FileNotFoundException e) {
                        break;
                    }
                    cmdarray.add(String.format("-Xmx%dg", single_max_g));
                    String where = String.valueOf(curdir) + "/DangerZone.jar";
                    cmdarray.add("-jar");
                    cmdarray.add(where);
                    try {
                        Runnit.launch("singleplayer", cmdarray, 1000);
                    }
                    catch (IOException | InterruptedException e) {}
                    break;
                }
                ++i;
            }
        }
        System.exit(0);
    }

    private static void readConfig() {
        server_max_g = 2;
        client_max_g = 3;
        single_max_g = 4;
    }

    public static int getPropertyInt(Properties prop, String propname, int min, int max, int dflt) {
        int retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Integer.parseInt(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }
}

