/*
 * Decompiled with CFR 0.152.
 */
package demomodcode;

import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import demomodcode.DemoModMain;
import slick.Texture;

public class DemoBeast
extends EntityLiving {
    public DemoBeast(World w) {
        super(w);
        this.width = 0.75f;
        this.height = 1.75f;
        this.uniquename = "DemoMod:DemoBeast";
        this.has_inventory = false;
        this.attackRange = 3.0f;
        this.setMaxHealth(40.0f);
        this.setHealth(40.0f);
        this.setExperience(50);
        this.setDefense(1.5f);
        this.setAttackDamage(5.0f);
        this.setMaxAir(40.0f);
        this.setAir(40.0f);
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(5) != 0) {
            return null;
        }
        return "DangerZone:werewolf_living";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:anteater_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:werewolf_death";
    }

    @Override
    public String getAttackSound() {
        return "DangerZone:werewolf_attack";
    }

    @Override
    public void doDeathDrops() {
        super.doDeathDrops();
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, DemoModMain.trophydemobeast.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        int howmany = 5 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.furball.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("demores/skins/DemoBeastTexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof DemoBeast) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }
}

