/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.world;

import dangerzone.StuffList;
import dangerzone.Utils;
import dangerzone.biomes.Biome;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Items;
import dangerzone.rendering.Fastmath;
import dangerzone.threads.CaveBuilder;
import dangerzone.world.Dimensions;
import dangerzone.world.World;
import dangerzone.world.WorldDecorator;

public class DZWorldDecorator
extends WorldDecorator {
    public static StuffList[] things = new StuffList[]{new StuffList(Items.coinsilver, 5, 25, 75), new StuffList(Items.coingold, 3, 15, 65), new StuffList(Items.coinplatinum, 1, 5, 55), new StuffList(Items.diamond, 1, 5, 5), new StuffList(Items.emerald, 1, 5, 5), new StuffList(Items.bloodstone, 1, 5, 5), new StuffList(Items.sunstone, 1, 5, 5), new StuffList(Items.scubatanks, 1, 2, 25), new StuffList(Items.scubamask, 1, 2, 25), new StuffList(Items.bullets, 4, 16, 25), new StuffList(Items.pistol, 1, 1, 15), new StuffList(Items.semipistol, 1, 1, 10), new StuffList(Items.autopistol, 1, 1, 5), new StuffList(Items.woodenaxe, 1, 1, 25), new StuffList(Items.woodenshovel, 1, 1, 25), new StuffList(Items.woodenhoe, 1, 1, 25), new StuffList(Items.woodenpickaxe, 1, 1, 25), new StuffList(Items.woodensword, 1, 1, 25), new StuffList(Items.silveraxe, 1, 1, 20), new StuffList(Items.silvershovel, 1, 1, 20), new StuffList(Items.silverhoe, 1, 1, 20), new StuffList(Items.silverpickaxe, 1, 1, 20), new StuffList(Items.silversword, 1, 1, 20), new StuffList(Items.tinsword, 1, 1, 20), new StuffList(Items.tinaxe, 1, 1, 20), new StuffList(Items.tinshovel, 1, 1, 20), new StuffList(Items.tinhoe, 1, 1, 20), new StuffList(Items.tinpickaxe, 1, 1, 20), new StuffList(Items.coppersword, 1, 1, 20), new StuffList(Items.copperaxe, 1, 1, 20), new StuffList(Items.coppershovel, 1, 1, 20), new StuffList(Items.copperhoe, 1, 1, 20), new StuffList(Items.copperpickaxe, 1, 1, 20), new StuffList(Items.platinumaxe, 1, 1, 15), new StuffList(Items.platinumshovel, 1, 1, 15), new StuffList(Items.platinumhoe, 1, 1, 15), new StuffList(Items.platinumpickaxe, 1, 1, 15), new StuffList(Items.platinumsword, 1, 1, 15), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.instability, 1, 16, 25), new StuffList(Items.instabilitylarge, 1, 16, 20), new StuffList(Items.instabilityhuge, 1, 16, 15), new StuffList(Items.corn, 1, 16, 45), new StuffList(Items.corn, 1, 16, 45), new StuffList(Items.radish, 1, 16, 45), new StuffList(Items.radish, 1, 16, 45), new StuffList(Items.moosemeat, 1, 16, 45), new StuffList(Items.moosemeat_cooked, 1, 16, 35), new StuffList(Items.moosebone, 1, 16, 45), new StuffList(Items.goosemeat, 1, 16, 45), new StuffList(Items.goosemeat_cooked, 1, 16, 35), new StuffList(Items.feather, 1, 16, 45), new StuffList(Items.ostrichmeat, 1, 16, 35), new StuffList(Items.ostrichmeat_cooked, 1, 16, 45), new StuffList(Items.silverhelmet, 1, 1, 20), new StuffList(Items.silverchestplate, 1, 1, 20), new StuffList(Items.silverleggings, 1, 1, 20), new StuffList(Items.silverboots, 1, 1, 20), new StuffList(Items.platinumhelmet, 1, 1, 15), new StuffList(Items.platinumchestplate, 1, 1, 15), new StuffList(Items.platinumleggings, 1, 1, 15), new StuffList(Items.platinumboots, 1, 1, 15), new StuffList(Items.copperhelmet, 1, 1, 20), new StuffList(Items.copperchestplate, 1, 1, 20), new StuffList(Items.copperleggings, 1, 1, 20), new StuffList(Items.copperboots, 1, 1, 20), new StuffList(Items.tinhelmet, 1, 1, 20), new StuffList(Items.tinchestplate, 1, 1, 20), new StuffList(Items.tinleggings, 1, 1, 20), new StuffList(Items.tinboots, 1, 1, 20), new StuffList(Items.firestick, 1, 1, 45), new StuffList(Items.deadbug, 1, 16, 45), new StuffList(Items.peachseed, 1, 16, 45), new StuffList(Items.appleseed, 1, 16, 45), new StuffList(Items.cherryseed, 1, 16, 45), new StuffList(Items.dark, 1, 16, 25), new StuffList(Items.light, 1, 16, 25), new StuffList(Items.bottle, 1, 16, 45), new StuffList(Items.experiencebottle, 1, 16, 45), new StuffList(Items.noobbottle, 1, 16, 65), new StuffList(Items.noobbottle, 1, 16, 65), new StuffList(Items.noobbottle, 1, 16, 65), new StuffList(Items.noobbottle, 1, 16, 65), new StuffList(Items.bread, 1, 16, 45), new StuffList(Items.rice, 1, 16, 45), new StuffList(Items.scubatanks, 1, 1, 55), new StuffList(Items.scubamask, 1, 1, 55), new StuffList(Items.eggbutterfly, 1, 6, 15), new StuffList(Items.eggghost, 1, 6, 15), new StuffList(Items.eggghostskelly, 1, 6, 15), new StuffList(Items.eggrat, 1, 6, 15), new StuffList(Items.eggcockroach, 1, 6, 15), new StuffList(Items.eggmoose, 1, 6, 15), new StuffList(Items.egggoose, 1, 6, 15), new StuffList(Items.egggosling, 1, 6, 15), new StuffList(Items.eggostrich, 1, 6, 15), new StuffList(Items.eggsparklemuffin, 1, 6, 15), new StuffList(Items.eggskeletorus, 1, 6, 15), new StuffList(Items.egganteater, 1, 6, 15), new StuffList(Items.eggvampire, 1, 6, 15), new StuffList(Items.eggthecount, 1, 6, 15), new StuffList(Items.eggwerewolf, 1, 6, 15), new StuffList(Items.eggvixen, 1, 6, 15), new StuffList(Items.frog_speed1, 1, 6, 15), new StuffList(Items.frog_slowness1, 1, 6, 15), new StuffList(Items.frog_speed2, 1, 6, 15), new StuffList(Items.frog_slowness2, 1, 6, 15), new StuffList(Items.frog_speed3, 1, 6, 15), new StuffList(Items.frog_slowness3, 1, 6, 15), new StuffList(Items.frog_strength1, 1, 6, 15), new StuffList(Items.frog_weakness1, 1, 6, 15), new StuffList(Items.frog_strength2, 1, 6, 15), new StuffList(Items.frog_weakness2, 1, 6, 15), new StuffList(Items.frog_strength3, 1, 6, 15), new StuffList(Items.frog_weakness3, 1, 6, 15), new StuffList(Items.frog_regen1, 1, 6, 15), new StuffList(Items.frog_poison1, 1, 6, 15), new StuffList(Items.frog_regen2, 1, 6, 15), new StuffList(Items.frog_poison2, 1, 6, 15), new StuffList(Items.frog_regen3, 1, 6, 15), new StuffList(Items.frog_poison3, 1, 6, 15), new StuffList(Items.frog_confusion1, 1, 6, 15), new StuffList(Items.frog_confusion2, 1, 6, 15), new StuffList(Items.frog_confusion3, 1, 6, 15), new StuffList(Items.frog_morph1, 1, 6, 15), new StuffList(Items.frog_morph2, 1, 6, 15), new StuffList(Items.frog_morph3, 1, 6, 15), new StuffList(Blocks.stand, 5, 10, 25), new StuffList(Blocks.stone, 1, 5, 10), new StuffList(Blocks.greystone, 1, 5, 10), new StuffList(Blocks.lightstick, 1, 16, 60), new StuffList(Blocks.darkstick, 1, 16, 10), new StuffList(Blocks.blocklight, 1, 1, 5), new StuffList(Blocks.blockdark, 1, 1, 5), new StuffList(Blocks.blocksilver, 1, 1, 5), new StuffList(Blocks.blockcopper, 1, 1, 15), new StuffList(Blocks.blocktin, 1, 1, 15), new StuffList(Blocks.blockplatinum, 1, 1, 5), new StuffList(Blocks.oresilver, 5, 10, 15), new StuffList(Blocks.oreplatinum, 5, 10, 10), new StuffList(Blocks.log, 5, 10, 25), new StuffList(Blocks.willowlog, 5, 10, 25), new StuffList(Blocks.redwoodlog, 5, 10, 25), new StuffList(Blocks.stopblock, 1, 5, 10)};
    public static StuffList[] martian_things = new StuffList[]{new StuffList(Items.coinsilver, 5, 64, 75), new StuffList(Items.coingold, 3, 32, 65), new StuffList(Items.coinplatinum, 1, 16, 55), new StuffList(Items.diamond, 1, 16, 5), new StuffList(Items.emerald, 1, 32, 5), new StuffList(Items.bloodstone, 1, 5, 5), new StuffList(Items.sunstone, 1, 5, 5), new StuffList(Items.frog_speed3, 1, 6, 15), new StuffList(Items.frog_slowness3, 1, 6, 15), new StuffList(Items.frog_strength3, 1, 6, 15), new StuffList(Items.frog_weakness3, 1, 6, 15), new StuffList(Items.frog_regen3, 1, 6, 15), new StuffList(Items.frog_poison3, 1, 6, 15), new StuffList(Items.frog_confusion3, 1, 6, 15), new StuffList(Items.frog_morph3, 1, 6, 15), new StuffList(Items.instabilitylarge, 1, 16, 15), new StuffList(Items.instabilityhuge, 1, 8, 15), new StuffList(Items.scrollaccuracyIV, 1, 8, 15), new StuffList(Items.scrolldamageIV, 1, 8, 15), new StuffList(Items.scrolldurabilityIV, 1, 8, 15), new StuffList(Items.scrollreachIV, 1, 8, 15), new StuffList(Items.scrollspamIV, 1, 8, 15), new StuffList(Items.scrollaccuracyV, 1, 4, 15), new StuffList(Items.scrolldamageV, 1, 4, 15), new StuffList(Items.scrolldurabilityV, 1, 4, 15), new StuffList(Items.scrollreachV, 1, 4, 15), new StuffList(Items.scrollspamV, 1, 4, 15), new StuffList(Items.scrollharm, 1, 16, 15), new StuffList(Items.scrollheal, 1, 16, 15), new StuffList(Items.drone, 1, 4, 15), new StuffList(Items.drone_motor, 1, 8, 15), new StuffList(Items.drone_body, 1, 8, 15), new StuffList(Items.drone_camera, 1, 8, 15)};
    private Trees tr = null;

    @Override
    public void decorate(World world, int dimension, Biome b, int chunkx, int chunkz) {
        int i;
        int posZ;
        int posX;
        int what;
        int bid;
        int planttype;
        int iy;
        int iz;
        int ix;
        int howmany;
        if (!world.isServer) {
            return;
        }
        if (b == null) {
            return;
        }
        if (this.tr == null) {
            this.tr = new Trees();
        }
        if (b.should_add_caves) {
            double starty = 10.0f + Fastmath.nextFloat() * 60.0f;
            double startx = Fastmath.nextFloat() * 16.0f;
            double startz = Fastmath.nextFloat() * 16.0f;
            this.add_cave(world, dimension, chunkx, chunkz, 0, 4.0f, 100.0f, startx += (double)(chunkx << 4), starty, startz += (double)(chunkz << 4));
        }
        if (b.should_add_dungeons) {
            this.add_dungeon(world, dimension, chunkx, chunkz);
        }
        if (b.should_add_roaches && Fastmath.nextInt(40) == 1) {
            howmany = 1 + Fastmath.nextInt(3);
            int m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + Fastmath.nextInt(16);
                iz = (chunkz << 4) + Fastmath.nextInt(16);
                iy = 150;
                while (iy > 60) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy, iz, Blocks.roachnest.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (b.should_add_butterflies && Fastmath.nextInt(50) == 1) {
            howmany = 1 + Fastmath.nextInt(3);
            int m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + Fastmath.nextInt(16);
                iz = (chunkz << 4) + Fastmath.nextInt(16);
                iy = 150;
                while (iy > 60) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy + 1, iz, Blocks.butterfly_plant.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (b.should_add_flowers && Fastmath.nextInt(12) == 1) {
            howmany = 1 + Fastmath.nextInt(5);
            int m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + Fastmath.nextInt(16);
                iz = (chunkz << 4) + Fastmath.nextInt(16);
                iy = 165;
                while (iy > 60) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_red.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (b.should_add_flowers && Fastmath.nextInt(12) == 1) {
            howmany = 1 + Fastmath.nextInt(6);
            int m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + Fastmath.nextInt(16);
                iz = (chunkz << 4) + Fastmath.nextInt(16);
                iy = 180;
                while (iy > 60) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_yellow.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (b.should_add_waterplants && Fastmath.nextInt(4) == 1) {
            howmany = 5 + Fastmath.nextInt(12);
            int which = Fastmath.nextInt(16);
            planttype = Blocks.reefgrass.blockID;
            switch (which) {
                case 0: {
                    planttype = Blocks.redcoral.blockID;
                    break;
                }
                case 1: {
                    planttype = Blocks.reefgrass.blockID;
                    break;
                }
                case 2: {
                    planttype = Blocks.redreefgrass.blockID;
                    break;
                }
                case 3: {
                    planttype = Blocks.yellowcoral.blockID;
                    break;
                }
                case 4: {
                    planttype = Blocks.bluecoral.blockID;
                    break;
                }
                case 5: {
                    planttype = Blocks.firecoral.blockID;
                    break;
                }
                case 6: {
                    planttype = Blocks.redfancoral.blockID;
                    break;
                }
                case 7: {
                    planttype = Blocks.blackfancoral.blockID;
                    break;
                }
                case 8: {
                    planttype = Blocks.seaweed.blockID;
                    break;
                }
                case 9: {
                    planttype = Blocks.yellowseaweed.blockID;
                    break;
                }
                case 10: {
                    planttype = Blocks.brownseaweed.blockID;
                    break;
                }
                case 11: {
                    planttype = Blocks.kelp.blockID;
                    break;
                }
                default: {
                    planttype = Blocks.reefgrass.blockID;
                }
            }
            if (planttype == Blocks.reefgrass.blockID) {
                howmany += 16;
            }
            if (planttype == Blocks.redreefgrass.blockID) {
                howmany += 10;
            }
            int m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + Fastmath.nextInt(16);
                iz = (chunkz << 4) + Fastmath.nextInt(16);
                bid = 0;
                iy = 80;
                while (iy > 10) {
                    bid = world.getblock(dimension, ix, iy, iz);
                    if (bid != 0 && bid != Blocks.waterstatic.blockID) {
                        if (bid != Blocks.stone.blockID && bid != Blocks.sand.blockID || world.getblock(dimension, ix, iy + 1, iz) != Blocks.waterstatic.blockID || world.getblock(dimension, ix, iy + 2, iz) != Blocks.waterstatic.blockID) break;
                        if (Fastmath.nextInt(200) == 5) {
                            world.setblocknonotify(dimension, ix, iy + 1, iz, Blocks.fishnursery.blockID);
                            break;
                        }
                        world.setblocknonotify(dimension, ix, iy + 1, iz, planttype);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        } else if (b.should_add_waterplants && Fastmath.nextInt(10) == 1) {
            howmany = 5 + Fastmath.nextInt(6);
            int which = Fastmath.nextInt(6);
            planttype = Blocks.tallseaweed.blockID;
            switch (which) {
                case 0: {
                    planttype = Blocks.tallseaweed.blockID;
                    break;
                }
                case 1: {
                    planttype = Blocks.browntallseaweed.blockID;
                    break;
                }
                case 2: {
                    planttype = Blocks.yellowtallseaweed.blockID;
                    break;
                }
                case 3: {
                    planttype = Blocks.tallkelp.blockID;
                    break;
                }
                default: {
                    planttype = Blocks.tallseaweed.blockID;
                }
            }
            int m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + Fastmath.nextInt(16);
                iz = (chunkz << 4) + Fastmath.nextInt(16);
                bid = 0;
                iy = 80;
                block31: while (iy > 10) {
                    bid = world.getblock(dimension, ix, iy, iz);
                    if (bid != 0 && bid != Blocks.waterstatic.blockID) {
                        if (bid != Blocks.stone.blockID && bid != Blocks.sand.blockID || world.getblock(dimension, ix, iy + 1, iz) != Blocks.waterstatic.blockID || world.getblock(dimension, ix, iy + 2, iz) != Blocks.waterstatic.blockID) break;
                        while (world.getblock(dimension, ix, iy + 2, iz) == Blocks.waterstatic.blockID) {
                            world.setblocknonotify(dimension, ix, iy + 1, iz, planttype);
                            ++iy;
                            if (Fastmath.nextInt(50) == 1) break block31;
                        }
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Overworld Dimension")) {
            what = Fastmath.nextInt(6);
            howmany = Fastmath.nextInt(4);
            if (what != 0) {
                howmany *= 2;
            }
            if (b.uniquename.equals("DangerZone:Overworld Tall Forest")) {
                what = 0;
            } else if (b.uniquename.equals("DangerZone:Overworld Tall Willow Forest")) {
                what = 1;
            } else if (b.uniquename.equals("DangerZone:Overworld Scraggly Forest")) {
                what = 2;
            } else if (Fastmath.nextInt(5) != 0) {
                howmany = 0;
            }
            int cx = chunkx << 4;
            int cz = chunkz << 4;
            int i2 = 0;
            while (i2 < howmany) {
                posX = cx + Fastmath.nextInt(16);
                posZ = cz + Fastmath.nextInt(16);
                int posY = 128;
                while (posY > 40) {
                    if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                        if (what == 0) {
                            this.tr.TallWoodTree(world, dimension, posX, posY, posZ);
                            break;
                        }
                        if (what == 1) {
                            this.tr.TallWillowTree(world, dimension, posX, posY, posZ);
                            break;
                        }
                        this.tr.ScragglyRedwoodTree(world, dimension, posX, posY, posZ);
                        break;
                    }
                    --posY;
                }
                ++i2;
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Overworld Dimension") || Dimensions.getName(dimension).equals("DangerZone: Rugged Hills Dimension")) {
            int howhigh;
            if (Fastmath.nextInt(64) == 1) {
                howmany = 1 + Fastmath.nextInt(5);
                int m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + Fastmath.nextInt(16);
                    iz = (chunkz << 4) + Fastmath.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            howhigh = 2 + Fastmath.nextInt(4);
                            int i3 = 0;
                            while (i3 < howhigh) {
                                if (world.getblock(dimension, ix, iy + i3 + 2, iz) != 0) {
                                    howhigh = i3;
                                    break;
                                }
                                world.setblock(dimension, ix, iy + i3 + 1, iz, Fastmath.nextBoolean() ? Blocks.corn_plant2.blockID : Blocks.corn_plant3.blockID);
                                ++i3;
                            }
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            world.setblock(dimension, ix, iy + howhigh + 1, iz, Blocks.corn_plant.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (Fastmath.nextInt(256) == 1) {
                howmany = 1 + Fastmath.nextInt(7);
                int m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + Fastmath.nextInt(16);
                    iz = (chunkz << 4) + Fastmath.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            howhigh = 1 + Fastmath.nextInt(3);
                            int i4 = 0;
                            while (i4 < howhigh) {
                                if (world.getblock(dimension, ix, iy + i4 + 2, iz) != 0) {
                                    howhigh = i4;
                                    break;
                                }
                                if (Fastmath.nextBoolean()) {
                                    world.setblock(dimension, ix, iy + i4 + 1, iz, Fastmath.nextBoolean() ? Blocks.milkweed_plant2.blockID : Blocks.milkweed_plant3.blockID);
                                } else {
                                    world.setblock(dimension, ix, iy + i4 + 1, iz, Blocks.milkweed_plant1.blockID);
                                }
                                ++i4;
                            }
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            world.setblock(dimension, ix, iy + howhigh + 1, iz, Blocks.milkweed_plant.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Big Round Tree Dimension")) {
            if (b.uniquename.equals("DangerZone:Big Trees") && !this.tr.addGenericTrees(world, dimension, chunkx << 4, chunkz << 4)) {
                this.tr.addTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Big Trees Flower") && !this.tr.addBigRoundLightTree(world, dimension, chunkx << 4, chunkz << 4)) {
                this.tr.addFlowerTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Big Trees Flower Two") && !this.tr.addBigRoundLightTree(world, dimension, chunkx << 4, chunkz << 4)) {
                this.tr.addFlowerTwoTrees(world, dimension, chunkx << 4, chunkz << 4);
                this.addMartianHabitat(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (Fastmath.nextInt(7) == 1) {
                howmany = 2 + Fastmath.nextInt(5);
                int m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + Fastmath.nextInt(16);
                    iz = (chunkz << 4) + Fastmath.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_blue.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (Fastmath.nextInt(64) == 1) {
                howmany = 1 + Fastmath.nextInt(5);
                int m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + Fastmath.nextInt(16);
                    iz = (chunkz << 4) + Fastmath.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            if (Fastmath.nextInt(3) == 0) {
                                world.setblock(dimension, ix, iy + 1, iz, Blocks.radish_plant.blockID);
                                break;
                            }
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.radish_plant3.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Pathway Dimension")) {
            if (b.uniquename.equals("DangerZone:Pathway")) {
                this.tr.addGenericTrees(world, dimension, chunkx << 4, chunkz << 4);
                if (Fastmath.nextInt(3) == 0) {
                    what = Fastmath.nextInt(3);
                    howmany = Fastmath.nextInt(6);
                    int i5 = 0;
                    while (i5 < howmany) {
                        posX = (chunkx << 4) + Fastmath.nextInt(16);
                        posZ = (chunkz << 4) + Fastmath.nextInt(16);
                        int posY = 90;
                        while (posY > 50) {
                            if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                                if (what == 0) {
                                    this.tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.cherryleaves.blockID);
                                    break;
                                }
                                if (what != 1) break;
                                this.tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.appleleaves.blockID);
                                break;
                            }
                            --posY;
                        }
                        ++i5;
                    }
                }
            }
            if (b.uniquename.equals("DangerZone:Pathway Forest")) {
                this.tr.addForestTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Umbrella Forest")) {
                this.tr.addUmbrellaTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Bulb Forest")) {
                this.tr.addBulbTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Loop Forest")) {
                this.tr.addlooplowspiralTree(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Loop Forest II")) {
                this.tr.addloopTree(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (Fastmath.nextInt(8) == 1) {
                howmany = 2 + Fastmath.nextInt(6);
                int m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + Fastmath.nextInt(16);
                    iz = (chunkz << 4) + Fastmath.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_purple.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (Fastmath.nextInt(64) == 1) {
                howmany = 1 + Fastmath.nextInt(5);
                int m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + Fastmath.nextInt(16);
                    iz = (chunkz << 4) + Fastmath.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            if (Fastmath.nextInt(3) != 0) {
                                world.setblock(dimension, ix, iy + 1, iz, Blocks.rice_plant.blockID);
                                break;
                            }
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.rice_plant3.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Rugged Hills Dimension")) {
            if (Fastmath.nextInt(18) == 1) {
                howmany = 2 + Fastmath.nextInt(6);
                int m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + Fastmath.nextInt(16);
                    iz = (chunkz << 4) + Fastmath.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_purple.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (Fastmath.nextInt(100) == 1) {
                howmany = 1 + Fastmath.nextInt(5);
                int m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + Fastmath.nextInt(16);
                    iz = (chunkz << 4) + Fastmath.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            if (Fastmath.nextInt(3) != 0) {
                                world.setblock(dimension, ix, iy + 1, iz, Blocks.rice_plant.blockID);
                                break;
                            }
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.rice_plant3.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            int howoften = 30;
            howmany = 1;
            if (b.uniquename.equals("DangerZone:Rugged Hills") && Fastmath.nextInt(howoften) == 0) {
                what = Fastmath.nextInt(3);
                i = 0;
                while (i < howmany) {
                    posX = (chunkx << 4) + Fastmath.nextInt(16);
                    posZ = (chunkz << 4) + Fastmath.nextInt(16);
                    int posY = 90;
                    while (posY > 50) {
                        if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                            if (what == 0) {
                                this.tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.peachleaves.blockID);
                                break;
                            }
                            if (what != 1) break;
                            this.tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.appleleaves.blockID);
                            break;
                        }
                        --posY;
                    }
                    ++i;
                }
            }
            if (b.uniquename.equals("DangerZone:Rugged Plains")) {
                howoften = 8;
                howmany = 1 + Fastmath.nextInt(3);
                if (Fastmath.nextInt(howoften) == 0) {
                    what = Fastmath.nextInt(3);
                    i = 0;
                    while (i < howmany) {
                        posX = (chunkx << 4) + Fastmath.nextInt(16);
                        posZ = (chunkz << 4) + Fastmath.nextInt(16);
                        int posY = 90;
                        while (posY > 50) {
                            if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                                if (what == 0) {
                                    this.tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.peachleaves.blockID);
                                    break;
                                }
                                if (what != 1) break;
                                this.tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.appleleaves.blockID);
                                break;
                            }
                            --posY;
                        }
                        ++i;
                    }
                }
            }
            if (b.uniquename.equals("DangerZone:Rugged Plains II")) {
                howoften = 3;
                howmany = 1;
                if (Fastmath.nextInt(howoften) == 0) {
                    what = Fastmath.nextInt(3);
                    i = 0;
                    while (i < howmany) {
                        posX = (chunkx << 4) + Fastmath.nextInt(16);
                        posZ = (chunkz << 4) + Fastmath.nextInt(16);
                        int posY = 90;
                        while (posY > 50) {
                            if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                                if (what == 0) {
                                    this.tr.bowlTree(world, dimension, posX, posY - 1, posZ);
                                    break;
                                }
                                if (what != 1) break;
                                this.tr.doublebowlTree(world, dimension, posX, posY - 1, posZ);
                                break;
                            }
                            --posY;
                        }
                        ++i;
                    }
                }
            }
            if (b.uniquename.equals("DangerZone:Rugged Plains Desert")) {
                this.tr.addScrubTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Sky Islands Dimension")) {
            howmany = 0;
            int howoften = 8;
            howmany = Fastmath.nextInt(3);
            if (Fastmath.nextInt(howoften) == 0) {
                i = 0;
                while (i < howmany) {
                    posX = (chunkx << 4) + Fastmath.nextInt(16);
                    posZ = (chunkz << 4) + Fastmath.nextInt(16);
                    int posY = 220;
                    while (posY > 100) {
                        if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                            this.tr.vaseTree(world, dimension, posX, posY - 1, posZ);
                            break;
                        }
                        --posY;
                    }
                    ++i;
                }
            }
        }
    }

    public void add_cave(World world, int dimension, int chunkx, int chunkz, int recur, float mxw, float mxlen, double startx, double starty, double startz) {
        CaveBuilder rt = new CaveBuilder(world, dimension, chunkx, chunkz, recur, mxw, mxlen, startx, starty, startz);
        Thread it = new Thread(rt);
        it.setPriority(5);
        it.start();
    }

    public void add_dungeon(World world, int dimension, int chunkx, int chunkz) {
        int bid;
        if (Fastmath.nextInt(64) != 0) {
            return;
        }
        int x = chunkx << 4;
        int z = chunkz << 4;
        int width = 11;
        int xoff = Fastmath.nextInt(16);
        int zoff = Fastmath.nextInt(16);
        int yoff = Fastmath.nextInt(40) + 5;
        if (!Blocks.isSolid(world.getblock(dimension, x + xoff, yoff - 1, z + zoff))) {
            return;
        }
        if (!Blocks.isSolid(world.getblock(dimension, x + xoff + width, yoff - 1, z + zoff))) {
            return;
        }
        if (!Blocks.isSolid(world.getblock(dimension, x + xoff, yoff - 1, z + zoff + width))) {
            return;
        }
        if (!Blocks.isSolid(world.getblock(dimension, x + xoff + width, yoff - 1, z + zoff + width))) {
            return;
        }
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < 5) {
                int k = 0;
                while (k < width) {
                    bid = 0;
                    if (i == 0 || i == 10) {
                        bid = Blocks.greystone.blockID;
                    }
                    if (j == 0 || j == 4) {
                        bid = Blocks.greystone.blockID;
                    }
                    if (k == 0 || k == 10) {
                        bid = Blocks.greystone.blockID;
                    }
                    world.setblocknonotify(dimension, x + xoff + i, yoff + j, z + zoff + k, bid);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int type = Fastmath.nextInt(4);
        bid = Blocks.ratspawner.blockID;
        if (type == 1) {
            bid = Blocks.werewolfspawner.blockID;
        }
        if (type == 2) {
            bid = Blocks.vampirespawner.blockID;
        }
        if (type == 3) {
            bid = Blocks.snarlerspawner.blockID;
        }
        world.setblock(dimension, x + xoff + 5, yoff + 1, z + zoff + 5, bid);
        Utils.add_chest(world, dimension, x + xoff + 5, yoff + 1, z + zoff + 1, things);
    }

    public void addMartianHabitat(World w, int d, int cx, int cz) {
        if (w.rand.nextInt(16) != 0) {
            return;
        }
        if ((cx & 0x3F) != 0) {
            return;
        }
        if ((cz & 0x3F) != 0) {
            return;
        }
        int iy = 100;
        while (iy > 50) {
            int bid = w.getblock(d, cx, iy, cz);
            if (bid == Blocks.stone.blockID) {
                w.setblock(d, cx, iy + 1, cz, Blocks.lightstick.blockID);
                this.buildHabitat(w, d, cx, iy, cz);
                break;
            }
            if (bid != 0) break;
            --iy;
        }
    }

    public void buildHabitat(World w, int d, int cx, int cy, int cz) {
        int level = 40 - w.rand.nextInt(20);
        int iz = 0;
        int iy = 0;
        while (cy - iy > level) {
            int j = 0;
            while (j < 3) {
                int i = 0;
                while (i < 2) {
                    if (w.getblock(d, cx + i, cy - iy + j, cz + iz) == Blocks.dirt.blockID) {
                        return;
                    }
                    w.setblock(d, cx + i, cy - iy + j, cz + iz, 0);
                    ++i;
                }
                ++j;
            }
            ++iz;
            ++iy;
        }
        this.buildBigRoom(w, d, cx, level, cz + iz + 6, false, false, false, true);
    }

    public void buildBigRoom(World w, int d, int cx, int cy, int cz, boolean fxp, boolean fxm, boolean fzp, boolean fzm) {
        int dy;
        int k;
        int width = 6;
        if (w.getblock(d, cx, cy, cz) == Blocks.chest.blockID) {
            return;
        }
        int i = -width;
        while (i <= width) {
            k = -width;
            while (k <= width) {
                int j = 0;
                while (j < 3) {
                    if (w.getblock(d, cx + i, cy + j, cz + k) == Blocks.dirt.blockID) {
                        return;
                    }
                    w.setblock(d, cx + i, cy + j, cz + k, 0);
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        if (!Blocks.isSolid(w.getblock(d, cx, cy - 1, cz))) {
            return;
        }
        Utils.add_chest(w, d, cx, cy, cz, martian_things);
        i = -2;
        while (i <= 2) {
            k = -2;
            while (k <= 2) {
                if ((k == -2 || k == 2 || i == -2 || i == 2) && Blocks.isSolid(w.getblock(d, cx + i, cy - 1, cz + k))) {
                    switch (w.rand.nextInt(8)) {
                        case 0: {
                            w.setblock(d, cx + i, cy, cz + k, Blocks.workbench.blockID);
                            break;
                        }
                        case 1: {
                            w.setblock(d, cx + i, cy, cz + k, Blocks.desk.blockID);
                            break;
                        }
                        case 2: {
                            w.setblock(d, cx + i, cy, cz + k, Blocks.furnace.blockID);
                            break;
                        }
                        case 3: {
                            Entity e = w.createEntityByName("DangerZone:Martian", d, cx + i, cy, cz + k);
                            if (e == null) break;
                            e.init();
                            w.spawnEntityInWorld(e);
                            break;
                        }
                    }
                }
                ++k;
            }
            ++i;
        }
        if (!fxp && Fastmath.nextBoolean()) {
            int n = dy = Fastmath.nextBoolean() ? 0 : -1;
            if (w.getblock(d, cx + 16, cy + dy * 16, cz) != 0) {
                this.buildConnection(w, d, cx + width, cy, cz, 1, dy, 0);
            }
        }
        if (!fxm && Fastmath.nextBoolean()) {
            int n = dy = Fastmath.nextBoolean() ? 0 : -1;
            if (w.getblock(d, cx - 16, cy + dy * 16, cz) != 0) {
                this.buildConnection(w, d, cx - width, cy, cz, -1, dy, 0);
            }
        }
        if (!fzp && Fastmath.nextBoolean()) {
            int n = dy = Fastmath.nextBoolean() ? 0 : -1;
            if (w.getblock(d, cx, cy + dy * 16, cz + 16) != 0) {
                this.buildConnection(w, d, cx, cy, cz + width, 0, dy, 1);
            }
        }
        if (!fzm && Fastmath.nextBoolean()) {
            int n = dy = Fastmath.nextBoolean() ? 0 : -1;
            if (w.getblock(d, cx, cy + dy * 16, cz - 16) != 0) {
                this.buildConnection(w, d, cx, cy, cz - width, 0, dy, -1);
            }
        }
    }

    public void buildConnection(World w, int d, int cx, int cy, int cz, int dx, int dy, int dz) {
        int ix = cx;
        int iz = cz;
        int iy = cy;
        int ddz = 0;
        int ddx = 0;
        if (dx == 0) {
            ddx = 1;
        }
        if (dz == 0) {
            ddz = 1;
        }
        int i = 0;
        while (i <= 16) {
            ix = cx + dx * i;
            iz = cz + dz * i;
            iy = cy + dy * i;
            if (iy <= 1) {
                return;
            }
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 2) {
                    w.setblock(d, ix + ddx * k, iy + j, iz + ddz * k, 0);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        boolean fzm = false;
        boolean fzp = false;
        boolean fxm = false;
        boolean fxp = false;
        if (dx > 0) {
            fxm = true;
        }
        if (dx < 0) {
            fxp = true;
        }
        if (dz > 0) {
            fzm = true;
        }
        if (dz < 0) {
            fzp = true;
        }
        this.buildBigRoom(w, d, ix + dx * 6, iy, iz + dz * 6, fxp, fxm, fzp, fzm);
    }
}

