/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.world;

import dangerzone.DangerZone;
import dangerzone.world.Chunk;
import dangerzone.world.World;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ChunkCache {
    private Lock lock = new ReentrantLock();
    public Chunk[] chunks = new Chunk[4096];
    public static final int cachewidth = 64;
    public static final int cachemask = 63;
    public static int nextrow = 0;
    public boolean passthru = false;

    public ChunkCache() {
        int i = 0;
        while (i < 64) {
            int j = 0;
            while (j < 64) {
                this.chunks[i * 64 + j] = null;
                ++j;
            }
            ++i;
        }
        this.passthru = false;
    }

    public boolean DecoratedChunkExists(int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return false;
        }
        if (y > 255) {
            return false;
        }
        if (this.passthru) {
            return DangerZone.server_chunk_cache.DecoratedChunkExists(dimension, x, y, z);
        }
        this.lock.lock();
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        if (this.chunks[i * 64 + j] != null && this.chunks[i * 64 + j].isValid != 0 && this.chunks[i * 64 + j].dimension == dimension && this.chunks[i * 64 + j].chunkX == x >> 4 && this.chunks[i * 64 + j].chunkZ == z >> 4) {
            this.lock.unlock();
            return true;
        }
        this.lock.unlock();
        return false;
    }

    public Chunk getChunk(World w, int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        if (y > 255) {
            return null;
        }
        if (this.passthru) {
            return DangerZone.server_chunk_cache.getChunk(DangerZone.server_world, dimension, x, y, z);
        }
        this.lock.lock();
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        if (this.chunks[i * 64 + j] != null && this.chunks[i * 64 + j].isValid != 0 && this.chunks[i * 64 + j].dimension == dimension && this.chunks[i * 64 + j].chunkX == x >> 4 && this.chunks[i * 64 + j].chunkZ == z >> 4) {
            this.lock.unlock();
            return this.chunks[i * 64 + j];
        }
        this.lock.unlock();
        DangerZone.server_connection.getDecoratedChunk(dimension, x, y, z);
        return null;
    }

    public void cleanCacheRow(int dimension, int x, int y, int z) {
        if (this.passthru) {
            return;
        }
        int dist = DangerZone.entityupdatedist / 16;
        if (DangerZone.renderdistance > dist) {
            dist = DangerZone.renderdistance;
        }
        this.lock.lock();
        int i = 0;
        while (i < 64) {
            if (this.chunks[nextrow * 64 + i] != null) {
                if (this.chunks[ChunkCache.nextrow * 64 + i].dimension != dimension) {
                    if (DangerZone.wr != null) {
                        DangerZone.wr.deleteVBOlist(this.chunks[ChunkCache.nextrow * 64 + i].VBOids);
                    }
                    this.chunks[ChunkCache.nextrow * 64 + i] = null;
                } else {
                    int j = this.chunks[ChunkCache.nextrow * 64 + i].chunkX;
                    int k = this.chunks[ChunkCache.nextrow * 64 + i].chunkZ;
                    if (Math.sqrt(((j <<= 4) - x) * (j - x) + ((k <<= 4) - z) * (k - z)) / 16.0 > (double)(dist + 4)) {
                        if (DangerZone.wr != null) {
                            DangerZone.wr.deleteVBOlist(this.chunks[ChunkCache.nextrow * 64 + i].VBOids);
                        }
                        this.chunks[ChunkCache.nextrow * 64 + i] = null;
                    }
                }
            }
            ++i;
        }
        if (++nextrow >= 64) {
            nextrow = 0;
        }
        this.lock.unlock();
    }

    public void releaseAllVBOs() {
        if (this.passthru) {
            DangerZone.server_chunk_cache.releaseAllVBOs();
            return;
        }
        this.lock.lock();
        Chunk c = null;
        int i = 0;
        while (i < 64) {
            int j = 0;
            while (j < 64) {
                c = this.chunks[i * 64 + j];
                if (c != null) {
                    DangerZone.wr.deleteVBOlist(c.VBOids);
                    c.VBOids = new long[20];
                }
                ++j;
            }
            ++i;
        }
        this.lock.unlock();
    }

    public Chunk getDecoratedChunkForRenderer(int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        if (y > 255) {
            return null;
        }
        if (this.passthru) {
            return DangerZone.server_chunk_cache.getDecoratedChunkForRenderer(dimension, x, y, z);
        }
        this.lock.lock();
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.isDecorated != 0 && c.dimension == dimension && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            this.lock.unlock();
            return c;
        }
        this.lock.unlock();
        DangerZone.server_connection.getDecoratedChunk(dimension, x, y, z);
        return null;
    }

    public Chunk getDecoratedChunk(int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        if (y > 255) {
            return null;
        }
        if (this.passthru) {
            return DangerZone.server_chunk_cache.getDecoratedChunk(dimension, x, y, z);
        }
        this.lock.lock();
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.isDecorated != 0 && c.dimension == dimension && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            this.lock.unlock();
            return c;
        }
        this.lock.unlock();
        DangerZone.server_connection.getDecoratedChunk(dimension, x, y, z);
        return null;
    }

    public Chunk getDecoratedChunkTry(int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        if (y > 255) {
            return null;
        }
        DangerZone.server_connection.getDecoratedChunk(dimension, x, y, z);
        return null;
    }

    public short[] getDecoratedChunkLevelData(int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        if (y > 255) {
            return null;
        }
        if (this.passthru) {
            return DangerZone.server_chunk_cache.getDecoratedChunkLevelData(dimension, x, y, z);
        }
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.isDecorated != 0 && c.dimension == dimension && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            return c.blockdata[y];
        }
        DangerZone.server_connection.getDecoratedChunk(dimension, x, y, z);
        return null;
    }

    public long[] getDecoratedChunkVBOids(int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        if (y > 255) {
            return null;
        }
        if (this.passthru) {
            long[] VBOdata = DangerZone.server_chunk_cache.getDecoratedChunkVBOids(dimension, x, y, z);
            if (VBOdata == null) {
                DangerZone.server_connection.getDecoratedChunk(dimension, x, y, z);
                return null;
            }
            return VBOdata;
        }
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.isDecorated != 0 && c.dimension == dimension && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            return c.VBOids;
        }
        DangerZone.server_connection.getDecoratedChunk(dimension, x, y, z);
        return null;
    }

    public short[] getDecoratedChunkLevelMetaData(int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        if (y > 255) {
            return null;
        }
        if (this.passthru) {
            return DangerZone.server_chunk_cache.getDecoratedChunkMetaData(dimension, x, y, z);
        }
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.isDecorated != 0 && c.dimension == dimension && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            return c.metadata[y];
        }
        DangerZone.server_connection.getDecoratedChunk(dimension, x, y, z);
        return null;
    }

    public short[] getDecoratedChunkDrawn(int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        if (y > 255) {
            return null;
        }
        if (this.passthru) {
            return DangerZone.server_chunk_cache.getDecoratedChunkDrawn(dimension, x, y, z);
        }
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.isDecorated != 0 && c.dimension == dimension && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            return c.drawn;
        }
        DangerZone.server_connection.getDecoratedChunk(dimension, x, y, z);
        return null;
    }

    public float[] getDecoratedChunkLightmap(int dimension, int x, int y, int z) {
        if (this.passthru) {
            return DangerZone.server_chunk_cache.getDecoratedChunkLightmap(dimension, x, y, z);
        }
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        if (y > 255) {
            return null;
        }
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.isDecorated != 0 && c.dimension == dimension && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            if (c.lightmap == null) {
                return null;
            }
            return c.lightmap[y];
        }
        return null;
    }

    public float getDecoratedChunkLightmapVal(int dimension, int x, int y, int z) {
        if (this.passthru) {
            return DangerZone.server_chunk_cache.getDecoratedChunkLightmapVal(dimension, x, y, z);
        }
        if (x < 0 || y < 0 || z < 0) {
            return 0.0f;
        }
        if (y > 255) {
            return 0.0f;
        }
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.isDecorated != 0 && c.dimension == dimension && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            if (c.lightmap == null) {
                return 0.0f;
            }
            if (c.lightmap[y] == null) {
                return 0.0f;
            }
            return c.lightmap[y][(x & 0xF) * 16 + (z & 0xF)];
        }
        return 0.0f;
    }

    public void clearDecoratedChunkLightmap(int dimension, int x, int y, int z) {
    }

    public void setDecoratedChunkLightValue(int dimension, int x, int y, int z, float v) {
        if (this.passthru) {
            DangerZone.server_chunk_cache.setDecoratedChunkLightmapValue(dimension, x, y, z, v);
            return;
        }
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        if (y > 255) {
            return;
        }
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.isDecorated != 0 && c.dimension == dimension && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            try {
                int m = x & 0xF;
                int n = z & 0xF;
                if (c.lightmap == null) {
                    float[][] tmp = new float[256][];
                    tmp[y] = new float[256];
                    tmp[y][m * 16 + n] = v;
                    c.lightmap = tmp;
                    return;
                }
                if (c.lightmap[y] == null) {
                    c.lightmap[y] = new float[256];
                    c.lightmap[y][m * 16 + n] = v;
                    return;
                }
                c.lightmap[y][m * 16 + n] = v;
                return;
            }
            catch (Exception e) {
                System.out.printf("setDecoratedChunkLightValue failed at %d, %d, %d, %d, val %f\n", dimension, x, y, z, Float.valueOf(v));
                return;
            }
        }
    }

    public void addCacheChunk(Chunk c) {
        if (this.passthru) {
            return;
        }
        this.lock.lock();
        int i = c.chunkX & 0x3F;
        int j = c.chunkZ & 0x3F;
        Chunk old = this.chunks[i * 64 + j];
        if (old != null && DangerZone.wr != null) {
            if (old.dimension == c.dimension && old.chunkX == c.chunkX && old.chunkZ == c.chunkZ) {
                DangerZone.wr.deleteVBOlist(old.VBOids);
            } else {
                int dx = (int)DangerZone.player.posx;
                int dz = (int)DangerZone.player.posz;
                int x = c.chunkX << 4;
                int z = c.chunkZ << 4;
                float newdist = (float)Math.sqrt((x - dx) * (x - dx) + (z - dz) * (z - dz));
                x = old.chunkX << 4;
                z = old.chunkZ << 4;
                float olddist = (float)Math.sqrt((x - dx) * (x - dx) + (z - dz) * (z - dz));
                if (olddist < newdist) {
                    this.lock.unlock();
                    return;
                }
                DangerZone.wr.deleteVBOlist(old.VBOids);
            }
        }
        this.chunks[i * 64 + j] = c;
        this.lock.unlock();
    }

    public int getBlock(World w, int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return 0;
        }
        if (y > 255) {
            return 0;
        }
        if (this.passthru) {
            return DangerZone.server_chunk_cache.getBlock(DangerZone.server_world, d, x, y, z);
        }
        this.lock.lock();
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.dimension == d && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            int b = c.getblock(x, y, z);
            this.lock.unlock();
            return b;
        }
        this.lock.unlock();
        DangerZone.server_connection.getDecoratedChunk(d, x, y, z);
        return 0;
    }

    public int getBlockmeta(World w, int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return 0;
        }
        if (y > 255) {
            return 0;
        }
        if (this.passthru) {
            return DangerZone.server_chunk_cache.getBlockmeta(DangerZone.server_world, d, x, y, z);
        }
        this.lock.lock();
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.dimension == d && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            int b = c.getblockmeta(x, y, z);
            this.lock.unlock();
            return b;
        }
        this.lock.unlock();
        DangerZone.server_connection.getDecoratedChunk(d, x, y, z);
        return 0;
    }

    public void setBlock(World w, int d, int x, int y, int z, int id, int meta) {
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        if (y > 255) {
            return;
        }
        if (this.passthru) {
            DangerZone.server_chunk_cache.setBlock(DangerZone.server_world, d, x, y, z, id, meta);
            return;
        }
        this.lock.lock();
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.dimension == d && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            int b = c.getblock(x, y, z);
            int m = c.getblockmeta(x, y, z);
            if (id == b && meta == m) {
                this.lock.unlock();
                return;
            }
            if (id != b) {
                c.setblock(x, y, z, id);
            }
            if (meta != m) {
                c.setblockmeta(x, y, z, meta);
            }
            this.lock.unlock();
            DangerZone.server_connection.blockChanged(d, x, y, z, id, meta);
            return;
        }
        this.lock.unlock();
    }

    public void setBlockSilent(int d, int x, int y, int z, int id, int meta) {
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        if (y > 255) {
            return;
        }
        if (this.passthru) {
            DangerZone.server_chunk_cache.setBlock(DangerZone.server_world, d, x, y, z, id, meta);
            return;
        }
        this.lock.lock();
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.dimension == d && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            int b = c.getblock(x, y, z);
            int m = c.getblockmeta(x, y, z);
            if (id == b && meta == m) {
                this.lock.unlock();
                return;
            }
            if (id != b) {
                c.setblock(x, y, z, id);
            }
            if (meta != m) {
                c.setblockmeta(x, y, z, meta);
            }
            this.lock.unlock();
            return;
        }
        this.lock.unlock();
    }

    public void setChunkMeta(int d, int x, int z, List<String> newowners) {
        if (x < 0 || z < 0) {
            return;
        }
        if (this.passthru) {
            return;
        }
        this.lock.lock();
        int i = x >> 4 & 0x3F;
        int j = z >> 4 & 0x3F;
        Chunk c = this.chunks[i * 64 + j];
        if (c != null && c.isValid != 0 && c.dimension == d && c.chunkX == x >> 4 && c.chunkZ == z >> 4) {
            c.ownernames = newowners;
            this.lock.unlock();
            return;
        }
        this.lock.unlock();
    }
}

