/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.world;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.entities.Entity;
import dangerzone.world.BreakCheck;
import dangerzone.world.World;
import java.util.List;

public class BreakChecks {
    public static BreakCheck[] BreakCheckArray = null;
    public static final int BreakCheckMAX = 64;

    public static void registerBreakCheck(BreakCheck b) {
        int i;
        if (BreakCheckArray == null) {
            BreakCheckArray = new BreakCheck[64];
            i = 0;
            while (i < 64) {
                BreakChecks.BreakCheckArray[i] = null;
                ++i;
            }
        }
        i = 0;
        while (i < 64) {
            if (BreakCheckArray[i] == null) {
                BreakChecks.BreakCheckArray[i] = b;
                return;
            }
            ++i;
        }
    }

    public static boolean canChangeBlock(Entity e, int d, int x, int y, int z, int tobid, int tometa) {
        List<String> cowners;
        Player pl;
        if (e instanceof Player) {
            pl = (Player)e;
            if ((pl.player_privs & 2) != 0 && pl.getGameMode() == 2) {
                return true;
            }
        }
        if (DangerZone.freeze_world) {
            return false;
        }
        if (DangerZone.start_server && DangerZone.start_client) {
            return true;
        }
        if (e instanceof Player) {
            List<String> cowners2;
            pl = (Player)e;
            if (pl.getGameMode() == 3) {
                return false;
            }
            if (pl.world.isServer && (cowners2 = DangerZone.server_chunk_cache.getChunkOwners(d, x, y, z)) != null && !BreakChecks.isIn(pl.myname, cowners2)) {
                return false;
            }
        } else if (DangerZone.start_server && (cowners = DangerZone.server_chunk_cache.getChunkOwners(d, x, y, z)) != null) {
            return false;
        }
        if (BreakCheckArray == null) {
            return true;
        }
        int i = 0;
        while (i < 64) {
            if (BreakCheckArray[i] != null && !BreakCheckArray[i].canChangeBlock(e, d, x, y, z, tobid, tometa)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean fireDamage(Entity e, int d, int x, int y, int z) {
        if (!DangerZone.firedamage) {
            return false;
        }
        if (DangerZone.freeze_world) {
            return false;
        }
        if (BreakCheckArray == null) {
            return true;
        }
        int i = 0;
        while (i < 64) {
            if (BreakCheckArray[i] != null && !BreakCheckArray[i].fireDamage(e, d, x, y, z)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean canChangeBlock(World w, int od, int ox, int oy, int oz, int d, int x, int y, int z, int tobid, int tometa) {
        int i;
        if (DangerZone.freeze_world) {
            return false;
        }
        if (DangerZone.start_server && DangerZone.start_client) {
            return true;
        }
        if (DangerZone.start_server) {
            List<String> toowners = DangerZone.server_chunk_cache.getChunkOwners(d, x, y, z);
            List<String> fowners = DangerZone.server_chunk_cache.getChunkOwners(od, ox, oy, oz);
            if (toowners != null) {
                if (fowners == null) {
                    return false;
                }
                boolean isOK = false;
                i = 0;
                while (i < fowners.size()) {
                    if (BreakChecks.isIn(fowners.get(i), toowners)) {
                        isOK = true;
                        break;
                    }
                    ++i;
                }
                if (!isOK) {
                    return false;
                }
            }
        }
        if (BreakCheckArray == null) {
            return true;
        }
        i = 0;
        while (i < 64) {
            if (BreakCheckArray[i] != null && !BreakCheckArray[i].canChangeBlock(w, od, ox, oy, oz, d, x, y, z, tobid, tometa)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isIn(String is, List<String> inlist) {
        if (is == null && inlist == null) {
            return true;
        }
        if (inlist == null) {
            return false;
        }
        if (is == null) {
            return false;
        }
        int i = 0;
        int ilen = inlist.size();
        while (ilen > 0) {
            if (is.toLowerCase().equals(inlist.get(i).toLowerCase())) {
                return true;
            }
            --ilen;
            ++i;
        }
        return false;
    }

    public static boolean canTakeStuff(Player p, Entity e) {
        if (p.getDistanceFromEntity(e) > 10.0) {
            return false;
        }
        return BreakChecks.canChangeBlock(p, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz, 0, 0);
    }
}

