/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.ServerHooker;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Flag;
import dangerzone.world.Swarm;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ServerEntityUpdateLoop
implements Runnable {
    public List<Integer> entity_list;
    public List<Integer> entity_free_list;
    public volatile Entity[] entities;
    public Lock entity_list_lock = new ReentrantLock();
    public long upticker = 1L;
    public int active_entities;

    @Override
    public void run() {
        Entity ent;
        long lasttime = System.currentTimeMillis();
        long loop_interval = DangerZone.serverentityupdaterate;
        int inext = 0;
        this.entity_list_lock.lock();
        this.entities = new Entity[DangerZone.max_entities];
        this.entity_list = new ArrayList<Integer>();
        this.entity_free_list = new ArrayList<Integer>();
        int j = 1;
        while (j < DangerZone.max_entities) {
            this.entity_free_list.add(j);
            ++j;
        }
        this.entity_list_lock.unlock();
        while (DangerZone.gameover == 0) {
            long currtime = System.currentTimeMillis();
            long tlong = currtime - lasttime;
            if ((tlong = loop_interval - tlong) < 0L) {
                tlong = 0L;
            }
            if (tlong > loop_interval) {
                tlong = loop_interval;
            }
            if (tlong > 0L) {
                try {
                    Thread.sleep(tlong);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                currtime = System.currentTimeMillis();
            }
            tlong = currtime - lasttime;
            lasttime = currtime;
            float deltaT = tlong;
            if (deltaT < 100.0f) {
                deltaT = 100.0f;
            }
            if (deltaT > 500.0f) {
                deltaT = 500.0f;
            }
            deltaT /= (float)loop_interval;
            if (DangerZone.gameover != 0) break;
            if (DangerZone.start_client) {
                int tmp = DangerZone.renderdistance;
                if ((tmp += 4) > 24) {
                    tmp = 24;
                }
                DangerZone.entityupdatedist = tmp * 16;
            }
            inext = 0;
            int ent_counter = 0;
            if (DangerZone.f12_on) {
                DangerZone.server.flushAll();
                continue;
            }
            Swarm.doSpawnSwarm();
            ServerHooker.entity_loop_start(deltaT);
            int i = 0;
            while (i < DangerZone.server.max_players) {
                if (DangerZone.server.players[i] != null && DangerZone.server.players[i].p != null) {
                    ServerHooker.player_entity_loop_start(DangerZone.server.players[i].p);
                }
                ++i;
            }
            inext = 0;
            while (inext < DangerZone.max_entities) {
                ent = this.entities[inext];
                if (ent != null && ent.deadflag) {
                    this.removeEntityByID(inext);
                    DangerZone.server.sendEntityRemoveToAll(inext);
                } else if (ent != null) {
                    if (DangerZone.server.isPlayerCloseInDimension(ent)) {
                        if (ent.access_lock.tryLock()) {
                            ServerHooker.entity_action(ent, deltaT);
                            ent.doEntityAction(deltaT);
                            ent.doEntityCollisions(deltaT);
                            ent.update(deltaT);
                            ++ent_counter;
                            ent.access_lock.unlock();
                        }
                    } else if (!DangerZone.server_chunk_cache.DecoratedChunkExists(ent.dimension, (int)ent.posx, 100, (int)ent.posz)) {
                        DangerZone.chunkwriter.addEntity(inext);
                    }
                    if (ent instanceof Player) {
                        ++ent.stray_entity_ticker;
                        if (ent.stray_entity_ticker > 300) {
                            Player plyr = (Player)ent;
                            plyr.server_thread.fatal_error = 1;
                            plyr.deadflag = true;
                            this.removeEntityByID(inext);
                            DangerZone.server.removeMe(plyr.server_thread);
                            DangerZone.server.sendEntityRemoveToAllExcept(plyr, inext);
                        }
                    }
                }
                ++inext;
            }
            this.active_entities = ent_counter;
            DangerZone.server.flushAll();
            ++this.upticker;
        }
        inext = 0;
        while (inext < DangerZone.max_entities) {
            ent = this.entities[inext];
            if (ent != null && !ent.deadflag && !DangerZone.server_chunk_cache.DecoratedChunkExists(ent.dimension, (int)ent.posx, 100, (int)ent.posz)) {
                DangerZone.chunkwriter.addEntity(inext);
            }
            ++inext;
        }
        System.out.printf("ServerEntityUpdateLoop exit.\n", new Object[0]);
    }

    private int find_entity_slot() {
        int retval = -1;
        if (DangerZone.graphics_mode < 0 && this.entity_free_list.size() < DangerZone.max_entities / 2) {
            return retval;
        }
        if (this.entity_free_list.size() > 0) {
            retval = this.entity_free_list.get(0);
            this.entity_free_list.remove(0);
        }
        return retval;
    }

    public int addEntity(Entity e) {
        this.entity_list_lock.lock();
        int i = this.find_entity_slot();
        if (i <= 0) {
            e.entityID = -1;
            this.entity_list_lock.unlock();
            return -1;
        }
        e.entityID = i;
        this.entities[i] = e;
        this.entity_list.add(i);
        this.entity_list_lock.unlock();
        return i;
    }

    public List<Integer> getEntitiesInChunk(int dim, int cx, int cz) {
        this.entity_list_lock.lock();
        ArrayList<Integer> retlist = null;
        for (int st : this.entity_list) {
            if (this.entities[st] == null || this.entities[st].dimension != dim || (int)this.entities[st].posx >> 4 != cx || (int)this.entities[st].posz >> 4 != cz) continue;
            if (retlist == null) {
                retlist = new ArrayList<Integer>();
            }
            retlist.add(st);
        }
        this.entity_list_lock.unlock();
        return retlist;
    }

    public boolean areEntitiesInChunk(int dim, int cx, int cz) {
        this.entity_list_lock.lock();
        for (int st : this.entity_list) {
            if (this.entities[st] == null || this.entities[st].dimension != dim || (int)this.entities[st].posx >> 4 != cx || (int)this.entities[st].posz >> 4 != cz) continue;
            this.entity_list_lock.unlock();
            return true;
        }
        this.entity_list_lock.unlock();
        return false;
    }

    public Entity findEntityByID(int eid) {
        if (eid <= 0) {
            return null;
        }
        if (eid >= DangerZone.max_entities) {
            return null;
        }
        return this.entities[eid];
    }

    public Entity findPlayerByName(String playername) {
        if (playername == null) {
            return null;
        }
        Entity ent = null;
        this.entity_list_lock.lock();
        for (int st : this.entity_list) {
            if (this.entities[st] == null || !(this.entities[st] instanceof Player)) continue;
            Player p = (Player)this.entities[st];
            if (!p.myname.toLowerCase().equals(playername.toLowerCase())) continue;
            ent = this.entities[st];
            break;
        }
        this.entity_list_lock.unlock();
        return ent;
    }

    public void removeEntityByID(int eid) {
        this.entity_list_lock.lock();
        Iterator<Integer> ii = this.entity_list.iterator();
        while (ii.hasNext()) {
            int st = ii.next();
            if (st != eid) continue;
            if (this.entities[st] != null) {
                if (!this.entities[st].deadflag && !this.entities[st].has_been_saved) {
                    System.out.printf("Ent %d : %s is not saved yet, not removing\n", st, this.entities[st].uniquename);
                    DangerZone.chunkwriter.addEntity(st);
                    break;
                }
                this.entities[st] = null;
                this.entity_free_list.add(st);
            }
            ii.remove();
            break;
        }
        this.entity_list_lock.unlock();
    }

    public List<Entity> findEntitiesInRange(float range, int dim, double x, double y, double z) {
        this.entity_list_lock.lock();
        ArrayList<Entity> retlist = new ArrayList<Entity>();
        for (int st : this.entity_list) {
            if (this.entities[st] == null || this.entities[st].dimension != dim) continue;
            double dx = x - this.entities[st].posx;
            double dy = y - this.entities[st].posy;
            double dz = z - this.entities[st].posz;
            if (!((dx = Math.sqrt(dx * dx + dy * dy + dz * dz)) < (double)range && this.entities[st] instanceof EntityLiving) && !(this.entities[st] instanceof Flag)) continue;
            retlist.add(this.entities[st]);
        }
        this.entity_list_lock.unlock();
        return retlist;
    }

    public List<Integer> findEntitiesInRangei(float range, int dim, double x, double y, double z) {
        this.entity_list_lock.lock();
        ArrayList<Integer> retlist = new ArrayList<Integer>();
        for (int st : this.entity_list) {
            if (this.entities[st] == null || this.entities[st].dimension != dim) continue;
            double dx = x - this.entities[st].posx;
            double dy = y - this.entities[st].posy;
            double dz = z - this.entities[st].posz;
            if (!((dx = Math.sqrt(dx * dx + dy * dy + dz * dz)) < (double)range && this.entities[st] instanceof EntityLiving) && !(this.entities[st] instanceof Flag)) continue;
            retlist.add(st);
        }
        this.entity_list_lock.unlock();
        return retlist;
    }

    public List<Entity> findALLEntitiesInRange(float range, int dim, double x, double y, double z) {
        this.entity_list_lock.lock();
        ArrayList<Entity> retlist = new ArrayList<Entity>();
        for (int st : this.entity_list) {
            if (this.entities[st] == null || this.entities[st].dimension != dim) continue;
            double dx = x - this.entities[st].posx;
            double dy = y - this.entities[st].posy;
            double dz = z - this.entities[st].posz;
            if (!((dx = Math.sqrt(dx * dx + dy * dy + dz * dz)) < (double)range)) continue;
            retlist.add(this.entities[st]);
        }
        this.entity_list_lock.unlock();
        return retlist;
    }
}

