/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.DangerZone;
import dangerzone.Utils;
import dangerzone.particles.Particle;
import dangerzone.particles.ParticleDroplet;
import dangerzone.particles.ParticleRain;
import dangerzone.rendering.Fastmath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ParticleUpdateLoop
implements Runnable {
    public List<Particle> particle_list = null;
    public Lock particle_list_lock = new ReentrantLock();
    public List<Particle> particle_add_list = null;
    public Lock particle_add_list_lock = new ReentrantLock();

    @Override
    public void run() {
        long lasttime = System.currentTimeMillis();
        long loop_interval = DangerZone.entityupdaterate;
        Particle ent2 = null;
        this.particle_list = new ArrayList<Particle>();
        this.particle_add_list = new ArrayList<Particle>();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        while (DangerZone.gameover == 0) {
            long currtime = System.currentTimeMillis();
            long tlong = currtime - lasttime;
            if ((tlong = loop_interval - tlong) < 0L) {
                tlong = 0L;
            }
            if (tlong > loop_interval) {
                tlong = loop_interval;
            }
            if (tlong > 0L) {
                try {
                    Thread.sleep(tlong);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                currtime = System.currentTimeMillis();
            }
            tlong = currtime - lasttime;
            lasttime = currtime;
            float deltaT = tlong;
            if (deltaT < 16.0f) {
                deltaT = 16.0f;
            }
            if (deltaT > 200.0f) {
                deltaT = 200.0f;
            }
            deltaT /= (float)loop_interval;
            if (DangerZone.gameover != 0) {
                return;
            }
            if (DangerZone.f12_on) continue;
            this.particle_list_lock.lock();
            for (Particle ent2 : this.particle_list) {
                if (ent2 == null || ent2.deleteme) continue;
                ent2.update(deltaT);
                if (ent2.lifetimeticker <= ent2.maxlifetime && ent2.dimension == DangerZone.player.dimension && !(ent2.posy < 0.0) && !(ent2.posy > 255.0)) continue;
                ent2.deleteme = true;
            }
            this.particle_list_lock.unlock();
            Thread.yield();
            this.particle_list_lock.lock();
            Iterator<Particle> li = this.particle_list.iterator();
            while (li.hasNext()) {
                ent2 = li.next();
                if (!ent2.deleteme) continue;
                li.remove();
            }
            this.particle_add_list_lock.lock();
            li = this.particle_add_list.iterator();
            while (li.hasNext()) {
                this.particle_list.add(li.next());
            }
            this.particle_add_list.clear();
            this.particle_add_list_lock.unlock();
            this.particle_list_lock.unlock();
            this.add_background_particles();
        }
        return;
    }

    public void addParticle(Particle e) {
        float dist = (float)Math.sqrt((e.posx - DangerZone.player.posx) * (e.posx - DangerZone.player.posx) + (e.posz - DangerZone.player.posz) * (e.posz - DangerZone.player.posz));
        int maxdist = e.maxrenderdist;
        if (DangerZone.graphics_mode >= 0) {
            maxdist += e.maxrenderdist;
        }
        if (DangerZone.graphics_mode >= 3) {
            maxdist += e.maxrenderdist;
        }
        if (dist < (float)maxdist) {
            this.particle_add_list_lock.lock();
            int sz = this.particle_list.size() + this.particle_add_list.size();
            int factor = DangerZone.wr.fps;
            if (DangerZone.graphics_mode >= 3) {
                factor = 60;
            }
            if (factor < 10) {
                factor = 10;
            }
            if (DangerZone.graphics_mode < 0) {
                factor /= 2;
            }
            if (sz > factor * 60) {
                if (e instanceof ParticleDroplet && Fastmath.nextInt(2) == 1) {
                    this.particle_add_list_lock.unlock();
                    return;
                }
                if (Fastmath.nextInt(2) == 1) {
                    this.particle_add_list_lock.unlock();
                    return;
                }
            }
            if (sz > factor * 80) {
                if (e instanceof ParticleDroplet && Fastmath.nextInt(2) == 1) {
                    this.particle_add_list_lock.unlock();
                    return;
                }
                if (e instanceof ParticleRain && Fastmath.nextInt(2) == 1) {
                    this.particle_add_list_lock.unlock();
                    return;
                }
                if (Fastmath.nextInt(2) == 1) {
                    this.particle_add_list_lock.unlock();
                    return;
                }
            }
            if (sz > factor * 100) {
                if (e instanceof ParticleDroplet) {
                    this.particle_add_list_lock.unlock();
                    return;
                }
                if (e instanceof ParticleRain) {
                    this.particle_add_list_lock.unlock();
                    return;
                }
                if (Fastmath.nextInt(2) == 1) {
                    this.particle_add_list_lock.unlock();
                    return;
                }
            }
            if (sz < factor * 120) {
                this.particle_add_list.add(e);
            }
            this.particle_add_list_lock.unlock();
        }
    }

    private void add_background_particles() {
        if (Fastmath.nextInt(25) != 0) {
            return;
        }
        String str = "DangerZone:ParticleSparkle";
        float dist = 8.0f + DangerZone.rand.nextFloat() * (float)DangerZone.renderdistance * 12.0f;
        float dir = (float)((double)DangerZone.rand.nextFloat() * Math.PI * 2.0);
        double posx = DangerZone.player.posx + Math.sin(dir) * (double)dist;
        double posz = DangerZone.player.posz + Math.cos(dir) * (double)dist;
        double posy = -1.0;
        int i = 250;
        while (i > 0) {
            if (DangerZone.player.world.getblock(DangerZone.player.dimension, (int)posx, i, (int)posz) != 0) {
                posy = i + 1;
                break;
            }
            --i;
        }
        if (posy > 0.0) {
            Utils.spawnParticles(DangerZone.player.world, str, 5, DangerZone.player.dimension, posx, posy, posz, false);
        }
    }
}

