/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.DangerZone;
import dangerzone.entities.Entity;
import dangerzone.world.Chunk;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ChunkWriterThread
implements Runnable {
    public List<Chunk> chunk_list;
    public List<Chunk> chunk_keep_list;
    public List<Integer> ent_list;
    public Lock chunk_list_lock = new ReentrantLock();

    @Override
    public void run() {
        this.chunk_list = new ArrayList<Chunk>();
        this.chunk_keep_list = new ArrayList<Chunk>();
        this.ent_list = new ArrayList<Integer>();
        Chunk ck = null;
        Entity ent = null;
        while (true) {
            try {
                if (DangerZone.graphics_mode >= 3) {
                    Thread.sleep(10L);
                } else {
                    Thread.sleep(20L);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.chunk_list_lock.lock();
            while (this.chunk_keep_list.size() > 0) {
                ck = this.chunk_keep_list.get(0);
                this.chunk_keep_list.remove(0);
                this.chunk_list_lock.unlock();
                ck.saveToDisk(false, false);
                ck = null;
                Thread.yield();
                this.chunk_list_lock.lock();
            }
            while (this.chunk_list.size() > 0) {
                ck = this.chunk_list.get(0);
                this.chunk_list.remove(0);
                this.chunk_list_lock.unlock();
                ck.saveToDisk(true, true);
                ck = null;
                Thread.yield();
                this.chunk_list_lock.lock();
            }
            while (this.ent_list.size() > 0) {
                ent = DangerZone.server.entityManager.findEntityByID(this.ent_list.get(0));
                this.ent_list.remove(0);
                if (ent == null) continue;
                this.chunk_list_lock.unlock();
                DangerZone.server_chunk_cache.getDecoratedChunk(ent.dimension, (int)ent.posx, 100, (int)ent.posz);
                ent = null;
                Thread.yield();
                this.chunk_list_lock.lock();
            }
            this.chunk_list_lock.unlock();
        }
    }

    public void addChunk(Chunk c) {
        this.chunk_list_lock.lock();
        int i = this.chunk_list.size();
        int j = 0;
        while (j < i) {
            if (c == this.chunk_list.get(j)) {
                this.chunk_list_lock.unlock();
                return;
            }
            ++j;
        }
        this.chunk_list.add(c);
        this.chunk_list_lock.unlock();
    }

    public void addEntity(int e) {
        this.chunk_list_lock.lock();
        int i = this.ent_list.size();
        int j = 0;
        while (j < i) {
            if (e == this.ent_list.get(j)) {
                this.chunk_list_lock.unlock();
                return;
            }
            ++j;
        }
        this.ent_list.add(e);
        this.chunk_list_lock.unlock();
    }

    public void addChunkKeep(Chunk c) {
        this.chunk_list_lock.lock();
        int i = this.chunk_list.size();
        int j = 0;
        while (j < i) {
            if (c == this.chunk_list.get(j)) {
                this.chunk_list_lock.unlock();
                return;
            }
            ++j;
        }
        i = this.chunk_keep_list.size();
        j = 0;
        while (j < i) {
            if (c == this.chunk_keep_list.get(j)) {
                this.chunk_list_lock.unlock();
                return;
            }
            ++j;
        }
        this.chunk_keep_list.add(c);
        this.chunk_list_lock.unlock();
    }

    public Chunk getChunk(int d, int cx, int cz) {
        Chunk c;
        this.chunk_list_lock.lock();
        int i = this.chunk_list.size();
        int j = 0;
        while (j < i) {
            c = this.chunk_list.get(j);
            if (d == c.dimension && c.chunkX == cx && c.chunkZ == cz) {
                this.chunk_list.remove(j);
                this.chunk_list_lock.unlock();
                return c;
            }
            ++j;
        }
        i = this.chunk_keep_list.size();
        j = 0;
        while (j < i) {
            c = this.chunk_keep_list.get(j);
            if (d == c.dimension && c.chunkX == cx && c.chunkZ == cz) {
                this.chunk_keep_list.remove(j);
                this.chunk_list_lock.unlock();
                return c;
            }
            ++j;
        }
        this.chunk_list_lock.unlock();
        return null;
    }

    public int getSize() {
        this.chunk_list_lock.lock();
        int i = this.chunk_list.size();
        i += this.chunk_keep_list.size();
        this.chunk_list_lock.unlock();
        return i += this.ent_list.size();
    }
}

