/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.rendering;

import dangerzone.DangerZone;
import dangerzone.Focus_Finder;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TargetInfo;
import dangerzone.Utils;
import dangerzone.biomes.Biome;
import dangerzone.biomes.BiomeManager;
import dangerzone.blocks.Block;
import dangerzone.blocks.BlockFlower;
import dangerzone.blocks.BlockLeaves;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Item;
import dangerzone.items.ItemBow;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.StitchedTextureFile;
import dangerzone.rendering.TextureMapper;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRendererUtils;
import dangerzone.threads.CleanerThread;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.Chunk;
import dangerzone.world.Dimension;
import dangerzone.world.Dimensions;
import dangerzone.world.World;
import java.awt.Font;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import slick.Texture;
import slick.TextureImpl;
import slick.TrueTypeFont;

public class WorldRenderer {
    public volatile List<long[]> VBO_delete_list;
    public Lock VBOlistlock = new ReentrantLock();
    public static Texture heart_texture = null;
    public static Texture unheart_texture = null;
    public static Texture hungerfull_texture = null;
    public static Texture hungerempty_texture = null;
    public static Texture bubble_texture = null;
    public static Texture sun_texture = null;
    public static Texture moon_texture = null;
    public static Texture magic_texture = null;
    public static Texture magicempty_texture = null;
    public static Texture focus_texture = null;
    public static int last_texture = -1;
    public static StitchedTextureFile[] stitches = null;
    public static int next_stitch = 0;
    public volatile int oneblock = -1;
    public int blockrenderwidth = 16;
    public int show_focus_x;
    public int show_focus_y;
    public int show_focus_z;
    public int show_focus_side;
    public int show_focus_bid;
    public int show_focus_meta;
    public float show_focus_damage = 0.0f;
    public float show_focus_maxdamage = 0.0f;
    public float show_focus_dist = 0.0f;
    public Entity show_focus_entity = null;
    public double show_poi_x;
    public double show_poi_y;
    public double show_poi_z;
    public Focus_Finder focus_finder = null;
    public static volatile boolean do_draw_focus = false;
    public float linewidth = 3.0f;
    public int topid;
    public int bottomid;
    public int leftid;
    public int rightid;
    public int frontid;
    public int backid;
    public Font awtfont = null;
    public TrueTypeFont font = null;
    public static float brightness_red;
    public static float brightness_green;
    public static float brightness_blue;
    public float sky_red;
    public float sky_green;
    public float sky_blue;
    private static Lock lock;
    private long lasttime = 0L;
    private long nowtime = 0L;
    public int fps = 30;
    private int fpscounter = 0;
    private int pps = 0;
    private int cps = 0;
    private float bounce = 0.0f;
    private float lastbounce = 0.0f;
    private float eatbounce = 0.0f;
    private int hit_cycles = 7;
    private int hit_cycle_count = 0;
    private int hit_cycle_dir = 1;
    private float hitx = -5.0f;
    private float hity = -9.2f;
    private float hitz = 2.5f;
    private float hitp = -19.7f;
    private float hitw = -27.6f;
    private float hitr = 11.5f;
    private float hitxn = -0.2f;
    private float hityn = -2.4f;
    private float hitzn = -5.3f;
    private float hitpn = -12.4f;
    private float hitwn = -47.5f;
    private float hitrn = 0.7f;
    private int eat_cycles = 7;
    private int eat_cycle_count = 0;
    private int eat_cycle_dir = 1;
    private int eat_delay_count = 0;
    private float eatxn = 5.0f;
    private float eatyn = -5.0f;
    private float eatzn = -7.9f;
    private float eatpn = -69.6f;
    private float eatwn = -16.5f;
    private float eatrn = 0.7f;
    private float hitxb = -5.4f;
    private float hityb = 2.9f;
    private float hitzb = -8.1f;
    private float hitpb = 0.8f;
    private float hitwb = -0.8f;
    private float hitrb = -27.7f;
    public float f5x;
    public float f5y;
    public float f5z;
    public float f5yaw;
    public float f5pitch;
    private float cdir;
    private float tdir;
    private float pdiff;
    private float ydiff;
    private float rdiff;
    public volatile long nextVBOid;
    public volatile Map<Long, VBOBuffer> VBOmap = null;
    public volatile List<VBOBuffer> translucentVBOs;
    public volatile int VBOmemorysize;
    public int lastplayerdimension = 0;
    private boolean eat_sound = true;
    private double traveled = 0.0;
    public long framecounter = 0L;
    public volatile int vbocount = 0;
    public VBODataBuilderThread builder = null;
    public VBODataBuilderThread builder_two = null;
    private int usex;
    private int usey;
    private int usez;
    private int uses;
    public Entity usee = null;
    private FloatBuffer wrfogColor = null;
    public Entity ViewFromEntity = null;
    public boolean normal_sun = true;
    public float shift_x = 0.0f;
    public float shift_z = 0.0f;
    public float shift_y = 0.0f;
    public float eyeadjust = 0.0f;
    public float ref_pitch = 0.0f;
    public float ref_yaw = 0.0f;
    public float ref_roll = 0.0f;
    public int ref_dim = 0;
    public double ref_posx = 0.0;
    public double ref_posy = 0.0;
    public double ref_posz = 0.0;
    public List<Integer> DrawMe = null;
    public List<Particle> DrawMeP = null;
    boolean doforce = false;

    static {
        lock = new ReentrantLock();
    }

    public WorldRenderer() {
        int stride;
        heart_texture = TextureMapper.getTexture("res/menus/heart.png");
        unheart_texture = TextureMapper.getTexture("res/menus/unheart.png");
        hungerfull_texture = TextureMapper.getTexture("res/menus/hungerfull.png");
        hungerempty_texture = TextureMapper.getTexture("res/menus/hungerempty.png");
        bubble_texture = TextureMapper.getTexture("res/menus/bubble.png");
        magic_texture = TextureMapper.getTexture("res/menus/star.png");
        magicempty_texture = TextureMapper.getTexture("res/menus/star_empty.png");
        focus_texture = TextureMapper.getTexture("res/misc/focus_block.png");
        int textureoff = stride = 12;
        int coloroff = stride += 8;
        ByteBuffer vbodata = BufferUtils.createByteBuffer(4 * (stride += 12));
        GregorianCalendar gcalendar = new GregorianCalendar();
        int nowmonth = gcalendar.get(2);
        int nowday = gcalendar.get(5);
        if (nowmonth == 9 && nowday == 31) {
            sun_texture = TextureMapper.getTexture("res/misc/sunpumpkin.png");
            this.normal_sun = false;
        } else {
            sun_texture = TextureMapper.getTexture("res/misc/sun.png");
        }
        moon_texture = TextureMapper.getTexture("res/misc/moon.png");
        stitches = new StitchedTextureFile[20];
        this.nextVBOid = 1L;
        this.VBOmap = new HashMap<Long, VBOBuffer>();
        this.VBO_delete_list = new ArrayList<long[]>();
        this.translucentVBOs = new ArrayList<VBOBuffer>();
        this.framecounter = 0L;
        this.vbocount = 0;
        this.VBOmemorysize = 0;
        if (this.font == null) {
            this.awtfont = new Font("Times New Roman", 0, 24);
            this.font = new TrueTypeFont(this.awtfont, false);
        }
        this.oneblock = -1;
        this.topid = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.topid);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        vbodata.flip();
        int vbo_buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo_buffer);
        GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        vbodata.rewind();
        this.bottomid = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.bottomid);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        vbodata.flip();
        vbo_buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo_buffer);
        GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        vbodata.rewind();
        this.frontid = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.frontid);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        vbodata.flip();
        vbo_buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo_buffer);
        GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        vbodata.rewind();
        this.backid = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.backid);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        vbodata.flip();
        vbo_buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo_buffer);
        GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        vbodata.rewind();
        this.leftid = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.leftid);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        vbodata.flip();
        vbo_buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo_buffer);
        GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        vbodata.rewind();
        this.rightid = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.rightid);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        vbodata.flip();
        vbo_buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo_buffer);
        GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        vbodata.rewind();
        this.wrfogColor = BufferUtils.createFloatBuffer(4);
        this.wrfogColor.put(0.75f);
        this.wrfogColor.put(0.75f);
        this.wrfogColor.put(0.75f);
        this.wrfogColor.put(1.0f);
        this.wrfogColor.position(0);
        this.ViewFromEntity = DangerZone.player;
        this.ref_yaw = DangerZone.player.rotation_yaw_head;
        this.ref_pitch = DangerZone.player.rotation_pitch_head;
        this.ref_roll = DangerZone.player.rotation_roll_head;
        this.ref_posx = DangerZone.player.display_posx;
        this.ref_posy = DangerZone.player.display_posy;
        this.ref_posz = DangerZone.player.display_posz;
        this.focus_finder = new Focus_Finder();
        this.show_focus_x = 0;
        this.show_focus_y = 0;
        this.show_focus_z = 0;
        this.show_focus_side = 0;
        this.show_focus_bid = 0;
        this.show_focus_meta = 0;
        this.show_focus_damage = 0.0f;
        this.show_focus_maxdamage = 0.0f;
        this.show_focus_dist = 0.0f;
        this.show_focus_entity = null;
        this.show_poi_z = 0.0;
        this.show_poi_y = 0.0;
        this.show_poi_x = 0.0;
        this.DrawMe = new ArrayList<Integer>();
        this.DrawMeP = new ArrayList<Particle>();
    }

    private void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        vbodata.putFloat(vx);
        vbodata.putFloat(vy);
        vbodata.putFloat(vz);
        vbodata.putFloat(tx);
        vbodata.putFloat(ty);
        vbodata.putFloat(br);
        vbodata.putFloat(bg);
        vbodata.putFloat(bb);
    }

    public void loadBlockTextures() {
        StitchedTexture st = null;
        int bid = 0;
        while (bid < 2048) {
            if (Blocks.BlockArray[bid] != null) {
                int side = 0;
                while (side < 6) {
                    st = Blocks.BlockArray[bid].getStitchedTexture(side);
                    if (st.texturesindex < 0) {
                        StitchedTextureFile stf = stitches[next_stitch];
                        if (stf == null) {
                            WorldRenderer.stitches[WorldRenderer.next_stitch] = new StitchedTextureFile();
                        }
                        stf = stitches[next_stitch];
                        if (stf.nexty >= 32) {
                            stitches[next_stitch].doMakeMipMaps();
                            WorldRenderer.stitches[++WorldRenderer.next_stitch] = new StitchedTextureFile();
                        }
                        st.texturesindex = next_stitch;
                        StitchedTexture stnew = stitches[next_stitch].doAddTextureToBuffer(Blocks.BlockArray[bid].getStitchedTextureName(side));
                        if (stnew != null) {
                            st.yoffsetmax = stnew.yoffsetmax;
                            st.yoffsetmin = stnew.yoffsetmin;
                            st.xoffsetmax = stnew.xoffsetmax;
                            st.xoffsetmin = stnew.xoffsetmin;
                        }
                    }
                    ++side;
                }
            }
            ++bid;
        }
        stitches[next_stitch].doMakeMipMaps();
    }

    public void loadOneBlockTexture(int bid) {
        StitchedTexture st = null;
        if (Blocks.BlockArray[bid] != null) {
            int side = 0;
            while (side < 6) {
                st = Blocks.BlockArray[bid].getStitchedTexture(side);
                if (st.texturesindex < 0) {
                    StitchedTextureFile stf = stitches[next_stitch];
                    if (stf == null) {
                        WorldRenderer.stitches[WorldRenderer.next_stitch] = new StitchedTextureFile();
                    }
                    stf = stitches[next_stitch];
                    if (stf.nexty >= 32) {
                        WorldRenderer.stitches[++WorldRenderer.next_stitch] = new StitchedTextureFile();
                    }
                    st.texturesindex = next_stitch;
                    StitchedTexture stnew = stitches[next_stitch].doAddTexture(Blocks.BlockArray[bid].getStitchedTextureName(side));
                    if (stnew != null) {
                        st.yoffsetmax = stnew.yoffsetmax;
                        st.yoffsetmin = stnew.yoffsetmin;
                        st.xoffsetmax = stnew.xoffsetmax;
                        st.xoffsetmin = stnew.xoffsetmin;
                    }
                }
                ++side;
            }
        }
    }

    private void doHouseKeeping(World world, int inview) {
        ++this.framecounter;
        if (this.builder == null) {
            this.builder = new VBODataBuilderThread(world);
            this.builder.odd_even = 0;
            Thread cwt = new Thread(this.builder);
            cwt.setPriority(5);
            cwt.start();
            this.builder_two = new VBODataBuilderThread(world);
            this.builder_two.odd_even = 1;
            Thread cwt_two = new Thread(this.builder_two);
            cwt_two.setPriority(5);
            cwt_two.start();
        }
        ++this.fpscounter;
        this.nowtime = System.currentTimeMillis();
        if (this.nowtime - this.lasttime > 1000L) {
            this.fps = (this.fps * 2 + this.fpscounter) / 3;
            ++this.fps;
            if (this.fps < 1) {
                this.fps = 1;
            }
            this.fpscounter = 0;
            this.lasttime = this.nowtime;
            this.pps = DangerZone.packets_per_second;
            DangerZone.packets_per_second = 0;
            this.cps = DangerZone.chunks_per_second;
            DangerZone.chunks_per_second = 0;
        }
        if (this.lastplayerdimension != DangerZone.player.dimension) {
            world.chunkcache.releaseAllVBOs();
            this.lastplayerdimension = DangerZone.player.dimension;
            CleanerThread.cleanmenowplease = true;
            while (CleanerThread.cleanmenowplease) {
                Thread.yield();
            }
        }
        if (this.oneblock != -1) {
            this.loadOneBlockTexture(this.oneblock);
            this.oneblock = -1;
        }
        this.VBOlistlock.lock();
        if (!this.VBO_delete_list.isEmpty()) {
            Iterator<long[]> ii = this.VBO_delete_list.iterator();
            while (ii.hasNext()) {
                long[] st = ii.next();
                if (st != null) {
                    int vdx = 0;
                    while (vdx < 20) {
                        if (st[vdx] != 0L) {
                            VBOBuffer v = this.VBOmap.get(st[vdx]);
                            if (v != null) {
                                this.VBOmap.remove(v.VBOid);
                                --this.vbocount;
                                v.free();
                            }
                            st[vdx] = 0L;
                        }
                        ++vdx;
                    }
                }
                ii.remove();
            }
        }
        int maxvbo = 5000;
        int maxdirect = 2000;
        if (DangerZone.renderdistance <= 16) {
            maxvbo = 3000;
            maxdirect = 1000;
        }
        if (this.vbocount > maxvbo || this.VBOmemorysize / 0x100000 > maxdirect) {
            Iterator<Map.Entry<Long, VBOBuffer>> it = this.VBOmap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, VBOBuffer> pair = it.next();
                VBOBuffer v = pair.getValue();
                if (v == null || this.framecounter - v.lastusedframe <= 10L) continue;
                --this.vbocount;
                v.free();
                it.remove();
            }
        }
        this.VBOlistlock.unlock();
        if (this.ViewFromEntity != DangerZone.player) {
            if (this.ViewFromEntity == null) {
                this.ViewFromEntity = DangerZone.player;
                this.ref_yaw = DangerZone.player.rotation_yaw_head;
            }
            if (this.ViewFromEntity.deadflag) {
                this.ViewFromEntity = DangerZone.player;
                this.ref_yaw = DangerZone.player.rotation_yaw_head;
            }
        }
        this.ViewFromEntity.dimension = DangerZone.player.dimension;
    }

    private void calcBounceAndFocus(World world) {
        this.eyeadjust = (float)((double)this.ViewFromEntity.getEyeHeight() + DangerZone.eyeheight_adjust);
        if (this.eyeadjust < 0.0f) {
            this.eyeadjust = 0.0f;
        }
        if (this.ViewFromEntity != DangerZone.player) {
            this.lastbounce = 0.0f;
            this.bounce = 0.0f;
            this.ViewFromEntity.rotation_pitch_head %= 360.0f;
            this.ViewFromEntity.rotation_yaw_head %= 360.0f;
            this.ViewFromEntity.rotation_roll_head %= 360.0f;
            this.ref_yaw = 360.0f - (this.ViewFromEntity.rotation_yaw_head + 180.0f) % 360.0f;
            this.ref_pitch = this.ViewFromEntity.rotation_pitch_head;
            this.ref_roll = this.ViewFromEntity.rotation_roll_head;
            this.ref_posx = this.ViewFromEntity.display_posx;
            this.ref_posy = this.ViewFromEntity.display_posy;
            this.ref_posz = this.ViewFromEntity.display_posz;
            this.ref_dim = this.ViewFromEntity.dimension;
            return;
        }
        if (!DangerZone.isVR) {
            this.ref_pitch = DangerZone.player.rotation_pitch_head;
            this.ref_yaw = DangerZone.player.rotation_yaw_head;
            this.ref_roll = DangerZone.player.rotation_roll_head;
            this.ref_posx = this.ViewFromEntity.display_posx;
            this.ref_posy = this.ViewFromEntity.display_posy;
            this.ref_posz = this.ViewFromEntity.display_posz;
            this.ref_dim = this.ViewFromEntity.dimension;
        } else {
            this.ref_pitch = DangerZone.headset.display_pitch;
            this.ref_yaw = DangerZone.headset.display_yaw;
            this.ref_roll = DangerZone.headset.display_roll;
            this.ref_posx = this.ViewFromEntity.display_posx;
            this.ref_posy = this.ViewFromEntity.display_posy;
            this.ref_posz = this.ViewFromEntity.display_posz;
            this.ref_dim = this.ViewFromEntity.dimension;
        }
        if (DangerZone.player.getGameMode() != 2 && DangerZone.player.getGameMode() != 3 && DangerZone.player.getRiddenEntity() == null) {
            double rdd = Math.sqrt(DangerZone.player.motionx * DangerZone.player.motionx + DangerZone.player.motionz * DangerZone.player.motionz);
            if (DangerZone.player.isLadder()) {
                rdd = Math.abs(DangerZone.player.motiony * 2.0f);
            }
            this.traveled += rdd;
            if (DangerZone.player.isBaby()) {
                this.traveled += rdd;
                rdd /= 2.0;
            }
            rdd /= 18.0;
            if ((rdd *= ((double)0.35f - rdd) * 2.0) < 0.0) {
                rdd = 0.0;
            }
            if (DangerZone.gofast != 0) {
                this.bounce = (float)(rdd * Math.cos(Math.toRadians(this.traveled * 11.3)));
            } else {
                this.bounce = (float)(rdd * Math.cos(Math.toRadians(this.traveled * 13.3)));
                this.bounce = (float)((double)this.bounce * 2.5);
            }
            if (!DangerZone.player.getOnGround() && !DangerZone.player.isLadder()) {
                this.bounce = 0.0f;
            }
        } else {
            this.bounce = 0.0f;
        }
        if (this.bounce != 0.0f && (this.lastbounce > 0.0f && this.bounce < 0.0f || this.lastbounce < 0.0f && this.bounce > 0.0f)) {
            DangerZone.world.playSound(Blocks.getStepSound(DangerZone.world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy - (double)0.1f), (int)DangerZone.player.posz)), DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.2f);
        }
        this.lastbounce = this.bounce;
        DangerZone.player.posx += Math.cos(Math.toRadians(DangerZone.player.rotation_yaw)) * (double)this.bounce / 12.0;
        DangerZone.player.posz += Math.sin(Math.toRadians(DangerZone.player.rotation_yaw)) * (double)this.bounce / 12.0;
        if (this.bounce < 0.0f) {
            this.bounce = -this.bounce;
        }
        DangerZone.player.rotation_pitch_head %= 360.0f;
        DangerZone.player.rotation_yaw_head %= 360.0f;
        DangerZone.player.rotation_roll_head %= 360.0f;
        boolean changed = this.focus_finder.find_focus(world);
        if (!DangerZone.isVR || changed) {
            this.show_focus_x = this.focus_finder.focus_x;
            this.show_focus_y = this.focus_finder.focus_y;
            this.show_focus_z = this.focus_finder.focus_z;
            this.show_focus_side = this.focus_finder.focus_side;
            this.show_focus_bid = this.focus_finder.focus_bid;
            this.show_focus_meta = this.focus_finder.focus_meta;
            this.show_focus_damage = this.focus_finder.focus_damage;
            this.show_focus_maxdamage = this.focus_finder.focus_maxdamage;
            this.show_focus_dist = this.focus_finder.focus_dist;
            this.show_focus_entity = this.focus_finder.focus_entity;
            this.show_poi_x = this.focus_finder.poi_x;
            this.show_poi_y = this.focus_finder.poi_y;
            this.show_poi_z = this.focus_finder.poi_z;
        }
    }

    private void lookAtSelf(World world) {
        float t;
        float ddst;
        Entity e;
        float dst;
        this.f5pitch = 0.0f;
        this.f5yaw = 0.0f;
        this.f5z = 0.0f;
        this.f5y = 0.0f;
        this.f5x = 0.0f;
        if (DangerZone.f5_front) {
            dst = this.ViewFromEntity.getHeight() * 3.25f;
            if (dst < 6.0f) {
                dst = 6.0f;
            }
            if ((e = this.ViewFromEntity.getRiddenEntity()) != null && dst < (ddst = e.getHeight() * 3.25f)) {
                dst = ddst;
            }
            t = (float)Math.cos(Math.toRadians(this.ref_pitch));
            this.f5y = (float)Math.sin(Math.toRadians(this.ref_pitch)) * dst * (float)this.blockrenderwidth;
            this.f5x = (float)Math.cos(Math.toRadians(this.ref_yaw + 90.0f)) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5z = (float)Math.sin(Math.toRadians(this.ref_yaw + 90.0f)) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5yaw = 180.0f;
            this.f5pitch = this.ref_pitch * 2.0f;
            if (!DangerZone.isVR) {
                this.f5pitch = -this.ref_pitch * 2.0f;
            }
        }
        if (DangerZone.f5_back) {
            dst = this.ViewFromEntity.getHeight() * 4.25f;
            if (dst < 8.0f) {
                dst = 8.0f;
            }
            if ((e = this.ViewFromEntity.getRiddenEntity()) != null && dst < (ddst = e.getHeight() * 4.25f)) {
                dst = ddst;
            }
            t = (float)Math.cos(Math.toRadians(this.ref_pitch));
            this.f5y = -((float)Math.sin(Math.toRadians(this.ref_pitch))) * dst * (float)this.blockrenderwidth;
            this.f5x = -((float)Math.cos(Math.toRadians(this.ref_yaw + 90.0f))) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5z = -((float)Math.sin(Math.toRadians(this.ref_yaw + 90.0f))) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5yaw = 0.0f;
            this.f5pitch = 0.0f;
        }
        if (DangerZone.f5_side) {
            dst = this.ViewFromEntity.getHeight() * 3.25f;
            if (dst < 6.0f) {
                dst = 6.0f;
            }
            if ((e = this.ViewFromEntity.getRiddenEntity()) != null && dst < (ddst = e.getHeight() * 3.25f)) {
                dst = ddst;
            }
            t = (float)Math.cos(Math.toRadians(this.ref_pitch));
            this.f5y = (float)Math.sin(Math.toRadians(this.ref_pitch)) * dst * (float)this.blockrenderwidth;
            this.f5x = -((float)Math.cos(Math.toRadians(this.ref_yaw - 35.0f))) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5z = -((float)Math.sin(Math.toRadians(this.ref_yaw - 35.0f))) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5yaw = 235.0f;
            this.f5pitch = 0.0f;
            if (!DangerZone.isVR) {
                this.f5pitch = -this.ref_pitch * 2.0f;
            }
        }
        if (DangerZone.f5_front || DangerZone.f5_back || DangerZone.f5_side) {
            this.Scalef5toSolid();
        }
    }

    private void doClickyStuff(World world) {
        InventoryContainer ic;
        int i;
        if (this.ViewFromEntity != DangerZone.player) {
            return;
        }
        if (DangerZone.player.getGameMode() == 3) {
            this.hit_cycle_count = 0;
            DangerZone.do_hit_cycle = 0;
            this.eat_cycle_count = 0;
            DangerZone.do_food_cycle = 0;
            DangerZone.dorightclickup = false;
            DangerZone.rightbuttondowncounter = 0;
            DangerZone.vrdorightclickup = false;
            DangerZone.vrrightbuttondowncounter = 0;
            DangerZone.singleshot = false;
            DangerZone.vrsingleshot = false;
            DangerZone.semiauto = false;
            DangerZone.vrsemiauto = false;
            DangerZone.fullauto = false;
            DangerZone.vrfullauto = false;
            return;
        }
        if (this.hit_cycle_count != 0) {
            i = this.fps / 10;
            if (i < 1) {
                i = 1;
            }
            if (i > 6) {
                i = 6;
            }
            this.hit_cycles = i + 1;
            this.hit_cycle_count += this.hit_cycle_dir;
            if (this.hit_cycle_count >= this.hit_cycles) {
                if (DangerZone.doleftclick || DangerZone.vrdoleftclick) {
                    DangerZone.player.leftclick(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.magic_power, DangerZone.magic_type, this.show_poi_x, this.show_poi_y, this.show_poi_z);
                    DangerZone.doleftclick = false;
                    DangerZone.vrdoleftclick = false;
                    DangerZone.magic_power = 0.0f;
                }
                if (DangerZone.dorightclick || DangerZone.vrdorightclick) {
                    DangerZone.player.rightclick(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, this.show_poi_x, this.show_poi_y, this.show_poi_z);
                    DangerZone.dorightclick = false;
                    DangerZone.vrdorightclick = false;
                    DangerZone.magic_power = 0.0f;
                }
                this.hit_cycle_dir = -1;
            }
        } else if (DangerZone.do_hit_cycle != 0) {
            this.hit_cycle_count = 1;
            this.hit_cycle_dir = 1;
            this.usex = this.show_focus_x;
            this.usey = this.show_focus_y;
            this.usez = this.show_focus_z;
            this.uses = this.show_focus_side;
            this.usee = this.show_focus_entity;
            if (DangerZone.doleftclick) {
                int which = DangerZone.player.world.rand.nextInt(6);
                if (which == 0) {
                    DangerZone.player.world.playSound("DangerZone:swish3", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
                if (which == 1) {
                    DangerZone.player.world.playSound("DangerZone:swish4", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
                if (which == 2) {
                    DangerZone.player.world.playSound("DangerZone:swish5", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
                if (which == 3) {
                    DangerZone.player.world.playSound("DangerZone:swish6", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
                if (which == 4) {
                    DangerZone.player.world.playSound("DangerZone:swish7", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
                if (which == 5) {
                    DangerZone.player.world.playSound("DangerZone:swish8", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
            }
        }
        if (this.eat_cycle_count != 0) {
            i = this.fps / 2;
            if (i < 1) {
                i = 1;
            }
            if (i > 30) {
                i = 30;
            }
            this.eat_cycles = i + 1;
            this.eat_cycle_count += this.eat_cycle_dir;
            if (this.eat_cycle_count >= this.eat_cycles) {
                InventoryContainer ic2 = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
                this.eat_cycle_count = this.eat_cycles;
                if (this.eat_delay_count > 0) {
                    if (this.eat_sound) {
                        world.playSound("DangerZone:eating", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
                    }
                    this.eat_sound = false;
                    --this.eat_delay_count;
                } else {
                    Item itm;
                    if (ic2 != null && Items.isFood(ic2.iid) && (DangerZone.player.getHunger() < DangerZone.player.getMaxHunger() || Items.eatAnyTime(ic2.iid)) && (itm = ic2.getItem()) != null) {
                        itm.onFoodEaten(DangerZone.player);
                        DangerZone.server_connection.playerActionToServer(0, 2, itm.itemID, 0, 0, 0, 0, 0.0f, 0);
                        if (ic2 != null && Items.isFood(ic2.iid)) {
                            Utils.spawnParticlesScaled(DangerZone.player.world, "DangerZone:ParticleItem", 10, DangerZone.player.dimension, DangerZone.player.posx + (double)((float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 0.25f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head))), DangerZone.player.posy + (double)(DangerZone.player.height * 9.25f / 10.0f) - (double)((float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 0.25f), DangerZone.player.posz + (double)((float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 0.25f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head))), ic2.iid, 0.25f, true);
                        }
                    }
                    this.eat_cycle_dir = -1;
                }
            }
        } else if (DangerZone.do_food_cycle != 0 && (ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex())) != null && Items.isFood(ic.iid) && (DangerZone.player.getHunger() < DangerZone.player.getMaxHunger() || Items.eatAnyTime(ic.iid))) {
            this.eat_cycle_count = 1;
            this.eat_cycle_dir = 1;
            this.eat_delay_count = this.fps + 10;
            this.eat_sound = true;
        }
        if (DangerZone.dorightclickup) {
            DangerZone.player.rightclickup(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.rightbuttondowncounter * 100 / this.fps);
            DangerZone.dorightclickup = false;
            DangerZone.rightbuttondowncounter = 0;
        }
        if (DangerZone.vrdorightclickup) {
            DangerZone.player.rightclickup(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.vrrightbuttondowncounter * 100 / this.fps);
            DangerZone.vrdorightclickup = false;
            DangerZone.vrrightbuttondowncounter = 0;
        }
        if (DangerZone.singleshot) {
            DangerZone.player.singleshot(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.rightbuttondowncounter * 100 / this.fps);
            DangerZone.singleshot = false;
        }
        if (DangerZone.vrsingleshot) {
            DangerZone.player.singleshot(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.vrrightbuttondowncounter * 100 / this.fps);
            DangerZone.vrsingleshot = false;
        }
        if (DangerZone.semiauto) {
            DangerZone.player.semiauto(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.rightbuttondowncounter * 100 / this.fps);
            DangerZone.semiauto = false;
        }
        if (DangerZone.vrsemiauto) {
            DangerZone.player.semiauto(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.vrrightbuttondowncounter * 100 / this.fps);
            DangerZone.vrsemiauto = false;
        }
        if (DangerZone.fullauto) {
            DangerZone.player.fullauto(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.rightbuttondowncounter * 100 / this.fps);
            DangerZone.fullauto = false;
        }
        if (DangerZone.vrfullauto) {
            DangerZone.player.fullauto(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.vrrightbuttondowncounter * 100 / this.fps);
            DangerZone.vrfullauto = false;
        }
        if (DangerZone.vrrightbuttondowncounter > 0) {
            DangerZone.player.setRightButtonDownCount(DangerZone.vrrightbuttondowncounter * 100 / this.fps);
        } else {
            DangerZone.player.setRightButtonDownCount(DangerZone.rightbuttondowncounter * 100 / this.fps);
        }
    }

    private void drawPlayerHeldItem(World world) {
        if (DangerZone.isVR) {
            this.drawPlayerHeldItem_VR(world);
        } else {
            this.drawPlayerHeldItem_3D(world);
        }
    }

    private void drawPlayerHeldItem_VR(World world) {
        if (this.ViewFromEntity != DangerZone.player) {
            return;
        }
        InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
        if (!(ic == null || DangerZone.f5_front || DangerZone.f5_back || DangerZone.f5_side)) {
            Item it;
            TargetInfo ti = DangerZone.weapon_controller;
            WorldRenderer.recalcBrightness(DangerZone.player.dimension, (int)(DangerZone.player.posy + (double)(DangerZone.player.getHeight() / 2.0f)));
            this.setBrightness(WorldRendererUtils.getLightMapValue(world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy + (double)(DangerZone.player.getHeight() / 2.0f)), (int)DangerZone.player.posz));
            this.rotate_world_view();
            MatrixStack.sendCurrentStack();
            MatrixStack.pushMatrix();
            MatrixStack.translate((float)(ti.rel_posx - DangerZone.headset.rel_posx) * 16.0f + this.shift_x, (float)(ti.rel_posy - DangerZone.headset.rel_posy) * 16.0f + this.shift_y, (float)(ti.rel_posz - DangerZone.headset.rel_posz) * 16.0f + this.shift_z);
            MatrixStack.sendCurrentStack();
            MatrixStack.pushMatrix();
            MatrixStack.rotate(ti.display_pitch, 1.0f, 0.0f, 0.0f);
            MatrixStack.rotate(ti.display_yaw, 0.0f, 1.0f, 0.0f);
            MatrixStack.rotate(ti.display_roll, 0.0f, 0.0f, 1.0f);
            if (ic.iid != 0 && (it = ic.getItem()) != null) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                MatrixStack.scale(0.45f, 0.45f, 0.45f);
                MatrixStack.sendCurrentStack();
                MatrixStack.pushMatrix();
                MatrixStack.rotate(it.roll_off, 0.0f, 0.0f, 1.0f);
                MatrixStack.rotate(it.yaw_off, 0.0f, 1.0f, 0.0f);
                MatrixStack.rotate(it.pitch_off, 1.0f, 0.0f, 0.0f);
                MatrixStack.translate(it.xoff, it.yoff, it.zoff);
                this.forceloadtexture(Items.getTexture(ic.iid));
                MatrixStack.sendCurrentStack();
                Items.renderMeHeld(this, DangerZone.player, ic, true);
                MatrixStack.popMatrix();
                GL11.glDisable((int)3042);
            }
            if (ic.bid != 0) {
                MatrixStack.scale(0.2f, 0.2f, 0.2f);
                MatrixStack.sendCurrentStack();
                if (Blocks.hasOwnRenderer(ic.bid)) {
                    Blocks.renderMeHeld(DangerZone.wr, DangerZone.player, ic.bid, true);
                } else {
                    this.drawTexturedCube(255, Blocks.isSolidForRender(ic.bid), ic.bid, 0, false);
                }
            }
            MatrixStack.popMatrix();
            MatrixStack.popMatrix();
            MatrixStack.adjustStackDepthDown();
        }
    }

    private void drawPlayerHeldItem_3D(World world) {
        if (this.ViewFromEntity != DangerZone.player) {
            return;
        }
        InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
        if (!(ic == null || DangerZone.f5_front || DangerZone.f5_back || DangerZone.f5_side)) {
            Block bl;
            WorldRenderer.recalcBrightness(DangerZone.player.dimension, (int)(DangerZone.player.posy + (double)(DangerZone.player.getHeight() / 2.0f)));
            this.setBrightness(WorldRendererUtils.getLightMapValue(world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy + (double)(DangerZone.player.getHeight() / 2.0f)), (int)DangerZone.player.posz));
            if (ic.bid != 0 && ((bl = Blocks.BlockArray[ic.bid]) instanceof BlockFlower || bl instanceof BlockLeaves) && this.hit_cycle_count >= this.hit_cycles) {
                Utils.spawnParticlesScaled(DangerZone.player.world, "DangerZone:ParticleDust", 4, DangerZone.player.dimension, DangerZone.player.posx + (double)((float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 2.0f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head))), DangerZone.player.posy + (double)(DangerZone.player.height * 9.5f / 10.0f) - (double)((float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f), DangerZone.player.posz + (double)((float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 2.0f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head))), 0, 0.125f, false);
            }
            MatrixStack.sendCurrentStack();
            MatrixStack.pushMatrix();
            MatrixStack.translate(6.0f, -(4.0f + this.bounce * 2.0f), -540.0f / (float)DangerZone.fieldOfView);
            MatrixStack.rotate(-15.0f, 1.0f, 0.0f, 0.0f);
            MatrixStack.sendCurrentStack();
            MatrixStack.pushMatrix();
            if (ic.bid != 0) {
                MatrixStack.scale(0.2f, 0.2f, 0.2f);
                if (this.hit_cycle_count != 0) {
                    MatrixStack.translate(0.2f + this.hitxb * ((float)this.hit_cycle_count / (float)this.hit_cycles), -1.2f + this.hityb * ((float)this.hit_cycle_count / (float)this.hit_cycles), -0.1f + this.hitzb * ((float)this.hit_cycle_count / (float)this.hit_cycles));
                    MatrixStack.rotate(4.3f + this.hitpb * ((float)this.hit_cycle_count / (float)this.hit_cycles), 1.0f, 0.0f, 0.0f);
                    MatrixStack.rotate(-2.5f + this.hitwb * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 1.0f, 0.0f);
                    MatrixStack.rotate(-0.1f + this.hitrb * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 0.0f, 1.0f);
                } else {
                    MatrixStack.translate(0.2f, -1.2f, -0.1f);
                    MatrixStack.rotate(4.3f, 1.0f, 0.0f, 0.0f);
                    MatrixStack.rotate(-2.5f, 0.0f, 1.0f, 0.0f);
                    MatrixStack.rotate(-0.1f, 0.0f, 0.0f, 1.0f);
                }
                MatrixStack.sendCurrentStack();
                if (Blocks.hasOwnRenderer(ic.bid)) {
                    Blocks.renderMeHeld(DangerZone.wr, DangerZone.player, ic.bid, true);
                } else {
                    this.drawTexturedCube(255, Blocks.isSolidForRender(ic.bid), ic.bid, 0, false);
                }
            } else if (ic.iid != 0) {
                MatrixStack.scale(0.35f, 0.35f, 0.35f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                if (Items.isFlipped(ic.iid)) {
                    if (Items.getfullholdcount(ic.iid) == 0.0f || DangerZone.rightbuttondowncounter == 0 && DangerZone.rapidfire_delay == 0) {
                        if (this.hit_cycle_count != 0) {
                            MatrixStack.translate(this.hitx * ((float)this.hit_cycle_count / (float)this.hit_cycles), this.hity * ((float)this.hit_cycle_count / (float)this.hit_cycles), this.hitz * ((float)this.hit_cycle_count / (float)this.hit_cycles));
                            MatrixStack.rotate(this.hitp * ((float)this.hit_cycle_count / (float)this.hit_cycles) + 251.6f, 1.0f, 0.0f, 0.0f);
                            MatrixStack.rotate(this.hitw * ((float)this.hit_cycle_count / (float)this.hit_cycles) + 38.5f + this.bounce * 4.0f, 0.0f, 1.0f, 0.0f);
                            MatrixStack.rotate(this.hitr * ((float)this.hit_cycle_count / (float)this.hit_cycles) - 81.7f + this.bounce * 4.0f, 0.0f, 0.0f, 1.0f);
                        } else if (this.eat_cycle_count == 0) {
                            MatrixStack.translate(0.0f, 0.8f, 0.0f);
                            MatrixStack.rotate(248.5f, 1.0f, 0.0f, 0.0f);
                            MatrixStack.rotate(57.1f + this.bounce * 4.0f, 0.0f, 1.0f, 0.0f);
                            MatrixStack.rotate(-76.8f + this.bounce * 4.0f, 0.0f, 0.0f, 1.0f);
                        }
                    }
                } else if (Items.getfullholdcount(ic.iid) != 0.0f && (DangerZone.rightbuttondowncounter != 0 || DangerZone.rapidfire_delay != 0)) {
                    if (ic.getItem() instanceof ItemBow) {
                        MatrixStack.translate(-1.3f, -0.5f, -0.2f);
                        MatrixStack.rotate(64.0f, 1.0f, 0.0f, 0.0f);
                        MatrixStack.rotate(-51.2f + this.bounce * 4.0f, 0.0f, 1.0f, 0.0f);
                        MatrixStack.rotate(-109.7f + this.bounce * 4.0f, 0.0f, 0.0f, 1.0f);
                    } else {
                        MatrixStack.translate(0.1f, 0.8f, 0.5f);
                        MatrixStack.rotate(-92.4f, 1.0f, 0.0f, 0.0f);
                        MatrixStack.rotate(59.2f + this.bounce * 4.0f, 0.0f, 1.0f, 0.0f);
                        MatrixStack.rotate(-86.8f + this.bounce * 4.0f, 0.0f, 0.0f, 1.0f);
                    }
                } else if (this.hit_cycle_count != 0) {
                    MatrixStack.translate(0.1f + this.hitxn * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.8f + this.hityn * ((float)this.hit_cycle_count / (float)this.hit_cycles), -0.1f + this.hitzn * ((float)this.hit_cycle_count / (float)this.hit_cycles));
                    MatrixStack.rotate(-91.5f + this.hitpn * ((float)this.hit_cycle_count / (float)this.hit_cycles), 1.0f, 0.0f, 0.0f);
                    MatrixStack.rotate(-3.1f + this.bounce * 4.0f + this.hitwn * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 1.0f, 0.0f);
                    MatrixStack.rotate(-88.2f + this.bounce * 4.0f + this.hitrn * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 0.0f, 1.0f);
                } else if (this.eat_cycle_count != 0) {
                    this.eatbounce = this.bounce;
                    if (this.eat_cycle_count >= this.eat_cycles && this.eat_delay_count > 0) {
                        this.eatbounce = (float)Math.cos(Math.toRadians((float)DangerZone.player.lifetimeticker * 25.3f));
                    }
                    MatrixStack.translate(0.1f + this.eatxn * ((float)this.eat_cycle_count / (float)this.eat_cycles), 0.8f + this.eatyn * ((float)this.eat_cycle_count / (float)this.eat_cycles), 0.5f + this.eatzn * ((float)this.eat_cycle_count / (float)this.eat_cycles));
                    MatrixStack.rotate(-92.4f + this.eatpn * ((float)this.eat_cycle_count / (float)this.eat_cycles), 1.0f, 0.0f, 0.0f);
                    MatrixStack.rotate(59.2f + this.eatbounce * 4.0f + this.eatwn * ((float)this.eat_cycle_count / (float)this.eat_cycles), 0.0f, 1.0f, 0.0f);
                    MatrixStack.rotate(-86.8f + this.eatbounce * 4.0f + this.eatrn * ((float)this.eat_cycle_count / (float)this.eat_cycles), 0.0f, 0.0f, 1.0f);
                } else if (Items.isFlopped(ic.iid)) {
                    MatrixStack.translate(-1.3f, -0.5f, -0.2f);
                    MatrixStack.rotate(64.0f, 1.0f, 0.0f, 0.0f);
                    MatrixStack.rotate(-51.2f + this.bounce * 4.0f, 0.0f, 1.0f, 0.0f);
                    MatrixStack.rotate(-109.7f + this.bounce * 4.0f, 0.0f, 0.0f, 1.0f);
                } else {
                    MatrixStack.translate(0.1f, 0.8f, 0.5f);
                    MatrixStack.rotate(-92.4f, 1.0f, 0.0f, 0.0f);
                    MatrixStack.rotate(59.2f + this.bounce * 4.0f, 0.0f, 1.0f, 0.0f);
                    MatrixStack.rotate(-86.8f + this.bounce * 4.0f, 0.0f, 0.0f, 1.0f);
                }
                this.forceloadtexture(Items.getTexture(ic.iid));
                MatrixStack.sendCurrentStack();
                Items.renderMeHeld(this, DangerZone.player, ic, true);
                GL11.glDisable((int)3042);
            }
            MatrixStack.popMatrix();
            MatrixStack.popMatrix();
            MatrixStack.adjustStackDepthDown();
        }
    }

    public void rotate_world_view() {
        MatrixStack.rotate(-this.ref_roll, 0.0f, 0.0f, 1.0f);
        MatrixStack.rotate(-(this.ref_yaw + this.f5yaw), 0.0f, 1.0f, 0.0f);
        MatrixStack.rotate(-(this.ref_pitch + this.f5pitch), 1.0f, 0.0f, 0.0f);
    }

    public void do_boring_things(World world, int inview) {
        this.doHouseKeeping(world, inview);
        this.calcBounceAndFocus(world);
        this.lookAtSelf(world);
        this.recalcSkyBrightness();
    }

    public void renderWorld(World world, int inview) {
        if (!DangerZone.isVR || DangerZone.isVR && inview == 1) {
            if (DangerZone.refresh_rate == 120 && (DangerZone.frame_scaler & 1) == 0) {
                this.do_boring_things(world, inview);
            } else if (DangerZone.refresh_rate == 90 && DangerZone.frame_scaler % 3 != 0) {
                this.do_boring_things(world, inview);
            } else {
                this.do_boring_things(world, inview);
            }
        }
        this.doClickyStuff(world);
        if (DangerZone.f12_on && DangerZone.current_gui == null || inview == 0 && !DangerZone.monitor_enable) {
            this.sky_blue = 0.15f;
            this.sky_green = 0.15f;
            this.sky_red = 0.15f;
        }
        if (DangerZone.isVR) {
            if (inview == 1) {
                this.shift_z = DangerZone.headset.dx / 2.0f;
                this.shift_x = -DangerZone.headset.dz / 2.0f;
                this.shift_y = DangerZone.headset.dy / 2.0f;
            }
            if (inview == 2) {
                this.shift_z = -DangerZone.headset.dx / 2.0f;
                this.shift_x = DangerZone.headset.dz / 2.0f;
                this.shift_y = -DangerZone.headset.dy / 2.0f;
            }
            if (inview == 0) {
                this.shift_x = 0.0f;
                this.shift_z = 0.0f;
                this.shift_y = 0.0f;
            }
            this.shift_x *= DangerZone.ipd;
            this.shift_y *= DangerZone.ipd;
            this.shift_z *= DangerZone.ipd;
        }
        DangerZone.set_shader_projection(inview, DangerZone.model_shader, DangerZone.screen_width, DangerZone.screen_height);
        GL11.glClearColor((float)this.sky_red, (float)this.sky_green, (float)this.sky_blue, (float)0.0f);
        GL11.glClear((int)16640);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL14.glSecondaryColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3553);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)33880);
        if (DangerZone.f12_on && DangerZone.current_gui == null || inview == 0 && !DangerZone.monitor_enable) {
            WorldRendererUtils.drawShowcaseMonster(inview);
            GL11.glFlush();
            return;
        }
        double pi = 3.1415926545;
        int torender = 6;
        double dist = 0.0;
        ModelBase modl = null;
        Entity morphent = null;
        WorldRenderer.recalcBrightness(this.ref_dim, 60);
        this.setBrightness();
        last_texture = -1;
        MatrixStack.identity();
        MatrixStack.translate((float)(-(this.ref_posx * (double)this.blockrenderwidth % (double)(16 * this.blockrenderwidth))) + (float)(this.blockrenderwidth / 2) + this.f5x + this.shift_x, (float)(-((this.ref_posy + (double)this.bounce + (double)this.eyeadjust - 0.5) * (double)this.blockrenderwidth)) + this.f5y + this.shift_y, (float)(-(this.ref_posz * (double)this.blockrenderwidth % (double)(16 * this.blockrenderwidth))) + (float)(this.blockrenderwidth / 2) + this.f5z + this.shift_z);
        this.rotate_world_view();
        MatrixStack.sendCurrentStack();
        torender = this.ref_pitch < 45.0f || this.ref_pitch > 315.0f ? DangerZone.renderdistance : DangerZone.renderdistance - 2;
        if (torender < 3) {
            torender = 3;
        }
        do_draw_focus = false;
        float use_fov = DangerZone.fieldOfView;
        if (inview != 0) {
            use_fov += 15.0f;
        }
        WorldRendererUtils.drawSunAndMoon(world, this.normal_sun);
        int i = -torender;
        while (i <= torender) {
            int j = -torender;
            while (j <= torender) {
                dist = (float)Math.sqrt(i * i + j * j);
                if (dist <= (double)torender) {
                    double rhdir;
                    double rr = (float)Math.atan2(j * 16, i * 16);
                    double rdd = (rr - (rhdir = (double)((this.ref_yaw + this.f5yaw - 90.0f) % 360.0f) * 0.0174533)) % (pi * 2.0);
                    if (rdd < 0.0) {
                        rdd = -rdd;
                    }
                    if (rdd > pi) {
                        rdd -= pi * 2.0;
                    }
                    if (rdd < 0.0) {
                        rdd = -rdd;
                    }
                    if (!((this.ref_pitch < 45.0f || this.ref_pitch > 315.0f) && (dist > 8.0 && rdd > pi / 3.0 * (double)use_fov / 45.0 || dist > 4.0 && rdd > pi / 2.0 * (double)use_fov / 45.0 || dist > 1.0 && rdd > pi * 3.0 / 4.0 * (double)use_fov / 45.0 && !DangerZone.f5_front && !DangerZone.f5_back && !DangerZone.f5_side))) {
                        this.renderChunk(world, i, j, this.ref_dim, this.ref_posx, this.ref_posy, this.ref_posz);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (this.show_focus_bid != 0 && this.show_focus_x != 0 && this.show_focus_z != 0) {
            if (this.ViewFromEntity.getDistanceFromEntityCenter(this.show_focus_x, this.show_focus_y, this.show_focus_z) > 16.0) {
                this.show_focus_meta = 0;
                this.show_focus_bid = 0;
                this.show_focus_z = 0;
                this.show_focus_y = 0;
                this.show_focus_x = 0;
                this.show_focus_maxdamage = 0.0f;
                this.show_focus_damage = 0.0f;
            } else {
                int pbid = world.getblock(this.ref_dim, (int)this.ref_posx, (int)(this.ref_posy + (double)this.ViewFromEntity.getEyeHeight()), (int)this.ref_posz);
                if (pbid == 0 || !Blocks.isSolid(pbid) || Blocks.isLiquid(pbid)) {
                    MatrixStack.identity();
                    MatrixStack.translate(-((float)((this.ref_posx - ((double)this.show_focus_x + 0.5)) * (double)this.blockrenderwidth)) + this.f5x + this.shift_x, -((float)((this.ref_posy + (double)this.bounce + (double)this.eyeadjust - ((double)this.show_focus_y + 0.5)) * (double)this.blockrenderwidth)) + this.f5y + this.shift_y, -((float)((this.ref_posz - ((double)this.show_focus_z + 0.5)) * (double)this.blockrenderwidth)) + this.f5z + this.shift_z);
                    this.rotate_world_view();
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    if (this.show_focus_damage != 0.0f && this.show_focus_maxdamage > 0.0f) {
                        if (this.show_focus_damage > this.show_focus_maxdamage) {
                            this.show_focus_damage = this.show_focus_maxdamage;
                        }
                        MatrixStack.scale(1.0f - 0.65f * this.show_focus_damage / this.show_focus_maxdamage, 1.0f - 0.65f * this.show_focus_damage / this.show_focus_maxdamage, 1.0f - 0.65f * this.show_focus_damage / this.show_focus_maxdamage);
                        MatrixStack.rotate((float)((double)(15.0f * this.show_focus_damage / this.show_focus_maxdamage) * Math.cos(Math.toRadians(this.ViewFromEntity.lifetimeticker * 3L))), 1.0f, 0.0f, 0.0f);
                        MatrixStack.rotate((float)((double)(15.0f * this.show_focus_damage / this.show_focus_maxdamage) * Math.cos(Math.toRadians(this.ViewFromEntity.lifetimeticker * 7L))), 0.0f, 1.0f, 0.0f);
                        MatrixStack.rotate((float)((double)(15.0f * this.show_focus_damage / this.show_focus_maxdamage) * Math.cos(Math.toRadians(this.ViewFromEntity.lifetimeticker * 5L))), 0.0f, 0.0f, 1.0f);
                    } else {
                        MatrixStack.scale(1.001f, 1.001f, 1.001f);
                    }
                    this.setBrightnessFocusBlock();
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    if (Blocks.hasOwnRenderer(this.show_focus_bid)) {
                        Blocks.renderMe(this, world, this.ref_dim, this.show_focus_x, this.show_focus_y, this.show_focus_z, this.show_focus_bid, this.show_focus_meta, 255, true);
                        this.drawTexturedCube(0, true, this.show_focus_bid, 0, true);
                    } else {
                        this.drawTexturedCube(255, Blocks.isSolidForRender(this.show_focus_bid), this.show_focus_bid, this.show_focus_meta, true);
                    }
                    MatrixStack.popMatrix();
                    this.setBrightness();
                    MatrixStack.popMatrix();
                }
            }
        }
        this.draw_entities(world, inview);
        if (inview == 2 || !DangerZone.isVR) {
            this.DrawMe.clear();
            DangerZone.displaysorterthread.LDrawMelock.lock();
            Iterator<Integer> li = DangerZone.displaysorterthread.LDrawMe.iterator();
            while (li.hasNext()) {
                this.DrawMe.add(li.next());
            }
            DangerZone.displaysorterthread.LDrawMelock.unlock();
        }
        this.draw_particles(world, inview);
        if (inview == 2 || !DangerZone.isVR) {
            this.DrawMeP.clear();
            DangerZone.displaysorterthread.LDrawMePlock.lock();
            Iterator<Particle> li = DangerZone.displaysorterthread.LDrawMeP.iterator();
            while (li.hasNext()) {
                this.DrawMeP.add(li.next());
            }
            DangerZone.displaysorterthread.LDrawMePlock.unlock();
        }
        if ((DangerZone.f5_front || DangerZone.f5_back || DangerZone.f5_side) && this.ViewFromEntity == DangerZone.player) {
            Entity ent;
            float ouch = 1.0f;
            modl = this.ViewFromEntity.model;
            morphent = null;
            if (this.ViewFromEntity == DangerZone.player) {
                morphent = DangerZone.player.morph;
            }
            if (!(ent = this.ViewFromEntity).isInvisible()) {
                float fyw = 360.0f - (ent.rotation_yaw + 180.0f) % 360.0f;
                MatrixStack.sendCurrentStack();
                MatrixStack.pushMatrix();
                MatrixStack.translate((float)(-((this.ref_posx - ent.posx) * (double)this.blockrenderwidth)) + this.f5x + this.shift_x, (float)(-((this.ref_posy + (double)this.bounce + (double)this.eyeadjust - ent.posy) * (double)this.blockrenderwidth)) + this.f5y + this.shift_y, (float)(-((this.ref_posz - ent.posz) * (double)this.blockrenderwidth)) + this.f5z + this.shift_z);
                MatrixStack.sendCurrentStack();
                MatrixStack.pushMatrix();
                MatrixStack.rotate(-fyw, 0.0f, 1.0f, 0.0f);
                MatrixStack.rotate(ent.rotation_pitch, 1.0f, 0.0f, 0.0f);
                WorldRenderer.recalcBrightness(this.ref_dim, (int)(this.ref_posy + (double)(this.ViewFromEntity.getHeight() / 2.0f)));
                this.setBrightness(WorldRendererUtils.getLightMapValue(world, this.ref_dim, (int)this.ref_posx, (int)(this.ref_posy + (double)(ent.getHeight() / 2.0f)), (int)this.ref_posz));
                MatrixStack.sendCurrentStack();
                MatrixStack.pushMatrix();
                if (morphent != null) {
                    this.loadtexture(modl.getTexture(morphent));
                    modl.doScale(morphent);
                } else {
                    this.loadtexture(modl.getTexture(ent));
                    modl.doScale(ent);
                }
                ouch = 1.0f;
                boolean washurt = ent.isHurt();
                if (washurt) {
                    ouch = 1.1f;
                    this.setHurt();
                }
                if (ent.getDeathFactor() > 0.0f) {
                    ouch = ent.getDeathFactor();
                }
                float velocity = (float)Math.sqrt(ent.motionx * ent.motionx + ent.motiony * ent.motiony + ent.motionz * ent.motionz);
                this.cdir = (float)Math.toRadians(ent.rotation_pitch);
                this.tdir = (float)Math.toRadians(ent.rotation_pitch_head);
                this.pdiff = this.tdir - this.cdir;
                while ((double)this.pdiff > Math.PI) {
                    this.pdiff = (float)((double)this.pdiff - Math.PI * 2);
                }
                while ((double)this.pdiff < -Math.PI) {
                    this.pdiff = (float)((double)this.pdiff + Math.PI * 2);
                }
                this.pdiff = (float)Math.toDegrees(this.pdiff);
                this.cdir = (float)Math.toRadians(ent.rotation_yaw);
                this.tdir = (float)Math.toRadians(ent.rotation_yaw_head);
                this.ydiff = this.tdir - this.cdir;
                while ((double)this.ydiff > Math.PI) {
                    this.ydiff = (float)((double)this.ydiff - Math.PI * 2);
                }
                while ((double)this.ydiff < -Math.PI) {
                    this.ydiff = (float)((double)this.ydiff + Math.PI * 2);
                }
                this.ydiff = (float)Math.toDegrees(this.ydiff);
                this.cdir = (float)Math.toRadians(ent.rotation_roll);
                this.tdir = (float)Math.toRadians(ent.rotation_roll_head);
                this.rdiff = this.tdir - this.cdir;
                while ((double)this.rdiff > Math.PI) {
                    this.rdiff = (float)((double)this.rdiff - Math.PI * 2);
                }
                while ((double)this.rdiff < -Math.PI) {
                    this.rdiff = (float)((double)this.rdiff + Math.PI * 2);
                }
                this.rdiff = (float)Math.toDegrees(this.rdiff);
                MatrixStack.sendCurrentStack();
                if (morphent != null) {
                    modl.render(morphent, ent.lifetimeticker, velocity, this.pdiff, -this.ydiff, this.rdiff, ouch);
                } else {
                    modl.render(ent, ent.lifetimeticker, velocity, this.pdiff, -this.ydiff, this.rdiff, ouch);
                }
                MatrixStack.popMatrix();
                if (ent.getPetName() != null) {
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    MatrixStack.translate(-(this.font.getWidth(ent.getPetName()) / 2), -(ent.getNameHeight() * 125.0f + 25.0f), 0.0f);
                    if (ent.isBaby()) {
                        MatrixStack.scale(0.25f, 0.25f, 0.25f);
                    }
                    MatrixStack.scale(0.15f, 0.15f, 0.15f);
                    WorldRendererUtils.textAt3D(this.font, 0.0f, 0.0f, ent.getPetName());
                    MatrixStack.popMatrix();
                }
                if (ent.getOnFire() > 0) {
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    WorldRendererUtils.drawEntityOnFire(ent);
                    MatrixStack.popMatrix();
                }
                if (washurt && DangerZone.showhitbox) {
                    MatrixStack.identity();
                    if (ent.rotation_pitch != 0.0f) {
                        MatrixStack.rotate(ent.rotation_pitch, 1.0f, 0.0f, 0.0f);
                    }
                    if (ent.rotation_yaw != 0.0f) {
                        MatrixStack.rotate(ent.rotation_yaw, 0.0f, 1.0f, 0.0f);
                    }
                    if (ent.rotation_roll != 0.0f) {
                        MatrixStack.rotate(ent.rotation_roll, 0.0f, 0.0f, 1.0f);
                    }
                    if (ent.isBaby()) {
                        MatrixStack.scale(0.25f, 0.25f, 0.25f);
                    }
                    MatrixStack.translate(0.0f, 8.0f, 0.0f);
                    MatrixStack.scale(ent.getWidth(), ent.getHeight(), ent.getWidth());
                    this.forceloadtexture(Blocks.BlockArray[Blocks.hitbox.blockID].getTexture(0));
                    MatrixStack.sendCurrentStack();
                    this.drawTexturedCube(255, false, Blocks.hitbox.blockID, 0, false);
                }
                if (washurt) {
                    this.setBrightness(0.0f);
                }
                MatrixStack.popMatrix();
                MatrixStack.popMatrix();
            }
        }
        if (!DangerZone.showcase) {
            MatrixStack.identity();
            this.drawPlayerHeldItem(world);
        }
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)DangerZone.model_shader, (CharSequence)"colorfixr"), (float)1.0f);
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)DangerZone.model_shader, (CharSequence)"colorfixg"), (float)1.0f);
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)DangerZone.model_shader, (CharSequence)"colorfixb"), (float)1.0f);
        MatrixStack.identity();
        MatrixStack.translate((float)(-(this.ref_posx * (double)this.blockrenderwidth % (double)(16 * this.blockrenderwidth))) + (float)(this.blockrenderwidth / 2) + this.f5x + this.shift_x, (float)(-((this.ref_posy + (double)this.bounce + (double)this.eyeadjust - 0.5) * (double)this.blockrenderwidth)) + this.f5y + this.shift_y, (float)(-(this.ref_posz * (double)this.blockrenderwidth % (double)(16 * this.blockrenderwidth))) + (float)(this.blockrenderwidth / 2) + this.f5z + this.shift_z);
        this.rotate_world_view();
        MatrixStack.sendCurrentStack();
        if (!this.translucentVBOs.isEmpty()) {
            Iterator<VBOBuffer> iitr = this.translucentVBOs.iterator();
            VBOBuffer sstr = null;
            while (iitr.hasNext()) {
                sstr = iitr.next();
                MatrixStack.pushMatrix();
                MatrixStack.translate(sstr.xoff, 0.0f, sstr.zoff);
                MatrixStack.sendCurrentStack();
                this.loadStitchedtexture(sstr.textureindex);
                sstr.lastusedframe = this.framecounter;
                sstr.draw();
                MatrixStack.popMatrix();
            }
            this.translucentVBOs.clear();
            MatrixStack.adjustStackDepthDown();
        }
        WorldRenderer.recalcBrightness(DangerZone.player.dimension, 60);
        this.setBrightness();
        GL20.glUseProgram((int)0);
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)DangerZone.screen_width, (double)0.0, (double)DangerZone.screen_height, (double)-320.0, (double)320.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        if (!(DangerZone.showcase || !DangerZone.overlays_on || DangerZone.f5_front || DangerZone.f5_back || DangerZone.f5_side || DangerZone.isVR)) {
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)2.0f);
            GL11.glBegin((int)3);
            GL11.glColor4f((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
            GL11.glVertex3f((float)((float)(DangerZone.screen_width / 2) - 10.0f), (float)(DangerZone.screen_height / 2), (float)0.0f);
            GL11.glColor4f((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
            GL11.glVertex3f((float)((float)(DangerZone.screen_width / 2) + 10.0f), (float)(DangerZone.screen_height / 2), (float)0.0f);
            GL11.glEnd();
            GL11.glBegin((int)3);
            GL11.glColor4f((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
            GL11.glVertex3f((float)(DangerZone.screen_width / 2), (float)((float)(DangerZone.screen_height / 2) - 10.0f), (float)0.0f);
            GL11.glColor4f((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
            GL11.glVertex3f((float)(DangerZone.screen_width / 2), (float)((float)(DangerZone.screen_height / 2) + 10.0f), (float)0.0f);
            GL11.glEnd();
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (DangerZone.overlays_on) {
            this.doMenuThings(world, inview);
        }
    }

    private void doMenuThings(World world, int inview) {
        int i;
        if (this.ViewFromEntity != DangerZone.player) {
            return;
        }
        int startx = DangerZone.get_left(inview);
        int middle = DangerZone.get_middle(inview);
        int starty = DangerZone.get_top(inview);
        int bottom = DangerZone.get_bottom(inview);
        if (inview != 0) {
            GL11.glTranslatef((float)0.0f, (float)100.0f, (float)0.0f);
        }
        if (!DangerZone.showcase) {
            WorldRendererUtils.drawHotbar(world, inview);
            WorldRendererUtils.drawHealth(world, inview);
            WorldRendererUtils.drawHunger(world, inview);
            WorldRendererUtils.drawMagic(world, inview);
            WorldRendererUtils.drawAir(world, inview);
            WorldRendererUtils.drawBoss(world, inview);
            DangerZone.wr.setBrightnessNonFocus();
            if (DangerZone.messagetimer > 0 && DangerZone.messagestring != null) {
                if (!DangerZone.isVR || inview == 1) {
                    --DangerZone.messagetimer;
                }
                WorldRendererUtils.drawRectangleWithTexture(DangerZone.textinputtexture, startx + 30, bottom + 120, 600.0f, 30.0f);
                WorldRendererUtils.textAt(this.font, startx + 50, bottom + 150, DangerZone.messagestring);
            }
            if (DangerZone.hotmessagetimer > 0 && DangerZone.hotmessagestring != null) {
                if (!DangerZone.isVR || inview == 1) {
                    --DangerZone.hotmessagetimer;
                }
                WorldRendererUtils.drawRectangleWithTexture(DangerZone.textinputtexture, middle - 5 * DangerZone.hotmessagestring.length() - 50, bottom + 105, 13 * DangerZone.hotmessagestring.length() + 20, 30.0f);
                WorldRendererUtils.textAt(this.font, middle - 5 * DangerZone.hotmessagestring.length() - 30, bottom + 135, DangerZone.hotmessagestring);
                InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
                if (DangerZone.current_gui == null && ic != null && ic.iid != 0 && ic.count == 1 && ic.getMaxStack() == 1 && ic.attributes != null) {
                    int ayoff = bottom + 250;
                    if (inview != 0) {
                        startx += 200;
                    }
                    i = 1;
                    while (i < 10) {
                        int val = ic.getAttribute(i);
                        if (val > 0) {
                            String outtext = "";
                            if (i == 1) {
                                outtext = "Accuracy:   ";
                            }
                            if (i == 2) {
                                outtext = "Damage:     ";
                            }
                            if (i == 3) {
                                outtext = "Durability: ";
                            }
                            if (i == 4) {
                                outtext = "Reach:      ";
                            }
                            if (i == 5) {
                                outtext = "Spam:       ";
                            }
                            outtext = String.valueOf(outtext) + String.format("%d", val);
                            WorldRendererUtils.textAt(this.font, startx + 20, ayoff, outtext);
                            ayoff -= 25;
                        }
                        ++i;
                    }
                    if (inview != 0) {
                        startx -= 200;
                    }
                }
            } else if (DangerZone.current_gui == null) {
                String s = String.format("%d", DangerZone.player.getExperience());
                WorldRendererUtils.textAt(this.font, middle - 5 * s.length() - 30, bottom + 140, s);
            }
        }
        if (DangerZone.f3_on && DangerZone.current_gui == null) {
            int modepos = 10;
            if (inview != 0) {
                startx += 250;
                middle += 350;
            }
            DangerZone.wr.setBrightnessNonFocus();
            String s = String.format("Version: %s", DangerZone.versionstring);
            WorldRendererUtils.textAt(this.font, startx + 10, starty - 10, s);
            s = String.format("FPS: %d at Render Distance: %d", this.fps, DangerZone.renderdistance);
            WorldRendererUtils.textAt(this.font, startx + 10, starty - 50, s);
            if (DangerZone.server != null && DangerZone.server_chunk_cache != null) {
                Dimension dd = Dimensions.DimensionArray[DangerZone.player.dimension];
                if (dd != null) {
                    Biome bb;
                    s = String.format("Dimension: %s", dd.getDisplayName());
                    WorldRendererUtils.textAt(this.font, middle, starty - 10, s);
                    BiomeManager bm = dd.getBiomeManager();
                    if (bm != null && (bb = bm.getBiomeForChunk(null, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz)) != null) {
                        s = String.format("Biome: %s", bb.uniquename);
                        WorldRendererUtils.textAt(this.font, middle, starty - 50, s);
                    }
                }
                modepos = 90;
            }
            s = "Survival";
            if (DangerZone.player.getGameMode() == 1) {
                s = "Creative";
            }
            if (DangerZone.player.getGameMode() == 2) {
                s = "Ghost";
            }
            if (DangerZone.player.getGameMode() == 3) {
                s = "Limbo";
            }
            s = String.format("GameMode: %s", s);
            WorldRendererUtils.textAt(this.font, middle, starty - modepos, s);
            s = "Normal";
            if (DangerZone.player.getGameDifficulty() == -1) {
                s = "Easy";
            }
            if (DangerZone.player.getGameDifficulty() == -2) {
                s = "Girly";
            }
            if (DangerZone.player.getGameDifficulty() == 1) {
                s = "Hard";
            }
            if (DangerZone.player.getGameDifficulty() == 2) {
                s = "Brutal";
            }
            s = String.format("Difficulty: %s", s);
            WorldRendererUtils.textAt(this.font, middle, starty - (modepos + 40), s);
            Chunk c = world.chunkcache.getChunk(world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
            if (c != null) {
                List<String> owners = c.ownernames;
                if (owners != null) {
                    int olen = owners.size();
                    i = 0;
                    s = "Chunk Owners: ";
                    while (olen > 0) {
                        s = String.valueOf(s) + owners.get(i);
                        s = String.valueOf(s) + ", ";
                        --olen;
                        ++i;
                    }
                    WorldRendererUtils.textAt(this.font, middle, starty - (modepos + 80), s);
                }
                c = null;
            }
            s = String.format("XPOS: %d", (int)DangerZone.player.posx);
            WorldRendererUtils.textAt(this.font, startx + 10, starty - 90, s);
            s = String.format("YPOS: %d", (int)DangerZone.player.posy);
            WorldRendererUtils.textAt(this.font, startx + 10, starty - 130, s);
            s = String.format("ZPOS: %d", (int)DangerZone.player.posz);
            WorldRendererUtils.textAt(this.font, startx + 10, starty - 170, s);
            s = String.format("Packets: %d", this.pps);
            WorldRendererUtils.textAt(this.font, startx + 10, starty - 210, s);
            s = String.format("VBO memory: %d MB", this.VBOmemorysize / 0x100000);
            WorldRendererUtils.textAt(this.font, startx + 10, starty - 250, s);
            s = String.format("Light LVL: %f", Float.valueOf(WorldRendererUtils.getTotalLightAt(DangerZone.player.world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz)));
            WorldRendererUtils.textAt(this.font, startx + 10, starty - 290, s);
            if (DangerZone.server != null) {
                s = String.format("Entity Freelist: %d", DangerZone.server.entityManager.entity_free_list.size());
                WorldRendererUtils.textAt(this.font, startx + 10, starty - 330, s);
                s = String.format("Entities: %d", DangerZone.server.entityManager.entity_list.size());
                WorldRendererUtils.textAt(this.font, startx + 10, starty - 370, s);
                if (DangerZone.clientParticleManager != null) {
                    s = String.format("Particles: %d", DangerZone.clientParticleManager.particle_list.size());
                    WorldRendererUtils.textAt(this.font, startx + 10, starty - 410, s);
                }
            } else {
                s = String.format("Server Latency(ms): %d", DangerZone.server_connection.lastaverageloop);
                WorldRendererUtils.textAt(this.font, startx + 10, starty - 330, s);
                s = String.format("Chunks: %d", this.cps);
                WorldRendererUtils.textAt(this.font, startx + 10, starty - 370, s);
            }
        }
    }

    private void renderChunk(World world, int xrel, int zrel, int dim, double px, double py, double pz) {
        VBOBuffer v = null;
        int xpos = xrel * 16 + (int)px;
        int zpos = zrel * 16 + (int)pz;
        Chunk c = world.chunkcache.getDecoratedChunkForRenderer(dim, xpos, 0, zpos);
        if (c == null) {
            return;
        }
        this.VBOlistlock.lock();
        int itemp = 0;
        while (itemp <= 20) {
            if (c.VBOids[itemp] <= 0L) break;
            v = this.VBOmap.get(c.VBOids[itemp]);
            if (v == null) {
                int ivi = 0;
                while (ivi < 20) {
                    if (c.VBOids[ivi] > 0L) {
                        v = this.VBOmap.get(c.VBOids[ivi]);
                        if (v != null) {
                            this.VBOmap.remove(v.VBOid);
                            --this.vbocount;
                            v.free();
                        }
                        c.VBOids[ivi] = 0L;
                    }
                    ++ivi;
                }
                this.VBOlistlock.unlock();
                return;
            }
            ++itemp;
        }
        this.VBOlistlock.unlock();
        MatrixStack.pushMatrix();
        MatrixStack.translate(xrel * 16 * this.blockrenderwidth, 0.0f, zrel * 16 * this.blockrenderwidth);
        MatrixStack.sendCurrentStack();
        itemp = 0;
        while (itemp <= 20) {
            if (c.VBOids[itemp] <= 0L) break;
            this.VBOlistlock.lock();
            v = this.VBOmap.get(c.VBOids[itemp]);
            this.VBOlistlock.unlock();
            if (v != null) {
                v.xoff = xrel * 16 * this.blockrenderwidth;
                v.zoff = zrel * 16 * this.blockrenderwidth;
                if (!v.isTranslucent) {
                    this.loadStitchedtexture(v.textureindex);
                    v.lastusedframe = this.framecounter;
                    v.draw();
                } else {
                    this.translucentVBOs.add(v);
                }
            }
            ++itemp;
        }
        MatrixStack.popMatrix();
    }

    public void drawTexturedCube(int sides, boolean isSolid, int bid, int meta, boolean focus) {
        if (bid <= 0 || bid >= 2048) {
            return;
        }
        if (Blocks.BlockArray[bid] == null) {
            return;
        }
        if (!isSolid) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        if ((meta & 0xFC00) != 0) {
            MatrixStack.sendCurrentStack();
            MatrixStack.pushMatrix();
            if ((meta & 0xC000) == 16384) {
                MatrixStack.rotate(90.0f, 1.0f, 0.0f, 0.0f);
            }
            if ((meta & 0xC000) == 32768) {
                MatrixStack.rotate(180.0f, 1.0f, 0.0f, 0.0f);
            }
            if ((meta & 0xC000) == 49152) {
                MatrixStack.rotate(270.0f, 1.0f, 0.0f, 0.0f);
            }
            if ((meta & 0x3000) == 12288) {
                MatrixStack.rotate(90.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 0x3000) == 8192) {
                MatrixStack.rotate(180.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 0x3000) == 4096) {
                MatrixStack.rotate(270.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 0xC00) == 1024) {
                MatrixStack.rotate(90.0f, 0.0f, 0.0f, 1.0f);
            }
            if ((meta & 0xC00) == 2048) {
                MatrixStack.rotate(180.0f, 0.0f, 0.0f, 1.0f);
            }
            if ((meta & 0xC00) == 3072) {
                MatrixStack.rotate(270.0f, 0.0f, 0.0f, 1.0f);
            }
            sides = 255;
        }
        MatrixStack.sendCurrentStack();
        MatrixStack.sendFinalStack();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        if ((sides & 0x20) != 0 && this.loadtextureforblockside(0, bid, isSolid)) {
            GL30.glBindVertexArray((int)this.topid);
            GL11.glDrawArrays((int)7, (int)0, (int)4);
            GL30.glBindVertexArray((int)0);
        }
        if ((sides & 0x10) != 0 && this.loadtextureforblockside(5, bid, isSolid)) {
            GL30.glBindVertexArray((int)this.bottomid);
            GL11.glDrawArrays((int)7, (int)0, (int)4);
            GL30.glBindVertexArray((int)0);
        }
        if ((sides & 8) != 0 && this.loadtextureforblockside(1, bid, isSolid)) {
            GL30.glBindVertexArray((int)this.frontid);
            GL11.glDrawArrays((int)7, (int)0, (int)4);
            GL30.glBindVertexArray((int)0);
        }
        if ((sides & 4) != 0 && this.loadtextureforblockside(2, bid, isSolid)) {
            GL30.glBindVertexArray((int)this.backid);
            GL11.glDrawArrays((int)7, (int)0, (int)4);
            GL30.glBindVertexArray((int)0);
        }
        if ((sides & 1) != 0 && this.loadtextureforblockside(3, bid, isSolid)) {
            GL30.glBindVertexArray((int)this.leftid);
            GL11.glDrawArrays((int)7, (int)0, (int)4);
            GL30.glBindVertexArray((int)0);
        }
        if ((sides & 2) != 0 && this.loadtextureforblockside(4, bid, isSolid)) {
            GL30.glBindVertexArray((int)this.rightid);
            GL11.glDrawArrays((int)7, (int)0, (int)4);
            GL30.glBindVertexArray((int)0);
        }
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        if ((meta & 0xFC00) != 0) {
            MatrixStack.popMatrix();
        }
        if (!isSolid) {
            GL11.glDisable((int)3042);
        }
        if (focus) {
            this.forceloadtexture(focus_texture);
            MatrixStack.scale(1.01f, 1.01f, 1.01f);
            MatrixStack.sendCurrentStack();
            MatrixStack.sendFinalStack();
            if (this.show_focus_side == 0) {
                GL30.glBindVertexArray((int)this.topid);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
            }
            if (this.show_focus_side == 5) {
                GL30.glBindVertexArray((int)this.bottomid);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
            }
            if (this.show_focus_side == 1) {
                GL30.glBindVertexArray((int)this.frontid);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
            }
            if (this.show_focus_side == 2) {
                GL30.glBindVertexArray((int)this.backid);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
            }
            if (this.show_focus_side == 3) {
                GL30.glBindVertexArray((int)this.leftid);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
            }
            if (this.show_focus_side == 4) {
                GL30.glBindVertexArray((int)this.rightid);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
            }
        }
    }

    public void drawTexturedSquare(int side, boolean isSolid, int bid) {
        if (bid <= 0 || bid >= 2048) {
            return;
        }
        if (Blocks.BlockArray[bid] == null) {
            return;
        }
        if (!isSolid) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        if (this.loadtextureforblockside(side, bid, isSolid)) {
            WorldRendererUtils.drawSquare();
        }
        if (!isSolid) {
            GL11.glDisable((int)3042);
        }
    }

    public void loadStitchedtexture(int which) {
        if (which < 0 || which > 19) {
            return;
        }
        if (stitches[which] != null && last_texture != WorldRenderer.stitches[which].textureID) {
            stitches[which].bind();
            last_texture = WorldRenderer.stitches[which].textureID;
        }
    }

    public boolean loadtextureforblockside(int side, int bid, boolean solid) {
        Texture lt = Blocks.BlockArray[bid].getTexture(side);
        if (lt == null) {
            return false;
        }
        if (last_texture != lt.getTextureID()) {
            TextureImpl.unbind();
            lt.bind();
            last_texture = lt.getTextureID();
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        return true;
    }

    public boolean forceloadtexture(Texture lt) {
        if (lt == null) {
            return false;
        }
        last_texture = -1;
        TextureImpl.unbind();
        lt.bind();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        return true;
    }

    public boolean loadtexture(Texture lt) {
        if (lt == null) {
            return false;
        }
        if (last_texture != lt.getTextureID()) {
            last_texture = lt.getTextureID();
            TextureImpl.unbind();
            lt.bind();
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        return true;
    }

    public static void recalcBrightness(int d, int yp) {
        float f = WorldRendererUtils.getBrightnessForLevel(d, yp);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        brightness_green = brightness_blue = f;
        brightness_red = brightness_blue;
    }

    public void recalcSkyBrightness() {
        float tod = DangerZone.world.timetimer % DangerZone.world.lengthOfDay;
        float fsin = (float)Math.sin(Math.toRadians(tod / (float)DangerZone.world.lengthOfDay * 360.0f));
        if ((fsin *= 1.75f) > 1.0f) {
            fsin = 1.0f;
        }
        if (DangerZone.no_dark && fsin < -0.25f) {
            fsin = -0.25f;
        }
        if (fsin < -1.0f) {
            fsin = -1.0f;
        }
        float fsky = 0.5f + 0.45f * fsin;
        float maxfsky = 1.0f - 0.5f * ((float)DangerZone.thundercount / 300.0f);
        if (maxfsky < 0.5f) {
            maxfsky = 0.5f;
        }
        if (fsky > maxfsky) {
            fsky = maxfsky;
        }
        int pld = DangerZone.player.dimension;
        this.sky_red = Dimensions.DimensionArray[pld].sky_red * fsky;
        this.sky_green = Dimensions.DimensionArray[pld].sky_green * fsky;
        this.sky_blue = Dimensions.DimensionArray[pld].sky_blue * fsky;
    }

    public void setBrightness() {
    }

    public void setHurt() {
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)DangerZone.model_shader, (CharSequence)"colorfixr"), (float)0.95f);
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)DangerZone.model_shader, (CharSequence)"colorfixg"), (float)0.1f);
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)DangerZone.model_shader, (CharSequence)"colorfixb"), (float)0.1f);
    }

    public void setBrightness(float m) {
        float flb;
        float flg;
        float flr = brightness_red + m;
        if (flr < 0.0f) {
            flr = 0.0f;
        }
        if (flr > 1.0f) {
            flr = 1.0f;
        }
        if ((flg = brightness_green + m) < 0.0f) {
            flg = 0.0f;
        }
        if (flg > 1.0f) {
            flg = 1.0f;
        }
        if ((flb = brightness_blue + m) < 0.0f) {
            flb = 0.0f;
        }
        if (flb > 1.0f) {
            flb = 1.0f;
        }
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)DangerZone.model_shader, (CharSequence)"colorfixr"), (float)flr);
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)DangerZone.model_shader, (CharSequence)"colorfixg"), (float)flg);
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)DangerZone.model_shader, (CharSequence)"colorfixb"), (float)flb);
    }

    public void setBrightnessFocus() {
        float bval = 1.0f;
        if (!DangerZone.world.isDaytime()) {
            bval = 0.75f;
        }
        GL11.glColor3f((float)bval, (float)bval, (float)bval);
    }

    public void setBrightnessFocusBlock() {
        float bval = WorldRendererUtils.getTotalLightAt(DangerZone.world, DangerZone.player.dimension, this.show_focus_x, this.show_focus_y, this.show_focus_z);
        if (bval > 1.0f) {
            bval = 1.0f;
        }
        if (bval < 0.0f) {
            bval = 0.0f;
        }
        bval = bval > 0.65f ? (bval -= 0.35f) : (bval += 0.35f);
        GL11.glColor3f((float)bval, (float)bval, (float)bval);
    }

    public void setBrightnessNonFocus() {
        float bval = 0.75f;
        if (!DangerZone.world.isDaytime()) {
            bval = 0.5f;
        }
        GL11.glColor3f((float)bval, (float)bval, (float)bval);
    }

    public int getNextRenderID() {
        lock.lock();
        int i = GL11.glGenLists((int)1);
        lock.unlock();
        return i;
    }

    public long getNextVBOid() {
        lock.lock();
        long i = this.nextVBOid++;
        lock.unlock();
        return i;
    }

    public void deleteVBOlist(long[] vboids) {
        this.VBOlistlock.lock();
        this.VBO_delete_list.add(vboids);
        this.VBOlistlock.unlock();
    }

    private void Scalef5toSolid() {
        float dst = 0.0f;
        float dz = 0.0f;
        float dy = 0.0f;
        float dx = 0.0f;
        int lz = 0;
        int ly = 0;
        int lx = 0;
        while (dst <= 8.0f) {
            dx = this.f5x * dst / 8.0f;
            dy = this.f5y * dst / 8.0f;
            dz = this.f5z * dst / 8.0f;
            int ix = (int)(this.ref_posx - (double)(dx / (float)this.blockrenderwidth));
            int iy = (int)(this.ref_posy + (double)this.ViewFromEntity.getEyeHeight() - (double)(dy / (float)this.blockrenderwidth));
            int iz = (int)(this.ref_posz - (double)(dz / (float)this.blockrenderwidth));
            if (ix != lx || iy != ly || iz != lz) {
                lx = ix;
                ly = iy;
                lz = iz;
                int bid = DangerZone.world.getblock(this.ref_dim, ix, iy, iz);
                if (bid != 0 && Blocks.isSolidForRender(bid)) {
                    if ((dst -= 0.25f) < 0.0f) {
                        dst = 0.0f;
                    }
                    dx = this.f5x * dst / 8.0f;
                    dy = this.f5y * dst / 8.0f;
                    dz = this.f5z * dst / 8.0f;
                    break;
                }
            }
            dst += 0.1f;
        }
        this.f5x = dx;
        this.f5y = dy;
        this.f5z = dz;
    }

    public void setup_vr_menu() {
        DangerZone.set_shader_ortho(DangerZone.model_shader);
    }

    public void teardown_vr_menu() {
    }

    private void draw_entities(World world, int inview) {
        Entity ent;
        ModelBase modl = null;
        Entity morphent = null;
        String petname = null;
        double use_posx = 0.0;
        double use_posy = 0.0;
        double use_posz = 0.0;
        float use_rotation_yaw = 0.0f;
        float use_rotation_pitch = 0.0f;
        float use_rotation_roll = 0.0f;
        long use_ticker = 0L;
        float use_velocity = 0.0f;
        float use_head_pitch = 0.0f;
        float use_head_yaw = 0.0f;
        float use_head_roll = 0.0f;
        float ouch = 1.0f;
        this.doforce = false;
        MatrixStack.identity();
        this.rotate_world_view();
        MatrixStack.sendCurrentStack();
        if (this.DrawMe == null || this.DrawMe.isEmpty()) {
            return;
        }
        Iterator<Integer> ii = this.DrawMe.iterator();
        int ient = 0;
        while (ii.hasNext()) {
            ient = ii.next();
            if (ient <= 0 || ient >= DangerZone.max_entities || (ent = DangerZone.clientEntityManager.entities[ient]) == null || (modl = ent.model) == null) continue;
            morphent = null;
            if (ent instanceof Player) {
                Player pp = (Player)ent;
                modl = pp.model;
                morphent = pp.morph;
            }
            float velocity = (float)Math.sqrt(ent.motionx * ent.motionx + ent.motiony * ent.motiony + ent.motionz * ent.motionz);
            this.cdir = (float)Math.toRadians(ent.display_rotation_pitch);
            this.tdir = (float)Math.toRadians(ent.rotation_pitch_head);
            this.pdiff = this.tdir - this.cdir;
            while ((double)this.pdiff > Math.PI) {
                this.pdiff = (float)((double)this.pdiff - Math.PI * 2);
            }
            while ((double)this.pdiff < -Math.PI) {
                this.pdiff = (float)((double)this.pdiff + Math.PI * 2);
            }
            this.pdiff = (float)Math.toDegrees(this.pdiff);
            this.cdir = (float)Math.toRadians(ent.display_rotation_yaw);
            this.tdir = (float)Math.toRadians(ent.rotation_yaw_head);
            this.ydiff = this.tdir - this.cdir;
            while ((double)this.ydiff > Math.PI) {
                this.ydiff = (float)((double)this.ydiff - Math.PI * 2);
            }
            while ((double)this.ydiff < -Math.PI) {
                this.ydiff = (float)((double)this.ydiff + Math.PI * 2);
            }
            this.ydiff = (float)Math.toDegrees(this.ydiff);
            this.cdir = (float)Math.toRadians(ent.display_rotation_roll);
            this.tdir = (float)Math.toRadians(ent.rotation_roll_head);
            this.rdiff = this.tdir - this.cdir;
            while ((double)this.rdiff > Math.PI) {
                this.rdiff = (float)((double)this.rdiff - Math.PI * 2);
            }
            while ((double)this.rdiff < -Math.PI) {
                this.rdiff = (float)((double)this.rdiff + Math.PI * 2);
            }
            this.rdiff = (float)Math.toDegrees(this.rdiff);
            use_posx = -((this.ref_posx - ent.display_posx) * (double)this.blockrenderwidth);
            use_posy = -((this.ref_posy + (double)this.bounce + (double)this.eyeadjust - ent.display_posy) * (double)this.blockrenderwidth);
            use_posz = -((this.ref_posz - ent.display_posz) * (double)this.blockrenderwidth);
            use_rotation_yaw = -ent.display_rotation_yaw;
            use_rotation_pitch = -ent.display_rotation_pitch;
            use_rotation_roll = ent.display_rotation_roll;
            use_ticker = ent.lifetimeticker;
            use_velocity = velocity;
            use_head_pitch = this.pdiff;
            use_head_yaw = this.ydiff;
            use_head_roll = this.rdiff;
            if (inview == 1) {
                ent.modesync_rotation_yaw = use_rotation_yaw;
                ent.modesync_rotation_pitch = use_rotation_pitch;
                ent.modesync_rotation_roll = use_rotation_roll;
                ent.modesync_velocity = use_velocity;
                ent.modesync_ticker = use_ticker;
                ent.modesync_head_pitch = use_head_pitch;
                ent.modesync_head_yaw = use_head_yaw;
                ent.modesync_head_roll = use_head_roll;
                ent.modesync_posx = use_posx;
                ent.modesync_posy = use_posy;
                ent.modesync_posz = use_posz;
                ent.modesync_isvalid = true;
            }
            if (inview == 2) {
                if (!ent.modesync_isvalid) continue;
                use_rotation_yaw = ent.modesync_rotation_yaw;
                use_rotation_pitch = ent.modesync_rotation_pitch;
                use_rotation_roll = ent.modesync_rotation_roll;
                use_velocity = ent.modesync_velocity;
                use_ticker = ent.modesync_ticker;
                use_head_pitch = ent.modesync_head_pitch;
                use_head_yaw = ent.modesync_head_yaw;
                use_head_roll = ent.modesync_head_roll;
                use_posx = ent.modesync_posx;
                use_posy = ent.modesync_posy;
                use_posz = ent.modesync_posz;
                ent.modesync_isvalid = false;
            }
            MatrixStack.pushMatrix();
            if (use_rotation_pitch != 0.0f) {
                MatrixStack.rotate(use_rotation_pitch, 1.0f, 0.0f, 0.0f);
            }
            if (use_rotation_yaw != 0.0f) {
                MatrixStack.rotate(use_rotation_yaw, 0.0f, 1.0f, 0.0f);
            }
            if (use_rotation_roll != 0.0f) {
                MatrixStack.rotate(use_rotation_roll, 0.0f, 0.0f, 1.0f);
            }
            MatrixStack.translate((float)use_posx + this.f5x + this.shift_x, (float)use_posy + this.f5y + this.shift_y, (float)use_posz + this.f5z + this.shift_z);
            MatrixStack.sendCurrentStack();
            MatrixStack.pushMatrix();
            WorldRenderer.recalcBrightness(this.ref_dim, (int)(ent.display_posy + (double)(ent.getHeight() / 2.0f)));
            this.setBrightness(ent.getBrightness() + WorldRendererUtils.getLightMapValue(ent.world, ent.dimension, (int)ent.display_posx, (int)(ent.display_posy + (double)(ent.getHeight() / 2.0f)), (int)ent.display_posz));
            ouch = 1.0f;
            boolean washurt = ent.isHurt();
            if (washurt) {
                ouch = 1.1f;
                this.setHurt();
            }
            if (ent.getDeathFactor() > 0.0f) {
                ouch = ent.getDeathFactor();
            }
            if (morphent != null) {
                if (this.doforce) {
                    this.forceloadtexture(modl.getTexture(morphent));
                    this.doforce = false;
                } else {
                    this.loadtexture(modl.getTexture(morphent));
                }
                modl.doScale(morphent);
                MatrixStack.sendCurrentStack();
                MatrixStack.pushMatrix();
                modl.render(morphent, use_ticker, use_velocity, use_head_pitch, use_head_yaw, use_head_roll, ouch);
                MatrixStack.popMatrix();
            } else {
                if (this.doforce) {
                    this.forceloadtexture(modl.getTexture(ent));
                    this.doforce = false;
                } else {
                    this.loadtexture(modl.getTexture(ent));
                }
                modl.doScale(ent);
                MatrixStack.sendCurrentStack();
                MatrixStack.pushMatrix();
                modl.render(ent, use_ticker, use_velocity, use_head_pitch, use_head_yaw, use_head_roll, ouch);
                MatrixStack.popMatrix();
            }
            petname = ent.getPetName();
            if (petname != null || ent.getOnFire() > 0 || washurt && DangerZone.showhitbox) {
                MatrixStack.popMatrix();
                MatrixStack.identity();
                MatrixStack.translate((float)use_posx + this.f5x + this.shift_x, (float)use_posy + this.f5y + this.shift_y, (float)use_posz + this.f5z + this.shift_z);
                MatrixStack.sendCurrentStack();
                MatrixStack.pushMatrix();
                MatrixStack.rotate(this.ref_yaw + this.f5yaw, 0.0f, 1.0f, 0.0f);
                if (petname != null) {
                    this.doforce = true;
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    MatrixStack.translate(-(this.font.getWidth(petname) / 2), -(ent.getNameHeight() * 125.0f + 25.0f), 0.0f);
                    if (ent.isBaby()) {
                        MatrixStack.scale(0.25f, 0.25f, 0.25f);
                    }
                    MatrixStack.scale(0.15f, 0.15f, 0.15f);
                    WorldRendererUtils.textAt3D(this.font, 0.0f, 0.0f, petname);
                    MatrixStack.popMatrix();
                }
                if (ent.getOnFire() > 0) {
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    WorldRendererUtils.drawEntityOnFire(ent);
                    MatrixStack.popMatrix();
                }
                if (washurt && DangerZone.showhitbox) {
                    MatrixStack.identity();
                    if (use_rotation_pitch != 0.0f) {
                        MatrixStack.rotate(use_rotation_pitch, 1.0f, 0.0f, 0.0f);
                    }
                    if (use_rotation_yaw != 0.0f) {
                        MatrixStack.rotate(use_rotation_yaw, 0.0f, 1.0f, 0.0f);
                    }
                    if (use_rotation_roll != 0.0f) {
                        MatrixStack.rotate(use_rotation_roll, 0.0f, 0.0f, 1.0f);
                    }
                    if (ent.isBaby()) {
                        MatrixStack.scale(0.25f, 0.25f, 0.25f);
                    }
                    MatrixStack.translate(0.0f, 8.0f, 0.0f);
                    MatrixStack.scale(ent.getWidth(), ent.getHeight(), ent.getWidth());
                    this.forceloadtexture(Blocks.BlockArray[Blocks.hitbox.blockID].getTexture(0));
                    MatrixStack.sendCurrentStack();
                    this.drawTexturedCube(255, false, Blocks.hitbox.blockID, 0, false);
                }
            }
            if (washurt) {
                this.setBrightness(0.0f);
            }
            MatrixStack.popMatrix();
            MatrixStack.popMatrix();
        }
        petname = null;
        ent = null;
    }

    private void draw_particles(World world, int inview) {
        if (this.DrawMeP == null || this.DrawMeP.isEmpty()) {
            return;
        }
        for (Particle pst : this.DrawMeP) {
            if (pst.model == null) continue;
            MatrixStack.pushMatrix();
            MatrixStack.translate((float)(-((this.ref_posx - pst.posx) * (double)this.blockrenderwidth)) + this.f5x + this.shift_x, (float)(-((this.ref_posy + (double)this.bounce + (double)this.eyeadjust - pst.posy) * (double)this.blockrenderwidth)) + this.f5y + this.shift_y, (float)(-((this.ref_posz - pst.posz) * (double)this.blockrenderwidth)) + this.f5z + this.shift_z);
            MatrixStack.sendCurrentStack();
            MatrixStack.pushMatrix();
            MatrixStack.rotate(pst.rotation_roll, 0.0f, 0.0f, 1.0f);
            MatrixStack.rotate(pst.rotation_yaw, 0.0f, 1.0f, 0.0f);
            MatrixStack.rotate(pst.rotation_pitch, 1.0f, 0.0f, 0.0f);
            WorldRenderer.recalcBrightness(this.ref_dim, (int)pst.posy);
            this.setBrightness(pst.brightness + WorldRendererUtils.getLightMapValue(world, pst.dimension, (int)pst.posx, (int)pst.posy, (int)pst.posz));
            MatrixStack.scale(pst.renderscale, pst.renderscale, pst.renderscale);
            MatrixStack.sendCurrentStack();
            if (this.doforce) {
                this.forceloadtexture(pst.model.getTexture(pst));
                this.doforce = false;
            } else {
                this.loadtexture(pst.model.getTexture(pst));
            }
            pst.model.renderParticle(pst);
            MatrixStack.popMatrix();
            MatrixStack.popMatrix();
        }
    }
}

