/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.rendering;

import dangerzone.rendering.Fastmath;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class MatrixStack {
    private static final int SIZE = 4;
    private static final int DEPTH = 15;
    private static float[][] elements_trans = new float[15][16];
    private static float[][] elements_rotxx = new float[15][16];
    private static float[][] elements_rotyy = new float[15][16];
    private static float[][] elements_rotzz = new float[15][16];
    private static float[][] elements_scale = new float[15][16];
    private static int[] orders = new int[15];
    private static int[] orders_next = new int[15];
    private static int next = 0;
    private static int[] save_orders = new int[15];
    private static int[] save_orders_next = new int[15];
    private static float[] elements_trans_cleared = new float[16];
    private static float[] elements_rotxx_cleared = new float[16];
    private static float[] elements_rotyy_cleared = new float[16];
    private static float[] elements_rotzz_cleared = new float[16];
    private static float[] elements_scale_cleared = new float[16];
    private static float[][] mats = new float[15][16];
    private static float[] proj_save = new float[16];
    private static float[] temp = new float[16];

    public static void reset(float[] proj) {
        next = 0;
        int i = 0;
        while (i < 15) {
            MatrixStack.orders[i] = 0;
            MatrixStack.orders_next[i] = 0;
            MatrixStack.save_orders[i] = 0;
            MatrixStack.save_orders_next[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                MatrixStack.elements_trans_cleared[i * 4 + j] = 0.0f;
                MatrixStack.elements_rotxx_cleared[i * 4 + j] = 0.0f;
                MatrixStack.elements_rotyy_cleared[i * 4 + j] = 0.0f;
                MatrixStack.elements_rotzz_cleared[i * 4 + j] = 0.0f;
                MatrixStack.elements_scale_cleared[i * 4 + j] = 0.0f;
                MatrixStack.mats[0][i * 4 + j] = proj[i * 4 + j];
                MatrixStack.proj_save[i * 4 + j] = proj[i * 4 + j];
                ++j;
            }
            ++i;
        }
        MatrixStack.elements_trans_cleared[0] = 1.0f;
        MatrixStack.elements_rotxx_cleared[0] = 1.0f;
        MatrixStack.elements_rotxx_cleared[0] = 1.0f;
        MatrixStack.elements_rotxx_cleared[0] = 1.0f;
        MatrixStack.elements_scale_cleared[0] = 1.0f;
        MatrixStack.elements_trans_cleared[5] = 1.0f;
        MatrixStack.elements_rotxx_cleared[5] = 1.0f;
        MatrixStack.elements_rotyy_cleared[5] = 1.0f;
        MatrixStack.elements_rotzz_cleared[5] = 1.0f;
        MatrixStack.elements_scale_cleared[5] = 1.0f;
        MatrixStack.elements_trans_cleared[10] = 1.0f;
        MatrixStack.elements_rotxx_cleared[10] = 1.0f;
        MatrixStack.elements_rotyy_cleared[10] = 1.0f;
        MatrixStack.elements_rotzz_cleared[10] = 1.0f;
        MatrixStack.elements_scale_cleared[10] = 1.0f;
        MatrixStack.elements_trans_cleared[15] = 1.0f;
        MatrixStack.elements_rotxx_cleared[15] = 1.0f;
        MatrixStack.elements_rotyy_cleared[15] = 1.0f;
        MatrixStack.elements_rotzz_cleared[15] = 1.0f;
        MatrixStack.elements_scale_cleared[15] = 1.0f;
        MatrixStack.rotate_clear(0.0f, 1.0f, 0.0f, 0.0f);
        MatrixStack.rotate_clear(0.0f, 0.0f, 1.0f, 0.0f);
        MatrixStack.rotate_clear(0.0f, 0.0f, 0.0f, 1.0f);
        MatrixStack.identity();
    }

    public static void identity() {
        MatrixStack.orders[MatrixStack.next] = 0;
        MatrixStack.orders_next[MatrixStack.next] = 0;
        int i = 0;
        while (i < 16) {
            MatrixStack.elements_trans[MatrixStack.next][i] = elements_trans_cleared[i];
            MatrixStack.elements_rotxx[MatrixStack.next][i] = elements_rotxx_cleared[i];
            MatrixStack.elements_rotyy[MatrixStack.next][i] = elements_rotyy_cleared[i];
            MatrixStack.elements_rotzz[MatrixStack.next][i] = elements_rotzz_cleared[i];
            MatrixStack.elements_scale[MatrixStack.next][i] = elements_scale_cleared[i];
            ++i;
        }
        if (next == 0) {
            i = 0;
            while (i < 16) {
                MatrixStack.mats[0][i] = proj_save[i];
                ++i;
            }
        }
    }

    public static void pushMatrix() {
        if (next + 1 >= 15) {
            return;
        }
        if (next == 0) {
            int k = 0;
            while (k < 16) {
                MatrixStack.mats[0][k] = proj_save[k];
                ++k;
            }
        } else {
            int k = 0;
            while (k < 16) {
                MatrixStack.mats[MatrixStack.next][k] = mats[next - 1][k];
                ++k;
            }
        }
        MatrixStack.mul_it_out(next);
        ++next;
        MatrixStack.identity();
    }

    public static void popMatrix() {
        if (next <= 0) {
            return;
        }
        MatrixStack.orders[MatrixStack.next] = 0;
        MatrixStack.orders_next[MatrixStack.next] = 0;
        --next;
    }

    private static void mul(float[] right, float[] left) {
        int i = 0;
        while (i < 4) {
            int isz = i * 4;
            int j = 0;
            while (j < 4) {
                MatrixStack.temp[isz + j] = left[isz] * right[j] + left[isz + 1] * right[4 + j] + left[isz + 2] * right[8 + j] + left[isz + 3] * right[12 + j];
                ++j;
            }
            ++i;
        }
    }

    private static void mul_it_out(int which) {
        if (orders[which] == 0) {
            return;
        }
        int i = 4;
        while (i >= 0) {
            int k;
            if (MatrixStack.is_next(which, i + 1, 0).booleanValue()) {
                MatrixStack.mul(elements_trans[which], mats[which]);
                k = 0;
                while (k < 16) {
                    MatrixStack.mats[which][k] = temp[k];
                    ++k;
                }
            } else if (MatrixStack.is_next(which, i + 1, 9).booleanValue()) {
                MatrixStack.mul(elements_rotyy[which], mats[which]);
                k = 0;
                while (k < 16) {
                    MatrixStack.mats[which][k] = temp[k];
                    ++k;
                }
            } else if (MatrixStack.is_next(which, i + 1, 6).booleanValue()) {
                MatrixStack.mul(elements_rotxx[which], mats[which]);
                k = 0;
                while (k < 16) {
                    MatrixStack.mats[which][k] = temp[k];
                    ++k;
                }
            } else if (MatrixStack.is_next(which, i + 1, 12).booleanValue()) {
                MatrixStack.mul(elements_rotzz[which], mats[which]);
                k = 0;
                while (k < 16) {
                    MatrixStack.mats[which][k] = temp[k];
                    ++k;
                }
            } else if (MatrixStack.is_next(which, i + 1, 3).booleanValue()) {
                MatrixStack.mul(elements_scale[which], mats[which]);
                k = 0;
                while (k < 16) {
                    MatrixStack.mats[which][k] = temp[k];
                    ++k;
                }
            }
            --i;
        }
    }

    private static Boolean is_next(int lvel, int nxt, int shift) {
        if ((orders[lvel] >> shift & 7) == nxt) {
            return true;
        }
        return false;
    }

    public static void set_order(int which, int bits, int shift) {
        if ((orders[which] & bits << shift) != 0) {
            return;
        }
        if (orders_next[which] >= 5) {
            return;
        }
        int n = which;
        orders_next[n] = orders_next[n] + 1;
        int n2 = which;
        orders[n2] = orders[n2] | orders_next[which] << shift;
    }

    public static boolean is_used(int which, int bits, int shift) {
        return (orders[which] & bits << shift) != 0;
    }

    public static void translate(float x, float y, float z) {
        MatrixStack.set_order(next, 7, 0);
        float[] fArray = elements_trans[next];
        fArray[3] = fArray[3] + x;
        float[] fArray2 = elements_trans[next];
        fArray2[7] = fArray2[7] + y;
        float[] fArray3 = elements_trans[next];
        fArray3[11] = fArray3[11] + z;
    }

    public static void scale(float x, float y, float z) {
        MatrixStack.set_order(next, 7, 3);
        float[] fArray = elements_scale[next];
        fArray[0] = fArray[0] * x;
        float[] fArray2 = elements_scale[next];
        fArray2[5] = fArray2[5] * y;
        float[] fArray3 = elements_scale[next];
        fArray3[10] = fArray3[10] * z;
    }

    public static void rotate(float angle, float x, float y, float z) {
        if (angle == 0.0f) {
            return;
        }
        float cos = (float)Fastmath.cos(Math.toRadians(angle));
        float sin = (float)Fastmath.sin(Math.toRadians(angle));
        float C = 1.0f - cos;
        if (x != 0.0f) {
            MatrixStack.set_order(next, 7, 6);
            MatrixStack.elements_rotxx[MatrixStack.next][0] = cos + x * x * C;
            MatrixStack.elements_rotxx[MatrixStack.next][4] = x * y * C - z * sin;
            MatrixStack.elements_rotxx[MatrixStack.next][8] = x * z * C + y * sin;
            MatrixStack.elements_rotxx[MatrixStack.next][1] = y * x * C + z * sin;
            MatrixStack.elements_rotxx[MatrixStack.next][5] = cos + y * y * C;
            MatrixStack.elements_rotxx[MatrixStack.next][9] = y * z * C - x * sin;
            MatrixStack.elements_rotxx[MatrixStack.next][2] = z * x * C - y * sin;
            MatrixStack.elements_rotxx[MatrixStack.next][6] = z * y * C + x * sin;
            MatrixStack.elements_rotxx[MatrixStack.next][10] = cos + z * z * C;
        }
        if (y != 0.0f) {
            MatrixStack.set_order(next, 7, 9);
            MatrixStack.elements_rotyy[MatrixStack.next][0] = cos + x * x * C;
            MatrixStack.elements_rotyy[MatrixStack.next][4] = x * y * C - z * sin;
            MatrixStack.elements_rotyy[MatrixStack.next][8] = x * z * C + y * sin;
            MatrixStack.elements_rotyy[MatrixStack.next][1] = y * x * C + z * sin;
            MatrixStack.elements_rotyy[MatrixStack.next][5] = cos + y * y * C;
            MatrixStack.elements_rotyy[MatrixStack.next][9] = y * z * C - x * sin;
            MatrixStack.elements_rotyy[MatrixStack.next][2] = z * x * C - y * sin;
            MatrixStack.elements_rotyy[MatrixStack.next][6] = z * y * C + x * sin;
            MatrixStack.elements_rotyy[MatrixStack.next][10] = cos + z * z * C;
        }
        if (z != 0.0f) {
            MatrixStack.set_order(next, 7, 12);
            MatrixStack.elements_rotzz[MatrixStack.next][0] = cos + x * x * C;
            MatrixStack.elements_rotzz[MatrixStack.next][4] = x * y * C - z * sin;
            MatrixStack.elements_rotzz[MatrixStack.next][8] = x * z * C + y * sin;
            MatrixStack.elements_rotzz[MatrixStack.next][1] = y * x * C + z * sin;
            MatrixStack.elements_rotzz[MatrixStack.next][5] = cos + y * y * C;
            MatrixStack.elements_rotzz[MatrixStack.next][9] = y * z * C - x * sin;
            MatrixStack.elements_rotzz[MatrixStack.next][2] = z * x * C - y * sin;
            MatrixStack.elements_rotzz[MatrixStack.next][6] = z * y * C + x * sin;
            MatrixStack.elements_rotzz[MatrixStack.next][10] = cos + z * z * C;
        }
    }

    public static void rotate_clear(float angle, float x, float y, float z) {
        float cos = (float)Math.cos(Math.toRadians(angle));
        float sin = (float)Math.sin(Math.toRadians(angle));
        float C = 1.0f - cos;
        if (x != 0.0f) {
            MatrixStack.elements_rotxx_cleared[0] = cos + x * x * C;
            MatrixStack.elements_rotxx_cleared[4] = x * y * C - z * sin;
            MatrixStack.elements_rotxx_cleared[8] = x * z * C + y * sin;
            MatrixStack.elements_rotxx_cleared[1] = y * x * C + z * sin;
            MatrixStack.elements_rotxx_cleared[5] = cos + y * y * C;
            MatrixStack.elements_rotxx_cleared[9] = y * z * C - x * sin;
            MatrixStack.elements_rotxx_cleared[2] = z * x * C - y * sin;
            MatrixStack.elements_rotxx_cleared[6] = z * y * C + x * sin;
            MatrixStack.elements_rotxx_cleared[10] = cos + z * z * C;
        }
        if (y != 0.0f) {
            MatrixStack.elements_rotyy_cleared[0] = cos + x * x * C;
            MatrixStack.elements_rotyy_cleared[4] = x * y * C - z * sin;
            MatrixStack.elements_rotyy_cleared[8] = x * z * C + y * sin;
            MatrixStack.elements_rotyy_cleared[1] = y * x * C + z * sin;
            MatrixStack.elements_rotyy_cleared[5] = cos + y * y * C;
            MatrixStack.elements_rotyy_cleared[9] = y * z * C - x * sin;
            MatrixStack.elements_rotyy_cleared[2] = z * x * C - y * sin;
            MatrixStack.elements_rotyy_cleared[6] = z * y * C + x * sin;
            MatrixStack.elements_rotyy_cleared[10] = cos + z * z * C;
        }
        if (z != 0.0f) {
            MatrixStack.elements_rotzz_cleared[0] = cos + x * x * C;
            MatrixStack.elements_rotzz_cleared[4] = x * y * C - z * sin;
            MatrixStack.elements_rotzz_cleared[8] = x * z * C + y * sin;
            MatrixStack.elements_rotzz_cleared[1] = y * x * C + z * sin;
            MatrixStack.elements_rotzz_cleared[5] = cos + y * y * C;
            MatrixStack.elements_rotzz_cleared[9] = y * z * C - x * sin;
            MatrixStack.elements_rotzz_cleared[2] = z * x * C - y * sin;
            MatrixStack.elements_rotzz_cleared[6] = z * y * C + x * sin;
            MatrixStack.elements_rotzz_cleared[10] = cos + z * z * C;
        }
    }

    public static void sendCurrentStack() {
    }

    public static void adjustStackDepthUp() {
    }

    public static void adjustStackDepthDown() {
    }

    public static void send_part(int which, String tr, String sc, String rx, String ry, String rz) {
    }

    public static void sendFinalStack() {
        if (next == 0) {
            int k = 0;
            while (k < 16) {
                MatrixStack.mats[0][k] = proj_save[k];
                ++k;
            }
        } else {
            int k = 0;
            while (k < 16) {
                MatrixStack.mats[MatrixStack.next][k] = mats[next - 1][k];
                ++k;
            }
        }
        MatrixStack.mul_it_out(next);
        GL20.glUniformMatrix4fv((int)GL20.glGetUniformLocation((int)GL11.glGetInteger((int)35725), (CharSequence)"projection"), (boolean)true, (float[])mats[next]);
    }
}

