/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.items;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TargetInfo;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityExtendedRangeDamage;
import dangerzone.gui.InventoryMenus;
import dangerzone.items.Item;
import dangerzone.items.ModelShotgun;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.TextureMapper;
import dangerzone.rendering.WorldRenderer;
import slick.Texture;

public class ItemShotgun
extends Item {
    Texture texturebig = null;
    ModelShotgun ma = null;

    public ItemShotgun(String n, String txt, int att, int uses) {
        super(n, txt);
        this.maxstack = 1;
        this.maxuses = uses;
        this.attackstrength = att;
        this.menu = InventoryMenus.HARDWARE;
        this.hold_straight = true;
        this.do_shoot_clicks = true;
        this.xoff = 1.2f;
        this.yoff = -10.0f;
        this.zoff = -4.3999996f;
        this.pitch_off = 227.8f;
        this.yaw_off = 285.2f;
        this.roll_off = 33.4f;
    }

    public void renderMe(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay) {
        if (this.texturebig == null) {
            this.texturebig = TextureMapper.getTexture("res/items/Shotguntexture.png");
        }
        DangerZone.wr.loadtexture(this.texturebig);
        if (this.ma == null) {
            this.ma = new ModelShotgun();
        }
        MatrixStack.pushMatrix();
        MatrixStack.rotate(5.5f, 1.0f, 0.0f, 0.0f);
        MatrixStack.rotate(-75.1f, 0.0f, 1.0f, 0.0f);
        MatrixStack.rotate(149.7f, 0.0f, 0.0f, 1.0f);
        MatrixStack.translate(1.5f, 18.1f, -4.4f);
        MatrixStack.sendCurrentStack();
        if (this.ma != null) {
            this.ma.render(e, ic);
        }
        MatrixStack.popMatrix();
    }

    @Override
    public void renderMeHeld(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay) {
        if (e == null) {
            return;
        }
        float count = e.getRightButtonDownCount();
        if (count > this.getfullholdcount()) {
            count = this.getfullholdcount();
        }
        float pct = count / this.getfullholdcount();
        boolean tweaked = false;
        if (DangerZone.isVR) {
            pct = 0.0f;
        }
        if (isdisplay && e.getRightButtonDownCount() != 0) {
            MatrixStack.pushMatrix();
            MatrixStack.rotate(pct * -6.3f, 1.0f, 0.0f, 0.0f);
            MatrixStack.rotate(pct * 12.8f, 0.0f, 1.0f, 0.0f);
            MatrixStack.rotate(pct * 20.8f, 0.0f, 0.0f, 1.0f);
            MatrixStack.translate(pct * 2.4f, pct * 2.5f, pct * -17.5f);
            MatrixStack.sendCurrentStack();
            tweaked = true;
        } else if (!isdisplay) {
            MatrixStack.pushMatrix();
            pct = 1.0f;
            MatrixStack.rotate(-16.4f, 1.0f, 0.0f, 0.0f);
            MatrixStack.rotate(5.7f, 0.0f, 1.0f, 0.0f);
            MatrixStack.rotate(-64.9f, 0.0f, 0.0f, 1.0f);
            MatrixStack.translate(-7.3f, -4.2f, 1.1f);
            MatrixStack.sendCurrentStack();
            tweaked = true;
        }
        this.renderMe(wr, e, ic, isdisplay);
        if (tweaked) {
            MatrixStack.popMatrix();
        }
    }

    @Override
    public boolean singleshot(Entity holder, InventoryContainer ic, int holdcount) {
        int spam = ic.getAttribute(5);
        int acc = ic.getAttribute(1);
        int dmg = ic.getAttribute(2);
        int rch = ic.getAttribute(4);
        float held = holdcount + 10 * spam;
        if (holder.world.isServer) {
            if (acc < 1) {
                acc = 1;
            }
            float acu = 1 / acc;
            float dam = this.attackstrength + 2 * dmg;
            float spd = 0.75f * (float)rch;
            if (held > this.getfullholdcount()) {
                held = this.getfullholdcount();
            }
            if (this.maxuses - ic.currentuses <= 1) {
                return false;
            }
            if (held < this.getfullholdcount()) {
                return false;
            }
            TargetInfo ti = DangerZone.weapon_controller;
            EntityExtendedRangeDamage e = null;
            e = DangerZone.isVR && holder instanceof Player ? (EntityExtendedRangeDamage)holder.world.createEntityByName("DangerZone:ExtendedRangeDamage", holder.dimension, ti.real_posx, ti.real_posy + (double)holder.getEyeHeight(), ti.real_posz) : (EntityExtendedRangeDamage)holder.world.createEntityByName("DangerZone:ExtendedRangeDamage", holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.5f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.25f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 1.5f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.5f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))));
            if (e != null) {
                e.init();
                e.setDamageType(8);
                e.setRange(64);
                e.thrower = holder;
                e.setAttackDamage(dam);
                e.setExplosivePower(1);
                e.setItemDamage(1);
                e.setSpreadRate(0.1f);
                e.setNoFire(true);
                float mx = (float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head));
                float my = -((float)Math.sin(Math.toRadians(holder.rotation_pitch_head - 0.55f)));
                float mz = (float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head));
                float dz = 0.0f;
                float dy = 0.0f;
                float dx = 0.0f;
                if (DangerZone.isVR && holder instanceof Player) {
                    ti.calc_50();
                    e.setDirectionAndVelocity(ti.dx_50, ti.dy_50, ti.dz_50, 13.25f + spd, 0.02f * acu);
                } else {
                    e.setDirectionAndVelocity(mx, my, mz, 13.25f + spd, 0.02f * acu);
                }
                holder.world.spawnEntityInWorld(e);
                if (holder.world.rand.nextBoolean()) {
                    holder.world.playSound("DangerZone:shotgun_1", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 1.65f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.2f);
                } else {
                    holder.world.playSound("DangerZone:shotgun_2", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 1.65f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.2f);
                }
                if (DangerZone.isVR && holder instanceof Player) {
                    Utils.spawnParticlesFromServerScaled(holder.world, "DangerZone:ParticleDust", 30, holder.dimension, ti.real_posx + (double)ti.dx_50, ti.real_posy + (double)holder.getEyeHeight() + (double)ti.dy_50, ti.real_posz + (double)ti.dz_50, 0, 0.25f * (holder.getWidth() + holder.getHeight()) / 4.0f);
                    Utils.spawnParticlesFromServerScaledWithDirection(holder.world, "DangerZone:ParticleBlast", 20, holder.dimension, ti.real_posx + (double)ti.dx_50, ti.real_posy + (double)holder.getEyeHeight() + (double)ti.dy_50, ti.real_posz + (double)ti.dz_50, dx, dy, dz, 0, 0.15f * (holder.getWidth() + holder.getHeight()) / 4.0f, 1.25f, 0.5f);
                } else if (!(DangerZone.f5_front || DangerZone.f5_back || DangerZone.f5_side)) {
                    Utils.spawnParticlesFromServerScaled(holder.world, "DangerZone:ParticleDust", 30, holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.25f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 0.35f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), 0, 0.15f * (holder.getWidth() + holder.getHeight()) / 4.0f);
                    Utils.spawnParticlesFromServerScaledWithDirection(holder.world, "DangerZone:ParticleBlast", 20, holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.25f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 0.35f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), mx, my, mz, 0, 0.15f * (holder.getWidth() + holder.getHeight()) / 4.0f, 1.25f, 0.5f);
                } else {
                    Utils.spawnParticlesFromServerScaled(holder.world, "DangerZone:ParticleDust", 30, holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head - 15.0f)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.25f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 0.35f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head - 15.0f)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), 0, 0.15f * (holder.getWidth() + holder.getHeight()) / 4.0f);
                    Utils.spawnParticlesFromServerScaledWithDirection(holder.world, "DangerZone:ParticleBlast", 20, holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head - 15.0f)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.25f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 0.35f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head - 15.0f)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), mx, my, mz, 0, 0.15f * (holder.getWidth() + holder.getHeight()) / 4.0f, 1.25f, 0.5f);
                }
            } else {
                return false;
            }
            holder.addKnockback(e, 0.5f, 0.15f);
            return !(holder instanceof Player) || holder.getGameMode() == 0;
        }
        if (this.maxuses - ic.currentuses <= 1) {
            return false;
        }
        if (held < this.getfullholdcount()) {
            return false;
        }
        DangerZone.hit_pulse(3000);
        return false;
    }

    @Override
    public float getfullholdcount() {
        return 20.0f;
    }
}

