/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.items;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Item;
import dangerzone.items.Items;

public class ItemBucket
extends Item {
    public ItemBucket(String n, String txt) {
        super(n, txt);
        this.maxstack = 1;
        this.burntime = 0;
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int side) {
        if (p != null && p.world.isServer) {
            int bid = p.world.getblock(dimension, x, y, z);
            if (bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID) {
                p.world.setblockandmetaWithPerm(p, dimension, x, y, z, 0, 0);
                p.setHotbar(p.gethotbarindex(), new InventoryContainer(0, Items.bucketwater.itemID, 1, 0));
                return false;
            }
            if (bid == Blocks.milk.blockID || bid == Blocks.milkstatic.blockID) {
                p.world.setblockandmetaWithPerm(p, dimension, x, y, z, 0, 0);
                p.setHotbar(p.gethotbarindex(), new InventoryContainer(0, Items.bucketmilk.itemID, 1, 0));
                return false;
            }
            if (bid == Blocks.lava.blockID || bid == Blocks.lavastatic.blockID) {
                p.world.setblockandmetaWithPerm(p, dimension, x, y, z, 0, 0);
                p.setHotbar(p.gethotbarindex(), new InventoryContainer(0, Items.bucketlava.itemID, 1, 0));
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null && holder.world.isServer && clickedon != null && clickedon.isMilkable) {
            holder.setHotbar(holder.gethotbarindex(), new InventoryContainer(0, Items.bucketmilk.itemID, 1, 0));
        }
        return true;
    }

    @Override
    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null && holder.world.isServer && clickedon != null && clickedon.isMilkable) {
            holder.setHotbar(holder.gethotbarindex(), new InventoryContainer(0, Items.bucketmilk.itemID, 1, 0));
            return false;
        }
        return false;
    }
}

