/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Rat;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Snarler
extends EntityLiving {
    public float visibility = 1.0f;

    public Snarler(World w) {
        super(w);
        this.width = 0.95f;
        this.height = 0.65f;
        this.uniquename = "DangerZone:Snarler";
        this.has_inventory = false;
        this.attackRange = 2.0f;
        this.setMaxHealth(15.0f);
        this.setHealth(15.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(5.0f);
        this.setExperience(80);
        this.setMaxAir(20.0f);
        this.setAir(20.0f);
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
        this.movefrequency = 40;
        this.visibility = 1.0f;
        this.setInvisible(false);
        this.setVarFloat(10, 1.0f);
    }

    @Override
    public void doAttack(Entity victim) {
        this.visibility = 1.0f;
        this.setInvisible(false);
        super.doAttack(victim);
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        this.visibility = 1.0f;
        this.setInvisible(false);
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.visibility > 0.0f) {
            this.visibility -= 0.01f;
        }
        if (this.visibility < 0.0f) {
            this.visibility = 0.0f;
        }
        if (this.visibility == 0.0f) {
            this.setInvisible(true);
        }
        this.setVarFloat(10, this.visibility);
        if (this.isSwarming()) {
            this.moveSpeed = 0.37f;
        }
        super.doEntityAction(deltaT);
    }

    public float getVisibility() {
        return this.getVarFloat(10);
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:cryo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public String getAttackSound() {
        int which = this.world.rand.nextInt(9);
        if (which == 0) {
            return "DangerZone:growl1";
        }
        if (which == 1) {
            return "DangerZone:growl2";
        }
        if (which == 2) {
            return "DangerZone:growl3";
        }
        if (which == 3) {
            return "DangerZone:growl4";
        }
        if (which == 4) {
            return "DangerZone:growl5";
        }
        if (which == 5) {
            return "DangerZone:growl6";
        }
        if (which == 6) {
            return "DangerZone:growl7";
        }
        if (which == 7) {
            return "DangerZone:growl8";
        }
        return "DangerZone:growl9";
    }

    @Override
    public void update(float deltaT) {
        if (this.world == null) {
            this.visibility = 1.0f;
            this.setInvisible(false);
        }
        super.update(deltaT);
    }

    @Override
    public void doDeathDrops() {
        super.doDeathDrops();
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophysnarler.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.sign.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.string.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if ((e instanceof Rat || e instanceof Cockroach) && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Snarlertexture.png");
        }
        return this.texture;
    }
}

