/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Flag;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Rat
extends EntityLiving {
    public Rat(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.35f;
        this.width = 0.45f;
        this.uniquename = "DangerZone:Rat";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(5.0f);
        this.setHealth(5.0f);
        this.setDefense(1.25f);
        this.setAttackDamage(1.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 1.5f;
        this.movefrequency = 25;
        this.setExperience(10);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.canridemaglevcart = true;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        return "DangerZone:ratlive";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:rathit";
    }

    @Override
    public String getDeathSound() {
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ratdead1";
        }
        if (i == 1) {
            return "DangerZone:ratdead2";
        }
        return "DangerZone:ratdead3";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophyrat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Rattexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Rat) {
            return false;
        }
        if (e instanceof Flag && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        if (y > 30) {
            return super.getCanSpawnHereNow(w, dimension, x, y, z);
        }
        return !(this.getLightAtLocation(w, dimension, x, y, z) > 0.55f);
    }
}

