/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Monarch;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class MonarchCrysalis
extends EntityLiving {
    Texture texture2 = null;

    public MonarchCrysalis(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.25f;
        this.width = 0.15f;
        this.uniquename = "DangerZone:Monarch Crysalis";
        this.moveSpeed = 0.0f;
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 4000;
        this.setExperience(1);
        this.canSwim = false;
        this.daytimespawn = false;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = false;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            this.rotation_yaw_motion = 1.0f;
        }
        super.update(deltaT);
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.world.rand.nextInt(500) == 1) {
            this.doHatch();
        }
        super.doEntityAction(deltaT);
    }

    private void doHatch() {
        this.setVarInt(31, this.getVarInt(31) + 1);
        if (this.getVarInt(31) > 20 && this.world.isDaytime()) {
            Monarch sc = (Monarch)this.world.createEntityByName("DangerZone:Monarch", this.dimension, this.posx, this.posy, this.posz);
            if (sc != null) {
                sc.init();
                this.world.spawnEntityInWorld(sc);
            }
            this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 0.15f, 1.0f);
            this.deadflag = true;
        }
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (ic != null && ic.count != 0) {
            return false;
        }
        if (this.world.isServer && p != null) {
            this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 0.15f, 1.0f);
            if (this.getVarInt(31) > 16) {
                Utils.doDropRand(this.world, 0, Items.eggmonarchcrysalis2.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
            } else {
                Utils.doDropRand(this.world, 0, Items.eggmonarchcrysalis.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            this.deadflag = true;
        }
        return false;
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/MonarchCrysalistexture.png");
            this.texture2 = TextureMapper.getTexture("res/skins/MonarchCrysalistexture2.png");
        }
        if (this.getVarInt(31) > 16) {
            return this.texture2;
        }
        return this.texture;
    }
}

