/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.MonarchCrysalis;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class MonarchCaterpillar
extends EntityLiving {
    public MonarchCaterpillar(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.15f;
        this.width = 0.15f;
        this.uniquename = "DangerZone:Monarch Caterpillar";
        this.moveSpeed = 0.01f;
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.01f);
        this.searchDistance = 8.0f;
        this.attackRange = 0.25f;
        this.movefrequency = 35;
        this.setExperience(0);
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 11;
        this.foodblockdistxz = 7;
        this.foodblockdisty = 3;
        this.foodblockheal = 1;
        this.foodblockdisteat = 2;
        this.fooddaytimeonly = false;
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.moveSpeed = 0.01f * (float)(this.getVarInt(31) + 1);
        this.setVarInt(30, this.getVarInt(30) + 1);
        if (this.getVarInt(30) > 6000) {
            this.deadflag = true;
        }
        super.doEntityAction(deltaT);
        if (this.getVarInt(31) >= 5 && this.world.rand.nextInt(20) == 1) {
            this.spawnCrysalis(this.world, this.dimension, this.posx, this.posy, this.posz);
            this.deadflag = true;
        }
    }

    public void spawnCrysalis(World world, int d, double x, double y, double z) {
        MonarchCrysalis sc = (MonarchCrysalis)world.createEntityByName("DangerZone:Monarch Crysalis", d, x, y, z);
        if (sc != null) {
            sc.init();
            world.spawnEntityInWorld(sc);
        }
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (ic != null && ic.count != 0) {
            return false;
        }
        if (this.world.isServer && p != null) {
            this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 0.15f, 1.0f);
            Utils.doDropRand(this.world, 0, Items.eggmonarchcaterpillar.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
            this.deadflag = true;
        }
        return false;
    }

    @Override
    public void doEatFoodAction(int d, int x, int y, int z) {
        if (this.world.rand.nextInt(4) == 1) {
            this.playburp(0.01f * (float)this.getVarInt(31));
        }
        if (this.world.rand.nextInt(50) == 1 && this.getVarInt(31) < 5) {
            this.setVarInt(31, this.getVarInt(31) + 1);
        }
        this.setVarInt(30, 0);
        if (this.getVarInt(31) >= 5 && this.world.rand.nextInt(150) == 1) {
            this.world.setblockandmetaWithPerm(this, d, x, y, z, 0, 0);
        }
    }

    @Override
    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.milkweed_plant.blockID) {
            return true;
        }
        if (bid == Blocks.milkweed_plant1.blockID) {
            return true;
        }
        if (bid == Blocks.milkweed_plant2.blockID) {
            return true;
        }
        return bid == Blocks.milkweed_plant3.blockID;
    }

    @Override
    public float getScale() {
        if (this.getVarInt(31) == 0) {
            return 0.01f;
        }
        if (this.getVarInt(31) == 1) {
            return 0.02f;
        }
        if (this.getVarInt(31) == 2) {
            return 0.03f;
        }
        if (this.getVarInt(31) == 3) {
            return 0.04f;
        }
        if (this.getVarInt(31) == 4) {
            return 0.05f;
        }
        return 0.06f;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return null;
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophymonarchcaterpillar.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.deadbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/MonarchCaterpillartexture.png");
        }
        return this.texture;
    }
}

