/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.crafting.Shred;
import dangerzone.crafting.Shredding;
import dangerzone.entities.Entity;
import dangerzone.items.Items;
import dangerzone.world.World;

public class EntityShredder
extends Entity {
    public int blocktries = 0;
    public int shredding = 0;
    public Shred spitout = null;
    public int shredded = 60;

    public EntityShredder(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityShredder";
        this.ignoreCollisions = true;
        this.width = 0.01f;
        this.height = 0.01f;
        this.has_inventory = true;
        this.maxrenderdist = 64;
    }

    @Override
    public void update(float deltaT) {
        String icstring;
        InventoryContainer ic;
        int bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        if (bid != Blocks.shredder.blockID && this.world.isServer) {
            ++this.blocktries;
            if (this.blocktries > 20) {
                ic = this.getInventory(0);
                if (ic != null && ic.count > 0) {
                    icstring = null;
                    icstring = ic.getUniqueName();
                    int iid = Items.findByName(icstring);
                    bid = Blocks.findByName(icstring);
                    int i = 0;
                    while (i < ic.count) {
                        Utils.doDropRand(this.world, bid, iid, 2.0f, this.dimension, this.posx, this.posy, this.posz);
                        ++i;
                    }
                    this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
                this.deadflag = true;
            }
        }
        if (!this.deadflag && this.world.isServer) {
            if (this.shredding > 0) {
                ++this.shredding;
                if (this.shredding > this.shredded) {
                    this.shredding = 0;
                    if (this.spitout != null) {
                        int iid = Items.findByName(this.spitout.out);
                        bid = Blocks.findByName(this.spitout.out);
                        int i = 0;
                        while (i < this.spitout.out_count) {
                            Utils.doDropRand(this.world, bid, iid, 2.0f, this.dimension, this.posx, this.posy, this.posz);
                            ++i;
                        }
                        this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                    }
                    this.spitout = null;
                }
            } else {
                ic = this.getInventory(0);
                if (ic != null && ic.count > 0) {
                    icstring = null;
                    icstring = ic.getUniqueName();
                    if (icstring != null) {
                        this.spitout = Shredding.find(icstring);
                        if (this.spitout != null) {
                            --ic.count;
                            this.shredding = 1;
                            this.shredded = 60 + this.world.rand.nextInt(20);
                            if (ic.count < 1) {
                                ic = null;
                            }
                            this.setInventory(0, ic);
                            int which = this.world.rand.nextInt(3);
                            if (which == 0) {
                                this.world.playSound("DangerZone:shredder1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                            }
                            if (which == 1) {
                                this.world.playSound("DangerZone:shredder2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                            }
                            if (which == 2) {
                                this.world.playSound("DangerZone:shredder3", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                            }
                        }
                    }
                }
            }
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        super.update(deltaT);
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        int bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        if (bid != Blocks.shredder.blockID) {
            this.deadflag = true;
            return false;
        }
        Blocks.rightClickOnBlock(Blocks.shredder.blockID, p, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, 0);
        return false;
    }
}

