/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Explosion;
import dangerzone.blocks.BlockInstability;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.threads.ExplosionThread;
import dangerzone.world.World;
import slick.Texture;

public class EntityExplosiveBlock
extends EntityLiving {
    int exploded_already = 0;

    public EntityExplosiveBlock(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityExplosiveBlock";
        this.width = 0.9f;
        this.height = 0.9f;
        this.moveSpeed = 0.0f;
        this.movefrequency = 5555;
        this.setVarFloat(10, 10 + DangerZone.rand.nextInt(5));
        this.setHealth(1.0f);
        this.setMaxHealth(1.0f);
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
    }

    @Override
    public void doAttackFromCustom(Entity e, int dt, float pain, boolean addknockback) {
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            if (Blocks.getMaxStack(this.getBID()) == 0) {
                this.deadflag = true;
            } else {
                this.setVarFloat(11, this.getVarFloat(11) + 1.0f);
                if (this.getVarFloat(11) > this.getVarFloat(10)) {
                    this.exploded_already = 1;
                    this.trigger(this.world, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
                    if ((int)this.getAttackDamage() <= 99) {
                        Explosion.boom(this, this.world, this.dimension, this.posx, this.posy, this.posz, (int)this.getAttackDamage(), true);
                    } else {
                        ExplosionThread rt = new ExplosionThread(this, this.world, this.dimension, this.posx, this.posy, this.posz, (int)this.getAttackDamage(), true);
                        Thread it = new Thread(rt);
                        it.setPriority(5);
                        it.start();
                    }
                    this.deadflag = true;
                }
            }
        }
        super.update(deltaT);
    }

    public void trigger(World w, int d, int x, int y, int z) {
        int range = 1;
        if ((int)this.getAttackDamage() > 5) {
            range = 3;
        }
        if ((int)this.getAttackDamage() > 50) {
            range = 5;
        }
        int i = -range;
        while (i <= range) {
            int j = -range;
            while (j <= range) {
                int k = -range;
                while (k <= range) {
                    int bid = w.getblock(d, x + i, y + j, z + k);
                    if (Blocks.BlockArray[bid] != null && Blocks.BlockArray[bid] instanceof BlockInstability) {
                        BlockInstability b = (BlockInstability)Blocks.BlockArray[bid];
                        b.trigger(w, d, x + i, y + j, z + k);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void onDeath() {
        if (this.exploded_already == 0) {
            this.exploded_already = 1;
            this.trigger(this.world, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
            if ((int)this.getAttackDamage() <= 99) {
                Explosion.boom(this, this.world, this.dimension, this.posx, this.posy, this.posz, (int)this.getAttackDamage(), true);
            } else {
                ExplosionThread rt = new ExplosionThread(this, this.world, this.dimension, this.posx, this.posy, this.posz, (int)this.getAttackDamage(), true);
                Thread it = new Thread(rt);
                it.setPriority(5);
                it.start();
            }
        }
    }

    @Override
    public float getWidth() {
        if (this.getVarFloat(11) == 0.0f) {
            return 1.0f;
        }
        return this.width + this.getVarFloat(11) * this.width * 1.5f / this.getVarFloat(10);
    }

    @Override
    public float getHeight() {
        if (this.getVarFloat(11) == 0.0f) {
            return 1.0f;
        }
        return this.height + this.getVarFloat(11) * this.height * 1.5f / this.getVarFloat(10);
    }

    @Override
    public float getScale() {
        if (this.getVarFloat(11) == 0.0f) {
            return 1.0f;
        }
        return 1.0f + this.getVarFloat(11) * 1.5f / this.getVarFloat(10);
    }

    @Override
    public Texture getTexture() {
        return null;
    }

    @Override
    public boolean isDying() {
        return false;
    }

    @Override
    public void doDeathAnimation() {
        this.deathfactor = 0.0f;
        this.motionz = 0.0f;
        this.motionx = 0.0f;
        this.motiony = 0.0f;
    }
}

