/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.KVPair;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Dean;
import dangerzone.entities.Doctor;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Libtard;
import dangerzone.entities.Professor;
import dangerzone.entities.Teacher;
import dangerzone.entities.Vaxxed;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import slick.Texture;

public class BigPharma
extends EntityLiving {
    int spawnedminions = 0;

    public BigPharma(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 3.8f;
        this.width = 1.7f;
        this.uniquename = "DangerZone:Big Pharma";
        this.moveSpeed = 0.45f;
        this.setMaxHealth(2000.0f);
        this.setHealth(2000.0f);
        this.setDefense(2.75f);
        this.setAttackDamage(60.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 5.5f;
        this.movefrequency = 55;
        this.setExperience(10000);
        this.canSwim = true;
        this.has_inventory = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = true;
        this.enable_buddy = true;
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getLivingSound() {
        int which = this.world.rand.nextInt(8);
        if (which == 1) {
            return "DangerZone:vaxxed_living1";
        }
        if (which == 2) {
            return "DangerZone:vaxxed_living2";
        }
        if (which == 3) {
            return "DangerZone:vaxxed_living3";
        }
        if (which == 4) {
            return "DangerZone:vaxxed_living4";
        }
        if (which == 5) {
            return "DangerZone:vaxxed_living5";
        }
        return null;
    }

    @Override
    public void update(float deltaT) {
        if (this.getAttacking()) {
            this.setArmsUp(true);
        } else {
            this.setArmsUp(false);
        }
        super.update(deltaT);
    }

    @Override
    public float getLivingSoundVolume() {
        return 1.0f;
    }

    @Override
    public String getHurtSound() {
        int which = this.world.rand.nextInt(5);
        if (which == 1) {
            return "DangerZone:vaxxed_hit1";
        }
        if (which == 2) {
            return "DangerZone:vaxxed_hit2";
        }
        if (which == 3) {
            return "DangerZone:vaxxed_hit3";
        }
        if (which == 4) {
            return "DangerZone:vaxxed_hit4";
        }
        if (which == 0) {
            return "DangerZone:vaxxed_hit5";
        }
        return null;
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:vaxxed_death";
    }

    @Override
    public String getAttackSound() {
        int which = this.world.rand.nextInt(5);
        if (which == 1) {
            return "DangerZone:vaxxed_attack1";
        }
        if (which == 2) {
            return "DangerZone:vaxxed_attack2";
        }
        if (which == 3) {
            return "DangerZone:vaxxed_attack3";
        }
        return null;
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof BigPharma;
    }

    @Override
    public void doFindBuddy() {
        if (this.world.rand.nextInt(this.findbuddyfrequency) == 1) {
            List<Integer> nearby_list = null;
            int nbuddy = 0;
            double totalz = 0.0;
            double totalx = 0.0;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRangei(this.findbuddydistance, this.dimension, this.posx, this.posy, this.posz);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                Entity e = null;
                ListIterator<Integer> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = DangerZone.server.entityManager.entities[li.next()];
                    if (e == null || e == this || !this.isBuddy(e)) continue;
                    int mult = 1;
                    totalx += e.posx * (double)mult;
                    totalz += e.posz * (double)mult;
                    nbuddy += mult;
                }
                if (nbuddy > 0) {
                    float rundir = (float)Math.atan2((totalx /= (double)nbuddy) - this.posx, (totalz /= (double)nbuddy) - this.posz);
                    rundir = (float)Math.toDegrees(rundir);
                    this.findNewTarget(rundir, 45.0f);
                }
            }
        }
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 13) {
            return;
        }
        this.doAttackFromCustom(e, dt, pain, true);
    }

    @Override
    public void doAttack(Entity victim) {
        Effects ef = new Effects(6, 0.2f, 500);
        victim.addEffectFromServer(ef);
        ef = new Effects(7, 2.0f, 500);
        victim.addEffectFromServer(ef);
        ef = new Effects(4, 2.0f, 500);
        victim.addEffectFromServer(ef);
        ef = new Effects(2, 4.0f, 500);
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.world.isServer) {
            if (this.effect_list == null || this.effect_list.size() == 0) {
                Effects ef = new Effects(6, 0.01f, 1000);
                this.addEffect(ef);
                ef = new Effects(7, 1.0f, 1000);
                this.addEffect(ef);
                ef = new Effects(4, 0.1f, 1000);
                this.addEffect(ef);
                ef = new Effects(2, 0.1f, 1000);
                this.addEffect(ef);
            }
            if (this.spawnedminions == 0) {
                int which = 0;
                int m = 0;
                while (m < 13) {
                    double px = this.posx;
                    double py = this.posy;
                    double pz = this.posz;
                    px += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 8.0f);
                    pz += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 8.0f);
                    which = this.world.rand.nextInt(80);
                    int i = -5;
                    while (i <= 5) {
                        int bid = this.world.getblock(this.dimension, (int)px, (int)py + i, (int)pz);
                        if (bid == 0 && (bid = this.world.getblock(this.dimension, (int)px, (int)py + i - 1, (int)pz)) != 0) {
                            EntityLiving sc = null;
                            if (which <= 40) {
                                sc = (EntityLiving)this.world.createEntityByName("DangerZone:Vaxxed", this.dimension, px, py + (double)i, pz);
                            } else if (which <= 60) {
                                sc = (EntityLiving)this.world.createEntityByName("DangerZone:Libtard", this.dimension, px, py + (double)i, pz);
                            } else if (which <= 70) {
                                sc = (EntityLiving)this.world.createEntityByName("DangerZone:Teacher", this.dimension, px, py + (double)i, pz);
                            } else if (which <= 75) {
                                sc = (EntityLiving)this.world.createEntityByName("DangerZone:Professor", this.dimension, px, py + (double)i, pz);
                            } else if (which <= 77) {
                                sc = (EntityLiving)this.world.createEntityByName("DangerZone:Dean", this.dimension, px, py + (double)i, pz);
                            }
                            if (sc != null) {
                                sc.init();
                                this.world.spawnEntityInWorld(sc);
                            }
                        }
                        ++i;
                    }
                    ++m;
                }
                this.spawnedminions = 1;
            }
        }
        super.doEntityAction(deltaT);
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, Items.trophybigpharma.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        int i = 0;
        while (i < 10) {
            Utils.doDropRand(this.world, 0, Items.frog_speed3.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            Utils.doDropRand(this.world, 0, Items.frog_strength3.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            Utils.doDropRand(this.world, 0, Items.frog_regen3.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            Utils.doDropRand(this.world, 0, Items.frog_morph3.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            Utils.doDropRand(this.world, 0, Items.scrollheal.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        Utils.doDropRand(this.world, 0, Items.scrollaccuracyV.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.scrolldamageV.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.scrolldurabilityV.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.scrollreachV.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.scrollspamV.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Vaxxed) {
            return false;
        }
        if (e instanceof Libtard) {
            return false;
        }
        if (e instanceof Teacher) {
            return false;
        }
        if (e instanceof Professor) {
            return false;
        }
        if (e instanceof Dean) {
            return false;
        }
        if (e instanceof Doctor) {
            return false;
        }
        if (e instanceof BigPharma) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/BigPharmatexture.png");
        }
        return this.texture;
    }

    @Override
    public float getScale() {
        if (this.isBaby()) {
            return 1.0f;
        }
        return 2.0f;
    }

    @Override
    public void writeSelf(List<KVPair> prop, String tag) {
        prop.add(new KVPair(String.format("%s%s", tag, "spawnedminions"), String.format("%d", this.spawnedminions)));
        super.writeSelf(prop, tag);
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        this.spawnedminions = Utils.getPropertyInt(prop, String.format("%s%s", tag, "spawnedminions"), 0, 100000, 0);
        super.readSelf(prop, tag);
    }
}

